// DO NOT EDIT. This file is auto-generated by `amalgamate.py`.

#include <Zydis.h>


//
// Source file: /Users/admin/Projects/zydis/src/Encoder.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Mappa

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

// ReSharper disable CppClangTidyClangDiagnosticSwitchEnum
// ReSharper disable CppClangTidyClangDiagnosticCoveredSwitchDefault
// ReSharper disable CppClangTidyClangDiagnosticImplicitFallthrough


//
// Header: Zycore/LibC.h
//

/***************************************************************************************************

  Zyan Core Library (Zycore-C)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

/**
 * @file
 * Provides a simple LibC abstraction and fallback routines.
 */

#ifndef ZYCORE_LIBC_H
#define ZYCORE_LIBC_H

#ifndef ZYAN_CUSTOM_LIBC

// Include a custom LibC header and define `ZYAN_CUSTOM_LIBC` to provide your own LibC
// replacement functions

#ifndef ZYAN_NO_LIBC

/* ============================================================================================== */
/* LibC is available                                                                              */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* errno.h                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

#include <errno.h>

#define ZYAN_ERRNO  errno

/* ---------------------------------------------------------------------------------------------- */
/* stdarg.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#include <stdarg.h>

/**
 * Defines the `ZyanVAList` datatype.
 */
typedef va_list ZyanVAList;

#define ZYAN_VA_START               va_start
#define ZYAN_VA_ARG                 va_arg
#define ZYAN_VA_END                 va_end
#define ZYAN_VA_COPY(dest, source)  va_copy((dest), (source))

/* ---------------------------------------------------------------------------------------------- */
/* stdio.h                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

#include <stdio.h>

#define ZYAN_FPUTS      fputs
#define ZYAN_FPUTC      fputc
#define ZYAN_FPRINTF    fprintf
#define ZYAN_PRINTF     printf
#define ZYAN_PUTC       putc
#define ZYAN_PUTS       puts
#define ZYAN_SCANF      scanf
#define ZYAN_SSCANF     sscanf
#define ZYAN_VSNPRINTF  vsnprintf

/**
 * Defines the `ZyanFile` datatype.
 */
typedef FILE ZyanFile;

#define ZYAN_STDIN      stdin
#define ZYAN_STDOUT     stdout
#define ZYAN_STDERR     stderr

/* ---------------------------------------------------------------------------------------------- */
/* stdlib.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#include <stdlib.h>
#define ZYAN_CALLOC     calloc
#define ZYAN_FREE       free
#define ZYAN_MALLOC     malloc
#define ZYAN_REALLOC    realloc

/* ---------------------------------------------------------------------------------------------- */
/* string.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#include <string.h>
#define ZYAN_MEMCHR     memchr
#define ZYAN_MEMCMP     memcmp
#define ZYAN_MEMCPY     memcpy
#define ZYAN_MEMMOVE    memmove
#define ZYAN_MEMSET     memset
#define ZYAN_STRCAT     strcat
#define ZYAN_STRCHR     strchr
#define ZYAN_STRCMP     strcmp
#define ZYAN_STRCOLL    strcoll
#define ZYAN_STRCPY     strcpy
#define ZYAN_STRCSPN    strcspn
#define ZYAN_STRLEN     strlen
#define ZYAN_STRNCAT    strncat
#define ZYAN_STRNCMP    strncmp
#define ZYAN_STRNCPY    strncpy
#define ZYAN_STRPBRK    strpbrk
#define ZYAN_STRRCHR    strrchr
#define ZYAN_STRSPN     strspn
#define ZYAN_STRSTR     strstr
#define ZYAN_STRTOK     strtok
#define ZYAN_STRXFRM    strxfrm

/* ---------------------------------------------------------------------------------------------- */

#else  // if ZYAN_NO_LIBC

/* ============================================================================================== */
/* No LibC available, use our own functions                                                       */
/* ============================================================================================== */


/*
 * These implementations are by no means optimized and will be outperformed by pretty much any
 * libc implementation out there. We do not aim towards providing competetive implementations here,
 * but towards providing a last resort fallback for environments without a working libc.
 */

/* ---------------------------------------------------------------------------------------------- */
/* stdarg.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#if defined(ZYAN_MSVC) || defined(ZYAN_ICC)

/**
 * Defines the `ZyanVAList` datatype.
 */
typedef char* ZyanVAList;

#   define ZYAN_VA_START __crt_va_start
#   define ZYAN_VA_ARG   __crt_va_arg
#   define ZYAN_VA_END   __crt_va_end
#   define ZYAN_VA_COPY(destination, source) ((destination) = (source))

#elif defined(ZYAN_GNUC)

/**
 * Defines the `ZyanVAList` datatype.
 */
typedef __builtin_va_list  ZyanVAList;

#   define ZYAN_VA_START(v, l)  __builtin_va_start(v, l)
#   define ZYAN_VA_END(v)       __builtin_va_end(v)
#   define ZYAN_VA_ARG(v, l)    __builtin_va_arg(v, l)
#   define ZYAN_VA_COPY(d, s)   __builtin_va_copy(d, s)

#else
#   error "Unsupported compiler for no-libc mode."
#endif

/* ---------------------------------------------------------------------------------------------- */
/* stdio.h                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

// ZYAN_INLINE int ZYAN_VSNPRINTF (char* const buffer, ZyanUSize const count,
//     char const* const format, ZyanVAList args)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(buffer);
//     ZYAN_UNUSED(count);
//     ZYAN_UNUSED(format);
//     ZYAN_UNUSED(args);
//     return ZYAN_NULL;
// }

/* ---------------------------------------------------------------------------------------------- */
/* stdlib.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

// ZYAN_INLINE void* ZYAN_CALLOC(ZyanUSize nitems, ZyanUSize size)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(nitems);
//     ZYAN_UNUSED(size);
//     return ZYAN_NULL;
// }
//
// ZYAN_INLINE void ZYAN_FREE(void *p)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(p);
// }
//
// ZYAN_INLINE void* ZYAN_MALLOC(ZyanUSize n)
// {
//     // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(n);
//     return ZYAN_NULL;
// }
//
// ZYAN_INLINE void* ZYAN_REALLOC(void* p, ZyanUSize n)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(p);
//     ZYAN_UNUSED(n);
//     return ZYAN_NULL;
// }

/* ---------------------------------------------------------------------------------------------- */
/* string.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZYAN_INLINE void* ZYAN_MEMCHR(const void* str, int c, ZyanUSize n)
{
    const ZyanU8* p = (ZyanU8*)str;
    while(n--)
    {
        if(*p != (ZyanU8)c)
        {
            p++;
        }
        else
        {
            return (void*)p;
        }
    }
    return 0;
}

ZYAN_INLINE int ZYAN_MEMCMP(const void* s1, const void* s2, ZyanUSize n)
{
    const ZyanU8* p1 = s1, *p2 = s2;
    while(n--)
    {
        if(*p1 != *p2)
        {
            return *p1 - *p2;
        }
        p1++, p2++;
    }
    return 0;
}

ZYAN_INLINE void* ZYAN_MEMCPY(void* dst, const void* src, ZyanUSize n)
{
    volatile ZyanU8* dp = dst;
    const ZyanU8* sp = src;
    while(n--)
    {
        *dp++ = *sp++;
    }
    return dst;
}

ZYAN_INLINE void* ZYAN_MEMMOVE(void* dst, const void* src, ZyanUSize n)
{
    volatile ZyanU8* pd = dst;
    const ZyanU8* ps = src;
    if(ps < pd)
    {
        for(pd += n, ps += n; n--;)
        {
            *--pd = *--ps;
        }
    }
    else
    {
        while(n--)
        {
            *pd++ = *ps++;
        }
    }
    return dst;
}

ZYAN_INLINE void* ZYAN_MEMSET(void* dst, int val, ZyanUSize n)
{
    volatile ZyanU8* p = dst;
    while(n--)
    {
        *p++ = (unsigned char)val;
    }
    return dst;
}

ZYAN_INLINE char* ZYAN_STRCAT(char* dest, const char* src)
{
    char* ret = dest;
    while(*dest)
    {
        dest++;
    }
    while((*dest++ = *src++));
    return ret;
}

ZYAN_INLINE char* ZYAN_STRCHR(const char* s, int c)
{
    while(*s != (char)c)
    {
        if(!*s++)
        {
            return 0;
        }
    }
    return (char*)s;
}

ZYAN_INLINE int ZYAN_STRCMP(const char* s1, const char* s2)
{
    while(*s1 && (*s1 == *s2))
    {
        s1++, s2++;
    }
    return *(const ZyanU8*)s1 - *(const ZyanU8*)s2;
}

ZYAN_INLINE int ZYAN_STRCOLL(const char* s1, const char* s2)
{
    // TODO: Implement

    ZYAN_UNUSED(s1);
    ZYAN_UNUSED(s2);

    return 0;
}

ZYAN_INLINE char* ZYAN_STRCPY(char* dest, const char* src)
{
    char* ret = dest;
    while((*dest++ = *src++));
    return ret;
}

ZYAN_INLINE ZyanUSize ZYAN_STRCSPN(const char* s1, const char* s2)
{
    ZyanUSize ret = 0;
    while(*s1)
    {
        if(ZYAN_STRCHR(s2, *s1))
        {
            return ret;
        }
        s1++, ret++;
    }
    return ret;
}

ZYAN_INLINE ZyanUSize ZYAN_STRLEN(const char* str)
{
    const char* p = str;
    while(*str)
    {
        ++str;
    }
    return str - p;
}

ZYAN_INLINE char* ZYAN_STRNCAT(char* dest, const char* src, ZyanUSize n)
{
    char* ret = dest;
    while(*dest)
    {
        dest++;
    }
    while(n--)
    {
        if(!(*dest++ = *src++))
        {
            return ret;
        }
    }
    *dest = 0;
    return ret;
}

ZYAN_INLINE int ZYAN_STRNCMP(const char* s1, const char* s2, ZyanUSize n)
{
    while(n--)
    {
        if(*s1++ != *s2++)
        {
            return *(unsigned char*)(s1 - 1) - *(unsigned char*)(s2 - 1);
        }
    }
    return 0;
}

ZYAN_INLINE char* ZYAN_STRNCPY(char* dest, const char* src, ZyanUSize n)
{
    char* ret = dest;
    do
    {
        if(!n--)
        {
            return ret;
        }
    }
    while((*dest++ = *src++));
    while(n--)
    {
        *dest++ = 0;
    }
    return ret;
}

ZYAN_INLINE char* ZYAN_STRPBRK(const char* s1, const char* s2)
{
    while(*s1)
    {
        if(ZYAN_STRCHR(s2, *s1++))
        {
            return (char*)--s1;
        }
    }
    return 0;
}

ZYAN_INLINE char* ZYAN_STRRCHR(const char* s, int c)
{
    char* ret = 0;
    do
    {
        if(*s == (char)c)
        {
            ret = (char*)s;
        }
    }
    while(*s++);
    return ret;
}

ZYAN_INLINE ZyanUSize ZYAN_STRSPN(const char* s1, const char* s2)
{
    ZyanUSize ret = 0;
    while(*s1 && ZYAN_STRCHR(s2, *s1++))
    {
        ret++;
    }
    return ret;
}

ZYAN_INLINE char* ZYAN_STRSTR(const char* s1, const char* s2)
{
    const ZyanUSize n = ZYAN_STRLEN(s2);
    while(*s1)
    {
        if(!ZYAN_MEMCMP(s1++, s2, n))
        {
            return (char*)(s1 - 1);
        }
    }
    return 0;
}

ZYAN_INLINE char* ZYAN_STRTOK(char* str, const char* delim)
{
    static char* p = 0;
    if(str)
    {
        p = str;
    }
    else if(!p)
    {
        return 0;
    }
    str = p + ZYAN_STRSPN(p, delim);
    p = str + ZYAN_STRCSPN(str, delim);
    if(p == str)
    {
        return p = 0;
    }
    p = *p ? *p = 0, p + 1 : 0;
    return str;
}

ZYAN_INLINE ZyanUSize ZYAN_STRXFRM(char* dest, const char* src, ZyanUSize n)
{
    const ZyanUSize n2 = ZYAN_STRLEN(src);
    if(n > n2)
    {
        ZYAN_STRCPY(dest, src);
    }
    return n2;
}

/* ---------------------------------------------------------------------------------------------- */

#endif

#endif

/* ============================================================================================== */

#endif /* ZYCORE_LIBC_H */

//
// Header: Zydis/Internal/EncoderData.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Mappa

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

#ifndef ZYDIS_INTERNAL_ENCODERDATA_H
#define ZYDIS_INTERNAL_ENCODERDATA_H


/**
 * Used in encoder's table to represent standard ISA sizes in form of bit flags.
 */
typedef enum ZydisWidthFlag_
{
    ZYDIS_WIDTH_INVALID = 0x00,
    ZYDIS_WIDTH_16      = 0x01,
    ZYDIS_WIDTH_32      = 0x02,
    ZYDIS_WIDTH_64      = 0x04,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_WIDTH_MAX_VALUE = (ZYDIS_WIDTH_64 | (ZYDIS_WIDTH_64 - 1)),
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_WIDTH_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_WIDTH_MAX_VALUE)
} ZydisWidthFlag;

/**
 * Used in encoder's table to represent mandatory instruction prefix. Using this enum instead of
 * actual prefix value saves space.
 */
typedef enum ZydisMandatoryPrefix_
{
    ZYDIS_MANDATORY_PREFIX_NONE,
    ZYDIS_MANDATORY_PREFIX_66,
    ZYDIS_MANDATORY_PREFIX_F2,
    ZYDIS_MANDATORY_PREFIX_F3,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MANDATORY_PREFIX_MAX_VALUE = ZYDIS_MANDATORY_PREFIX_F3,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MANDATORY_PREFIX_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MANDATORY_PREFIX_MAX_VALUE)
} ZydisMandatoryPrefix;

/**
 * Used in encoder's table to represent vector size supported by instruction definition.
 */
typedef enum ZydisVectorLength_
{
    ZYDIS_VECTOR_LENGTH_INVALID,
    ZYDIS_VECTOR_LENGTH_128,
    ZYDIS_VECTOR_LENGTH_256,
    ZYDIS_VECTOR_LENGTH_512,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_VECTOR_LENGTH_MAX_VALUE = ZYDIS_VECTOR_LENGTH_512,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_VECTOR_LENGTH_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_VECTOR_LENGTH_MAX_VALUE)
} ZydisVectorLength;

/**
 * Used in encoder's table to represent hint type supported by instruction definition.
 */
typedef enum ZydisSizeHint_
{
    ZYDIS_SIZE_HINT_NONE,
    ZYDIS_SIZE_HINT_ASZ,
    ZYDIS_SIZE_HINT_OSZ,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_SIZE_HINT_MAX_VALUE = ZYDIS_SIZE_HINT_OSZ,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_SIZE_HINT_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_SIZE_HINT_MAX_VALUE)
} ZydisSizeHint;

/**
 * Used in encoder's primary lookup table which allows to access a set of instruction definitions
 * for specified mnemonic in constant time.
 */
typedef struct ZydisEncoderLookupEntry_
{
    /**
     * Index to main array of `ZydisEncodableInstruction`.
     */
    ZyanU16 encoder_reference;
    /**
     * The number of entries.
     */
    ZyanU8 instruction_count;
} ZydisEncoderLookupEntry;

#pragma pack(push, 1)

/**
 * This structure is encoder's internal representation of encodable instruction definition.
 */
typedef struct ZydisEncodableInstruction_
{
    /**
     * Index to one of decoder's instruction definition arrays.
     */
    ZyanU16 instruction_reference;
    /**
     * Compressed information about operand count and types. Operand count is stored in lowest bits.
     * Types of subsequent operands are stored in higher bits.
     */
    ZyanU16 operand_mask;
    /**
     * The instruction-opcode.
     */
    ZyanU8 opcode;
    /**
     * The mandatory ModR/M value.
     */
    ZyanU8 modrm;
    /**
     * The instruction-encoding.
     */
    ZyanU8 encoding                 ZYAN_BITFIELD(ZYDIS_INSTRUCTION_ENCODING_REQUIRED_BITS);
    /**
     * The opcode map.
     */
    ZyanU8 opcode_map               ZYAN_BITFIELD(ZYDIS_OPCODE_MAP_REQUIRED_BITS);
    /**
     * The combination of allowed processor modes.
     */
    ZyanU8 modes                    ZYAN_BITFIELD(ZYDIS_WIDTH_REQUIRED_BITS);
    /**
     * The combination of allowed address sizes.
     */
    ZyanU8 address_sizes            ZYAN_BITFIELD(ZYDIS_WIDTH_REQUIRED_BITS);
    /**
     * The combination of allowed operand sizes.
     */
    ZyanU8 operand_sizes            ZYAN_BITFIELD(ZYDIS_WIDTH_REQUIRED_BITS);
    /**
     * The mandatory prefix.
     */
    ZyanU8 mandatory_prefix         ZYAN_BITFIELD(ZYDIS_MANDATORY_PREFIX_REQUIRED_BITS);
    /**
     * True if `REX.W` is required for this definition.
     */
    ZyanU8 rex_w                    ZYAN_BITFIELD(1);
    /**
     * The vector length.
     */
    ZyanU8 vector_length            ZYAN_BITFIELD(ZYDIS_MANDATORY_PREFIX_REQUIRED_BITS);
    /**
     * The accepted sizing hint.
     */
    ZyanU8 accepts_hint             ZYAN_BITFIELD(ZYDIS_SIZE_HINT_REQUIRED_BITS);
    /**
     * Indicates that next instruction definition can be safely used instead of current one. This
     * is used with some `VEX` instructions to take advantage of 2-byte `VEX` prefix when possible.
     * 2-byte `VEX` allows to use high registers only when operand is encoded in `modrm_reg`
     * (high bit in `REX.R`). Encoder uses swappable definitions to take advantage of this
     * optimization opportunity.
     *
     * Second use of this field is to handle special case for `mov` instruction. This particular
     * conflict is described in detail inside `ZydisHandleSwappableDefinition`.
     */
    ZyanU8 swappable                ZYAN_BITFIELD(1);
} ZydisEncodableInstruction;

#pragma pack(pop)

/**
 * Contains information used by instruction size prediction algorithm inside
 * `ZydisEncoderEncodeInstructionAbsolute`.
 */
typedef struct ZydisEncoderRelInfo_
{
    /**
     * Sizes of instruction variants. First index is effective address size. Second index is
     * desired immediate size (8, 16 and 32 bits respectively).
     */
    ZyanU8 size[3][3];
    /**
     * See `ZydisSizeHint`.
     */
    ZyanU8 accepts_scaling_hints;
    /**
     * True if instruction accepts branch hint prefixes.
     */
    ZyanBool accepts_branch_hints;
} ZydisEncoderRelInfo;

/**
 * Fetches array of `ZydisEncodableInstruction` structures and its size for given instruction
 * mnemonic.
 *
 * @param   mnemonic    Instruction mnemonic.
 * @param   instruction This variable will receive a pointer to the array of
 *                      `ZydisEncodableInstruction` structures.
 *
 * @return  Entry count (0 if function failed).
 */
ZyanU8 ZydisGetEncodableInstructions(ZydisMnemonic mnemonic,
                                     const ZydisEncodableInstruction** instruction);

/**
 * Fetches `ZydisEncoderRelInfo` record for given instruction mnemonic.
 *
 * @param   mnemonic    Instruction mnemonic.
 *
 * @return  Pointer to `ZydisEncoderRelInfo` structure or `ZYAN_NULL` if instruction doesn't have
 *          relative operands.
 */
const ZydisEncoderRelInfo* ZydisGetRelInfo(ZydisMnemonic mnemonic);

#endif /* ZYDIS_INTERNAL_ENCODERDATA_H */

//
// Header: Zydis/Internal/SharedData.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

#ifndef ZYDIS_INTERNAL_SHAREDDATA_H
#define ZYDIS_INTERNAL_SHAREDDATA_H


#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Enums and types                                                                                */
/* ============================================================================================== */

// MSVC does not like types other than (un-)signed int for bit-fields
#ifdef ZYAN_MSVC
#   pragma warning(push)
#   pragma warning(disable:4214)
#endif

#pragma pack(push, 1)

/* ---------------------------------------------------------------------------------------------- */
/* Operand definition                                                                             */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisSemanticOperandType` enum.
 */
typedef enum ZydisSemanticOperandType_
{
    ZYDIS_SEMANTIC_OPTYPE_UNUSED,
    ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_REG,
    ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_MEM,
    ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_IMM1,
    ZYDIS_SEMANTIC_OPTYPE_GPR8,
    ZYDIS_SEMANTIC_OPTYPE_GPR16,
    ZYDIS_SEMANTIC_OPTYPE_GPR32,
    ZYDIS_SEMANTIC_OPTYPE_GPR64,
    ZYDIS_SEMANTIC_OPTYPE_GPR16_32_64,
    ZYDIS_SEMANTIC_OPTYPE_GPR32_32_64,
    ZYDIS_SEMANTIC_OPTYPE_GPR16_32_32,
    ZYDIS_SEMANTIC_OPTYPE_GPR_ASZ,
    ZYDIS_SEMANTIC_OPTYPE_FPR,
    ZYDIS_SEMANTIC_OPTYPE_MMX,
    ZYDIS_SEMANTIC_OPTYPE_XMM,
    ZYDIS_SEMANTIC_OPTYPE_YMM,
    ZYDIS_SEMANTIC_OPTYPE_ZMM,
    ZYDIS_SEMANTIC_OPTYPE_TMM,
    ZYDIS_SEMANTIC_OPTYPE_BND,
    ZYDIS_SEMANTIC_OPTYPE_SREG,
    ZYDIS_SEMANTIC_OPTYPE_CR,
    ZYDIS_SEMANTIC_OPTYPE_DR,
    ZYDIS_SEMANTIC_OPTYPE_MASK,
    ZYDIS_SEMANTIC_OPTYPE_MEM,
    ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBX,
    ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBY,
    ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBZ,
    ZYDIS_SEMANTIC_OPTYPE_IMM,
    ZYDIS_SEMANTIC_OPTYPE_REL,
    ZYDIS_SEMANTIC_OPTYPE_PTR,
    ZYDIS_SEMANTIC_OPTYPE_AGEN,
    ZYDIS_SEMANTIC_OPTYPE_MOFFS,
    ZYDIS_SEMANTIC_OPTYPE_MIB,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_SEMANTIC_OPTYPE_MAX_VALUE = ZYDIS_SEMANTIC_OPTYPE_MIB,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_SEMANTIC_OPTYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_SEMANTIC_OPTYPE_MAX_VALUE)
} ZydisSemanticOperandType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInternalElementType` enum.
 */
typedef enum ZydisInternalElementType_
{
    ZYDIS_IELEMENT_TYPE_INVALID,
    ZYDIS_IELEMENT_TYPE_VARIABLE,
    ZYDIS_IELEMENT_TYPE_STRUCT,
    ZYDIS_IELEMENT_TYPE_INT,
    ZYDIS_IELEMENT_TYPE_UINT,
    ZYDIS_IELEMENT_TYPE_INT1,
    ZYDIS_IELEMENT_TYPE_INT8,
    ZYDIS_IELEMENT_TYPE_INT8X4,
    ZYDIS_IELEMENT_TYPE_INT16,
    ZYDIS_IELEMENT_TYPE_INT32,
    ZYDIS_IELEMENT_TYPE_INT64,
    ZYDIS_IELEMENT_TYPE_UINT8,
    ZYDIS_IELEMENT_TYPE_UINT8X4,
    ZYDIS_IELEMENT_TYPE_UINT16,
    ZYDIS_IELEMENT_TYPE_UINT32,
    ZYDIS_IELEMENT_TYPE_UINT64,
    ZYDIS_IELEMENT_TYPE_UINT128,
    ZYDIS_IELEMENT_TYPE_UINT256,
    ZYDIS_IELEMENT_TYPE_FLOAT16,
    ZYDIS_IELEMENT_TYPE_FLOAT16X2,
    ZYDIS_IELEMENT_TYPE_FLOAT32,
    ZYDIS_IELEMENT_TYPE_FLOAT64,
    ZYDIS_IELEMENT_TYPE_FLOAT80,
    ZYDIS_IELEMENT_TYPE_BFLOAT16X2,
    ZYDIS_IELEMENT_TYPE_BCD80,
    ZYDIS_IELEMENT_TYPE_CC3,
    ZYDIS_IELEMENT_TYPE_CC5,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IELEMENT_TYPE_MAX_VALUE = ZYDIS_IELEMENT_TYPE_CC5,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IELEMENT_TYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IELEMENT_TYPE_MAX_VALUE)
} ZydisInternalElementType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisImplicitRegisterType` enum.
 */
typedef enum ZydisImplicitRegisterType_
{
    // TODO: Rename OSZ|ASZ|SSZ_
    ZYDIS_IMPLREG_TYPE_STATIC,
    ZYDIS_IMPLREG_TYPE_GPR_OSZ,
    ZYDIS_IMPLREG_TYPE_GPR_ASZ,
    ZYDIS_IMPLREG_TYPE_IP_ASZ,
    ZYDIS_IMPLREG_TYPE_IP_SSZ,
    ZYDIS_IMPLREG_TYPE_GPR_SSZ,
    ZYDIS_IMPLREG_TYPE_FLAGS_SSZ,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IMPLREG_TYPE_MAX_VALUE = ZYDIS_IMPLREG_TYPE_FLAGS_SSZ,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IMPLREG_TYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IMPLREG_TYPE_MAX_VALUE)
} ZydisImplicitRegisterType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisImplicitMemBase` enum.
 */
typedef enum ZydisImplicitMemBase_
{
    // TODO: Rename OSZ|ASZ|SSZ_
    ZYDIS_IMPLMEM_BASE_AGPR_REG,
    ZYDIS_IMPLMEM_BASE_AGPR_RM,
    ZYDIS_IMPLMEM_BASE_AAX,
    ZYDIS_IMPLMEM_BASE_ADX,
    ZYDIS_IMPLMEM_BASE_ABX,
    ZYDIS_IMPLMEM_BASE_ASI,
    ZYDIS_IMPLMEM_BASE_ADI,
    ZYDIS_IMPLMEM_BASE_SSP,
    ZYDIS_IMPLMEM_BASE_SBP,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IMPLMEM_BASE_MAX_VALUE = ZYDIS_IMPLMEM_BASE_SBP,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IMPLMEM_BASE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IMPLMEM_BASE_MAX_VALUE)
} ZydisImplicitMemBase;

/* ---------------------------------------------------------------------------------------------- */

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_SEMANTIC_OPTYPE_REQUIRED_BITS     <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPERAND_VISIBILITY_REQUIRED_BITS  <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPERAND_ACTION_REQUIRED_BITS      <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_IELEMENT_TYPE_REQUIRED_BITS       <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPERAND_ENCODING_REQUIRED_BITS    <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_IMPLREG_TYPE_REQUIRED_BITS        <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_REGISTER_REQUIRED_BITS            <= 16);
ZYAN_STATIC_ASSERT(ZYDIS_IMPLMEM_BASE_REQUIRED_BITS        <=  8);

/**
 * Defines the `ZydisOperandDefinition` struct.
 */
typedef struct ZydisOperandDefinition_
{
    ZyanU8 type                            ZYAN_BITFIELD(ZYDIS_SEMANTIC_OPTYPE_REQUIRED_BITS);
    ZyanU8 visibility                      ZYAN_BITFIELD(ZYDIS_OPERAND_VISIBILITY_REQUIRED_BITS);
    ZyanU8 actions                         ZYAN_BITFIELD(ZYDIS_OPERAND_ACTION_REQUIRED_BITS);
    ZyanU16 size[3];
    ZyanU8 element_type                    ZYAN_BITFIELD(ZYDIS_IELEMENT_TYPE_REQUIRED_BITS);
    union
    {
        ZyanU8 encoding                    ZYAN_BITFIELD(ZYDIS_OPERAND_ENCODING_REQUIRED_BITS);
        struct
        {
            ZyanU8 type                    ZYAN_BITFIELD(ZYDIS_IMPLREG_TYPE_REQUIRED_BITS);
            union
            {
                ZyanU16 reg                ZYAN_BITFIELD(ZYDIS_REGISTER_REQUIRED_BITS);
                ZyanU8 id                  ZYAN_BITFIELD(6);
            } reg;
        } reg;
        struct
        {
            ZyanU8 seg                     ZYAN_BITFIELD(3);
            ZyanU8 base                    ZYAN_BITFIELD(ZYDIS_IMPLMEM_BASE_REQUIRED_BITS);
        } mem;
    } op;
    ZyanBool is_multisource4               ZYAN_BITFIELD(1);
    ZyanBool ignore_seg_override           ZYAN_BITFIELD(1);
} ZydisOperandDefinition;

/* ---------------------------------------------------------------------------------------------- */
/* Instruction definition                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisReadWriteAction` enum.
 */
typedef enum ZydisReadWriteAction_
{
    ZYDIS_RW_ACTION_NONE,
    ZYDIS_RW_ACTION_READ,
    ZYDIS_RW_ACTION_WRITE,
    ZYDIS_RW_ACTION_READWRITE,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_RW_ACTION_MAX_VALUE = ZYDIS_RW_ACTION_READWRITE,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_RW_ACTION_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_RW_ACTION_MAX_VALUE)
} ZydisReadWriteAction;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInternalVectorLength` enum.
 */
typedef enum ZydisInternalVectorLength_
{
    ZYDIS_IVECTOR_LENGTH_DEFAULT,
    ZYDIS_IVECTOR_LENGTH_FIXED_128,
    ZYDIS_IVECTOR_LENGTH_FIXED_256,
    ZYDIS_IVECTOR_LENGTH_FIXED_512,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IVECTOR_LENGTH_MAX_VALUE = ZYDIS_IVECTOR_LENGTH_FIXED_512,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IVECTOR_LENGTH_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IVECTOR_LENGTH_MAX_VALUE)
} ZydisInternalVectorLength;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInternalElementSize` enum.
 */
typedef enum ZydisInternalElementSize_
{
    ZYDIS_IELEMENT_SIZE_INVALID,
    ZYDIS_IELEMENT_SIZE_8,
    ZYDIS_IELEMENT_SIZE_16,
    ZYDIS_IELEMENT_SIZE_32,
    ZYDIS_IELEMENT_SIZE_64,
    ZYDIS_IELEMENT_SIZE_128,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IELEMENT_SIZE_MAX_VALUE = ZYDIS_IELEMENT_SIZE_128,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IELEMENT_SIZE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IELEMENT_SIZE_MAX_VALUE)
} ZydisInternalElementSize;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisEVEXFunctionality` enum.
 */
typedef enum ZydisEVEXFunctionality_
{
    ZYDIS_EVEX_FUNC_INVALID,
    /**
     * `EVEX.b` enables broadcast functionality.
     */
    ZYDIS_EVEX_FUNC_BC,
    /**
     * `EVEX.b` enables embedded-rounding functionality.
     */
    ZYDIS_EVEX_FUNC_RC,
    /**
     * `EVEX.b` enables sae functionality.
     */
    ZYDIS_EVEX_FUNC_SAE,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_EVEX_FUNC_MAX_VALUE = ZYDIS_EVEX_FUNC_SAE,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_EVEX_FUNC_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_EVEX_FUNC_MAX_VALUE)
} ZydisEVEXFunctionality;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisEVEXTupleType` enum.
 */
typedef enum ZydisEVEXTupleType_
{
    ZYDIS_TUPLETYPE_INVALID,
    /**
     * Full Vector
     */
    ZYDIS_TUPLETYPE_FV,
    /**
     * Half Vector
     */
    ZYDIS_TUPLETYPE_HV,
    /**
     * Full Vector Mem
     */
    ZYDIS_TUPLETYPE_FVM,
    /**
     * Tuple1 Scalar
     */
    ZYDIS_TUPLETYPE_T1S,
    /**
     * Tuple1 Fixed
     */
    ZYDIS_TUPLETYPE_T1F,
    /**
     * Tuple1 4x32
     */
    ZYDIS_TUPLETYPE_T1_4X,
    /**
     * Gather / Scatter
     */
    ZYDIS_TUPLETYPE_GSCAT,
    /**
     * Tuple2
     */
    ZYDIS_TUPLETYPE_T2,
    /**
     * Tuple4
     */
    ZYDIS_TUPLETYPE_T4,
    /**
     * Tuple8
     */
    ZYDIS_TUPLETYPE_T8,
    /**
     * Half Mem
     */
    ZYDIS_TUPLETYPE_HVM,
    /**
     * QuarterMem
     */
    ZYDIS_TUPLETYPE_QVM,
    /**
     * OctMem
     */
    ZYDIS_TUPLETYPE_OVM,
    /**
     * Mem128
     */
    ZYDIS_TUPLETYPE_M128,
    /**
     * MOVDDUP
     */
    ZYDIS_TUPLETYPE_DUP,
    /**
     * Quarter of the vector-length.
     */
    ZYDIS_TUPLETYPE_QUARTER,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_TUPLETYPE_MAX_VALUE = ZYDIS_TUPLETYPE_QUARTER,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_TUPLETYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_TUPLETYPE_MAX_VALUE)
} ZydisEVEXTupleType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMVEXFunctionality` enum.
 */
typedef enum ZydisMVEXFunctionality_
{
    /**
     * The `MVEX.SSS` value is ignored.
     */
    ZYDIS_MVEX_FUNC_IGNORED,
    /**
     * `MVEX.SSS` must be `000b`.
     */
    ZYDIS_MVEX_FUNC_INVALID,
    /**
     * `MVEX.SSS` controls embedded-rounding functionality.
     */
    ZYDIS_MVEX_FUNC_RC,
    /**
     * `MVEX.SSS` controls sae functionality.
     */
    ZYDIS_MVEX_FUNC_SAE,
    /**
     * No special operation (32bit float elements).
     */
    ZYDIS_MVEX_FUNC_F_32,
    /**
     * No special operation (32bit uint elements).
     */
    ZYDIS_MVEX_FUNC_I_32,
    /**
     * No special operation (64bit float elements).
     */
    ZYDIS_MVEX_FUNC_F_64,
    /**
     * No special operation (64bit uint elements).
     */
    ZYDIS_MVEX_FUNC_I_64,
    /**
     * Sf32(reg) or Si32(reg).
     */
    ZYDIS_MVEX_FUNC_SWIZZLE_32,
    /**
     * Sf64(reg) or Si64(reg).
     */
    ZYDIS_MVEX_FUNC_SWIZZLE_64,
    /**
     * Sf32(mem).
     */
    ZYDIS_MVEX_FUNC_SF_32,
    /**
     * Sf32(mem) broadcast only.
     */
    ZYDIS_MVEX_FUNC_SF_32_BCST,
    /**
     * Sf32(mem) broadcast 4to16 only.
     */
    ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16,
    /**
     * Sf64(mem).
     */
    ZYDIS_MVEX_FUNC_SF_64,
    /**
     * Si32(mem).
     */
    ZYDIS_MVEX_FUNC_SI_32,
    /**
     * Si32(mem) broadcast only.
     */
    ZYDIS_MVEX_FUNC_SI_32_BCST,
    /**
     * Si32(mem) broadcast 4to16 only.
     */
    ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16,
    /**
     * Si64(mem).
     */
    ZYDIS_MVEX_FUNC_SI_64,
    /**
     * Uf32.
     */
    ZYDIS_MVEX_FUNC_UF_32,
    /**
     * Uf64.
     */
    ZYDIS_MVEX_FUNC_UF_64,
    /**
     * Ui32.
     */
    ZYDIS_MVEX_FUNC_UI_32,
    /**
     * Ui64.
     */
    ZYDIS_MVEX_FUNC_UI_64,
    /**
     * Df32.
     */
    ZYDIS_MVEX_FUNC_DF_32,
    /**
     * Df64.
     */
    ZYDIS_MVEX_FUNC_DF_64,
    /**
     * Di32.
     */
    ZYDIS_MVEX_FUNC_DI_32,
    /**
     * Di64.
     */
    ZYDIS_MVEX_FUNC_DI_64,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MVEX_FUNC_MAX_VALUE = ZYDIS_MVEX_FUNC_DI_64,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MVEX_FUNC_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MVEX_FUNC_MAX_VALUE)
} ZydisMVEXFunctionality;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisVEXStaticBroadcast` enum.
 */
typedef enum ZydisVEXStaticBroadcast
{
    ZYDIS_VEX_STATIC_BROADCAST_NONE,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_2,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_4,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_8,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_16,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_32,
    ZYDIS_VEX_STATIC_BROADCAST_2_TO_4,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_VEX_STATIC_BROADCAST_MAX_VALUE = ZYDIS_VEX_STATIC_BROADCAST_2_TO_4,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_VEX_STATIC_BROADCAST_REQUIRED_BITS =
        ZYAN_BITS_TO_REPRESENT(ZYDIS_VEX_STATIC_BROADCAST_MAX_VALUE)
} ZydisVEXStaticBroadcast;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisEVEXStaticBroadcast` enum.
 */
typedef enum ZydisEVEXStaticBroadcast_
{
    ZYDIS_EVEX_STATIC_BROADCAST_NONE,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_2,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_4,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_8,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_16,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_32,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_64,
    ZYDIS_EVEX_STATIC_BROADCAST_2_TO_4,
    ZYDIS_EVEX_STATIC_BROADCAST_2_TO_8,
    ZYDIS_EVEX_STATIC_BROADCAST_2_TO_16,
    ZYDIS_EVEX_STATIC_BROADCAST_4_TO_8,
    ZYDIS_EVEX_STATIC_BROADCAST_4_TO_16,
    ZYDIS_EVEX_STATIC_BROADCAST_8_TO_16,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_EVEX_STATIC_BROADCAST_MAX_VALUE = ZYDIS_EVEX_STATIC_BROADCAST_8_TO_16,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_EVEX_STATIC_BROADCAST_REQUIRED_BITS =
        ZYAN_BITS_TO_REPRESENT(ZYDIS_EVEX_STATIC_BROADCAST_MAX_VALUE)
} ZydisEVEXStaticBroadcast;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMVEXStaticBroadcast` enum.
 */
typedef enum ZydisMVEXStaticBroadcast_
{
    ZYDIS_MVEX_STATIC_BROADCAST_NONE,
    ZYDIS_MVEX_STATIC_BROADCAST_1_TO_8,
    ZYDIS_MVEX_STATIC_BROADCAST_1_TO_16,
    ZYDIS_MVEX_STATIC_BROADCAST_4_TO_8,
    ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MVEX_STATIC_BROADCAST_MAX_VALUE = ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MVEX_STATIC_BROADCAST_REQUIRED_BITS =
        ZYAN_BITS_TO_REPRESENT(ZYDIS_MVEX_STATIC_BROADCAST_MAX_VALUE)
} ZydisMVEXStaticBroadcast;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMaskPolicy` enum.
 */
typedef enum ZydisMaskPolicy_
{
    ZYDIS_MASK_POLICY_INVALID,
    /**
     * The instruction accepts mask-registers other than the default-mask (K0), but
     *          does not require them.
     */
    ZYDIS_MASK_POLICY_ALLOWED,
    /**
     * The instruction requires a mask-register other than the default-mask (K0).
     */
    ZYDIS_MASK_POLICY_REQUIRED,
    /**
     * The instruction does not allow a mask-register other than the default-mask (K0).
     */
    ZYDIS_MASK_POLICY_FORBIDDEN,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MASK_POLICY_MAX_VALUE = ZYDIS_MASK_POLICY_FORBIDDEN,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MASK_POLICY_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MASK_POLICY_MAX_VALUE)
} ZydisMaskPolicy;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMaskOverride` enum.
 */
typedef enum ZydisMaskOverride_
{
    ZYDIS_MASK_OVERRIDE_DEFAULT,
    ZYDIS_MASK_OVERRIDE_ZEROING,
    ZYDIS_MASK_OVERRIDE_CONTROL,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MASK_OVERRIDE_MAX_VALUE = ZYDIS_MASK_OVERRIDE_CONTROL,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MASK_OVERRIDE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MASK_OVERRIDE_MAX_VALUE)
} ZydisMaskOverride;

/* ---------------------------------------------------------------------------------------------- */

#define ZYDIS_OPDEF_REQUIRED_BITS \
    ZYAN_MAX(ZYDIS_REGKIND_REQUIRED_BITS, ZYDIS_MEMOP_TYPE_REQUIRED_BITS + 1) + 1

#define ZYDIS_OPDEF_GET_REG(operand_definition) \
    ((operand_definition) & ((1 << ZYDIS_REGKIND_REQUIRED_BITS   ) - 1))

#define ZYDIS_OPDEF_GET_MEM(operand_definition) \
    ((operand_definition) & ((1 << ZYDIS_MEMOP_TYPE_REQUIRED_BITS) - 1))

#define ZYDIS_OPDEF_GET_REG_HIGH_BIT(operand_definition) \
    (((operand_definition) >> ZYDIS_REGKIND_REQUIRED_BITS   ) & 0x01)

#define ZYDIS_OPDEF_GET_MEM_HIGH_BIT(operand_definition) \
    (((operand_definition) >> ZYDIS_MEMOP_TYPE_REQUIRED_BITS) & 0x01)

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_MNEMONIC_REQUIRED_BITS        <= 16);
ZYAN_STATIC_ASSERT(ZYDIS_CATEGORY_REQUIRED_BITS        <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_ISA_SET_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_ISA_EXT_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_BRANCH_TYPE_REQUIRED_BITS     <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_EXCEPTION_CLASS_REQUIRED_BITS <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPDEF_REQUIRED_BITS           <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_RW_ACTION_REQUIRED_BITS       <=  8);

#ifndef ZYDIS_MINIMAL_MODE
#   define ZYDIS_INSTRUCTION_DEFINITION_BASE \
        ZyanU16 mnemonic                       ZYAN_BITFIELD(ZYDIS_MNEMONIC_REQUIRED_BITS); \
        ZyanU8 operand_count                   ZYAN_BITFIELD( 4); \
        ZyanU8 operand_count_visible           ZYAN_BITFIELD( 3); \
        ZyanU16 operand_reference              ZYAN_BITFIELD(15); \
        ZyanU8 operand_size_map                ZYAN_BITFIELD( 3); \
        ZyanU8 address_size_map                ZYAN_BITFIELD( 2); \
        ZyanU8 flags_reference                 ZYAN_BITFIELD( 7); \
        ZyanBool requires_protected_mode       ZYAN_BITFIELD( 1); \
        ZyanBool no_compat_mode                ZYAN_BITFIELD( 1); \
        ZyanU8 category                        ZYAN_BITFIELD(ZYDIS_CATEGORY_REQUIRED_BITS); \
        ZyanU8 isa_set                         ZYAN_BITFIELD(ZYDIS_ISA_SET_REQUIRED_BITS); \
        ZyanU8 isa_ext                         ZYAN_BITFIELD(ZYDIS_ISA_EXT_REQUIRED_BITS); \
        ZyanU8 branch_type                     ZYAN_BITFIELD(ZYDIS_BRANCH_TYPE_REQUIRED_BITS); \
        ZyanU8 exception_class                 ZYAN_BITFIELD(ZYDIS_EXCEPTION_CLASS_REQUIRED_BITS); \
        ZyanU8 op_reg                          ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS); \
        ZyanU8 op_rm                           ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS); \
        ZyanU8 cpu_state                       ZYAN_BITFIELD(ZYDIS_RW_ACTION_REQUIRED_BITS); \
        ZyanU8 fpu_state                       ZYAN_BITFIELD(ZYDIS_RW_ACTION_REQUIRED_BITS); \
        ZyanU8 xmm_state                       ZYAN_BITFIELD(ZYDIS_RW_ACTION_REQUIRED_BITS); \
        ZyanBool accepts_segment               ZYAN_BITFIELD( 1)
#else
#   define ZYDIS_INSTRUCTION_DEFINITION_BASE \
        ZyanU16 mnemonic                       ZYAN_BITFIELD(ZYDIS_MNEMONIC_REQUIRED_BITS); \
        ZyanU8 operand_size_map                ZYAN_BITFIELD( 3); \
        ZyanU8 address_size_map                ZYAN_BITFIELD( 2); \
        ZyanBool requires_protected_mode       ZYAN_BITFIELD( 1); \
        ZyanBool no_compat_mode                ZYAN_BITFIELD( 1); \
        ZyanU8 op_reg                          ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS); \
        ZyanU8 op_rm                           ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS)
#endif

#define ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR \
    ZYDIS_INSTRUCTION_DEFINITION_BASE; \
    ZyanU8 op_ndsndd                       ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS)

#define ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL \
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR; \
    ZyanBool is_gather                     ZYAN_BITFIELD( 1); \
    ZyanBool no_source_dest_match          ZYAN_BITFIELD( 1); \
    ZyanBool no_source_source_match        ZYAN_BITFIELD( 1)        // TODO: Could be moved to VEX

/**
 * Defines the `ZydisInstructionDefinition` struct.
 */
typedef struct ZydisInstructionDefinition_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE;
} ZydisInstructionDefinition;

/**
 * Defines the `ZydisInstructionDefinitionLEGACY` struct.
 */
typedef struct ZydisInstructionDefinitionLEGACY_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE;
#ifndef ZYDIS_MINIMAL_MODE
    ZyanBool is_privileged                 ZYAN_BITFIELD(1);
#endif
    ZyanBool accepts_LOCK                  ZYAN_BITFIELD(1);
#ifndef ZYDIS_MINIMAL_MODE
    ZyanBool accepts_REP                   ZYAN_BITFIELD(1);
    ZyanBool accepts_REPEREPZ              ZYAN_BITFIELD(1);
    ZyanBool accepts_REPNEREPNZ            ZYAN_BITFIELD(1);
    ZyanBool accepts_BOUND                 ZYAN_BITFIELD(1);
    ZyanBool accepts_XACQUIRE              ZYAN_BITFIELD(1);
    ZyanBool accepts_XRELEASE              ZYAN_BITFIELD(1);
    ZyanBool accepts_NOTRACK               ZYAN_BITFIELD(1);
    ZyanBool accepts_hle_without_lock      ZYAN_BITFIELD(1);
    ZyanBool accepts_branch_hints          ZYAN_BITFIELD(1);
#endif
} ZydisInstructionDefinitionLEGACY;

/**
 * Defines the `ZydisInstructionDefinition3DNOW` struct.
 */
typedef struct ZydisInstructionDefinition3DNOW_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE;
} ZydisInstructionDefinition3DNOW;

/**
 * Defines the `ZydisInstructionDefinitionXOP` struct.
 */
typedef struct ZydisInstructionDefinitionXOP_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR;
} ZydisInstructionDefinitionXOP;

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_VEX_STATIC_BROADCAST_REQUIRED_BITS  <=  8);

/**
 * Defines the `ZydisInstructionDefinitionVEX` struct.
 */
typedef struct ZydisInstructionDefinitionVEX_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL;
#ifndef ZYDIS_MINIMAL_MODE
    ZyanU8 broadcast                       ZYAN_BITFIELD(ZYDIS_VEX_STATIC_BROADCAST_REQUIRED_BITS);
#endif
} ZydisInstructionDefinitionVEX;

#ifndef ZYDIS_DISABLE_AVX512

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_IVECTOR_LENGTH_REQUIRED_BITS        <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_TUPLETYPE_REQUIRED_BITS             <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_IELEMENT_SIZE_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_EVEX_FUNC_REQUIRED_BITS             <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MASK_POLICY_REQUIRED_BITS           <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MASK_OVERRIDE_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_EVEX_STATIC_BROADCAST_REQUIRED_BITS <=  8);

/**
 * Defines the `ZydisInstructionDefinitionEVEX` struct.
 */
typedef struct ZydisInstructionDefinitionEVEX_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL;
#ifndef ZYDIS_MINIMAL_MODE
    ZyanU8 vector_length                   ZYAN_BITFIELD(ZYDIS_IVECTOR_LENGTH_REQUIRED_BITS);
    ZyanU8 tuple_type                      ZYAN_BITFIELD(ZYDIS_TUPLETYPE_REQUIRED_BITS);
    ZyanU8 element_size                    ZYAN_BITFIELD(ZYDIS_IELEMENT_SIZE_REQUIRED_BITS);
    ZyanU8 functionality                   ZYAN_BITFIELD(ZYDIS_EVEX_FUNC_REQUIRED_BITS);
#endif
    ZyanU8 mask_policy                     ZYAN_BITFIELD(ZYDIS_MASK_POLICY_REQUIRED_BITS);
    ZyanBool accepts_zero_mask             ZYAN_BITFIELD(1);
#ifndef ZYDIS_MINIMAL_MODE
    ZyanU8 mask_override                   ZYAN_BITFIELD(ZYDIS_MASK_OVERRIDE_REQUIRED_BITS);
    ZyanU8 broadcast                       ZYAN_BITFIELD(ZYDIS_EVEX_STATIC_BROADCAST_REQUIRED_BITS);
#endif
} ZydisInstructionDefinitionEVEX;
#endif

#ifndef ZYDIS_DISABLE_KNC

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_MVEX_FUNC_REQUIRED_BITS             <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MASK_POLICY_REQUIRED_BITS           <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MVEX_STATIC_BROADCAST_REQUIRED_BITS <=  8);

/**
 * Defines the `ZydisInstructionDefinitionMVEX` struct.
 */
typedef struct ZydisInstructionDefinitionMVEX_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL;
    ZyanU8 functionality                   ZYAN_BITFIELD(ZYDIS_MVEX_FUNC_REQUIRED_BITS);
    ZyanU8 mask_policy                     ZYAN_BITFIELD(ZYDIS_MASK_POLICY_REQUIRED_BITS);
#ifndef ZYDIS_MINIMAL_MODE
    ZyanBool has_element_granularity       ZYAN_BITFIELD(1);
    ZyanU8 broadcast                       ZYAN_BITFIELD(ZYDIS_MVEX_STATIC_BROADCAST_REQUIRED_BITS);
#endif
} ZydisInstructionDefinitionMVEX;
#endif

/* ---------------------------------------------------------------------------------------------- */

#pragma pack(pop)

#ifdef ZYAN_MSVC
#   pragma warning(pop)
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Accessed CPU/FPU flags                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/*
 * Contains information about the CPU/FPU flags accessed by an instruction.
 *
 * We don't want this struct to be packed! A pointer to the individual members will be used by the
 * `ZydisDecodedInstruction` struct.
 */
typedef struct ZydisDefinitionAccessedFlags_
{
    ZydisAccessedFlags cpu_flags;
    ZydisAccessedFlags fpu_flags;
} ZydisDefinitionAccessedFlags;

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Functions                                                                                      */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Instruction definition                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Returns the instruction-definition with the given `encoding` and `id`.
 *
 * @param   encoding    The instruction-encoding.
 * @param   id          The definition-id.
 * @param   definition  A pointer to the variable that receives a pointer to the instruction-
 *                      definition.
 */
ZYDIS_NO_EXPORT void ZydisGetInstructionDefinition(ZydisInstructionEncoding encoding,
        ZyanU16 id, const ZydisInstructionDefinition** definition);

/* ---------------------------------------------------------------------------------------------- */
/* Operand definition                                                                             */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Returns the the operand-definitions for the given instruction-`definition`.
 *
 * @param   definition  A pointer to the instruction-definition.
 *
 * @return  A pointer to the first operand definition of the instruction, or `ZYAN_NULL`.
 */
ZYDIS_NO_EXPORT const ZydisOperandDefinition* ZydisGetOperandDefinitions(
    const ZydisInstructionDefinition* definition);
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Element info                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Returns the actual type and size of an internal element-type.
 *
 * @param   element The internal element type.
 * @param   type    The actual element type.
 * @param   size    The element size.
 */
ZYDIS_NO_EXPORT void ZydisGetElementInfo(ZydisInternalElementType element, ZydisElementType* type,
        ZydisElementSize* size);
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Accessed CPU flags                                                                             */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Returns the the operand-definitions for the given instruction-`definition`.
 *
 * @param   definition  A pointer to the instruction-definition.
 * @param   flags       A pointer to the variable that receives the `ZydisDefinitionAccessedFlags`
 *                      struct.
 *
 * @return  `ZYAN_TRUE`, if the instruction accesses any flags, or `ZYAN_FALSE`, if not.
 */
ZYDIS_NO_EXPORT ZyanBool ZydisGetAccessedFlags(const ZydisInstructionDefinition* definition,
        const ZydisDefinitionAccessedFlags** flags);
#endif

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* ZYDIS_INTERNAL_SHAREDDATA_H */

/* ============================================================================================== */
/* Macros                                                                                         */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Constants                                                                                      */
/* ---------------------------------------------------------------------------------------------- */

#define ZYDIS_OPSIZE_MAP_BYTEOP                 1
#define ZYDIS_OPSIZE_MAP_DEFAULT64              4
#define ZYDIS_OPSIZE_MAP_FORCE64                5
#define ZYDIS_ADSIZE_MAP_IGNORED                1
#define ZYDIS_LEGACY_SEGMENTS                   (ZYDIS_ATTRIB_HAS_SEGMENT_CS | \
                                                 ZYDIS_ATTRIB_HAS_SEGMENT_SS | \
                                                 ZYDIS_ATTRIB_HAS_SEGMENT_DS | \
                                                 ZYDIS_ATTRIB_HAS_SEGMENT_ES)
#define ZYDIS_ENCODABLE_PREFIXES_NO_SEGMENTS    (ZYDIS_ENCODABLE_PREFIXES ^ \
                                                 ZYDIS_ATTRIB_HAS_SEGMENT)

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Internal enums and types                                                                       */
/* ============================================================================================== */

/**
 * Usage of `REX.W` prefix makes it impossible to use some byte-sized registers. Values of this
 * enum are used to track and facilitate enforcement of these restrictions.
 */
typedef enum ZydisEncoderRexType_
{
    ZYDIS_REX_TYPE_UNKNOWN,
    ZYDIS_REX_TYPE_REQUIRED,
    ZYDIS_REX_TYPE_FORBIDDEN,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_REX_TYPE_MAX_VALUE = ZYDIS_REX_TYPE_FORBIDDEN,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_REX_TYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_REX_TYPE_MAX_VALUE)
} ZydisEncoderRexType;

/**
 * Primary structure used during instruction matching phase. Once filled it contains information
 * about matched instruction definition and some values deduced from encoder request. It gets
 * converted to `ZydisEncoderInstruction` during instruction building phase.
 */
typedef struct ZydisEncoderInstructionMatch_
{
    /**
     * A pointer to the `ZydisEncoderRequest` instance.
     */
    const ZydisEncoderRequest* request;
    /**
     * A pointer to the `ZydisEncodableInstruction` instance.
     */
    const ZydisEncodableInstruction* definition;
    /**
     * A pointer to the `ZydisInstructionDefinition` instance.
     */
    const ZydisInstructionDefinition* base_definition;
    /**
     * A pointer to the `ZydisOperandDefinition` array.
     */
    const ZydisOperandDefinition* operands;
    /**
     * Encodable attributes for this instruction.
     */
    ZydisInstructionAttributes attributes;
    /**
     * Effective operand size attribute.
     */
    ZyanU8 eosz;
    /**
     * Effective address size attribute.
     */
    ZyanU8 easz;
    /**
     * Effective displacement size.
     */
    ZyanU8 disp_size;
    /**
     * Effective immediate size.
     */
    ZyanU8 imm_size;
    /**
     * Exponent of compressed displacement scale factor (2^cd8_scale)
     */
    ZyanU8 cd8_scale;
    /**
     * `REX` prefix constraints.
     */
    ZydisEncoderRexType rex_type;
    /**
     * True for special cases where operand size attribute must be lower than 64 bits.
     */
    ZyanBool eosz64_forbidden;
    /**
     * True when instruction definition has relative operand (used for branching instructions).
     */
    ZyanBool has_rel_operand;
} ZydisEncoderInstructionMatch;

/**
 * Encapsulates information about writable buffer.
 */
typedef struct ZydisEncoderBuffer_
{
    /**
     * A pointer to actual data buffer.
     */
    ZyanU8* buffer;
    /**
     * Size of this buffer.
     */
    ZyanUSize size;
    /**
     * Current write offset.
     */
    ZyanUSize offset;
} ZydisEncoderBuffer;

/**
 * Low-level instruction representation. Once filled this structure contains all information
 * required for final instruction emission phase.
 */
typedef struct ZydisEncoderInstruction_
{
    /**
     * Encodable attributes for this instruction.
     */
    ZydisInstructionAttributes attributes;
    /**
     * The instruction encoding.
     */
    ZydisInstructionEncoding encoding;
    /**
     * The opcode map.
     */
    ZydisOpcodeMap opcode_map;
    /**
     * The opcode.
     */
    ZyanU8 opcode;
    /**
     * The `vvvv` field (`VEX`, `EVEX`, `MVEX`, `XOP`).
     */
    ZyanU8 vvvv;
    /**
     * The `sss` field (`MVEX`).
     */
    ZyanU8 sss;
    /**
     * The mask register ID.
     */
    ZyanU8 mask;
    /**
     * The vector length.
     */
    ZyanU8 vector_length;
    /**
     * The `mod` component of Mod/RM byte.
     */
    ZyanU8 mod;
    /**
     * The `reg` component of Mod/RM byte.
     */
    ZyanU8 reg;
    /**
     * The `rm` component of Mod/RM byte.
     */
    ZyanU8 rm;
    /**
     * The scale component of SIB byte.
     */
    ZyanU8 scale;
    /**
     * The index component of SIB byte.
     */
    ZyanU8 index;
    /**
     * The base component of SIB byte.
     */
    ZyanU8 base;
    /**
     * The `REX.W` bit.
     */
    ZyanBool rex_w;
    /**
     * True if using zeroing mask (`EVEX`).
     */
    ZyanBool zeroing;
    /**
     * True if using eviction hint (`MVEX`).
     */
    ZyanBool eviction_hint;
    /**
     * Size of displacement value.
     */
    ZyanU8 disp_size;
    /**
     * Size of immediate value.
     */
    ZyanU8 imm_size;
    /**
     * The displacement value.
     */
    ZyanU64 disp;
    /**
     * The immediate value.
     */
    ZyanU64 imm;
} ZydisEncoderInstruction;

/* ============================================================================================== */
/* Internal functions                                                                             */
/* ============================================================================================== */

/**
 * Converts `ZydisInstructionEncoding` to `ZydisEncodableEncoding`.
 *
 * @param   encoding `ZydisInstructionEncoding` value to convert.
 *
 * @return  Equivalent `ZydisEncodableEncoding` value.
 */
static ZydisEncodableEncoding ZydisGetEncodableEncoding(ZydisInstructionEncoding encoding)
{
    static const ZydisEncodableEncoding encoding_lookup[6] =
    {
        ZYDIS_ENCODABLE_ENCODING_LEGACY,
        ZYDIS_ENCODABLE_ENCODING_3DNOW,
        ZYDIS_ENCODABLE_ENCODING_XOP,
        ZYDIS_ENCODABLE_ENCODING_VEX,
        ZYDIS_ENCODABLE_ENCODING_EVEX,
        ZYDIS_ENCODABLE_ENCODING_MVEX,
    };
    ZYAN_ASSERT((ZyanUSize)encoding <= ZYDIS_INSTRUCTION_ENCODING_MAX_VALUE);
    return encoding_lookup[encoding];
}

/**
 * Converts `ZydisMachineMode` to default stack width value expressed in bits.
 *
 * @param   machine_mode `ZydisMachineMode` value to convert.
 *
 * @return  Stack width for requested machine mode.
 */
static ZyanU8 ZydisGetMachineModeWidth(ZydisMachineMode machine_mode)
{
    switch(machine_mode)
    {
    case ZYDIS_MACHINE_MODE_REAL_16:
    case ZYDIS_MACHINE_MODE_LEGACY_16:
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
        return 16;
    case ZYDIS_MACHINE_MODE_LEGACY_32:
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
        return 32;
    case ZYDIS_MACHINE_MODE_LONG_64:
        return 64;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Converts `ZydisAddressSizeHint` to address size expressed in bits.
 *
 * @param   hint Address size hint.
 *
 * @return  Address size in bits.
 */
static ZyanU8 ZydisGetAszFromHint(ZydisAddressSizeHint hint)
{
    ZYAN_ASSERT((ZyanUSize)hint <= ZYDIS_ADDRESS_SIZE_HINT_MAX_VALUE);
    static const ZyanU8 lookup[ZYDIS_ADDRESS_SIZE_HINT_MAX_VALUE + 1] = { 0, 16, 32, 64 };
    return lookup[hint];
}

/**
 * Converts `ZydisOperandSizeHint` to operand size expressed in bits.
 *
 * @param   hint Operand size hint.
 *
 * @return  Operand size in bits.
 */
static ZyanU8 ZydisGetOszFromHint(ZydisOperandSizeHint hint)
{
    ZYAN_ASSERT((ZyanUSize)hint <= ZYDIS_OPERAND_SIZE_HINT_MAX_VALUE);
    static const ZyanU8 lookup[ZYDIS_OPERAND_SIZE_HINT_MAX_VALUE + 1] = { 0, 8, 16, 32, 64 };
    return lookup[hint];
}

/**
 * Calculates effective operand size.
 *
 * @param   match            A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   size_table       Array of possible size values for different operand sizes.
 * @param   desired_size     Operand size requested by caller.
 * @param   exact_match_mode True if desired_size must be matched exactly, false when
 *                           "not lower than" matching is desired.
 *
 * @return  Effective operand size in bits.
 */
static ZyanU8 ZydisGetOperandSizeFromElementSize(ZydisEncoderInstructionMatch* match,
        const ZyanU16* size_table, ZyanU16 desired_size, ZyanBool exact_match_mode)
{
    if((match->base_definition->operand_size_map == ZYDIS_OPSIZE_MAP_DEFAULT64) &&
            (match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64))
    {
        if((exact_match_mode && (size_table[2] == desired_size)) ||
                (!exact_match_mode && (size_table[2] >= desired_size)))
        {
            return 64;
        }
        else if(size_table[0] == desired_size)
        {
            return 16;
        }
    }
    else if((match->base_definition->operand_size_map == ZYDIS_OPSIZE_MAP_FORCE64) &&
            (match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64))
    {
        if(size_table[2] == desired_size)
        {
            return 64;
        }
    }
    else
    {
        static const ZyanI8 eosz_priority_lookup[4][3] =
        {
            {  0,  1, -1 },
            {  1,  0, -1 },
            {  1,  2,  0 },
        };
        const ZyanU8 eosz_index = ZydisGetMachineModeWidth(match->request->machine_mode) >> 5;
        for(int i = 0; i < 3; ++i)
        {
            const ZyanI8 eosz_candidate = eosz_priority_lookup[eosz_index][i];
            if((eosz_candidate == -1) ||
                    !(match->definition->operand_sizes & (1 << eosz_candidate)))
            {
                continue;
            }
            if((exact_match_mode && (size_table[eosz_candidate] == desired_size)) ||
                    (!exact_match_mode && (size_table[eosz_candidate] >= desired_size)))
            {
                return 16 << eosz_candidate;
            }
        }
    }

    return 0;
}

/**
 * Calculates effective immediate size.
 *
 * @param   match        A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   size_table   Array of possible size values for different operand sizes.
 * @param   min_imm_size Minimum immediate size.
 *
 * @return  Effective operand size in bits.
 */
static ZyanU8 ZydisGetScaledImmSize(ZydisEncoderInstructionMatch* match, const ZyanU16* size_table,
                                    ZyanU8 min_imm_size)
{
    if(match->eosz == 0)
    {
        match->eosz = ZydisGetOperandSizeFromElementSize(match, size_table, min_imm_size,
                      ZYAN_FALSE);
        return match->eosz != 0 ? (ZyanU8)size_table[match->eosz >> 5] : 0;
    }

    const ZyanU8 index = match->eosz >> 5;
    return size_table[index] >= min_imm_size ? (ZyanU8)size_table[index] : 0;
}

/**
 * Calculates size of smallest integral type able to represent provided signed value.
 *
 * @param   imm Immediate to be represented.
 *
 * @return  Size of smallest integral type able to represent provided signed value.
 */
static ZyanU8 ZydisGetSignedImmSize(ZyanI64 imm)
{
    if(imm >= ZYAN_INT8_MIN && imm <= ZYAN_INT8_MAX)
    {
        return 8;
    }
    if(imm >= ZYAN_INT16_MIN && imm <= ZYAN_INT16_MAX)
    {
        return 16;
    }
    if(imm >= ZYAN_INT32_MIN && imm <= ZYAN_INT32_MAX)
    {
        return 32;
    }

    return 64;
}

/**
 * Calculates size of smallest integral type able to represent provided unsigned value.
 *
 * @param   imm Immediate to be represented.
 *
 * @return  Size of smallest integral type able to represent provided unsigned value.
 */
static ZyanU8 ZydisGetUnsignedImmSize(ZyanU64 imm)
{
    if(imm <= ZYAN_UINT8_MAX)
    {
        return 8;
    }
    if(imm <= ZYAN_UINT16_MAX)
    {
        return 16;
    }
    if(imm <= ZYAN_UINT32_MAX)
    {
        return 32;
    }

    return 64;
}

/**
 * Checks if operand encoding encodes a signed immediate value.
 *
 * @param   encoding Operand encoding for immediate value.
 *
 * @return  True for encodings that represent signed values, false otherwise.
 */
static ZyanBool ZydisIsImmSigned(ZydisOperandEncoding encoding)
{
    switch(encoding)
    {
    case ZYDIS_OPERAND_ENCODING_SIMM8:
    case ZYDIS_OPERAND_ENCODING_SIMM16:
    case ZYDIS_OPERAND_ENCODING_SIMM32:
    case ZYDIS_OPERAND_ENCODING_SIMM64:
    case ZYDIS_OPERAND_ENCODING_SIMM16_32_64:
    case ZYDIS_OPERAND_ENCODING_SIMM32_32_64:
    case ZYDIS_OPERAND_ENCODING_SIMM16_32_32:
    case ZYDIS_OPERAND_ENCODING_JIMM8:
    case ZYDIS_OPERAND_ENCODING_JIMM16:
    case ZYDIS_OPERAND_ENCODING_JIMM32:
    case ZYDIS_OPERAND_ENCODING_JIMM64:
    case ZYDIS_OPERAND_ENCODING_JIMM16_32_64:
    case ZYDIS_OPERAND_ENCODING_JIMM32_32_64:
    case ZYDIS_OPERAND_ENCODING_JIMM16_32_32:
        return ZYAN_TRUE;
    case ZYDIS_OPERAND_ENCODING_DISP8:
    case ZYDIS_OPERAND_ENCODING_DISP16:
    case ZYDIS_OPERAND_ENCODING_DISP32:
    case ZYDIS_OPERAND_ENCODING_DISP64:
    case ZYDIS_OPERAND_ENCODING_DISP16_32_64:
    case ZYDIS_OPERAND_ENCODING_DISP32_32_64:
    case ZYDIS_OPERAND_ENCODING_DISP16_32_32:
    case ZYDIS_OPERAND_ENCODING_UIMM8:
    case ZYDIS_OPERAND_ENCODING_UIMM16:
    case ZYDIS_OPERAND_ENCODING_UIMM32:
    case ZYDIS_OPERAND_ENCODING_UIMM64:
    case ZYDIS_OPERAND_ENCODING_UIMM16_32_64:
    case ZYDIS_OPERAND_ENCODING_UIMM32_32_64:
    case ZYDIS_OPERAND_ENCODING_UIMM16_32_32:
    case ZYDIS_OPERAND_ENCODING_IS4:
        return ZYAN_FALSE;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Calculates effective immediate size.
 *
 * @param   match   A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   imm     Immediate value to encode.
 * @param   def_op  Operand definition for immediate operand.
 *
 * @return  Effective operand size in bits (0 if function failed).
 */
static ZyanU8 ZydisGetEffectiveImmSize(ZydisEncoderInstructionMatch* match, ZyanI64 imm,
                                       const ZydisOperandDefinition* def_op)
{
    ZyanU8 eisz = 0;
    ZyanU8 min_size = ZydisIsImmSigned((ZydisOperandEncoding)def_op->op.encoding)
                      ? ZydisGetSignedImmSize(imm)
                      : ZydisGetUnsignedImmSize((ZyanU64)imm);

    switch(def_op->op.encoding)
    {
    case ZYDIS_OPERAND_ENCODING_UIMM8:
    case ZYDIS_OPERAND_ENCODING_SIMM8:
        eisz = 8;
        break;
    case ZYDIS_OPERAND_ENCODING_IS4:
        ZYAN_ASSERT(def_op->element_type == ZYDIS_IELEMENT_TYPE_UINT8);
        eisz = ((ZyanU64)imm <= 15) ? 8 : 0;
        break;
    case ZYDIS_OPERAND_ENCODING_UIMM16:
    case ZYDIS_OPERAND_ENCODING_SIMM16:
        eisz = 16;
        break;
    case ZYDIS_OPERAND_ENCODING_UIMM32:
    case ZYDIS_OPERAND_ENCODING_SIMM32:
        eisz = 32;
        break;
    case ZYDIS_OPERAND_ENCODING_UIMM64:
    case ZYDIS_OPERAND_ENCODING_SIMM64:
        eisz = 64;
        break;
    case ZYDIS_OPERAND_ENCODING_UIMM16_32_64:
    case ZYDIS_OPERAND_ENCODING_SIMM16_32_64:
    {
        static const ZyanU16 simm16_32_64_sizes[3] = { 16, 32, 64 };
        return ZydisGetScaledImmSize(match, simm16_32_64_sizes, min_size);
    }
    case ZYDIS_OPERAND_ENCODING_UIMM32_32_64:
    case ZYDIS_OPERAND_ENCODING_SIMM32_32_64:
    {
        static const ZyanU16 simm32_32_64_sizes[3] = { 32, 32, 64 };
        return ZydisGetScaledImmSize(match, simm32_32_64_sizes, min_size);
    }
    case ZYDIS_OPERAND_ENCODING_UIMM16_32_32:
    case ZYDIS_OPERAND_ENCODING_SIMM16_32_32:
    {
        static const ZyanU16 simm16_32_32_sizes[3] = { 16, 32, 32 };
        return ZydisGetScaledImmSize(match, simm16_32_32_sizes, min_size);
    }
    case ZYDIS_OPERAND_ENCODING_DISP16_32_64:
        ZYAN_ASSERT(match->easz == 0);
        if(match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
        {
            if(min_size < 32)
            {
                min_size = 32;
            }
            if(min_size == 32 || min_size == 64)
            {
                match->easz = eisz = min_size;
            }
        }
        else
        {
            if(min_size < 16)
            {
                min_size = 16;
            }
            if(min_size == 16 || min_size == 32)
            {
                match->easz = eisz = min_size;
            }
        }
        break;
    case ZYDIS_OPERAND_ENCODING_JIMM8:
    case ZYDIS_OPERAND_ENCODING_JIMM16:
    case ZYDIS_OPERAND_ENCODING_JIMM32:
    case ZYDIS_OPERAND_ENCODING_JIMM64:
    {
        ZyanU8 jimm_index = def_op->op.encoding - ZYDIS_OPERAND_ENCODING_JIMM8;
        if((match->request->branch_width != ZYDIS_BRANCH_WIDTH_NONE) &&
                (match->request->branch_width != (ZydisBranchWidth)(ZYDIS_BRANCH_WIDTH_8 + jimm_index)))
        {
            return 0;
        }
        eisz = 8 << jimm_index;
        break;
    }
    case ZYDIS_OPERAND_ENCODING_JIMM16_32_32:
        switch(match->request->branch_width)
        {
        case ZYDIS_BRANCH_WIDTH_NONE:
        {
            static const ZyanU16 jimm16_32_32_sizes[3] = { 16, 32, 32 };
            return ZydisGetScaledImmSize(match, jimm16_32_32_sizes, min_size);
        }
        case ZYDIS_BRANCH_WIDTH_16:
            eisz = 16;
            break;
        case ZYDIS_BRANCH_WIDTH_32:
            eisz = 32;
            break;
        case ZYDIS_BRANCH_WIDTH_8:
        case ZYDIS_BRANCH_WIDTH_64:
            return 0;
        default:
            ZYAN_UNREACHABLE;
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    return eisz >= min_size ? eisz : 0;
}

/**
 * Checks if register width is compatible with effective operand size.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   reg_width   Register width in bits.
 *
 * @return  True if width is compatible, false otherwise.
 */
static ZyanBool ZydisCheckOsz(ZydisEncoderInstructionMatch* match, ZydisRegisterWidth reg_width)
{
    ZYAN_ASSERT(reg_width <= ZYAN_UINT8_MAX);
    if(match->eosz == 0)
    {
        if(reg_width == 8)
        {
            return ZYAN_FALSE;
        }
        match->eosz = (ZyanU8)reg_width;
        return ZYAN_TRUE;
    }

    return match->eosz == (ZyanU8)reg_width ? ZYAN_TRUE : ZYAN_FALSE;
}

/**
 * Checks if register width is compatible with effective address size.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   reg_width   Register width in bits.
 *
 * @return  True if width is compatible, false otherwise.
 */
static ZyanBool ZydisCheckAsz(ZydisEncoderInstructionMatch* match, ZydisRegisterWidth reg_width)
{
    ZYAN_ASSERT(reg_width <= ZYAN_UINT8_MAX);
    if(match->easz == 0)
    {
        if((match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
                (reg_width == 16))
        {
            return ZYAN_FALSE;
        }
        match->easz = (ZyanU8)reg_width;
        return ZYAN_TRUE;
    }

    return match->easz == (ZyanU8)reg_width ? ZYAN_TRUE : ZYAN_FALSE;
}

/**
 * Checks if specified register is valid for provided register class, encoding and machine mode.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   reg         `ZydisRegister` value.
 * @param   reg_class   Register class.
 *
 * @return  True if register value is allowed, false otherwise.
 */
static ZyanBool ZydisIsRegisterAllowed(ZydisEncoderInstructionMatch* match, ZydisRegister reg,
                                       ZydisRegisterClass reg_class)
{
    const ZyanI8 reg_id = ZydisRegisterGetId(reg);
    ZYAN_ASSERT(reg_id >= 0 && reg_id <= 31);
    if(match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
    {
        if((match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_EVEX) &&
                (match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_MVEX) &&
                (reg_class != ZYDIS_REGCLASS_GPR8) &&
                (reg_id >= 16))
        {
            return ZYAN_FALSE;
        }
    }
    else
    {
        if(reg_class == ZYDIS_REGCLASS_GPR64)
        {
            return ZYAN_FALSE;
        }
        if(reg_id >= 8)
        {
            return ZYAN_FALSE;
        }
    }

    return ZYAN_TRUE;
}

/**
 * Checks if specified scale value is valid for use with SIB addressing.
 *
 * @param   scale Scale value.
 *
 * @return  True if value is valid, false otherwise.
 */
static ZyanBool ZydisIsScaleValid(ZyanU8 scale)
{
    switch(scale)
    {
    case 0:
    case 1:
    case 2:
    case 4:
    case 8:
        return ZYAN_TRUE;
    default:
        return ZYAN_FALSE;
    }
}

/**
 * Enforces register usage constraints associated with usage of `REX` prefix.
 *
 * @param   match               A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   reg                 `ZydisRegister` value.
 * @param   addressing_mode     True if checked address is used for address calculations. This
 *                              implies more permissive checks.
 *
 * @return  True if register usage is allowed, false otherwise.
 */
static ZyanBool ZydisValidateRexType(ZydisEncoderInstructionMatch* match, ZydisRegister reg,
                                     ZyanBool addressing_mode)
{
    switch(reg)
    {
    case ZYDIS_REGISTER_AL:
    case ZYDIS_REGISTER_CL:
    case ZYDIS_REGISTER_DL:
    case ZYDIS_REGISTER_BL:
        return ZYAN_TRUE;
    case ZYDIS_REGISTER_AH:
    case ZYDIS_REGISTER_CH:
    case ZYDIS_REGISTER_DH:
    case ZYDIS_REGISTER_BH:
        if(match->rex_type == ZYDIS_REX_TYPE_UNKNOWN)
        {
            match->rex_type = ZYDIS_REX_TYPE_FORBIDDEN;
        }
        else if(match->rex_type == ZYDIS_REX_TYPE_REQUIRED)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_REGISTER_SPL:
    case ZYDIS_REGISTER_BPL:
    case ZYDIS_REGISTER_SIL:
    case ZYDIS_REGISTER_DIL:
    case ZYDIS_REGISTER_R8B:
    case ZYDIS_REGISTER_R9B:
    case ZYDIS_REGISTER_R10B:
    case ZYDIS_REGISTER_R11B:
    case ZYDIS_REGISTER_R12B:
    case ZYDIS_REGISTER_R13B:
    case ZYDIS_REGISTER_R14B:
    case ZYDIS_REGISTER_R15B:
        if(match->rex_type == ZYDIS_REX_TYPE_UNKNOWN)
        {
            match->rex_type = ZYDIS_REX_TYPE_REQUIRED;
        }
        else if(match->rex_type == ZYDIS_REX_TYPE_FORBIDDEN)
        {
            return ZYAN_FALSE;
        }
        break;
    default:
        if((ZydisRegisterGetId(reg) > 7) ||
                (!addressing_mode && (ZydisRegisterGetClass(reg) == ZYDIS_REGCLASS_GPR64)))
        {
            if(match->rex_type == ZYDIS_REX_TYPE_UNKNOWN)
            {
                match->rex_type = ZYDIS_REX_TYPE_REQUIRED;
            }
            else if(match->rex_type == ZYDIS_REX_TYPE_FORBIDDEN)
            {
                return ZYAN_FALSE;
            }
        }
        break;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if specified register is valid for use with SIB addressing.
 *
 * @param   match          A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   reg_class      Register class.
 * @param   reg            `ZydisRegister` value.
 *
 * @return  True if register value is allowed, false otherwise.
 */
static ZyanBool ZydisIsValidAddressingClass(ZydisEncoderInstructionMatch* match,
        ZydisRegisterClass reg_class, ZydisRegister reg)
{
    ZyanBool result;
    const ZyanBool is_64 = (match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64);
    switch(reg_class)
    {
    case ZYDIS_REGCLASS_INVALID:
        return ZYAN_TRUE;
    case ZYDIS_REGCLASS_GPR16:
        result = !is_64;
        break;
    case ZYDIS_REGCLASS_GPR32:
        result = is_64 || ZydisRegisterGetId(reg) < 8;
        break;
    case ZYDIS_REGCLASS_GPR64:
        result = is_64;
        break;
    default:
        return ZYAN_FALSE;
    }

    return result && ZydisValidateRexType(match, reg, ZYAN_TRUE);
}

/**
 * Helper function that determines correct `ModR/M.RM` value for 16-bit addressing mode.
 *
 * @param   base   `ZydisRegister` used as `SIB.base`.
 * @param   index  `ZydisRegister` used as `SIB.index`.
 *
 * @return  `ModR/M.RM` value (-1 if function failed).
 */
static ZyanI8 ZydisGetRm16(ZydisRegister base, ZydisRegister index)
{
    static const ZydisRegister modrm16_lookup[8][2] =
    {
        { ZYDIS_REGISTER_BX, ZYDIS_REGISTER_SI },
        { ZYDIS_REGISTER_BX, ZYDIS_REGISTER_DI },
        { ZYDIS_REGISTER_BP, ZYDIS_REGISTER_SI },
        { ZYDIS_REGISTER_BP, ZYDIS_REGISTER_DI },
        { ZYDIS_REGISTER_SI, ZYDIS_REGISTER_NONE },
        { ZYDIS_REGISTER_DI, ZYDIS_REGISTER_NONE },
        { ZYDIS_REGISTER_BP, ZYDIS_REGISTER_NONE },
        { ZYDIS_REGISTER_BX, ZYDIS_REGISTER_NONE },
    };
    for(ZyanI8 i = 0; i < (ZyanI8)ZYAN_ARRAY_LENGTH(modrm16_lookup); ++i)
    {
        if((modrm16_lookup[i][0] == base) &&
                (modrm16_lookup[i][1] == index))
        {
            return i;
        }
    }

    return -1;
}

/**
 * Encodes `MVEX.sss` field for specified broadcast mode.
 *
 * @param   broadcast Broadcast mode.
 *
 * @return  Corresponding `MVEX.sss` value.
 */
static ZyanU8 ZydisEncodeMvexBroadcastMode(ZydisBroadcastMode broadcast)
{
    switch(broadcast)
    {
    case ZYDIS_BROADCAST_MODE_INVALID:
        return 0;
    case ZYDIS_BROADCAST_MODE_1_TO_16:
    case ZYDIS_BROADCAST_MODE_1_TO_8:
        return 1;
    case ZYDIS_BROADCAST_MODE_4_TO_16:
    case ZYDIS_BROADCAST_MODE_4_TO_8:
        return 2;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Encodes `MVEX.sss` field for specified conversion mode.
 *
 * @param   conversion Conversion mode.
 *
 * @return  Corresponding `MVEX.sss` value.
 */
static ZyanU8 ZydisEncodeMvexConversionMode(ZydisConversionMode conversion)
{
    switch(conversion)
    {
    case ZYDIS_CONVERSION_MODE_INVALID:
        return 0;
    case ZYDIS_CONVERSION_MODE_FLOAT16:
        return 3;
    case ZYDIS_CONVERSION_MODE_UINT8:
        return 4;
    case ZYDIS_CONVERSION_MODE_SINT8:
        return 5;
    case ZYDIS_CONVERSION_MODE_UINT16:
        return 6;
    case ZYDIS_CONVERSION_MODE_SINT16:
        return 7;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Determines scale factor for compressed 8-bit displacement (`EVEX` instructions only).
 *
 * @param   match   A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  log2(scale factor)
 */
static ZyanU8 ZydisGetCompDispScaleEvex(const ZydisEncoderInstructionMatch* match)
{
    const ZydisInstructionDefinitionEVEX* evex_def =
        (const ZydisInstructionDefinitionEVEX*)match->base_definition;

    ZYAN_ASSERT(match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX);
    ZYAN_ASSERT(evex_def->tuple_type);
    ZYAN_ASSERT(evex_def->element_size);
    const ZyanU8 vector_length = match->definition->vector_length - ZYDIS_VECTOR_LENGTH_128;
    static const ZyanU8 size_indexes[ZYDIS_IELEMENT_SIZE_MAX_VALUE + 1] =
    {
        0, 0, 0, 1, 2, 4
    };
    ZYAN_ASSERT(evex_def->element_size < ZYAN_ARRAY_LENGTH(size_indexes));
    const ZyanU8 size_index = size_indexes[evex_def->element_size];
    switch(evex_def->tuple_type)
    {
    case ZYDIS_TUPLETYPE_FV:
    {
        static const ZyanU8 scales[2][3][3] =
        {
            /*B0*/ { /*16*/ { 4, 5, 6 }, /*32*/ { 4, 5, 6 }, /*64*/ { 4, 5, 6 } },
            /*B1*/ { /*16*/ { 1, 1, 1 }, /*32*/ { 2, 2, 2 }, /*64*/ { 3, 3, 3 } }
        };
        const ZyanU8 broadcast = match->request->evex.broadcast ? 1 : 0;
        ZYAN_ASSERT(size_index < 3);
        return scales[broadcast][size_index][vector_length];
    }
    case ZYDIS_TUPLETYPE_HV:
    {
        static const ZyanU8 scales[2][2][3] =
        {
            /*B0*/ { /*16*/ {  3, 4, 5 }, /*32*/ {  3, 4, 5 } },
            /*B1*/ { /*16*/ {  1, 1, 1 }, /*32*/ {  2, 2, 2 } }
        };
        const ZyanU8 broadcast = match->request->evex.broadcast ? 1 : 0;
        ZYAN_ASSERT(size_index < 3);
        return scales[broadcast][size_index][vector_length];
    }
    case ZYDIS_TUPLETYPE_FVM:
    {
        static const ZyanU8 scales[3] =
        {
            4, 5, 6
        };
        return scales[vector_length];
    }
    case ZYDIS_TUPLETYPE_GSCAT:
    case ZYDIS_TUPLETYPE_T1S:
    {
        static const ZyanU8 scales[6] =
        {
            /*   */ 0,
            /*  8*/ 0,
            /* 16*/ 1,
            /* 32*/ 2,
            /* 64*/ 3,
            /*128*/ 4
        };
        ZYAN_ASSERT(evex_def->element_size < ZYAN_ARRAY_LENGTH(scales));
        return scales[evex_def->element_size];
    }
    case ZYDIS_TUPLETYPE_T1F:
    {
        static const ZyanU8 scales[3] =
        {
            /* 16*/ 1,
            /* 32*/ 2,
            /* 64*/ 3
        };
        ZYAN_ASSERT(size_index < 3);
        return scales[size_index];
    }
    case ZYDIS_TUPLETYPE_T1_4X:
        return 4;
    case ZYDIS_TUPLETYPE_T2:
        return match->definition->rex_w ? 4 : 3;
    case ZYDIS_TUPLETYPE_T4:
        return match->definition->rex_w ? 5 : 4;
    case ZYDIS_TUPLETYPE_T8:
        return 5;
    case ZYDIS_TUPLETYPE_HVM:
    {
        static const ZyanU8 scales[3] =
        {
            3, 4, 5
        };
        return scales[vector_length];
    }
    case ZYDIS_TUPLETYPE_QVM:
    {
        static const ZyanU8 scales[3] =
        {
            2, 3, 4
        };
        return scales[vector_length];
    }
    case ZYDIS_TUPLETYPE_OVM:
    {
        static const ZyanU8 scales[3] =
        {
            1, 2, 3
        };
        return scales[vector_length];
    }
    case ZYDIS_TUPLETYPE_M128:
        return 4;
    case ZYDIS_TUPLETYPE_DUP:
    {
        static const ZyanU8 scales[3] =
        {
            3, 5, 6
        };
        return scales[vector_length];
    }
    case ZYDIS_TUPLETYPE_QUARTER:
    {
        static const ZyanU8 scales[2][3] =
        {
            /*B0*/ { 2, 3, 4 },
            /*B1*/ { 1, 1, 1 }
        };
        const ZyanU8 broadcast = match->request->evex.broadcast ? 1 : 0;
        return scales[broadcast][vector_length];
    }
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Determines scale factor for compressed 8-bit displacement (`MVEX` instructions only).
 *
 * @param   match   A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  log2(scale factor)
 */
static ZyanU8 ZydisGetCompDispScaleMvex(const ZydisEncoderInstructionMatch* match)
{
    const ZydisInstructionDefinitionMVEX* mvex_def =
        (const ZydisInstructionDefinitionMVEX*)match->base_definition;

    ZyanU8 index = mvex_def->has_element_granularity;
    ZYAN_ASSERT(!index || !mvex_def->broadcast);
    if(!index && mvex_def->broadcast)
    {
        switch(mvex_def->broadcast)
        {
        case ZYDIS_MVEX_STATIC_BROADCAST_1_TO_8:
        case ZYDIS_MVEX_STATIC_BROADCAST_1_TO_16:
            index = 1;
            break;
        case ZYDIS_MVEX_STATIC_BROADCAST_4_TO_8:
        case ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16:
            index = 2;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
    }

    const ZyanU8 sss = ZydisEncodeMvexBroadcastMode(match->request->mvex.broadcast) |
                       ZydisEncodeMvexConversionMode(match->request->mvex.conversion);
    switch(mvex_def->functionality)
    {
    case ZYDIS_MVEX_FUNC_IGNORED:
    case ZYDIS_MVEX_FUNC_INVALID:
    case ZYDIS_MVEX_FUNC_RC:
    case ZYDIS_MVEX_FUNC_SAE:
    case ZYDIS_MVEX_FUNC_SWIZZLE_32:
    case ZYDIS_MVEX_FUNC_SWIZZLE_64:
        return 0;
    case ZYDIS_MVEX_FUNC_F_32:
    case ZYDIS_MVEX_FUNC_I_32:
    case ZYDIS_MVEX_FUNC_F_64:
    case ZYDIS_MVEX_FUNC_I_64:
        return 6;
    case ZYDIS_MVEX_FUNC_SF_32:
    case ZYDIS_MVEX_FUNC_SF_32_BCST:
    case ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16:
    case ZYDIS_MVEX_FUNC_UF_32:
    {
        static const ZyanU8 lookup[3][8] =
        {
            { 6, 2, 4, 5, 4, 4, 5, 5 },
            { 2, 0, 0, 1, 0, 0, 1, 1 },
            { 4, 0, 0, 3, 2, 2, 3, 3 }
        };
        ZYAN_ASSERT(sss < ZYAN_ARRAY_LENGTH(lookup[index]));
        return lookup[index][sss];
    }
    case ZYDIS_MVEX_FUNC_SI_32:
    case ZYDIS_MVEX_FUNC_UI_32:
    case ZYDIS_MVEX_FUNC_SI_32_BCST:
    case ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16:
    {
        static const ZyanU8 lookup[3][8] =
        {
            { 6, 2, 4, 0, 4, 4, 5, 5 },
            { 2, 0, 0, 0, 0, 0, 1, 1 },
            { 4, 0, 0, 0, 2, 2, 3, 3 }
        };
        ZYAN_ASSERT(sss < ZYAN_ARRAY_LENGTH(lookup[index]));
        return lookup[index][sss];
    }
    case ZYDIS_MVEX_FUNC_SF_64:
    case ZYDIS_MVEX_FUNC_UF_64:
    case ZYDIS_MVEX_FUNC_SI_64:
    case ZYDIS_MVEX_FUNC_UI_64:
    {
        static const ZyanU8 lookup[3][3] =
        {
            { 6, 3, 5 },
            { 3, 0, 0 },
            { 5, 0, 0 }
        };
        ZYAN_ASSERT(sss < ZYAN_ARRAY_LENGTH(lookup[index]));
        return lookup[index][sss];
    }
    case ZYDIS_MVEX_FUNC_DF_32:
    case ZYDIS_MVEX_FUNC_DI_32:
    {
        static const ZyanU8 lookup[2][8] =
        {
            { 6, 0, 0, 5, 4, 4, 5, 5 },
            { 2, 0, 0, 1, 0, 0, 1, 1 }
        };
        ZYAN_ASSERT(index < 2);
        ZYAN_ASSERT(sss < ZYAN_ARRAY_LENGTH(lookup[index]));
        return lookup[index][sss];
    }
    case ZYDIS_MVEX_FUNC_DF_64:
    case ZYDIS_MVEX_FUNC_DI_64:
        ZYAN_ASSERT(index < 2);
        return index == 0 ? 6 : 3;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Determines scale factor for compressed 8-bit displacement.
 *
 * @param   match A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  log2(scale factor)
 */
static ZyanU8 ZydisGetCompDispScale(const ZydisEncoderInstructionMatch* match)
{
    switch(match->definition->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
    case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        return 0;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        return ZydisGetCompDispScaleEvex(match);
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        return ZydisGetCompDispScaleMvex(match);
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Checks if requested operand matches register operand from instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   user_op     Operand definition from `ZydisEncoderRequest` structure.
 * @param   def_op      Decoder's operand definition from current instruction definition.
 *
 * @return  True if operands match, false otherwise.
 */
static ZyanBool ZydisIsRegisterOperandCompatible(ZydisEncoderInstructionMatch* match,
        const ZydisEncoderOperand* user_op, const ZydisOperandDefinition* def_op)
{
    const ZydisRegisterClass reg_class = ZydisRegisterGetClass(user_op->reg.value);
    const ZydisRegisterWidth reg_width = ZydisRegisterClassGetWidth(match->request->machine_mode,
                                         reg_class);
    if(reg_width == 0)
    {
        return ZYAN_FALSE;
    }

    ZyanBool is4_expected_value = ZYAN_FALSE;
    switch(def_op->type)
    {
    case ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_REG:
        switch(def_op->op.reg.type)
        {
        case ZYDIS_IMPLREG_TYPE_STATIC:
            if(def_op->op.reg.reg.reg != user_op->reg.value)
            {
                return ZYAN_FALSE;
            }
            break;
        case ZYDIS_IMPLREG_TYPE_GPR_OSZ:
            if((reg_class != ZYDIS_REGCLASS_GPR8) &&
                    (reg_class != ZYDIS_REGCLASS_GPR16) &&
                    (reg_class != ZYDIS_REGCLASS_GPR32) &&
                    (reg_class != ZYDIS_REGCLASS_GPR64))
            {
                return ZYAN_FALSE;
            }
            if(def_op->op.reg.reg.id != ZydisRegisterGetId(user_op->reg.value))
            {
                return ZYAN_FALSE;
            }
            if(!ZydisCheckOsz(match, reg_width))
            {
                return ZYAN_FALSE;
            }
            break;
        case ZYDIS_IMPLREG_TYPE_GPR_ASZ:
            if((reg_class != ZYDIS_REGCLASS_GPR8) &&
                    (reg_class != ZYDIS_REGCLASS_GPR16) &&
                    (reg_class != ZYDIS_REGCLASS_GPR32) &&
                    (reg_class != ZYDIS_REGCLASS_GPR64))
            {
                return ZYAN_FALSE;
            }
            if(def_op->op.reg.reg.id != ZydisRegisterGetId(user_op->reg.value))
            {
                return ZYAN_FALSE;
            }
            if(!ZydisCheckAsz(match, reg_width))
            {
                return ZYAN_FALSE;
            }
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR8:
        if(reg_class != ZYDIS_REGCLASS_GPR8)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisValidateRexType(match, user_op->reg.value, ZYAN_FALSE))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR16:
        if(reg_class != ZYDIS_REGCLASS_GPR16)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR32:
        if(reg_class != ZYDIS_REGCLASS_GPR32)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR64:
        if(reg_class != ZYDIS_REGCLASS_GPR64)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR16_32_64:
        if((reg_class != ZYDIS_REGCLASS_GPR16) &&
                (reg_class != ZYDIS_REGCLASS_GPR32) &&
                (reg_class != ZYDIS_REGCLASS_GPR64))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisCheckOsz(match, reg_width))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisValidateRexType(match, user_op->reg.value, ZYAN_FALSE))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR32_32_64:
        if((reg_class != ZYDIS_REGCLASS_GPR32) &&
                (reg_class != ZYDIS_REGCLASS_GPR64))
        {
            return ZYAN_FALSE;
        }
        if(match->eosz == 0)
        {
            if(reg_class == ZYDIS_REGCLASS_GPR64)
            {
                match->eosz = 64;
            }
            else
            {
                match->eosz64_forbidden = ZYAN_TRUE;
            }
        }
        else if(match->eosz != (ZyanU8)reg_width)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisValidateRexType(match, user_op->reg.value, ZYAN_FALSE))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR16_32_32:
        if((reg_class != ZYDIS_REGCLASS_GPR16) &&
                (reg_class != ZYDIS_REGCLASS_GPR32))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisCheckOsz(match, reg_width))
        {
            if(match->eosz != 64 || reg_class != ZYDIS_REGCLASS_GPR32)
            {
                return ZYAN_FALSE;
            }
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_GPR_ASZ:
        if((reg_class != ZYDIS_REGCLASS_GPR16) &&
                (reg_class != ZYDIS_REGCLASS_GPR32) &&
                (reg_class != ZYDIS_REGCLASS_GPR64))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisCheckAsz(match, reg_width))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_FPR:
        if(reg_class != ZYDIS_REGCLASS_X87)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_MMX:
        if(reg_class != ZYDIS_REGCLASS_MMX)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_XMM:
        if(reg_class != ZYDIS_REGCLASS_XMM)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        is4_expected_value = def_op->op.encoding == ZYDIS_OPERAND_ENCODING_IS4;
        break;
    case ZYDIS_SEMANTIC_OPTYPE_YMM:
        if(reg_class != ZYDIS_REGCLASS_YMM)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        is4_expected_value = def_op->op.encoding == ZYDIS_OPERAND_ENCODING_IS4;
        break;
    case ZYDIS_SEMANTIC_OPTYPE_ZMM:
        if(reg_class != ZYDIS_REGCLASS_ZMM)
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsRegisterAllowed(match, user_op->reg.value, reg_class))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_TMM:
        if(reg_class != ZYDIS_REGCLASS_TMM)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_BND:
        if(reg_class != ZYDIS_REGCLASS_BOUND)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_SREG:
        if(reg_class != ZYDIS_REGCLASS_SEGMENT)
        {
            return ZYAN_FALSE;
        }
        if((def_op->actions & ZYDIS_OPERAND_ACTION_MASK_WRITE) &&
                (user_op->reg.value == ZYDIS_REGISTER_CS))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_CR:
    {
        if(reg_class != ZYDIS_REGCLASS_CONTROL)
        {
            return ZYAN_FALSE;
        }
        static const ZyanU8 cr_lookup[16] =
        {
            1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0
        };
        const ZyanI8 reg_id = ZydisRegisterGetId(user_op->reg.value);
        if((match->request->machine_mode != ZYDIS_MACHINE_MODE_LONG_64) &&
                (reg_id == 8))
        {
            return ZYAN_FALSE;
        }
        if(!cr_lookup[reg_id])
        {
            return ZYAN_FALSE;
        }
        break;
    }
    case ZYDIS_SEMANTIC_OPTYPE_DR:
        if(reg_class != ZYDIS_REGCLASS_DEBUG)
        {
            return ZYAN_FALSE;
        }
        if(user_op->reg.value >= ZYDIS_REGISTER_DR8)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_MASK:
        if(reg_class != ZYDIS_REGCLASS_MASK)
        {
            return ZYAN_FALSE;
        }

        // MVEX does not require similar policy check
        if((match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) &&
                (def_op->op.encoding == ZYDIS_OPERAND_ENCODING_MASK))
        {
            const ZydisInstructionDefinitionEVEX* evex_def =
                (const ZydisInstructionDefinitionEVEX*)match->base_definition;
            ZYAN_ASSERT((evex_def->mask_policy != ZYDIS_MASK_POLICY_INVALID) &&
                        (evex_def->mask_policy != ZYDIS_MASK_POLICY_FORBIDDEN));
            if((evex_def->mask_policy == ZYDIS_MASK_POLICY_REQUIRED) &&
                    (user_op->reg.value == ZYDIS_REGISTER_K0))
            {
                return ZYAN_FALSE;
            }
            if((evex_def->mask_policy == ZYDIS_MASK_POLICY_ALLOWED) &&
                    (match->request->evex.zeroing_mask) &&
                    (user_op->reg.value == ZYDIS_REGISTER_K0))
            {
                return ZYAN_FALSE;
            }
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    if(user_op->reg.is4 != is4_expected_value)
    {
        return ZYAN_FALSE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if requested operand matches memory operand from instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   user_op     Operand definition from `ZydisEncoderRequest` structure.
 * @param   def_op      Decoder's operand definition from current instruction definition.
 *
 * @return  True if operands match, false otherwise.
 */
static ZyanBool ZydisIsMemoryOperandCompatible(ZydisEncoderInstructionMatch* match,
        const ZydisEncoderOperand* user_op, const ZydisOperandDefinition* def_op)
{
    switch(def_op->type)
    {
    case ZYDIS_SEMANTIC_OPTYPE_MEM:
    case ZYDIS_SEMANTIC_OPTYPE_AGEN:
    case ZYDIS_SEMANTIC_OPTYPE_MIB:
    case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBX:
    case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBY:
    case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBZ:
    {
        if((def_op->type == ZYDIS_SEMANTIC_OPTYPE_MIB) &&
                (user_op->mem.scale != 0))
        {
            return ZYAN_FALSE;
        }
        ZyanI64 displacement = user_op->mem.displacement;
        ZyanU8 disp_size = 0;
        if(displacement)
        {
            disp_size = ZydisGetSignedImmSize(displacement);
            if(disp_size > 32)
            {
                return ZYAN_FALSE;
            }
            if(ZydisGetMachineModeWidth(match->request->machine_mode) == 16)
            {
                if((ZyanI16)displacement == 0)
                {
                    disp_size = 0;
                }
                else
                {
                    disp_size = ZydisGetSignedImmSize((ZyanI16)displacement);
                }
            }

            match->cd8_scale = ZydisGetCompDispScale(match);
            if(match->cd8_scale)
            {
                const ZyanI64 mask = (1 << match->cd8_scale) - 1;
                if(!(displacement & mask))
                {
                    disp_size = ZydisGetSignedImmSize(displacement >> match->cd8_scale);
                }
                else if(disp_size == 8)
                {
                    disp_size = 16;
                }
            }
        }

        if(def_op->type != ZYDIS_SEMANTIC_OPTYPE_AGEN)
        {
            if(match->eosz != 0)
            {
                const ZyanU8 eosz_index = match->eosz >> 5;
                if(def_op->size[eosz_index] != user_op->mem.size)
                {
                    return ZYAN_FALSE;
                }
            }
            else if((match->definition->vector_length != ZYDIS_VECTOR_LENGTH_INVALID) ||
                    (match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX))
            {
                ZyanU8 eosz_index = ZydisGetMachineModeWidth(match->request->machine_mode) >> 5;
                if(match->eosz64_forbidden && (eosz_index == 2))
                {
                    eosz_index = 1;
                }
                ZyanU16 allowed_mem_size = def_op->size[eosz_index];
                if((!allowed_mem_size) &&
                        (match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_VEX))
                {
                    ZYAN_ASSERT((match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
                                (match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX));
                    switch(match->definition->vector_length)
                    {
                    case ZYDIS_VECTOR_LENGTH_128:
                        allowed_mem_size = 16;
                        break;
                    case ZYDIS_VECTOR_LENGTH_256:
                        allowed_mem_size = 32;
                        break;
                    case ZYDIS_VECTOR_LENGTH_INVALID:
                        ZYAN_ASSERT(match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX);
                        ZYAN_FALLTHROUGH;
                    case ZYDIS_VECTOR_LENGTH_512:
                        allowed_mem_size = 64;
                        break;
                    default:
                        ZYAN_UNREACHABLE;
                    }
                    if(match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX)
                    {
                        const ZydisInstructionDefinitionEVEX* evex_def =
                            (const ZydisInstructionDefinitionEVEX*)match->base_definition;
                        static const ZyanU8 element_sizes[ZYDIS_IELEMENT_SIZE_MAX_VALUE + 1] =
                        {
                            0, 1, 2, 4, 8, 16
                        };
                        ZYAN_ASSERT(evex_def->element_size < ZYAN_ARRAY_LENGTH(element_sizes));
                        const ZyanU8 element_size = element_sizes[evex_def->element_size];
                        if(match->request->evex.broadcast || evex_def->broadcast)
                        {
                            allowed_mem_size = element_size;
                        }
                        else
                        {
                            switch(evex_def->tuple_type)
                            {
                            case ZYDIS_TUPLETYPE_FV:
                                break;
                            case ZYDIS_TUPLETYPE_HV:
                                allowed_mem_size /= 2;
                                break;
                            case ZYDIS_TUPLETYPE_QUARTER:
                                allowed_mem_size /= 4;
                                break;
                            default:
                                ZYAN_UNREACHABLE;
                            }
                        }
                    }
                    else
                    {
                        const ZydisInstructionDefinitionMVEX* mvex_def =
                            (const ZydisInstructionDefinitionMVEX*)match->base_definition;
                        ZyanU16 element_size;
                        switch(match->request->mvex.conversion)
                        {
                        case ZYDIS_CONVERSION_MODE_INVALID:

                            switch(mvex_def->functionality)
                            {
                            case ZYDIS_MVEX_FUNC_SF_32:
                            case ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16:
                            case ZYDIS_MVEX_FUNC_UF_32:
                            case ZYDIS_MVEX_FUNC_DF_32:
                            case ZYDIS_MVEX_FUNC_SI_32:
                            case ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16:
                            case ZYDIS_MVEX_FUNC_UI_32:
                            case ZYDIS_MVEX_FUNC_DI_32:
                                allowed_mem_size = 64;
                                element_size = 4;
                                break;
                            case ZYDIS_MVEX_FUNC_SF_64:
                            case ZYDIS_MVEX_FUNC_UF_64:
                            case ZYDIS_MVEX_FUNC_DF_64:
                            case ZYDIS_MVEX_FUNC_SI_64:
                            case ZYDIS_MVEX_FUNC_UI_64:
                            case ZYDIS_MVEX_FUNC_DI_64:
                                allowed_mem_size = 64;
                                element_size = 8;
                                break;
                            case ZYDIS_MVEX_FUNC_SF_32_BCST:
                            case ZYDIS_MVEX_FUNC_SI_32_BCST:
                                allowed_mem_size = 32;
                                element_size = 4;
                                break;
                            default:
                                ZYAN_UNREACHABLE;
                            }
                            break;
                        case ZYDIS_CONVERSION_MODE_FLOAT16:
                        case ZYDIS_CONVERSION_MODE_SINT16:
                        case ZYDIS_CONVERSION_MODE_UINT16:
                            allowed_mem_size = 32;
                            element_size = 2;
                            break;
                        case ZYDIS_CONVERSION_MODE_SINT8:
                        case ZYDIS_CONVERSION_MODE_UINT8:
                            allowed_mem_size = 16;
                            element_size = 1;
                            break;
                        default:
                            ZYAN_UNREACHABLE;
                        }
                        ZYAN_ASSERT(!mvex_def->broadcast || !match->request->mvex.broadcast);
                        switch(mvex_def->broadcast)
                        {
                        case ZYDIS_MVEX_STATIC_BROADCAST_NONE:
                            break;
                        case ZYDIS_MVEX_STATIC_BROADCAST_1_TO_8:
                        case ZYDIS_MVEX_STATIC_BROADCAST_1_TO_16:
                            allowed_mem_size = element_size;
                            break;
                        case ZYDIS_MVEX_STATIC_BROADCAST_4_TO_8:
                        case ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16:
                            allowed_mem_size = element_size * 4;
                            break;
                        default:
                            ZYAN_UNREACHABLE;
                        }
                        switch(match->request->mvex.broadcast)
                        {
                        case ZYDIS_BROADCAST_MODE_INVALID:
                            break;
                        case ZYDIS_BROADCAST_MODE_1_TO_8:
                        case ZYDIS_BROADCAST_MODE_1_TO_16:
                            allowed_mem_size = element_size;
                            break;
                        case ZYDIS_BROADCAST_MODE_4_TO_8:
                        case ZYDIS_BROADCAST_MODE_4_TO_16:
                            allowed_mem_size = element_size * 4;
                            break;
                        default:
                            ZYAN_UNREACHABLE;
                        }
                    }
                }
                if(user_op->mem.size != allowed_mem_size)
                {
                    return ZYAN_FALSE;
                }
            }
            else if(match->definition->rex_w)
            {
                match->eosz = 64;
            }
            else if(match->definition->vector_length == ZYDIS_VECTOR_LENGTH_INVALID)
            {
                match->eosz = ZydisGetOperandSizeFromElementSize(match, def_op->size,
                              user_op->mem.size, ZYAN_TRUE);
                if(match->eosz == 0)
                {
                    return ZYAN_FALSE;
                }
            }
            else
            {
                ZYAN_UNREACHABLE;
            }
        }
        else
        {
            if(match->easz != 0)
            {
                if(match->easz != user_op->mem.size)
                {
                    return ZYAN_FALSE;
                }
            }
            else
            {
                switch(user_op->mem.size)
                {
                case 2:
                case 4:
                case 8:
                    match->easz = (ZyanU8)user_op->mem.size << 3;
                    break;
                default:
                    return ZYAN_FALSE;
                }
            }
        }

        ZydisRegisterClass vsib_index_class = ZYDIS_REGCLASS_INVALID;
        ZyanBool is_vsib = ZYAN_TRUE;
        switch(def_op->type)
        {
        case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBX:
            vsib_index_class = ZYDIS_REGCLASS_XMM;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBY:
            vsib_index_class = ZYDIS_REGCLASS_YMM;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBZ:
            vsib_index_class = ZYDIS_REGCLASS_ZMM;
            break;
        default:
            is_vsib = ZYAN_FALSE;
            break;
        }
        const ZyanBool is_rip_relative = (user_op->mem.base == ZYDIS_REGISTER_RIP) ||
                                         (user_op->mem.base == ZYDIS_REGISTER_EIP);
        if(is_rip_relative)
        {
            const ZyanBool no_rip_rel = ZYDIS_OPDEF_GET_MEM_HIGH_BIT(match->base_definition->op_rm);
            if(no_rip_rel || ((match->definition->modrm & 7) == 4))
            {
                return ZYAN_FALSE;
            }
        }
        const ZydisRegisterClass reg_base_class = ZydisRegisterGetClass(user_op->mem.base);
        if((reg_base_class == ZYDIS_REGCLASS_INVALID) &&
                (user_op->mem.base != ZYDIS_REGISTER_NONE))
        {
            return ZYAN_FALSE;
        }
        const ZydisRegisterClass reg_index_class = ZydisRegisterGetClass(user_op->mem.index);
        if((reg_index_class == ZYDIS_REGCLASS_INVALID) &&
                (user_op->mem.index != ZYDIS_REGISTER_NONE))
        {
            return ZYAN_FALSE;
        }
        if(is_vsib)
        {
            const ZyanU8 mode_width = ZydisGetMachineModeWidth(match->request->machine_mode);
            const ZyanI8 reg_index_id = ZydisRegisterGetId(user_op->mem.index);
            if(((match->request->machine_mode != ZYDIS_MACHINE_MODE_LONG_64) ||
                    (reg_base_class != ZYDIS_REGCLASS_GPR64)) &&
                    (reg_base_class != ZYDIS_REGCLASS_GPR32) &&
                    (reg_base_class != ZYDIS_REGCLASS_INVALID))
            {
                return ZYAN_FALSE;
            }
            if((reg_base_class == ZYDIS_REGCLASS_GPR32) &&
                    (mode_width != 64) &&
                    (ZydisRegisterGetId(user_op->mem.base) > 7))
            {
                return ZYAN_FALSE;
            }
            ZyanU8 max_reg_id = 7;
            if(mode_width == 64)
            {
                max_reg_id = match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_VEX ?
                             31 : 15;
            }
            if((reg_index_class != vsib_index_class) ||
                    (reg_index_id > max_reg_id))
            {
                return ZYAN_FALSE;
            }
        }
        else
        {
            if(!ZydisIsValidAddressingClass(match, reg_base_class, user_op->mem.base))
            {
                if(!is_rip_relative || match->request->machine_mode != ZYDIS_MACHINE_MODE_LONG_64)
                {
                    return ZYAN_FALSE;
                }
            }
            if(!ZydisIsValidAddressingClass(match, reg_index_class, user_op->mem.index))
            {
                return ZYAN_FALSE;
            }
            if(reg_base_class != ZYDIS_REGCLASS_INVALID &&
                    reg_index_class != ZYDIS_REGCLASS_INVALID &&
                    reg_base_class != reg_index_class)
            {
                return ZYAN_FALSE;
            }
            if(user_op->mem.index == ZYDIS_REGISTER_ESP ||
                    user_op->mem.index == ZYDIS_REGISTER_RSP)
            {
                return ZYAN_FALSE;
            }
        }
        if(reg_index_class != ZYDIS_REGCLASS_INVALID &&
                user_op->mem.scale == 0 &&
                def_op->type != ZYDIS_SEMANTIC_OPTYPE_MIB)
        {
            return ZYAN_FALSE;
        }
        if(reg_index_class == ZYDIS_REGCLASS_INVALID &&
                user_op->mem.scale != 0)
        {
            return ZYAN_FALSE;
        }
        ZyanU8 candidate_easz = 0;
        ZyanBool disp_only = ZYAN_FALSE;
        if(reg_base_class != ZYDIS_REGCLASS_INVALID)
        {
            if(is_rip_relative)
            {
                candidate_easz = user_op->mem.base == ZYDIS_REGISTER_RIP ? 64 : 32;
            }
            else
            {
                candidate_easz = (ZyanU8)ZydisRegisterClassGetWidth(match->request->machine_mode,
                                 reg_base_class);
            }
        }
        else if(reg_index_class != ZYDIS_REGCLASS_INVALID)
        {
            if(is_vsib)
            {
                candidate_easz = ZydisGetMachineModeWidth(match->request->machine_mode);
            }
            else
            {
                candidate_easz = (ZyanU8)ZydisRegisterClassGetWidth(match->request->machine_mode,
                                 reg_index_class);
            }
        }
        else
        {
            ZyanU8 min_disp_size = match->easz ? match->easz : 16;
            if(((min_disp_size == 16) && !(match->definition->address_sizes & ZYDIS_WIDTH_16)) ||
                    (min_disp_size == 64))
            {
                min_disp_size = 32;
            }
            if(ZydisGetUnsignedImmSize(displacement) == 16)
            {
                disp_size = 16;
            }
            if(disp_size < min_disp_size)
            {
                disp_size = min_disp_size;
            }
            if(match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
            {
                candidate_easz = match->easz == 32 ? 32 : 64;
            }
            else
            {
                candidate_easz = disp_size;
            }
            disp_only = ZYAN_TRUE;
        }
        if(match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
        {
            if(is_rip_relative && reg_index_class != ZYDIS_REGCLASS_INVALID)
            {
                return ZYAN_FALSE;
            }
        }
        else
        {
            if(candidate_easz == 16 && !disp_only)
            {
                if(disp_size > 16)
                {
                    return ZYAN_FALSE;
                }
                const ZyanI8 rm16 = ZydisGetRm16(user_op->mem.base, user_op->mem.index);
                if(rm16 == -1)
                {
                    return ZYAN_FALSE;
                }
                const ZyanU8 allowed_scale = rm16 < 4 ? 1 : 0;
                if(user_op->mem.scale != allowed_scale)
                {
                    return ZYAN_FALSE;
                }
            }
        }
        if(match->easz != 0)
        {
            if(match->easz != candidate_easz)
            {
                return ZYAN_FALSE;
            }
        }
        else
        {
            match->easz = candidate_easz;
        }
        if((match->base_definition->address_size_map == ZYDIS_ADSIZE_MAP_IGNORED) &&
                (match->easz != ZydisGetMachineModeWidth(match->request->machine_mode)))
        {
            return ZYAN_FALSE;
        }
        match->disp_size = disp_size;
        break;
    }
    case ZYDIS_SEMANTIC_OPTYPE_MOFFS:
        if(user_op->mem.base != ZYDIS_REGISTER_NONE ||
                user_op->mem.index != ZYDIS_REGISTER_NONE ||
                user_op->mem.scale != 0)
        {
            return ZYAN_FALSE;
        }
        if(match->eosz != 0)
        {
            const ZyanU8 eosz_index = match->eosz >> 5;
            if(def_op->size[eosz_index] != user_op->mem.size)
            {
                return ZYAN_FALSE;
            }
        }
        else
        {
            match->eosz = ZydisGetOperandSizeFromElementSize(match, def_op->size,
                          user_op->mem.size, ZYAN_TRUE);
            if(match->eosz == 0)
            {
                return ZYAN_FALSE;
            }
        }
        match->disp_size = ZydisGetEffectiveImmSize(match, user_op->mem.displacement, def_op);
        if(match->disp_size == 0)
        {
            return ZYAN_FALSE;
        }
        // This is not a standard rejection. It's a special case for `mov` instructions (only ones
        // to use `moffs` operands). Size of `moffs` is tied to address size attribute, so its
        // signedness doesn't matter. However if displacement can be represented as a signed
        // integer of smaller size we reject `moffs` variant because it's guaranteed that better
        // alternative exists (in terms of size).
        ZyanU8 alternative_size = ZydisGetSignedImmSize(user_op->mem.displacement);
        const ZyanU8 min_disp_size =
            (match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) ? 32 : 16;
        if(alternative_size < min_disp_size)
        {
            alternative_size = min_disp_size;
        }
        if(alternative_size < match->disp_size)
        {
            return ZYAN_FALSE;
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if requested operand matches pointer operand from instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   user_op     Operand definition from `ZydisEncoderRequest` structure.
 *
 * @return  True if operands match, false otherwise.
 */
static ZyanBool ZydisIsPointerOperandCompatible(ZydisEncoderInstructionMatch* match,
        const ZydisEncoderOperand* user_op)
{
    ZYAN_ASSERT(match->eosz == 0);
    ZYAN_ASSERT(match->request->machine_mode != ZYDIS_MACHINE_MODE_LONG_64);
    ZYAN_ASSERT((match->request->branch_type == ZYDIS_BRANCH_TYPE_NONE) ||
                (match->request->branch_type == ZYDIS_BRANCH_TYPE_FAR));
    const ZyanU8 min_disp_size = ZydisGetUnsignedImmSize(user_op->ptr.offset);
    const ZyanU8 desired_disp_size = (match->request->branch_width == ZYDIS_BRANCH_WIDTH_NONE)
                                     ? ZydisGetMachineModeWidth(match->request->machine_mode)
                                     : (4 << match->request->branch_width);
    if(min_disp_size > desired_disp_size)
    {
        return ZYAN_FALSE;
    }
    match->eosz = match->disp_size = desired_disp_size;
    match->imm_size = 16;
    return ZYAN_TRUE;
}

/**
 * Checks if requested operand matches immediate operand from instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   user_op     Operand definition from `ZydisEncoderRequest` structure.
 * @param   def_op      Decoder's operand definition from current instruction definition.
 *
 * @return  True if operands match, false otherwise.
 */
static ZyanBool ZydisIsImmediateOperandCompabile(ZydisEncoderInstructionMatch* match,
        const ZydisEncoderOperand* user_op, const ZydisOperandDefinition* def_op)
{
    switch(def_op->type)
    {
    case ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_IMM1:
        if(user_op->imm.u != 1)
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_SEMANTIC_OPTYPE_IMM:
    case ZYDIS_SEMANTIC_OPTYPE_REL:
    {
        const ZyanU8 imm_size = ZydisGetEffectiveImmSize(match, user_op->imm.s, def_op);
        if(def_op->op.encoding != ZYDIS_OPERAND_ENCODING_IS4)
        {
            if(imm_size == 0)
            {
                return ZYAN_FALSE;
            }
            if(match->imm_size)
            {
                ZYAN_ASSERT(match->disp_size == 0);
                match->disp_size = match->imm_size;
            }
        }
        else
        {
            ZYAN_ASSERT(match->imm_size == 0);
            if(imm_size != 8)
            {
                return ZYAN_FALSE;
            }
        }
        match->imm_size = imm_size;
        match->has_rel_operand = (def_op->type == ZYDIS_SEMANTIC_OPTYPE_REL);
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if requested boardcast mode is compatible with instruction definition.
 *
 * @param   evex_def       Definition for `EVEX`-encoded instruction.
 * @param   vector_length  Vector length.
 * @param   broadcast      Requested broadcast mode.
 *
 * @return  True if broadcast mode is compatible, false otherwise.
 */
static ZyanBool ZydisIsBroadcastModeCompatible(const ZydisInstructionDefinitionEVEX* evex_def,
        ZydisVectorLength vector_length, ZydisBroadcastMode broadcast)
{
    if(broadcast == ZYDIS_BROADCAST_MODE_INVALID)
    {
        return ZYAN_TRUE;
    }

    ZyanU8 vector_size = 0;
    ZYAN_ASSERT(vector_length != ZYDIS_VECTOR_LENGTH_INVALID);
    switch(vector_length)
    {
    case ZYDIS_VECTOR_LENGTH_128:
        vector_size = 16;
        break;
    case ZYDIS_VECTOR_LENGTH_256:
        vector_size = 32;
        break;
    case ZYDIS_VECTOR_LENGTH_512:
        vector_size = 64;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    switch(evex_def->tuple_type)
    {
    case ZYDIS_TUPLETYPE_FV:
        break;
    case ZYDIS_TUPLETYPE_HV:
        vector_size /= 2;
        break;
    case ZYDIS_TUPLETYPE_QUARTER:
        vector_size /= 4;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    ZyanU8 element_size;
    switch(evex_def->element_size)
    {
    case ZYDIS_IELEMENT_SIZE_16:
        element_size = 2;
        break;
    case ZYDIS_IELEMENT_SIZE_32:
        element_size = 4;
        break;
    case ZYDIS_IELEMENT_SIZE_64:
        element_size = 8;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    ZydisBroadcastMode allowed_mode;
    const ZyanU8 element_count = vector_size / element_size;
    switch(element_count)
    {
    case 2:
        allowed_mode = ZYDIS_BROADCAST_MODE_1_TO_2;
        break;
    case 4:
        allowed_mode = ZYDIS_BROADCAST_MODE_1_TO_4;
        break;
    case 8:
        allowed_mode = ZYDIS_BROADCAST_MODE_1_TO_8;
        break;
    case 16:
        allowed_mode = ZYDIS_BROADCAST_MODE_1_TO_16;
        break;
    case 32:
        allowed_mode = ZYDIS_BROADCAST_MODE_1_TO_32;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    if(broadcast != allowed_mode)
    {
        return ZYAN_FALSE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if requested `EVEX`-specific features are compatible with instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   request     A pointer to `ZydisEncoderRequest` struct.
 *
 * @return  True if features are compatible, false otherwise.
 */
static ZyanBool ZydisAreEvexFeaturesCompatible(const ZydisEncoderInstructionMatch* match,
        const ZydisEncoderRequest* request)
{
    if(match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_EVEX)
    {
        return ZYAN_TRUE;
    }

    const ZydisInstructionDefinitionEVEX* evex_def =
        (const ZydisInstructionDefinitionEVEX*)match->base_definition;
    if((!evex_def->accepts_zero_mask) &&
            (evex_def->mask_override != ZYDIS_MASK_OVERRIDE_ZEROING) &&
            (request->evex.zeroing_mask))
    {
        return ZYAN_FALSE;
    }

    switch(evex_def->functionality)
    {
    case ZYDIS_EVEX_FUNC_INVALID:
        if((request->evex.sae) ||
                (request->evex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->evex.rounding != ZYDIS_ROUNDING_MODE_INVALID))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_EVEX_FUNC_BC:
        if((request->evex.sae) ||
                (request->evex.rounding != ZYDIS_ROUNDING_MODE_INVALID))
        {
            return ZYAN_FALSE;
        }
        if(!ZydisIsBroadcastModeCompatible(evex_def, match->definition->vector_length,
                                           request->evex.broadcast))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_EVEX_FUNC_RC:
        if(request->evex.broadcast != ZYDIS_BROADCAST_MODE_INVALID)
        {
            return ZYAN_FALSE;
        }
        if(request->evex.rounding == ZYDIS_ROUNDING_MODE_INVALID)
        {
            if(request->evex.sae)
            {
                return ZYAN_FALSE;
            }
        }
        else
        {
            if(!request->evex.sae)
            {
                return ZYAN_FALSE;
            }
        }
        break;
    case ZYDIS_EVEX_FUNC_SAE:
        if((request->evex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->evex.rounding != ZYDIS_ROUNDING_MODE_INVALID))
        {
            return ZYAN_FALSE;
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if requested `MVEX`-specific features are compatible with instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   request     A pointer to `ZydisEncoderRequest` struct.
 *
 * @return  True if features are compatible, false otherwise.
 */
static ZyanBool ZydisAreMvexFeaturesCompatible(const ZydisEncoderInstructionMatch* match,
        const ZydisEncoderRequest* request)
{
    if(match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_MVEX)
    {
        return ZYAN_TRUE;
    }
    if(((match->definition->modrm >> 6) == 3) &&
            (request->mvex.eviction_hint))
    {
        return ZYAN_FALSE;
    }

    const ZydisInstructionDefinitionMVEX* mvex_def =
        (const ZydisInstructionDefinitionMVEX*)match->base_definition;
    switch(mvex_def->functionality)
    {
    case ZYDIS_MVEX_FUNC_IGNORED:
    case ZYDIS_MVEX_FUNC_INVALID:
    case ZYDIS_MVEX_FUNC_F_32:
    case ZYDIS_MVEX_FUNC_I_32:
    case ZYDIS_MVEX_FUNC_F_64:
    case ZYDIS_MVEX_FUNC_I_64:
    case ZYDIS_MVEX_FUNC_UF_64:
    case ZYDIS_MVEX_FUNC_UI_64:
    case ZYDIS_MVEX_FUNC_DF_64:
    case ZYDIS_MVEX_FUNC_DI_64:
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_RC:
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.eviction_hint))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SAE:
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.eviction_hint))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SWIZZLE_32:
    case ZYDIS_MVEX_FUNC_SWIZZLE_64:
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SF_32:
        if((request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_1_TO_16) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_4_TO_16))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_FLOAT16) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_UINT8) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_UINT16) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_SINT16))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SI_32:
        if((request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_1_TO_16) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_4_TO_16))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_UINT8) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_SINT8) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_UINT16) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_SINT16))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SF_32_BCST:
    case ZYDIS_MVEX_FUNC_SI_32_BCST:
        if((request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_1_TO_16) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_4_TO_16))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16:
    case ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16:
        if((request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_4_TO_16))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_SF_64:
    case ZYDIS_MVEX_FUNC_SI_64:
        if((request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_1_TO_8) &&
                (request->mvex.broadcast != ZYDIS_BROADCAST_MODE_4_TO_8))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_UF_32:
    case ZYDIS_MVEX_FUNC_DF_32:
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        break;
    case ZYDIS_MVEX_FUNC_UI_32:
    case ZYDIS_MVEX_FUNC_DI_32:
        if((request->mvex.broadcast != ZYDIS_BROADCAST_MODE_INVALID) ||
                (request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID) ||
                (request->mvex.swizzle != ZYDIS_SWIZZLE_MODE_INVALID) ||
                (request->mvex.sae))
        {
            return ZYAN_FALSE;
        }
        if((request->mvex.conversion != ZYDIS_CONVERSION_MODE_INVALID) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_UINT8) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_SINT8) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_UINT16) &&
                (request->mvex.conversion != ZYDIS_CONVERSION_MODE_SINT16))
        {
            return ZYAN_FALSE;
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if operands specified in encoder request satisfy additional constraints mandated by
 * matched instruction definition.
 *
 * @param   match   A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  True if operands passed the checks, false otherwise.
 */
static ZyanBool ZydisCheckConstraints(const ZydisEncoderInstructionMatch* match)
{
    const ZydisEncoderOperand* operands = match->request->operands;
    ZyanBool is_gather = ZYAN_FALSE;
    switch(match->definition->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
    {
        const ZydisInstructionDefinitionVEX* vex_def =
            (const ZydisInstructionDefinitionVEX*)match->base_definition;
        if(vex_def->is_gather)
        {
            ZYAN_ASSERT(match->request->operand_count == 3);
            ZYAN_ASSERT(operands[0].type == ZYDIS_OPERAND_TYPE_REGISTER);
            ZYAN_ASSERT(operands[1].type == ZYDIS_OPERAND_TYPE_MEMORY);
            ZYAN_ASSERT(operands[2].type == ZYDIS_OPERAND_TYPE_REGISTER);
            const ZyanI8 dest = ZydisRegisterGetId(operands[0].reg.value);
            const ZyanI8 index = ZydisRegisterGetId(operands[1].mem.index);
            const ZyanI8 mask = ZydisRegisterGetId(operands[2].reg.value);
            // If any pair of the index, mask, or destination registers are the same, the
            // instruction results a UD fault.
            if((dest == index) || (dest == mask) || (index == mask))
            {
                return ZYAN_FALSE;
            }
        }

        if(vex_def->no_source_source_match)
        {
            ZYAN_ASSERT(match->request->operand_count == 3);
            ZYAN_ASSERT(operands[0].type == ZYDIS_OPERAND_TYPE_REGISTER);
            ZYAN_ASSERT(operands[1].type == ZYDIS_OPERAND_TYPE_REGISTER);
            ZYAN_ASSERT(operands[2].type == ZYDIS_OPERAND_TYPE_REGISTER);
            const ZydisRegister dest = operands[0].reg.value;
            const ZydisRegister source1 = operands[1].reg.value;
            const ZydisRegister source2 = operands[2].reg.value;
            // AMX-E4: #UD if srcdest == src1 OR src1 == src2 OR srcdest == src2.
            if((dest == source1) || (source1 == source2) || (dest == source2))
            {
                return ZYAN_FALSE;
            }
        }

        return ZYAN_TRUE;
    }
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
    {
        const ZydisInstructionDefinitionEVEX* evex_def =
            (const ZydisInstructionDefinitionEVEX*)match->base_definition;
        is_gather = evex_def->is_gather;
        if(evex_def->no_source_dest_match)
        {
            ZYAN_ASSERT(operands[0].type == ZYDIS_OPERAND_TYPE_REGISTER);
            ZYAN_ASSERT(operands[2].type == ZYDIS_OPERAND_TYPE_REGISTER);
            ZYAN_ASSERT((operands[3].type == ZYDIS_OPERAND_TYPE_REGISTER) ||
                        (operands[3].type == ZYDIS_OPERAND_TYPE_MEMORY));
            const ZydisRegister dest = operands[0].reg.value;
            const ZydisRegister source1 = operands[2].reg.value;
            const ZydisRegister source2 = (operands[3].type == ZYDIS_OPERAND_TYPE_REGISTER)
                                          ? operands[3].reg.value
                                          : ZYDIS_REGISTER_NONE;

            if((dest == source1) || (dest == source2))
            {
                return ZYAN_FALSE;
            }
        }
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
    {
        const ZydisInstructionDefinitionMVEX* mvex_def =
            (const ZydisInstructionDefinitionMVEX*)match->base_definition;
        is_gather = mvex_def->is_gather;
        break;
    }
    default:
        return ZYAN_TRUE;
    }

    if((is_gather) && (operands[0].type == ZYDIS_OPERAND_TYPE_REGISTER))
    {
        ZYAN_ASSERT(match->request->operand_count == 3);
        ZYAN_ASSERT(operands[0].type == ZYDIS_OPERAND_TYPE_REGISTER);
        ZYAN_ASSERT(operands[2].type == ZYDIS_OPERAND_TYPE_MEMORY);
        const ZyanI8 dest = ZydisRegisterGetId(operands[0].reg.value);
        const ZyanI8 index = ZydisRegisterGetId(operands[2].mem.index);
        // EVEX: The instruction will #UD fault if the destination vector zmm1 is the same as
        // index vector VINDEX.
        // MVEX: The KNC GATHER instructions forbid using the same vector register for destination
        // and for the index. (https://github.com/intelxed/xed/issues/281#issuecomment-970074554)
        if(dest == index)
        {
            return ZYAN_FALSE;
        }
    }

    return ZYAN_TRUE;
}

/**
 * Checks if operands and encoding-specific features from `ZydisEncoderRequest` match
 * encoder's instruction definition.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   request     A pointer to `ZydisEncoderRequest` struct.
 *
 * @return  True if definition is compatible, false otherwise.
 */
static ZyanBool ZydisIsDefinitionCompatible(ZydisEncoderInstructionMatch* match,
        const ZydisEncoderRequest* request)
{
    ZYAN_ASSERT(request->operand_count == match->base_definition->operand_count_visible);
    match->operands = ZydisGetOperandDefinitions(match->base_definition);

    if(!ZydisAreEvexFeaturesCompatible(match, request))
    {
        return ZYAN_FALSE;
    }
    if(!ZydisAreMvexFeaturesCompatible(match, request))
    {
        return ZYAN_FALSE;
    }

    for(ZyanU8 i = 0; i < request->operand_count; ++i)
    {
        const ZydisEncoderOperand* user_op = &request->operands[i];
        const ZydisOperandDefinition* def_op = &match->operands[i];
        ZYAN_ASSERT(def_op->visibility != ZYDIS_OPERAND_VISIBILITY_HIDDEN);
        ZyanBool is_compatible = ZYAN_FALSE;
        switch(user_op->type)
        {
        case ZYDIS_OPERAND_TYPE_REGISTER:
            is_compatible = ZydisIsRegisterOperandCompatible(match, user_op, def_op);
            break;
        case ZYDIS_OPERAND_TYPE_MEMORY:
            is_compatible = ZydisIsMemoryOperandCompatible(match, user_op, def_op);
            break;
        case ZYDIS_OPERAND_TYPE_POINTER:
            is_compatible = ZydisIsPointerOperandCompatible(match, user_op);
            break;
        case ZYDIS_OPERAND_TYPE_IMMEDIATE:
            is_compatible = ZydisIsImmediateOperandCompabile(match, user_op, def_op);
            break;
        default:
            ZYAN_UNREACHABLE;
        }

        if(!is_compatible)
        {
            return ZYAN_FALSE;
        }
    }

    ZyanU8 eosz = 0;
    if(match->base_definition->branch_type != ZYDIS_BRANCH_TYPE_NONE)
    {
        switch(request->branch_width)
        {
        case ZYDIS_BRANCH_WIDTH_NONE:
            break;
        case ZYDIS_BRANCH_WIDTH_8:
            if((!match->has_rel_operand) ||
                    (match->base_definition->branch_type != ZYDIS_BRANCH_TYPE_SHORT))
            {
                return ZYAN_FALSE;
            }
            break;
        case ZYDIS_BRANCH_WIDTH_16:
            eosz = 16;
            break;
        case ZYDIS_BRANCH_WIDTH_32:
            eosz = ((match->has_rel_operand) &&
                    (match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
                    (match->base_definition->operand_size_map == ZYDIS_OPSIZE_MAP_FORCE64))
                   ? 64
                   : 32;
            break;
        case ZYDIS_BRANCH_WIDTH_64:
            if(match->has_rel_operand)
            {
                return ZYAN_FALSE;
            }
            eosz = 64;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
    }
    if(eosz)
    {
        if(match->eosz != 0)
        {
            if(match->eosz != eosz)
            {
                return ZYAN_FALSE;
            }
        }
        else
        {
            match->eosz = eosz;
        }
    }

    if(!ZydisCheckConstraints(match))
    {
        return ZYAN_FALSE;
    }

    return ZYAN_TRUE;
}

/**
 * Checks if requested set of prefixes is compatible with instruction definition.
 *
 * @param   match A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  A zyan status code.
 */
static ZyanBool ZydisArePrefixesCompatible(const ZydisEncoderInstructionMatch* match)
{
    // Early-exit optimization for when no prefixes are requested at all.
    if(!(match->attributes & ZYDIS_ENCODABLE_PREFIXES))
    {
        return ZYAN_TRUE;
    }

    if((!match->base_definition->accepts_segment) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_SEGMENT))
    {
        return ZYAN_FALSE;
    }
    if(match->definition->encoding != ZYDIS_INSTRUCTION_ENCODING_LEGACY)
    {
        return !(match->attributes & ZYDIS_ENCODABLE_PREFIXES_NO_SEGMENTS);
    }

    const ZydisInstructionDefinitionLEGACY* legacy_def =
        (const ZydisInstructionDefinitionLEGACY*)match->base_definition;
    if((!legacy_def->accepts_LOCK) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_LOCK))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_REP) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_REP))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_REPEREPZ) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_REPE))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_REPNEREPNZ) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_REPNE))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_BOUND) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_BND))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_XACQUIRE) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_XACQUIRE))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_XRELEASE) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_XRELEASE))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_branch_hints) &&
            (match->attributes & (ZYDIS_ATTRIB_HAS_BRANCH_NOT_TAKEN |
                                  ZYDIS_ATTRIB_HAS_BRANCH_TAKEN)))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_NOTRACK) &&
            (match->attributes & ZYDIS_ATTRIB_HAS_NOTRACK))
    {
        return ZYAN_FALSE;
    }
    if((!legacy_def->accepts_hle_without_lock) &&
            (match->attributes & (ZYDIS_ATTRIB_HAS_XACQUIRE |
                                  ZYDIS_ATTRIB_HAS_XRELEASE)) &&
            !(match->attributes & ZYDIS_ATTRIB_HAS_LOCK))
    {
        return ZYAN_FALSE;
    }

    return ZYAN_TRUE;
}

/**
 * Returns operand mask containing information about operand count and types in a compressed form.
 *
 * @param   request     A pointer to `ZydisEncoderRequest` struct.
 *
 * @return  Operand mask.
 */
static ZyanU16 ZydisGetOperandMask(const ZydisEncoderRequest* request)
{
    ZyanU16 operand_mask = request->operand_count;
    ZyanU8 bit_offset = ZYAN_BITS_TO_REPRESENT(ZYDIS_ENCODER_MAX_OPERANDS);
    for(ZyanU8 i = 0; i < request->operand_count; ++i)
    {
        operand_mask |= (request->operands[i].type - ZYDIS_OPERAND_TYPE_REGISTER) << bit_offset;
        bit_offset += ZYAN_BITS_TO_REPRESENT(
                          ZYDIS_OPERAND_TYPE_MAX_VALUE - ZYDIS_OPERAND_TYPE_REGISTER);
    }

    return operand_mask;
}

/**
 * Handles optimization opportunities indicated by `swappable` field in instruction definition
 * structure. See `ZydisEncodableInstruction` for more information.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  True if definition has been swapped, false otherwise.
 */
static ZyanBool ZydisHandleSwappableDefinition(ZydisEncoderInstructionMatch* match)
{
    if(!match->definition->swappable)
    {
        return ZYAN_FALSE;
    }

    // Special case for ISA-wide unique conflict between two `mov` variants
    // mov gpr16_32_64(encoding=opcode), imm(encoding=simm16_32_64,scale_factor=osz)
    // mov gpr16_32_64(encoding=modrm_rm), imm(encoding=simm16_32_32,scale_factor=osz)
    if(match->request->mnemonic == ZYDIS_MNEMONIC_MOV)
    {
        const ZyanU8 imm_size = ZydisGetSignedImmSize(match->request->operands[1].imm.s);
        if((match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
                (match->eosz == 64) &&
                (imm_size < 64))
        {
            return ZYAN_TRUE;
        }
    }

    ZYAN_ASSERT((match->request->operand_count == 2) || (match->request->operand_count == 3));
    const ZyanU8 src_index = (match->request->operand_count == 3) ? 2 : 1;
    const ZyanI8 dest_id = ZydisRegisterGetId(match->request->operands[0].reg.value);
    const ZyanI8 src_id = ZydisRegisterGetId(match->request->operands[src_index].reg.value);
    if((dest_id <= 7) && (src_id > 7))
    {
        ++match->definition;
        ZydisGetInstructionDefinition(match->definition->encoding,
                                      match->definition->instruction_reference, &match->base_definition);
        match->operands = ZydisGetOperandDefinitions(match->base_definition);
        return ZYAN_TRUE;
    }

    return ZYAN_FALSE;
}

/**
 * This function attempts to find a matching instruction definition for provided encoder request.
 *
 * @param   request     A pointer to `ZydisEncoderRequest` struct.
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisFindMatchingDefinition(const ZydisEncoderRequest* request,
        ZydisEncoderInstructionMatch* match)
{
    ZYAN_MEMSET(match, 0, sizeof(ZydisEncoderInstructionMatch));
    match->request = request;
    match->attributes = request->prefixes;

    const ZydisEncodableInstruction* definition = ZYAN_NULL;
    const ZyanU8 definition_count = ZydisGetEncodableInstructions(request->mnemonic, &definition);
    ZYAN_ASSERT(definition && definition_count);
    const ZydisWidthFlag mode_width = ZydisGetMachineModeWidth(request->machine_mode) >> 4;
    const ZyanBool is_compat =
        (request->machine_mode == ZYDIS_MACHINE_MODE_LONG_COMPAT_16) ||
        (request->machine_mode == ZYDIS_MACHINE_MODE_LONG_COMPAT_32);
    const ZyanU8 default_asz = ZydisGetAszFromHint(request->address_size_hint);
    const ZyanU8 default_osz = ZydisGetOszFromHint(request->operand_size_hint);
    const ZyanU16 operand_mask = ZydisGetOperandMask(request);

    for(ZyanU8 i = 0; i < definition_count; ++i, ++definition)
    {
        if(definition->operand_mask != operand_mask)
        {
            continue;
        }
        const ZydisInstructionDefinition* base_definition = ZYAN_NULL;
        ZydisGetInstructionDefinition(definition->encoding, definition->instruction_reference,
                                      &base_definition);
        if(!(definition->modes & mode_width))
        {
            continue;
        }
        if((request->allowed_encodings != ZYDIS_ENCODABLE_ENCODING_DEFAULT) &&
                !(ZydisGetEncodableEncoding(definition->encoding) & request->allowed_encodings))
        {
            continue;
        }
        if(request->machine_mode == ZYDIS_MACHINE_MODE_REAL_16)
        {
            if(base_definition->requires_protected_mode)
            {
                continue;
            }
            switch(definition->encoding)
            {
            case ZYDIS_INSTRUCTION_ENCODING_XOP:
            case ZYDIS_INSTRUCTION_ENCODING_VEX:
            case ZYDIS_INSTRUCTION_ENCODING_EVEX:
            case ZYDIS_INSTRUCTION_ENCODING_MVEX:
                continue;
            default:
                break;
            }
        }
        else if((request->machine_mode != ZYDIS_MACHINE_MODE_LONG_64) &&
                (definition->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX))
        {
            continue;
        }
        if(is_compat && base_definition->no_compat_mode)
        {
            continue;
        }
        if((request->branch_type != ZYDIS_BRANCH_TYPE_NONE) &&
                (request->branch_type != base_definition->branch_type))
        {
            continue;
        }
        if((base_definition->branch_type == ZYDIS_BRANCH_TYPE_NONE) &&
                (request->branch_width != ZYDIS_BRANCH_WIDTH_NONE))
        {
            continue;
        }

        match->definition = definition;
        match->base_definition = base_definition;
        match->operands = ZYAN_NULL;
        match->easz = definition->accepts_hint == ZYDIS_SIZE_HINT_ASZ ? default_asz : 0;
        match->eosz = definition->accepts_hint == ZYDIS_SIZE_HINT_OSZ ? default_osz : 0;
        match->disp_size = match->imm_size = match->cd8_scale = 0;
        match->rex_type = ZYDIS_REX_TYPE_UNKNOWN;
        match->eosz64_forbidden = ZYAN_FALSE;
        match->has_rel_operand = ZYAN_FALSE;
        if((base_definition->operand_size_map != ZYDIS_OPSIZE_MAP_BYTEOP) &&
                (match->eosz == 8))
        {
            continue;
        }
        if(!ZydisArePrefixesCompatible(match))
        {
            continue;
        }
        if(!ZydisIsDefinitionCompatible(match, request))
        {
            continue;
        }
        if(ZydisHandleSwappableDefinition(match))
        {
            if(definition == match->definition)
            {
                continue;
            }
            ++i;
            definition = match->definition;
            base_definition = match->base_definition;
        }

        if(match->easz == 0)
        {
            if(definition->address_sizes & mode_width)
            {
                match->easz = (ZyanU8)(mode_width << 4);
            }
            else if(mode_width == ZYDIS_WIDTH_16)
            {
                match->easz = 32;
            }
            else if(mode_width == ZYDIS_WIDTH_32)
            {
                match->easz = 16;
            }
            else
            {
                match->easz = 32;
            }
            ZYAN_ASSERT(definition->address_sizes & (match->easz >> 4));
        }
        else if(!(definition->address_sizes & (match->easz >> 4)))
        {
            continue;
        }

        if(mode_width == ZYDIS_WIDTH_64)
        {
            if(base_definition->operand_size_map == ZYDIS_OPSIZE_MAP_DEFAULT64)
            {
                if(match->eosz == 0)
                {
                    ZYAN_ASSERT(definition->operand_sizes & (ZYDIS_WIDTH_16 | ZYDIS_WIDTH_64));
                    if(definition->operand_sizes & ZYDIS_WIDTH_64)
                    {
                        match->eosz = 64;
                    }
                    else
                    {
                        match->eosz = 16;
                    }
                }
                else if(match->eosz == 32)
                {
                    continue;
                }
            }
            else if(base_definition->operand_size_map == ZYDIS_OPSIZE_MAP_FORCE64)
            {
                if(match->eosz == 0)
                {
                    match->eosz = 64;
                }
                else if(match->eosz != 64)
                {
                    continue;
                }
            }
        }
        if(match->eosz == 0)
        {
            const ZydisWidthFlag default_width = (mode_width == ZYDIS_WIDTH_64)
                                                 ? ZYDIS_WIDTH_32
                                                 : mode_width;
            if(definition->operand_sizes & default_width)
            {
                match->eosz = (ZyanU8)(default_width << 4);
            }
            else if(definition->operand_sizes & ZYDIS_WIDTH_16)
            {
                match->eosz = 16;
            }
            else if(definition->operand_sizes & ZYDIS_WIDTH_32)
            {
                match->eosz = 32;
            }
            else
            {
                match->eosz = 64;
            }
        }
        else if(match->eosz64_forbidden && match->eosz == 64)
        {
            continue;
        }
        else if(!(definition->operand_sizes & (match->eosz >> 4)))
        {
            continue;
        }

        return ZYAN_STATUS_SUCCESS;
    }

    return ZYDIS_STATUS_IMPOSSIBLE_INSTRUCTION;
}

/**
 * Emits unsigned integer value.
 *
 * @param   data    Value to emit.
 * @param   size    Value size in bytes.
 * @param   buffer  A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitUInt(ZyanU64 data, ZyanU8 size, ZydisEncoderBuffer* buffer)
{
    ZYAN_ASSERT(size == 1 || size == 2 || size == 4 || size == 8);

    const ZyanUSize new_offset = buffer->offset + size;
    if(new_offset > buffer->size)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    // TODO: fix for big-endian systems
    // The size variable is not passed on purpose to allow the compiler
    // to generate better code with a known size at compile time.
    if(size == 1)
    {
        ZYAN_MEMCPY(buffer->buffer + buffer->offset, &data, 1);
    }
    else if(size == 2)
    {
        ZYAN_MEMCPY(buffer->buffer + buffer->offset, &data, 2);
    }
    else if(size == 4)
    {
        ZYAN_MEMCPY(buffer->buffer + buffer->offset, &data, 4);
    }
    else if(size == 8)
    {
        ZYAN_MEMCPY(buffer->buffer + buffer->offset, &data, 8);
    }
    else
    {
        ZYAN_UNREACHABLE;
    }

    buffer->offset = new_offset;
    return ZYAN_STATUS_SUCCESS;
}

/**
 * Emits a single byte.
 *
 * @param   byte    Value to emit.
 * @param   buffer  A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitByte(ZyanU8 byte, ZydisEncoderBuffer* buffer)
{
    return ZydisEmitUInt(byte, 1, buffer);
}

/**
 * Emits legact prefixes.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitLegacyPrefixes(const ZydisEncoderInstruction* instruction,
        ZydisEncoderBuffer* buffer)
{
    ZyanBool compressed_prefixes = ZYAN_FALSE;
    switch(instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        compressed_prefixes = ZYAN_TRUE;
        break;
    default:
        break;
    }

    // Group 1
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_LOCK)
    {
        ZYAN_CHECK(ZydisEmitByte(0xF0, buffer));
    }
    if(!compressed_prefixes)
    {
        if(instruction->attributes & (ZYDIS_ATTRIB_HAS_REPNE |
                                      ZYDIS_ATTRIB_HAS_BND |
                                      ZYDIS_ATTRIB_HAS_XACQUIRE))
        {
            ZYAN_CHECK(ZydisEmitByte(0xF2, buffer));
        }
        if(instruction->attributes & (ZYDIS_ATTRIB_HAS_REP |
                                      ZYDIS_ATTRIB_HAS_REPE |
                                      ZYDIS_ATTRIB_HAS_XRELEASE))
        {
            ZYAN_CHECK(ZydisEmitByte(0xF3, buffer));
        }
    }

    // Group 2
    if(instruction->attributes & (ZYDIS_ATTRIB_HAS_SEGMENT_CS |
                                  ZYDIS_ATTRIB_HAS_BRANCH_NOT_TAKEN))
    {
        ZYAN_CHECK(ZydisEmitByte(0x2E, buffer));
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_SS)
    {
        ZYAN_CHECK(ZydisEmitByte(0x36, buffer));
    }
    if(instruction->attributes & (ZYDIS_ATTRIB_HAS_SEGMENT_DS |
                                  ZYDIS_ATTRIB_HAS_BRANCH_TAKEN))
    {
        ZYAN_CHECK(ZydisEmitByte(0x3E, buffer));
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_ES)
    {
        ZYAN_CHECK(ZydisEmitByte(0x26, buffer));
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_FS)
    {
        ZYAN_CHECK(ZydisEmitByte(0x64, buffer));
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_GS)
    {
        ZYAN_CHECK(ZydisEmitByte(0x65, buffer));
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_NOTRACK)
    {
        ZYAN_CHECK(ZydisEmitByte(0x3E, buffer));
    }

    // Group 3
    if(!compressed_prefixes)
    {
        if(instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE)
        {
            ZYAN_CHECK(ZydisEmitByte(0x66, buffer));
        }
    }

    // Group 4
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE)
    {
        ZYAN_CHECK(ZydisEmitByte(0x67, buffer));
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Encodes low nibble of `REX` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   high_r          A pointer to `ZyanBool` variable that will be set to true when the
 *                          highest `ModR/M.reg` bit cannot be encoded using `REX` prefix.
 *
 * @return  A zyan status code.
 */
static ZyanU8 ZydisEncodeRexLowNibble(const ZydisEncoderInstruction* instruction, ZyanBool* high_r)
{
    if(high_r)
    {
        *high_r = ZYAN_FALSE;
    }

    ZyanU8 rex = 0;
    if((instruction->attributes & ZYDIS_ATTRIB_HAS_MODRM) &&
            (instruction->attributes & ZYDIS_ATTRIB_HAS_SIB))
    {
        if(instruction->base & 0x08)
        {
            rex |= 1;
        }
        if(instruction->index & 0x08)
        {
            rex |= 2;
        }
        if(instruction->reg & 0x08)
        {
            rex |= 4;
        }
        if(high_r && (instruction->reg & 0x10))
        {
            *high_r = ZYAN_TRUE;
        }
    }
    else if(instruction->attributes & ZYDIS_ATTRIB_HAS_MODRM)
    {
        if(instruction->rm & 0x08)
        {
            rex |= 1;
        }
        if(instruction->rm & 0x10)
        {
            rex |= 2;
        }
        if(instruction->reg & 0x08)
        {
            rex |= 4;
        }
        if(high_r && (instruction->reg & 0x10))
        {
            *high_r = ZYAN_TRUE;
        }
    }
    else
    {
        if(instruction->rm & 0x08)
        {
            rex |= 1;
        }
    }

    if(instruction->rex_w)
    {
        rex |= 8;
    }

    return rex;
}

/**
 * Emits `REX` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitRex(const ZydisEncoderInstruction* instruction,
                               ZydisEncoderBuffer* buffer)
{
    const ZyanU8 rex = ZydisEncodeRexLowNibble(instruction, ZYAN_NULL);
    if(rex || (instruction->attributes & ZYDIS_ATTRIB_HAS_REX))
    {
        ZYAN_CHECK(ZydisEmitByte(0x40 | rex, buffer));
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Encodes common parts of `VEX` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   mmmmm           A pointer to `ZyanU8` variable that will receive `VEX.mmmmm`
 * @param   pp              A pointer to `ZyanU8` variable that will receive `VEX.pp`
 * @param   vvvv            A pointer to `ZyanU8` variable that will receive `VEX.vvvv`
 * @param   rex             A pointer to `ZyanU8` variable that will receive 'REX`
 * @param   high_r          A pointer to `ZyanBool` variable that will be set to true when the
 *                          highest `ModR/M.reg` bit cannot be encoded using `REX` prefix.
 */
static void ZydisEncodeVexCommons(ZydisEncoderInstruction* instruction, ZyanU8* mmmmm, ZyanU8* pp,
                                  ZyanU8* vvvv, ZyanU8* rex, ZyanBool* high_r)
{
    switch(instruction->opcode_map)
    {
    case ZYDIS_OPCODE_MAP_DEFAULT:
    case ZYDIS_OPCODE_MAP_0F:
    case ZYDIS_OPCODE_MAP_0F38:
    case ZYDIS_OPCODE_MAP_0F3A:
    case ZYDIS_OPCODE_MAP_MAP5:
    case ZYDIS_OPCODE_MAP_MAP6:
        *mmmmm = (ZyanU8)instruction->opcode_map;
        break;
    case ZYDIS_OPCODE_MAP_XOP8:
    case ZYDIS_OPCODE_MAP_XOP9:
    case ZYDIS_OPCODE_MAP_XOPA:
        *mmmmm = 8 + ((ZyanU8)instruction->opcode_map - ZYDIS_OPCODE_MAP_XOP8);
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    instruction->opcode_map = ZYDIS_OPCODE_MAP_DEFAULT;

    *pp = 0;
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE)
    {
        *pp = 1;
    }
    else if(instruction->attributes & ZYDIS_ATTRIB_HAS_REP)
    {
        *pp = 2;
    }
    else if(instruction->attributes & ZYDIS_ATTRIB_HAS_REPNE)
    {
        *pp = 3;
    }

    *vvvv = ~instruction->vvvv;
    *rex = ZydisEncodeRexLowNibble(instruction, high_r);
}

/**
 * Emits `XOP` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitXop(ZydisEncoderInstruction* instruction, ZydisEncoderBuffer* buffer)
{
    ZyanU8 mmmmm, pp, vvvv, rex;
    ZydisEncodeVexCommons(instruction, &mmmmm, &pp, &vvvv, &rex, ZYAN_NULL);
    ZYAN_ASSERT(instruction->vector_length <= 1);
    const ZyanU8 b1 = (((~rex) & 0x07) << 5) | mmmmm;
    const ZyanU8 b2 = ((rex & 0x08) << 4) | ((vvvv & 0xF) << 3) | (instruction->vector_length << 2) | pp;
    ZYAN_CHECK(ZydisEmitByte(0x8F, buffer));
    ZYAN_CHECK(ZydisEmitByte(b1, buffer));
    ZYAN_CHECK(ZydisEmitByte(b2, buffer));
    return ZYAN_STATUS_SUCCESS;
}

/**
 * Emits `VEX` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitVex(ZydisEncoderInstruction* instruction, ZydisEncoderBuffer* buffer)
{
    ZyanU8 mmmmm, pp, vvvv, rex;
    ZydisEncodeVexCommons(instruction, &mmmmm, &pp, &vvvv, &rex, ZYAN_NULL);
    ZYAN_ASSERT(instruction->vector_length <= 1);
    if(mmmmm != 1 || (rex & 0x0B))
    {
        const ZyanU8 b1 = (((~rex) & 0x07) << 5) | mmmmm;
        const ZyanU8 b2 = ((rex & 0x08) << 4) |
                          ((vvvv & 0xF) << 3) |
                          (instruction->vector_length << 2) |
                          pp;
        ZYAN_CHECK(ZydisEmitByte(0xC4, buffer));
        ZYAN_CHECK(ZydisEmitByte(b1, buffer));
        ZYAN_CHECK(ZydisEmitByte(b2, buffer));
    }
    else
    {
        const ZyanU8 b1 = (((~rex) & 0x04) << 5) |
                          ((vvvv & 0xF) << 3) |
                          (instruction->vector_length << 2) |
                          pp;
        ZYAN_CHECK(ZydisEmitByte(0xC5, buffer));
        ZYAN_CHECK(ZydisEmitByte(b1, buffer));
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Encodes common parts of `EVEX` prefix.
 *
 * @param   instruction A pointer to `ZydisEncoderInstruction` struct.
 * @param   p0          A pointer to `ZyanU8` variable that will receive 2nd byte of `EVEX` prefix.
 * @param   p1          A pointer to `ZyanU8` variable that will receive 3rd byte of `EVEX` prefix.
 * @param   vvvvv       A pointer to `ZyanU8` variable that will receive `EVEX.vvvvv`.
 */
static void ZydisEncodeEvexCommons(ZydisEncoderInstruction* instruction, ZyanU8* p0, ZyanU8* p1,
                                   ZyanU8* vvvvv)
{
    ZyanBool high_r;
    ZyanU8 mmmmm, pp, rex;
    ZydisEncodeVexCommons(instruction, &mmmmm, &pp, vvvvv, &rex, &high_r);
    *p0 = (((~rex) & 0x07) << 5) | mmmmm;
    if(!high_r)
    {
        *p0 |= 0x10;
    }
    *p1 = ((rex & 0x08) << 4) | ((*vvvvv & 0x0F) << 3) | 0x04 | pp;
}

/**
 * Emits `EVEX` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitEvex(ZydisEncoderInstruction* instruction, ZydisEncoderBuffer* buffer)
{
    ZyanU8 p0, p1, vvvvv;
    ZydisEncodeEvexCommons(instruction, &p0, &p1, &vvvvv);
    ZyanU8 p2 = (instruction->vector_length << 5) | ((vvvvv & 0x10) >> 1) | instruction->mask;
    if(instruction->zeroing)
    {
        p2 |= 0x80;
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX_B)
    {
        p2 |= 0x10;
    }
    if(instruction->index & 0x10)
    {
        p2 &= 0xF7;
    }

    ZYAN_CHECK(ZydisEmitByte(0x62, buffer));
    ZYAN_CHECK(ZydisEmitByte(p0, buffer));
    ZYAN_CHECK(ZydisEmitByte(p1, buffer));
    ZYAN_CHECK(ZydisEmitByte(p2, buffer));
    return ZYAN_STATUS_SUCCESS;
}

/**
 * Emits `MVEX` prefix.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitMvex(ZydisEncoderInstruction* instruction, ZydisEncoderBuffer* buffer)
{
    ZyanU8 p0, p1, vvvvv;
    ZydisEncodeEvexCommons(instruction, &p0, &p1, &vvvvv);
    ZyanU8 p2 = (instruction->sss << 4) | ((vvvvv & 0x10) >> 1) | instruction->mask;
    if(instruction->eviction_hint)
    {
        p2 |= 0x80;
    }
    if(instruction->index & 0x10)
    {
        p2 &= 0xF7;
    }

    ZYAN_CHECK(ZydisEmitByte(0x62, buffer));
    ZYAN_CHECK(ZydisEmitByte(p0, buffer));
    ZYAN_CHECK(ZydisEmitByte(p1 & 0xFB, buffer));
    ZYAN_CHECK(ZydisEmitByte(p2, buffer));
    return ZYAN_STATUS_SUCCESS;
}

/**
 * Emits instruction as stream of bytes.
 *
 * @param   instruction     A pointer to `ZydisEncoderInstruction` struct.
 * @param   buffer          A pointer to `ZydisEncoderBuffer` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEmitInstruction(ZydisEncoderInstruction* instruction,
                                       ZydisEncoderBuffer* buffer)
{
    ZYAN_CHECK(ZydisEmitLegacyPrefixes(instruction, buffer));

    switch(instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
    case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
        ZYAN_CHECK(ZydisEmitRex(instruction, buffer));
        break;
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
        ZYAN_CHECK(ZydisEmitXop(instruction, buffer));
        break;
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        ZYAN_CHECK(ZydisEmitVex(instruction, buffer));
        break;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        ZYAN_CHECK(ZydisEmitEvex(instruction, buffer));
        break;
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        ZYAN_CHECK(ZydisEmitMvex(instruction, buffer));
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    switch(instruction->opcode_map)
    {
    case ZYDIS_OPCODE_MAP_DEFAULT:
        break;
    case ZYDIS_OPCODE_MAP_0F:
        ZYAN_CHECK(ZydisEmitByte(0x0F, buffer));
        break;
    case ZYDIS_OPCODE_MAP_0F38:
        ZYAN_CHECK(ZydisEmitByte(0x0F, buffer));
        ZYAN_CHECK(ZydisEmitByte(0x38, buffer));
        break;
    case ZYDIS_OPCODE_MAP_0F3A:
        ZYAN_CHECK(ZydisEmitByte(0x0F, buffer));
        ZYAN_CHECK(ZydisEmitByte(0x3A, buffer));
        break;
    case ZYDIS_OPCODE_MAP_0F0F:
        ZYAN_CHECK(ZydisEmitByte(0x0F, buffer));
        ZYAN_CHECK(ZydisEmitByte(0x0F, buffer));
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    if(instruction->encoding != ZYDIS_INSTRUCTION_ENCODING_3DNOW)
    {
        ZYAN_CHECK(ZydisEmitByte(instruction->opcode, buffer));
    }

    if(instruction->attributes & ZYDIS_ATTRIB_HAS_MODRM)
    {
        const ZyanU8 modrm = (instruction->mod << 6) |
                             ((instruction->reg & 7) << 3) |
                             (instruction->rm & 7);
        ZYAN_CHECK(ZydisEmitByte(modrm, buffer));
    }
    if(instruction->attributes & ZYDIS_ATTRIB_HAS_SIB)
    {
        const ZyanU8 sib = (instruction->scale << 6) |
                           ((instruction->index & 7) << 3) |
                           (instruction->base & 7);
        ZYAN_CHECK(ZydisEmitByte(sib, buffer));
    }
    if(instruction->disp_size)
    {
        ZYAN_CHECK(ZydisEmitUInt(instruction->disp, instruction->disp_size / 8, buffer));
    }
    if(instruction->imm_size)
    {
        ZYAN_CHECK(ZydisEmitUInt(instruction->imm, instruction->imm_size / 8, buffer));
    }
    if(instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_3DNOW)
    {
        ZYAN_CHECK(ZydisEmitByte(instruction->opcode, buffer));
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Encodes register operand as fields inside `ZydisEncoderInstruction` structure.
 *
 * @param   user_op     Validated operand definition from `ZydisEncoderRequest` structure.
 * @param   def_op      Decoder's operand definition from instruction definition.
 * @param   instruction A pointer to `ZydisEncoderInstruction` struct.
 */
void ZydisBuildRegisterOperand(const ZydisEncoderOperand* user_op,
                               const ZydisOperandDefinition* def_op, ZydisEncoderInstruction* instruction)
{
    if(def_op->type == ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_REG)
    {
        return;
    }

    ZyanU8 reg_id = 0;
    if(ZydisRegisterGetClass(user_op->reg.value) != ZYDIS_REGCLASS_GPR8)
    {
        reg_id = (ZyanU8)ZydisRegisterGetId(user_op->reg.value);
    }
    else
    {
        static const ZyanU8 reg8_lookup[] =
        {
            0, 1, 2, 3,                     // AL, CL, DL, BL
            4, 5, 6, 7,                     // AH, CH, DH, BH
            4, 5, 6, 7,                     // SPL, BPL, SIL, DIL
            8, 9, 10, 11, 12, 13, 14, 15,   // R8B-R15B
        };
        ZYAN_ASSERT(
            ((ZyanUSize)user_op->reg.value - ZYDIS_REGISTER_AL) < ZYAN_ARRAY_LENGTH(reg8_lookup));
        reg_id = reg8_lookup[user_op->reg.value - ZYDIS_REGISTER_AL];
        if(user_op->reg.value >= ZYDIS_REGISTER_SPL && user_op->reg.value <= ZYDIS_REGISTER_DIL)
        {
            instruction->attributes |= ZYDIS_ATTRIB_HAS_REX;
        }
    }

    switch(def_op->op.encoding)
    {
    case ZYDIS_OPERAND_ENCODING_MODRM_REG:
        instruction->attributes |= ZYDIS_ATTRIB_HAS_MODRM;
        instruction->reg = reg_id;
        break;
    case ZYDIS_OPERAND_ENCODING_MODRM_RM:
        instruction->attributes |= ZYDIS_ATTRIB_HAS_MODRM;
        instruction->rm = reg_id;
        break;
    case ZYDIS_OPERAND_ENCODING_OPCODE:
        instruction->opcode += reg_id & 7;
        instruction->rm = reg_id;
        break;
    case ZYDIS_OPERAND_ENCODING_NDSNDD:
        instruction->vvvv = reg_id;
        break;
    case ZYDIS_OPERAND_ENCODING_IS4:
        instruction->imm_size = 8;
        instruction->imm = reg_id << 4;
        break;
    case ZYDIS_OPERAND_ENCODING_MASK:
        instruction->mask = reg_id;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Encodes memory operand as fields inside `ZydisEncoderInstruction` structure.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   user_op     Decoder's operand definition from instruction definition.
 * @param   instruction A pointer to `ZydisEncoderInstruction` struct.
 */
static void ZydisBuildMemoryOperand(ZydisEncoderInstructionMatch* match,
                                    const ZydisEncoderOperand* user_op, ZydisEncoderInstruction* instruction)
{
    instruction->attributes |= ZYDIS_ATTRIB_HAS_MODRM;
    instruction->disp = (ZyanU64)user_op->mem.displacement;
    if(match->easz == 16)
    {
        const ZyanI8 rm = ZydisGetRm16(user_op->mem.base, user_op->mem.index);
        if(rm != -1)
        {
            instruction->rm = (ZyanU8)rm;
            instruction->disp_size = match->disp_size;
            switch(instruction->disp_size)
            {
            case 0:
                if(rm == 6)
                {
                    instruction->disp_size = 8;
                    instruction->mod = 1;
                }
                break;
            case 8:
                instruction->mod = 1;
                break;
            case 16:
                instruction->mod = 2;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
        }
        else
        {
            instruction->rm = 6;
            instruction->disp_size = 16;
        }
        return;
    }

    if(user_op->mem.index == ZYDIS_REGISTER_NONE)
    {
        if(user_op->mem.base == ZYDIS_REGISTER_NONE)
        {
            if(match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
            {
                instruction->rm = 4;
                instruction->attributes |= ZYDIS_ATTRIB_HAS_SIB;
                instruction->base = 5;
                instruction->index = 4;
            }
            else
            {
                instruction->rm = 5;
            }
            instruction->disp_size = 32;
            return;
        }
        else if((user_op->mem.base == ZYDIS_REGISTER_RIP) ||
                (user_op->mem.base == ZYDIS_REGISTER_EIP))
        {
            instruction->rm = 5;
            instruction->disp_size = 32;
            return;
        }
    }

    const ZyanU8 reg_base_id = (ZyanU8)ZydisRegisterGetId(user_op->mem.base);
    const ZyanU8 reg_index_id = (ZyanU8)ZydisRegisterGetId(user_op->mem.index);
    instruction->disp_size = match->disp_size;
    switch(instruction->disp_size)
    {
    case 0:
        if(reg_base_id == 5 || reg_base_id == 13)
        {
            instruction->disp_size = 8;
            instruction->disp = 0;
            instruction->mod = 1;
        }
        break;
    case 8:
        instruction->mod = 1;
        break;
    case 16:
        instruction->disp_size = 32;
        ZYAN_FALLTHROUGH;
    case 32:
        instruction->mod = 2;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    if((user_op->mem.index == ZYDIS_REGISTER_NONE) &&
            (reg_base_id != 4) &&
            (reg_base_id != 12) &&
            ((match->definition->modrm & 7) != 4))
    {
        instruction->rm = reg_base_id;
        return;
    }
    instruction->rm = 4;
    instruction->attributes |= ZYDIS_ATTRIB_HAS_SIB;
    if(reg_base_id != 0xFF)
    {
        instruction->base = reg_base_id;
    }
    else
    {
        instruction->base = 5;
        instruction->mod = 0;
        instruction->disp_size = 32;
    }
    if(reg_index_id != 0xFF)
    {
        instruction->index = reg_index_id;
    }
    else
    {
        instruction->index = 4;
    }
    switch(user_op->mem.scale)
    {
    case 0:
    case 1:
        break;
    case 2:
        instruction->scale = 1;
        break;
    case 4:
        instruction->scale = 2;
        break;
    case 8:
        instruction->scale = 3;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
}

/**
 * Encodes instruction as emittable `ZydisEncoderInstruction` struct.
 *
 * @param   match       A pointer to `ZydisEncoderInstructionMatch` struct.
 * @param   instruction A pointer to `ZydisEncoderInstruction` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisBuildInstruction(ZydisEncoderInstructionMatch* match,
                                        ZydisEncoderInstruction* instruction)
{
    ZYAN_MEMSET(instruction, 0, sizeof(ZydisEncoderInstruction));
    instruction->attributes = match->attributes;
    instruction->encoding = match->definition->encoding;
    instruction->opcode_map = match->definition->opcode_map;
    instruction->opcode = match->definition->opcode;
    instruction->rex_w = match->definition->rex_w;
    instruction->mod = (match->definition->modrm >> 6) & 3;
    instruction->reg = (match->definition->modrm >> 3) & 7;
    instruction->rm = match->definition->modrm & 7;
    if(match->definition->modrm)
    {
        instruction->attributes |= ZYDIS_ATTRIB_HAS_MODRM;
    }

    switch(match->definition->vector_length)
    {
    case ZYDIS_VECTOR_LENGTH_INVALID:
    case ZYDIS_VECTOR_LENGTH_128:
        instruction->vector_length = 0;
        break;
    case ZYDIS_VECTOR_LENGTH_256:
        instruction->vector_length = 1;
        break;
    case ZYDIS_VECTOR_LENGTH_512:
        instruction->vector_length = 2;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    if(match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX)
    {
        const ZydisInstructionDefinitionEVEX* evex_def =
            (const ZydisInstructionDefinitionEVEX*)match->base_definition;
        if(evex_def->mask_override != ZYDIS_MASK_OVERRIDE_ZEROING)
        {
            instruction->zeroing = match->request->evex.zeroing_mask;
        }
        if((match->request->evex.sae) ||
                (match->request->evex.broadcast != ZYDIS_BROADCAST_MODE_INVALID))
        {
            instruction->attributes |= ZYDIS_ATTRIB_HAS_EVEX_B;
        }
        if(match->request->evex.rounding != ZYDIS_ROUNDING_MODE_INVALID)
        {
            instruction->attributes |= ZYDIS_ATTRIB_HAS_EVEX_B;
            switch(match->request->evex.rounding)
            {
            case ZYDIS_ROUNDING_MODE_RN:
                instruction->vector_length = 0;
                break;
            case ZYDIS_ROUNDING_MODE_RD:
                instruction->vector_length = 1;
                break;
            case ZYDIS_ROUNDING_MODE_RU:
                instruction->vector_length = 2;
                break;
            case ZYDIS_ROUNDING_MODE_RZ:
                instruction->vector_length = 3;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
        }
    }
    else if(match->definition->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX)
    {
        instruction->sss |= ZydisEncodeMvexBroadcastMode(match->request->mvex.broadcast);
        instruction->sss |= ZydisEncodeMvexConversionMode(match->request->mvex.conversion);

        switch(match->request->mvex.rounding)
        {
        case ZYDIS_ROUNDING_MODE_INVALID:
            break;
        case ZYDIS_ROUNDING_MODE_RN:
        case ZYDIS_ROUNDING_MODE_RD:
        case ZYDIS_ROUNDING_MODE_RU:
        case ZYDIS_ROUNDING_MODE_RZ:
            instruction->sss |= match->request->mvex.rounding - ZYDIS_ROUNDING_MODE_RN;
            break;
        default:
            ZYAN_UNREACHABLE;
        }

        switch(match->request->mvex.swizzle)
        {
        case ZYDIS_SWIZZLE_MODE_INVALID:
            break;
        case ZYDIS_SWIZZLE_MODE_DCBA:
        case ZYDIS_SWIZZLE_MODE_CDAB:
        case ZYDIS_SWIZZLE_MODE_BADC:
        case ZYDIS_SWIZZLE_MODE_DACB:
        case ZYDIS_SWIZZLE_MODE_AAAA:
        case ZYDIS_SWIZZLE_MODE_BBBB:
        case ZYDIS_SWIZZLE_MODE_CCCC:
        case ZYDIS_SWIZZLE_MODE_DDDD:
            instruction->sss |= match->request->mvex.swizzle - ZYDIS_SWIZZLE_MODE_DCBA;
            break;
        default:
            ZYAN_UNREACHABLE;
        }

        if((match->request->mvex.sae) ||
                (match->request->mvex.eviction_hint) ||
                (match->request->mvex.rounding != ZYDIS_ROUNDING_MODE_INVALID))
        {
            instruction->eviction_hint = ZYAN_TRUE;
        }
        if(match->request->mvex.sae)
        {
            instruction->sss |= 4;
        }

        // Following instructions violate general `MVEX.EH` handling rules. In all other cases this
        // bit is used either as eviction hint (memory operands present) or to encode MVEX-specific
        // functionality (register forms). Instructions listed below use `MVEX.EH` to identify
        // different instructions with memory operands and don't treat it as eviction hint.
        switch(match->request->mnemonic)
        {
        case ZYDIS_MNEMONIC_VMOVNRAPD:
        case ZYDIS_MNEMONIC_VMOVNRAPS:
            instruction->eviction_hint = ZYAN_FALSE;
            break;
        case ZYDIS_MNEMONIC_VMOVNRNGOAPD:
        case ZYDIS_MNEMONIC_VMOVNRNGOAPS:
            instruction->eviction_hint = ZYAN_TRUE;
            break;
        default:
            break;
        }
    }

    switch(match->definition->mandatory_prefix)
    {
    case ZYDIS_MANDATORY_PREFIX_NONE:
        break;
    case ZYDIS_MANDATORY_PREFIX_66:
        instruction->attributes |= ZYDIS_ATTRIB_HAS_OPERANDSIZE;
        break;
    case ZYDIS_MANDATORY_PREFIX_F2:
        instruction->attributes |= ZYDIS_ATTRIB_HAS_REPNE;
        break;
    case ZYDIS_MANDATORY_PREFIX_F3:
        instruction->attributes |= ZYDIS_ATTRIB_HAS_REP;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    const ZyanU8 mode_width = ZydisGetMachineModeWidth(match->request->machine_mode);
    if(match->easz != mode_width)
    {
        instruction->attributes |= ZYDIS_ATTRIB_HAS_ADDRESSSIZE;
    }
    if((match->request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
            (match->base_definition->operand_size_map != ZYDIS_OPSIZE_MAP_FORCE64))
    {
        switch(match->eosz)
        {
        case 16:
            instruction->attributes |= ZYDIS_ATTRIB_HAS_OPERANDSIZE;
            break;
        case 32:
            break;
        case 64:
            instruction->rex_w =
                match->base_definition->operand_size_map != ZYDIS_OPSIZE_MAP_DEFAULT64;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
    }
    else
    {
        if(match->eosz != mode_width)
        {
            instruction->attributes |= ZYDIS_ATTRIB_HAS_OPERANDSIZE;
        }
    }

    for(ZyanU8 i = 0; i < match->request->operand_count; ++i)
    {
        const ZydisEncoderOperand* user_op = &match->request->operands[i];
        const ZydisOperandDefinition* def_op = &match->operands[i];
        switch(user_op->type)
        {
        case ZYDIS_OPERAND_TYPE_REGISTER:
            ZydisBuildRegisterOperand(user_op, def_op, instruction);
            break;
        case ZYDIS_OPERAND_TYPE_MEMORY:
            if(def_op->type != ZYDIS_SEMANTIC_OPTYPE_MOFFS)
            {
                ZydisBuildMemoryOperand(match, user_op, instruction);
                if((match->cd8_scale) &&
                        (instruction->disp_size == 8))
                {
                    instruction->disp >>= match->cd8_scale;
                }
            }
            else
            {
                instruction->disp_size = match->disp_size;
                instruction->disp = (ZyanU64)user_op->mem.displacement;
            }
            break;
        case ZYDIS_OPERAND_TYPE_POINTER:
            instruction->disp_size = match->disp_size;
            instruction->disp = user_op->ptr.offset;
            instruction->imm_size = match->imm_size;
            instruction->imm = user_op->ptr.segment;
            break;
        case ZYDIS_OPERAND_TYPE_IMMEDIATE:
            if(def_op->type == ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_IMM1)
            {
                break;
            }
            if(def_op->op.encoding != ZYDIS_OPERAND_ENCODING_IS4)
            {
                if(instruction->imm_size)
                {
                    ZYAN_ASSERT(instruction->disp_size == 0);
                    instruction->disp_size = match->disp_size;
                    instruction->disp = instruction->imm;
                }
                instruction->imm_size = match->imm_size;
                instruction->imm = user_op->imm.u;
            }
            else
            {
                ZYAN_ASSERT(instruction->imm_size == 8);
                instruction->imm |= user_op->imm.u;
            }
            break;
        default:
            ZYAN_UNREACHABLE;
        }
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Performs a set of sanity checks that must be satisfied for every valid encoder request.
 *
 * @param   request A pointer to `ZydisEncoderRequest` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEncoderCheckRequestSanity(const ZydisEncoderRequest* request)
{
    if(((ZyanUSize)request->machine_mode > ZYDIS_MACHINE_MODE_MAX_VALUE) ||
            ((ZyanUSize)request->allowed_encodings > ZYDIS_ENCODABLE_ENCODING_MAX_VALUE) ||
            ((ZyanUSize)request->mnemonic > ZYDIS_MNEMONIC_MAX_VALUE) ||
            ((ZyanUSize)request->branch_type > ZYDIS_BRANCH_TYPE_MAX_VALUE) ||
            ((ZyanUSize)request->branch_width > ZYDIS_BRANCH_WIDTH_MAX_VALUE) ||
            ((ZyanUSize)request->address_size_hint > ZYDIS_ADDRESS_SIZE_HINT_MAX_VALUE) ||
            ((ZyanUSize)request->operand_size_hint > ZYDIS_OPERAND_SIZE_HINT_MAX_VALUE) ||
            ((ZyanUSize)request->evex.broadcast > ZYDIS_BROADCAST_MODE_MAX_VALUE) ||
            ((ZyanUSize)request->evex.rounding > ZYDIS_ROUNDING_MODE_MAX_VALUE) ||
            ((ZyanUSize)request->mvex.broadcast > ZYDIS_BROADCAST_MODE_MAX_VALUE) ||
            ((ZyanUSize)request->mvex.conversion > ZYDIS_CONVERSION_MODE_MAX_VALUE) ||
            ((ZyanUSize)request->mvex.rounding > ZYDIS_ROUNDING_MODE_MAX_VALUE) ||
            ((ZyanUSize)request->mvex.swizzle > ZYDIS_SWIZZLE_MODE_MAX_VALUE) ||
            (request->operand_count > ZYDIS_ENCODER_MAX_OPERANDS) ||
            (request->mnemonic == ZYDIS_MNEMONIC_INVALID) ||
            (request->prefixes & ~ZYDIS_ENCODABLE_PREFIXES))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT)
    {
        if((request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
                (request->prefixes & ZYDIS_LEGACY_SEGMENTS))
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }

        ZyanU8 seg_override_count = 0;
        if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT_CS)
        {
            ++seg_override_count;
        }
        if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT_SS)
        {
            ++seg_override_count;
        }
        if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT_DS)
        {
            ++seg_override_count;
        }
        if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT_ES)
        {
            ++seg_override_count;
        }
        if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT_FS)
        {
            ++seg_override_count;
        }
        if(request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT_GS)
        {
            ++seg_override_count;
        }
        if(seg_override_count != 1)
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }
    ZyanU8 rep_family_count = 0;
    if(request->prefixes & ZYDIS_ATTRIB_HAS_REP)
    {
        ++rep_family_count;
    }
    if(request->prefixes & ZYDIS_ATTRIB_HAS_REPE)
    {
        ++rep_family_count;
    }
    if(request->prefixes & ZYDIS_ATTRIB_HAS_REPNE)
    {
        ++rep_family_count;
    }
    if(rep_family_count > 1)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    if((request->prefixes & ZYDIS_ATTRIB_HAS_XACQUIRE) &&
            (request->prefixes & ZYDIS_ATTRIB_HAS_XRELEASE))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    if((request->prefixes & ZYDIS_ATTRIB_HAS_BRANCH_NOT_TAKEN) &&
            (request->prefixes & ZYDIS_ATTRIB_HAS_BRANCH_TAKEN))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    if((request->prefixes & ZYDIS_ATTRIB_HAS_NOTRACK) &&
            (request->prefixes & ZYDIS_ATTRIB_HAS_SEGMENT))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    static const ZyanBool branch_lookup
    [ZYDIS_BRANCH_WIDTH_MAX_VALUE + 1][ZYDIS_BRANCH_TYPE_MAX_VALUE + 1] =
    {
        /* NONE */ { ZYAN_TRUE,  ZYAN_TRUE,  ZYAN_TRUE,  ZYAN_TRUE  },
        /* 8    */ { ZYAN_TRUE,  ZYAN_TRUE,  ZYAN_FALSE, ZYAN_FALSE },
        /* 16   */ { ZYAN_TRUE,  ZYAN_FALSE, ZYAN_TRUE,  ZYAN_TRUE  },
        /* 32   */ { ZYAN_TRUE,  ZYAN_FALSE, ZYAN_TRUE,  ZYAN_TRUE  },
        /* 64   */ { ZYAN_TRUE,  ZYAN_FALSE, ZYAN_TRUE,  ZYAN_TRUE  },
    };
    if(!branch_lookup[request->branch_width][request->branch_type])
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if(request->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
    {
        if(request->address_size_hint == ZYDIS_ADDRESS_SIZE_HINT_16)
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }
    else
    {
        if((request->branch_width == ZYDIS_BRANCH_WIDTH_64) ||
                (request->address_size_hint == ZYDIS_ADDRESS_SIZE_HINT_64) ||
                (request->operand_size_hint == ZYDIS_OPERAND_SIZE_HINT_64))
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }

    for(ZyanU8 i = 0; i < request->operand_count; ++i)
    {
        const ZydisEncoderOperand* op = &request->operands[i];
        if((op->type == ZYDIS_OPERAND_TYPE_UNUSED) ||
                ((ZyanUSize)op->type > ZYDIS_OPERAND_TYPE_MAX_VALUE))
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }

        switch(op->type)
        {
        case ZYDIS_OPERAND_TYPE_REGISTER:
            if(op->reg.value > ZYDIS_REGISTER_MAX_VALUE)
            {
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
            break;
        case ZYDIS_OPERAND_TYPE_MEMORY:
            if(((ZyanUSize)op->mem.base > ZYDIS_REGISTER_MAX_VALUE) ||
                    ((ZyanUSize)op->mem.index > ZYDIS_REGISTER_MAX_VALUE) ||
                    !ZydisIsScaleValid(op->mem.scale))
            {
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
            break;
        case ZYDIS_OPERAND_TYPE_POINTER:
        case ZYDIS_OPERAND_TYPE_IMMEDIATE:
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Encodes instruction with semantics specified in encoder request structure.
 *
 * @param   request     A pointer to the `ZydisEncoderRequest` struct. Must be validated before
 *                      calling this function.
 * @param   buffer      A pointer to the output buffer receiving encoded instruction.
 * @param   length      A pointer to the variable containing length of the output buffer. Upon
 *                      successful return this variable receives length of the encoded instruction.
 * @param   instruction Internal state of the encoder.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisEncoderEncodeInstructionInternal(const ZydisEncoderRequest* request,
        void* buffer, ZyanUSize* length, ZydisEncoderInstruction* instruction)
{
    ZydisEncoderInstructionMatch match;
    ZYAN_CHECK(ZydisFindMatchingDefinition(request, &match));
    ZydisEncoderBuffer output;
    output.buffer = (ZyanU8*)buffer;
    output.size = *length;
    output.offset = 0;
    ZYAN_CHECK(ZydisBuildInstruction(&match, instruction));
    ZYAN_CHECK(ZydisEmitInstruction(instruction, &output));
    *length = output.offset;
    return ZYAN_STATUS_SUCCESS;
}

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

ZYDIS_EXPORT ZyanStatus ZydisEncoderEncodeInstruction(const ZydisEncoderRequest* request,
        void* buffer, ZyanUSize* length)
{
    if(!request || !buffer || !length)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    ZYAN_CHECK(ZydisEncoderCheckRequestSanity(request));

    ZydisEncoderInstruction instruction;
    return ZydisEncoderEncodeInstructionInternal(request, buffer, length, &instruction);
}

ZYDIS_EXPORT ZyanStatus ZydisEncoderEncodeInstructionAbsolute(ZydisEncoderRequest* request,
        void* buffer, ZyanUSize* length, ZyanU64 runtime_address)
{
    if(!request || !buffer || !length)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    ZYAN_CHECK(ZydisEncoderCheckRequestSanity(request));

    const ZydisEncoderRelInfo* rel_info = ZydisGetRelInfo(request->mnemonic);
    ZydisEncoderOperand* op_rip_rel = ZYAN_NULL;
    ZyanBool adjusted_rel = ZYAN_FALSE;
    ZyanU64 absolute_address = 0;
    ZyanU8 mode_index = ZydisGetMachineModeWidth(request->machine_mode) >> 5;
    for(ZyanU8 i = 0; i < request->operand_count; ++i)
    {
        ZydisEncoderOperand* op = &request->operands[i];
        if((op->type == ZYDIS_OPERAND_TYPE_IMMEDIATE) && rel_info)
        {
            if(adjusted_rel)
            {
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }

            switch(rel_info->accepts_scaling_hints)
            {
            case ZYDIS_SIZE_HINT_NONE:
            case ZYDIS_SIZE_HINT_OSZ:
            {
                static const ZyanI8 asz_priority[3][3] =
                {
                    { 0, 1, 2 },
                    { 0, 2, 1 },
                    { 0, 2, -1 },
                };
                static const ZyanI8 osz_priority[3][3] =
                {
                    { 0, 1, 2 },
                    { 0, 2, 1 },
                    { 0, 2, 1 },
                };
                ZyanI8 forced_priority_row[3] = { -1, -1, -1 };
                ZyanI8* priority_row = ZYAN_NULL;
                ZyanU8 extra_length = 0;
                ZyanU8 start_offset = 0;
                if(rel_info->accepts_scaling_hints == ZYDIS_SIZE_HINT_NONE)
                {
                    if((request->branch_type == ZYDIS_BRANCH_TYPE_FAR) ||
                            (request->branch_width == ZYDIS_BRANCH_WIDTH_64))
                    {
                        return ZYAN_STATUS_INVALID_ARGUMENT;
                    }
                    if((rel_info->accepts_branch_hints) &&
                            (request->prefixes & (ZYDIS_ATTRIB_HAS_BRANCH_NOT_TAKEN |
                                                  ZYDIS_ATTRIB_HAS_BRANCH_TAKEN)))
                    {
                        extra_length = 1;
                    }
                    if(request->branch_width == ZYDIS_BRANCH_WIDTH_NONE)
                    {
                        if(request->branch_type == ZYDIS_BRANCH_TYPE_NEAR)
                        {
                            start_offset = 1;
                        }
                        priority_row = (ZyanI8*)&asz_priority[mode_index];
                    }
                    else
                    {
                        forced_priority_row[0] = (ZyanI8)(request->branch_width - 1);
                        priority_row = (ZyanI8*)&forced_priority_row;
                    }
                }
                else
                {
                    if(request->operand_size_hint == ZYDIS_OPERAND_SIZE_HINT_NONE)
                    {
                        priority_row = (ZyanI8*)&osz_priority[mode_index];
                    }
                    else
                    {
                        if(request->operand_size_hint == ZYDIS_OPERAND_SIZE_HINT_64)
                        {
                            extra_length = 1;
                            forced_priority_row[0] = 2;
                        }
                        else
                        {
                            forced_priority_row[0] = (ZyanI8)(request->operand_size_hint - 1);
                        }
                        priority_row = (ZyanI8*)&forced_priority_row;
                    }
                }
                ZYAN_ASSERT(ZYAN_ARRAY_LENGTH(asz_priority[0]) ==
                            ZYAN_ARRAY_LENGTH(osz_priority[0]));
                for(ZyanU8 j = start_offset; j < ZYAN_ARRAY_LENGTH(asz_priority[0]); ++j)
                {
                    ZyanI8 size_index = priority_row[j];
                    if(size_index < 0)
                    {
                        break;
                    }
                    ZyanU8 base_size = rel_info->size[mode_index][size_index];
                    if(base_size == 0)
                    {
                        continue;
                    }
                    ZyanU8 predicted_size = base_size + extra_length;
                    if(runtime_address > ZYAN_UINT64_MAX - predicted_size + 1)
                    {
                        continue;
                    }
                    ZyanI64 rel = (ZyanI64)(op->imm.u - (runtime_address + predicted_size));
                    ZyanU8 rel_size = ZydisGetSignedImmSize(rel);
                    if(rel_size > (8 << size_index))
                    {
                        continue;
                    }
                    op->imm.s = rel;
                    adjusted_rel = ZYAN_TRUE;
                    break;
                }
                break;
            }
            case ZYDIS_SIZE_HINT_ASZ:
            {
                static const ZyanI8 asz_prefix_lookup[3][ZYDIS_ADDRESS_SIZE_HINT_MAX_VALUE + 1] =
                {
                    { 0, 0, 1, -1 },
                    { 0, 1, 0, -1 },
                    { 0, -1, 1, 0 },
                };
                ZyanI8 extra_length = asz_prefix_lookup[mode_index][request->address_size_hint];
                if(extra_length < 0)
                {
                    return ZYAN_STATUS_INVALID_ARGUMENT;
                }
                ZyanU8 asz_index = (request->address_size_hint == ZYDIS_ADDRESS_SIZE_HINT_NONE)
                                   ? mode_index
                                   : ZydisGetAszFromHint(request->address_size_hint) >> 5;
                ZYAN_ASSERT((rel_info->size[asz_index][0] != 0) &&
                            (rel_info->size[asz_index][1] == 0) &&
                            (rel_info->size[asz_index][2] == 0) &&
                            !rel_info->accepts_branch_hints);
                ZyanU8 predicted_size = rel_info->size[asz_index][0] + extra_length;
                if(runtime_address > ZYAN_UINT64_MAX - predicted_size + 1)
                {
                    return ZYAN_STATUS_INVALID_ARGUMENT;
                }
                ZyanI64 rel = (ZyanI64)(op->imm.u - (runtime_address + predicted_size));
                ZyanU8 rel_size = ZydisGetSignedImmSize(rel);
                if(rel_size > 8)
                {
                    return ZYAN_STATUS_INVALID_ARGUMENT;
                }
                op->imm.s = rel;
                adjusted_rel = ZYAN_TRUE;
                break;
            }
            default:
                ZYAN_UNREACHABLE;
            }
            if(!adjusted_rel)
            {
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
        }
        else if((op->type == ZYDIS_OPERAND_TYPE_MEMORY) &&
                ((op->mem.base == ZYDIS_REGISTER_EIP) ||
                 (op->mem.base == ZYDIS_REGISTER_RIP)))
        {
            if(op_rip_rel)
            {
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }

            absolute_address = op->mem.displacement;
            op->mem.displacement = 0;
            op_rip_rel = op;
        }
    }

    ZydisEncoderInstruction instruction;
    ZYAN_CHECK(ZydisEncoderEncodeInstructionInternal(request, buffer, length, &instruction));
    if(op_rip_rel)
    {
        ZyanUSize instruction_size = *length;
        if(runtime_address > ZYAN_UINT64_MAX - instruction_size + 1)
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
        ZyanI64 rip_rel = (ZyanI64)(absolute_address - (runtime_address + instruction_size));
        if(ZydisGetSignedImmSize(rip_rel) > 32)
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
        ZYAN_ASSERT(instruction.disp_size != 0);
        ZyanU8 disp_offset = (instruction.disp_size >> 3) + (instruction.imm_size >> 3);
        ZYAN_ASSERT(instruction_size > disp_offset);
        ZYAN_MEMCPY((ZyanU8*)buffer + instruction_size - disp_offset, &rip_rel, sizeof(ZyanI32));
        op_rip_rel->mem.displacement = rip_rel;
    }

    return ZYAN_STATUS_SUCCESS;
}

ZYDIS_EXPORT ZyanStatus ZydisEncoderDecodedInstructionToEncoderRequest(
    const ZydisDecodedInstruction* instruction, const ZydisDecodedOperand* operands,
    ZyanU8 operand_count, ZydisEncoderRequest* request)
{
    if(!instruction || !request || (operand_count && !operands))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    ZYAN_MEMSET(request, 0, sizeof(ZydisEncoderRequest));
    request->machine_mode = instruction->machine_mode;
    request->mnemonic = instruction->mnemonic;
    request->prefixes = instruction->attributes & ZYDIS_ENCODABLE_PREFIXES;
    request->branch_type = instruction->meta.branch_type;
    if(!(instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_SEGMENT))
    {
        request->prefixes &= ~ZYDIS_ATTRIB_HAS_SEGMENT;
    }

    switch(instruction->address_width)
    {
    case 16:
        request->address_size_hint = ZYDIS_ADDRESS_SIZE_HINT_16;
        break;
    case 32:
        request->address_size_hint = ZYDIS_ADDRESS_SIZE_HINT_32;
        break;
    case 64:
        request->address_size_hint = ZYDIS_ADDRESS_SIZE_HINT_64;
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    switch(instruction->operand_width)
    {
    case 8:
        request->operand_size_hint = ZYDIS_OPERAND_SIZE_HINT_8;
        break;
    case 16:
        request->operand_size_hint = ZYDIS_OPERAND_SIZE_HINT_16;
        break;
    case 32:
        request->operand_size_hint = ZYDIS_OPERAND_SIZE_HINT_32;
        break;
    case 64:
        request->operand_size_hint = ZYDIS_OPERAND_SIZE_HINT_64;
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    switch(request->branch_type)
    {
    case ZYDIS_BRANCH_TYPE_NONE:
        request->branch_width = ZYDIS_BRANCH_WIDTH_NONE;
        break;
    case ZYDIS_BRANCH_TYPE_SHORT:
        request->branch_width = ZYDIS_BRANCH_WIDTH_8;
        break;
    case ZYDIS_BRANCH_TYPE_NEAR:
    case ZYDIS_BRANCH_TYPE_FAR:
        switch(instruction->operand_width)
        {
        case 16:
            request->branch_width = ZYDIS_BRANCH_WIDTH_16;
            break;
        case 32:
            request->branch_width = ZYDIS_BRANCH_WIDTH_32;
            break;
        case 64:
            request->branch_width = ZYDIS_BRANCH_WIDTH_64;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    switch(instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
    case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        break;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        request->evex.broadcast = !instruction->avx.broadcast.is_static ?
                                  instruction->avx.broadcast.mode : ZYDIS_BROADCAST_MODE_INVALID;
        request->evex.rounding = instruction->avx.rounding.mode;
        request->evex.sae = instruction->avx.has_sae;
        request->evex.zeroing_mask = (instruction->avx.mask.mode == ZYDIS_MASK_MODE_ZEROING ||
                                      instruction->avx.mask.mode == ZYDIS_MASK_MODE_CONTROL_ZEROING) &&
                                     (instruction->raw.evex.z) ? ZYAN_TRUE : ZYAN_FALSE;
        break;
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        request->mvex.broadcast = !instruction->avx.broadcast.is_static ?
                                  instruction->avx.broadcast.mode : ZYDIS_BROADCAST_MODE_INVALID;
        request->mvex.conversion = instruction->avx.conversion.mode;
        request->mvex.rounding = instruction->avx.rounding.mode;
        request->mvex.swizzle = instruction->avx.swizzle.mode;
        request->mvex.sae = instruction->avx.has_sae;
        request->mvex.eviction_hint = instruction->avx.has_eviction_hint;
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    request->allowed_encodings = 1 << instruction->encoding;

    if((operand_count > ZYDIS_ENCODER_MAX_OPERANDS) ||
            (operand_count > instruction->operand_count_visible))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    request->operand_count = operand_count;
    for(ZyanU8 i = 0; i < operand_count; ++i)
    {
        const ZydisDecodedOperand* dec_op = &operands[i];
        ZydisEncoderOperand* enc_op = &request->operands[i];

        enc_op->type = dec_op->type;
        switch(dec_op->type)
        {
        case ZYDIS_OPERAND_TYPE_REGISTER:
            enc_op->reg.value = dec_op->reg.value;
            enc_op->reg.is4 = dec_op->encoding == ZYDIS_OPERAND_ENCODING_IS4;
            break;
        case ZYDIS_OPERAND_TYPE_MEMORY:
            enc_op->mem.base = dec_op->mem.base;
            enc_op->mem.index = dec_op->mem.index;
            enc_op->mem.scale = dec_op->mem.type != ZYDIS_MEMOP_TYPE_MIB ? dec_op->mem.scale : 0;
            if(dec_op->encoding == ZYDIS_OPERAND_ENCODING_DISP16_32_64)
            {
                ZydisCalcAbsoluteAddress(instruction, dec_op, 0,
                                         (ZyanU64*)&enc_op->mem.displacement);
            }
            else
            {
                enc_op->mem.displacement = dec_op->mem.disp.has_displacement ?
                                           dec_op->mem.disp.value : 0;
            }
            enc_op->mem.size = dec_op->size / 8;
            break;
        case ZYDIS_OPERAND_TYPE_POINTER:
            enc_op->ptr.segment = dec_op->ptr.segment;
            enc_op->ptr.offset = dec_op->ptr.offset;
            break;
        case ZYDIS_OPERAND_TYPE_IMMEDIATE:
            enc_op->imm.u = dec_op->imm.value.u;
            // `XBEGIN` is an ISA-wide unique instruction because it's not a branching instruction
            // but it has a relative operand which behaves differently from all other relatives
            // (no truncating behavior in 16-bit mode). Encoder treats it as non-branching
            // instruction that scales with hidden operand size.
            if((dec_op->imm.is_relative) &&
                    (instruction->mnemonic != ZYDIS_MNEMONIC_XBEGIN))
            {
                switch(instruction->raw.imm->size)
                {
                case 8:
                    request->branch_width = ZYDIS_BRANCH_WIDTH_8;
                    break;
                case 16:
                    request->branch_width = ZYDIS_BRANCH_WIDTH_16;
                    break;
                case 32:
                    request->branch_width = ZYDIS_BRANCH_WIDTH_32;
                    break;
                default:
                    return ZYAN_STATUS_INVALID_ARGUMENT;
                }
            }
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }

    return ZYAN_STATUS_SUCCESS;
}

ZYDIS_EXPORT ZyanStatus ZydisEncoderNopFill(void* buffer, ZyanUSize length)
{
    if(!buffer)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    // Intel SDM Vol. 2B "Recommended Multi-Byte Sequence of NOP Instruction"
    static const ZyanU8 nops[9][9] =
    {
        { 0x90 },
        { 0x66, 0x90 },
        { 0x0F, 0x1F, 0x00 },
        { 0x0F, 0x1F, 0x40, 0x00 },
        { 0x0F, 0x1F, 0x44, 0x00, 0x00 },
        { 0x66, 0x0F, 0x1F, 0x44, 0x00, 0x00 },
        { 0x0F, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00 },
        { 0x0F, 0x1F, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00 },
        { 0x66, 0x0F, 0x1F, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00 },
    };

    ZyanU8* output = (ZyanU8*)buffer;
    while(length)
    {
        ZyanUSize nop_size = (length > 9) ? 9 : length;
        ZYAN_MEMCPY(output, nops[nop_size - 1], nop_size);
        output += nop_size;
        length -= nop_size;
    }

    return ZYAN_STATUS_SUCCESS;
}

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/Register.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


/* ============================================================================================== */
/* Register strings                                                                               */
/* ============================================================================================== */


//
// Header: Generated/EnumRegister.inc
//

static const ZydisShortString STR_REGISTERS[] =
{
    ZYDIS_MAKE_SHORTSTRING("none"),
    // General purpose registers  8-bit
    ZYDIS_MAKE_SHORTSTRING("al"),
    ZYDIS_MAKE_SHORTSTRING("cl"),
    ZYDIS_MAKE_SHORTSTRING("dl"),
    ZYDIS_MAKE_SHORTSTRING("bl"),
    ZYDIS_MAKE_SHORTSTRING("ah"),
    ZYDIS_MAKE_SHORTSTRING("ch"),
    ZYDIS_MAKE_SHORTSTRING("dh"),
    ZYDIS_MAKE_SHORTSTRING("bh"),
    ZYDIS_MAKE_SHORTSTRING("spl"),
    ZYDIS_MAKE_SHORTSTRING("bpl"),
    ZYDIS_MAKE_SHORTSTRING("sil"),
    ZYDIS_MAKE_SHORTSTRING("dil"),
    ZYDIS_MAKE_SHORTSTRING("r8b"),
    ZYDIS_MAKE_SHORTSTRING("r9b"),
    ZYDIS_MAKE_SHORTSTRING("r10b"),
    ZYDIS_MAKE_SHORTSTRING("r11b"),
    ZYDIS_MAKE_SHORTSTRING("r12b"),
    ZYDIS_MAKE_SHORTSTRING("r13b"),
    ZYDIS_MAKE_SHORTSTRING("r14b"),
    ZYDIS_MAKE_SHORTSTRING("r15b"),
    // General purpose registers 16-bit
    ZYDIS_MAKE_SHORTSTRING("ax"),
    ZYDIS_MAKE_SHORTSTRING("cx"),
    ZYDIS_MAKE_SHORTSTRING("dx"),
    ZYDIS_MAKE_SHORTSTRING("bx"),
    ZYDIS_MAKE_SHORTSTRING("sp"),
    ZYDIS_MAKE_SHORTSTRING("bp"),
    ZYDIS_MAKE_SHORTSTRING("si"),
    ZYDIS_MAKE_SHORTSTRING("di"),
    ZYDIS_MAKE_SHORTSTRING("r8w"),
    ZYDIS_MAKE_SHORTSTRING("r9w"),
    ZYDIS_MAKE_SHORTSTRING("r10w"),
    ZYDIS_MAKE_SHORTSTRING("r11w"),
    ZYDIS_MAKE_SHORTSTRING("r12w"),
    ZYDIS_MAKE_SHORTSTRING("r13w"),
    ZYDIS_MAKE_SHORTSTRING("r14w"),
    ZYDIS_MAKE_SHORTSTRING("r15w"),
    // General purpose registers 32-bit
    ZYDIS_MAKE_SHORTSTRING("eax"),
    ZYDIS_MAKE_SHORTSTRING("ecx"),
    ZYDIS_MAKE_SHORTSTRING("edx"),
    ZYDIS_MAKE_SHORTSTRING("ebx"),
    ZYDIS_MAKE_SHORTSTRING("esp"),
    ZYDIS_MAKE_SHORTSTRING("ebp"),
    ZYDIS_MAKE_SHORTSTRING("esi"),
    ZYDIS_MAKE_SHORTSTRING("edi"),
    ZYDIS_MAKE_SHORTSTRING("r8d"),
    ZYDIS_MAKE_SHORTSTRING("r9d"),
    ZYDIS_MAKE_SHORTSTRING("r10d"),
    ZYDIS_MAKE_SHORTSTRING("r11d"),
    ZYDIS_MAKE_SHORTSTRING("r12d"),
    ZYDIS_MAKE_SHORTSTRING("r13d"),
    ZYDIS_MAKE_SHORTSTRING("r14d"),
    ZYDIS_MAKE_SHORTSTRING("r15d"),
    // General purpose registers 64-bit
    ZYDIS_MAKE_SHORTSTRING("rax"),
    ZYDIS_MAKE_SHORTSTRING("rcx"),
    ZYDIS_MAKE_SHORTSTRING("rdx"),
    ZYDIS_MAKE_SHORTSTRING("rbx"),
    ZYDIS_MAKE_SHORTSTRING("rsp"),
    ZYDIS_MAKE_SHORTSTRING("rbp"),
    ZYDIS_MAKE_SHORTSTRING("rsi"),
    ZYDIS_MAKE_SHORTSTRING("rdi"),
    ZYDIS_MAKE_SHORTSTRING("r8"),
    ZYDIS_MAKE_SHORTSTRING("r9"),
    ZYDIS_MAKE_SHORTSTRING("r10"),
    ZYDIS_MAKE_SHORTSTRING("r11"),
    ZYDIS_MAKE_SHORTSTRING("r12"),
    ZYDIS_MAKE_SHORTSTRING("r13"),
    ZYDIS_MAKE_SHORTSTRING("r14"),
    ZYDIS_MAKE_SHORTSTRING("r15"),
    // Floating point legacy registers
    ZYDIS_MAKE_SHORTSTRING("st0"),
    ZYDIS_MAKE_SHORTSTRING("st1"),
    ZYDIS_MAKE_SHORTSTRING("st2"),
    ZYDIS_MAKE_SHORTSTRING("st3"),
    ZYDIS_MAKE_SHORTSTRING("st4"),
    ZYDIS_MAKE_SHORTSTRING("st5"),
    ZYDIS_MAKE_SHORTSTRING("st6"),
    ZYDIS_MAKE_SHORTSTRING("st7"),
    ZYDIS_MAKE_SHORTSTRING("x87control"),
    ZYDIS_MAKE_SHORTSTRING("x87status"),
    ZYDIS_MAKE_SHORTSTRING("x87tag"),
    // Floating point multimedia registers
    ZYDIS_MAKE_SHORTSTRING("mm0"),
    ZYDIS_MAKE_SHORTSTRING("mm1"),
    ZYDIS_MAKE_SHORTSTRING("mm2"),
    ZYDIS_MAKE_SHORTSTRING("mm3"),
    ZYDIS_MAKE_SHORTSTRING("mm4"),
    ZYDIS_MAKE_SHORTSTRING("mm5"),
    ZYDIS_MAKE_SHORTSTRING("mm6"),
    ZYDIS_MAKE_SHORTSTRING("mm7"),
    // Floating point vector registers 128-bit
    ZYDIS_MAKE_SHORTSTRING("xmm0"),
    ZYDIS_MAKE_SHORTSTRING("xmm1"),
    ZYDIS_MAKE_SHORTSTRING("xmm2"),
    ZYDIS_MAKE_SHORTSTRING("xmm3"),
    ZYDIS_MAKE_SHORTSTRING("xmm4"),
    ZYDIS_MAKE_SHORTSTRING("xmm5"),
    ZYDIS_MAKE_SHORTSTRING("xmm6"),
    ZYDIS_MAKE_SHORTSTRING("xmm7"),
    ZYDIS_MAKE_SHORTSTRING("xmm8"),
    ZYDIS_MAKE_SHORTSTRING("xmm9"),
    ZYDIS_MAKE_SHORTSTRING("xmm10"),
    ZYDIS_MAKE_SHORTSTRING("xmm11"),
    ZYDIS_MAKE_SHORTSTRING("xmm12"),
    ZYDIS_MAKE_SHORTSTRING("xmm13"),
    ZYDIS_MAKE_SHORTSTRING("xmm14"),
    ZYDIS_MAKE_SHORTSTRING("xmm15"),
    ZYDIS_MAKE_SHORTSTRING("xmm16"),
    ZYDIS_MAKE_SHORTSTRING("xmm17"),
    ZYDIS_MAKE_SHORTSTRING("xmm18"),
    ZYDIS_MAKE_SHORTSTRING("xmm19"),
    ZYDIS_MAKE_SHORTSTRING("xmm20"),
    ZYDIS_MAKE_SHORTSTRING("xmm21"),
    ZYDIS_MAKE_SHORTSTRING("xmm22"),
    ZYDIS_MAKE_SHORTSTRING("xmm23"),
    ZYDIS_MAKE_SHORTSTRING("xmm24"),
    ZYDIS_MAKE_SHORTSTRING("xmm25"),
    ZYDIS_MAKE_SHORTSTRING("xmm26"),
    ZYDIS_MAKE_SHORTSTRING("xmm27"),
    ZYDIS_MAKE_SHORTSTRING("xmm28"),
    ZYDIS_MAKE_SHORTSTRING("xmm29"),
    ZYDIS_MAKE_SHORTSTRING("xmm30"),
    ZYDIS_MAKE_SHORTSTRING("xmm31"),
    // Floating point vector registers 256-bit
    ZYDIS_MAKE_SHORTSTRING("ymm0"),
    ZYDIS_MAKE_SHORTSTRING("ymm1"),
    ZYDIS_MAKE_SHORTSTRING("ymm2"),
    ZYDIS_MAKE_SHORTSTRING("ymm3"),
    ZYDIS_MAKE_SHORTSTRING("ymm4"),
    ZYDIS_MAKE_SHORTSTRING("ymm5"),
    ZYDIS_MAKE_SHORTSTRING("ymm6"),
    ZYDIS_MAKE_SHORTSTRING("ymm7"),
    ZYDIS_MAKE_SHORTSTRING("ymm8"),
    ZYDIS_MAKE_SHORTSTRING("ymm9"),
    ZYDIS_MAKE_SHORTSTRING("ymm10"),
    ZYDIS_MAKE_SHORTSTRING("ymm11"),
    ZYDIS_MAKE_SHORTSTRING("ymm12"),
    ZYDIS_MAKE_SHORTSTRING("ymm13"),
    ZYDIS_MAKE_SHORTSTRING("ymm14"),
    ZYDIS_MAKE_SHORTSTRING("ymm15"),
    ZYDIS_MAKE_SHORTSTRING("ymm16"),
    ZYDIS_MAKE_SHORTSTRING("ymm17"),
    ZYDIS_MAKE_SHORTSTRING("ymm18"),
    ZYDIS_MAKE_SHORTSTRING("ymm19"),
    ZYDIS_MAKE_SHORTSTRING("ymm20"),
    ZYDIS_MAKE_SHORTSTRING("ymm21"),
    ZYDIS_MAKE_SHORTSTRING("ymm22"),
    ZYDIS_MAKE_SHORTSTRING("ymm23"),
    ZYDIS_MAKE_SHORTSTRING("ymm24"),
    ZYDIS_MAKE_SHORTSTRING("ymm25"),
    ZYDIS_MAKE_SHORTSTRING("ymm26"),
    ZYDIS_MAKE_SHORTSTRING("ymm27"),
    ZYDIS_MAKE_SHORTSTRING("ymm28"),
    ZYDIS_MAKE_SHORTSTRING("ymm29"),
    ZYDIS_MAKE_SHORTSTRING("ymm30"),
    ZYDIS_MAKE_SHORTSTRING("ymm31"),
    // Floating point vector registers 512-bit
    ZYDIS_MAKE_SHORTSTRING("zmm0"),
    ZYDIS_MAKE_SHORTSTRING("zmm1"),
    ZYDIS_MAKE_SHORTSTRING("zmm2"),
    ZYDIS_MAKE_SHORTSTRING("zmm3"),
    ZYDIS_MAKE_SHORTSTRING("zmm4"),
    ZYDIS_MAKE_SHORTSTRING("zmm5"),
    ZYDIS_MAKE_SHORTSTRING("zmm6"),
    ZYDIS_MAKE_SHORTSTRING("zmm7"),
    ZYDIS_MAKE_SHORTSTRING("zmm8"),
    ZYDIS_MAKE_SHORTSTRING("zmm9"),
    ZYDIS_MAKE_SHORTSTRING("zmm10"),
    ZYDIS_MAKE_SHORTSTRING("zmm11"),
    ZYDIS_MAKE_SHORTSTRING("zmm12"),
    ZYDIS_MAKE_SHORTSTRING("zmm13"),
    ZYDIS_MAKE_SHORTSTRING("zmm14"),
    ZYDIS_MAKE_SHORTSTRING("zmm15"),
    ZYDIS_MAKE_SHORTSTRING("zmm16"),
    ZYDIS_MAKE_SHORTSTRING("zmm17"),
    ZYDIS_MAKE_SHORTSTRING("zmm18"),
    ZYDIS_MAKE_SHORTSTRING("zmm19"),
    ZYDIS_MAKE_SHORTSTRING("zmm20"),
    ZYDIS_MAKE_SHORTSTRING("zmm21"),
    ZYDIS_MAKE_SHORTSTRING("zmm22"),
    ZYDIS_MAKE_SHORTSTRING("zmm23"),
    ZYDIS_MAKE_SHORTSTRING("zmm24"),
    ZYDIS_MAKE_SHORTSTRING("zmm25"),
    ZYDIS_MAKE_SHORTSTRING("zmm26"),
    ZYDIS_MAKE_SHORTSTRING("zmm27"),
    ZYDIS_MAKE_SHORTSTRING("zmm28"),
    ZYDIS_MAKE_SHORTSTRING("zmm29"),
    ZYDIS_MAKE_SHORTSTRING("zmm30"),
    ZYDIS_MAKE_SHORTSTRING("zmm31"),
    // Matrix registers
    ZYDIS_MAKE_SHORTSTRING("tmm0"),
    ZYDIS_MAKE_SHORTSTRING("tmm1"),
    ZYDIS_MAKE_SHORTSTRING("tmm2"),
    ZYDIS_MAKE_SHORTSTRING("tmm3"),
    ZYDIS_MAKE_SHORTSTRING("tmm4"),
    ZYDIS_MAKE_SHORTSTRING("tmm5"),
    ZYDIS_MAKE_SHORTSTRING("tmm6"),
    ZYDIS_MAKE_SHORTSTRING("tmm7"),
    // Flags registers
    ZYDIS_MAKE_SHORTSTRING("flags"),
    ZYDIS_MAKE_SHORTSTRING("eflags"),
    ZYDIS_MAKE_SHORTSTRING("rflags"),
    // Instruction-pointer registers
    ZYDIS_MAKE_SHORTSTRING("ip"),
    ZYDIS_MAKE_SHORTSTRING("eip"),
    ZYDIS_MAKE_SHORTSTRING("rip"),
    // Segment registers
    ZYDIS_MAKE_SHORTSTRING("es"),
    ZYDIS_MAKE_SHORTSTRING("cs"),
    ZYDIS_MAKE_SHORTSTRING("ss"),
    ZYDIS_MAKE_SHORTSTRING("ds"),
    ZYDIS_MAKE_SHORTSTRING("fs"),
    ZYDIS_MAKE_SHORTSTRING("gs"),
    // Table registers
    ZYDIS_MAKE_SHORTSTRING("gdtr"),
    ZYDIS_MAKE_SHORTSTRING("ldtr"),
    ZYDIS_MAKE_SHORTSTRING("idtr"),
    ZYDIS_MAKE_SHORTSTRING("tr"),
    // Test registers
    ZYDIS_MAKE_SHORTSTRING("tr0"),
    ZYDIS_MAKE_SHORTSTRING("tr1"),
    ZYDIS_MAKE_SHORTSTRING("tr2"),
    ZYDIS_MAKE_SHORTSTRING("tr3"),
    ZYDIS_MAKE_SHORTSTRING("tr4"),
    ZYDIS_MAKE_SHORTSTRING("tr5"),
    ZYDIS_MAKE_SHORTSTRING("tr6"),
    ZYDIS_MAKE_SHORTSTRING("tr7"),
    // Control registers
    ZYDIS_MAKE_SHORTSTRING("cr0"),
    ZYDIS_MAKE_SHORTSTRING("cr1"),
    ZYDIS_MAKE_SHORTSTRING("cr2"),
    ZYDIS_MAKE_SHORTSTRING("cr3"),
    ZYDIS_MAKE_SHORTSTRING("cr4"),
    ZYDIS_MAKE_SHORTSTRING("cr5"),
    ZYDIS_MAKE_SHORTSTRING("cr6"),
    ZYDIS_MAKE_SHORTSTRING("cr7"),
    ZYDIS_MAKE_SHORTSTRING("cr8"),
    ZYDIS_MAKE_SHORTSTRING("cr9"),
    ZYDIS_MAKE_SHORTSTRING("cr10"),
    ZYDIS_MAKE_SHORTSTRING("cr11"),
    ZYDIS_MAKE_SHORTSTRING("cr12"),
    ZYDIS_MAKE_SHORTSTRING("cr13"),
    ZYDIS_MAKE_SHORTSTRING("cr14"),
    ZYDIS_MAKE_SHORTSTRING("cr15"),
    // Debug registers
    ZYDIS_MAKE_SHORTSTRING("dr0"),
    ZYDIS_MAKE_SHORTSTRING("dr1"),
    ZYDIS_MAKE_SHORTSTRING("dr2"),
    ZYDIS_MAKE_SHORTSTRING("dr3"),
    ZYDIS_MAKE_SHORTSTRING("dr4"),
    ZYDIS_MAKE_SHORTSTRING("dr5"),
    ZYDIS_MAKE_SHORTSTRING("dr6"),
    ZYDIS_MAKE_SHORTSTRING("dr7"),
    ZYDIS_MAKE_SHORTSTRING("dr8"),
    ZYDIS_MAKE_SHORTSTRING("dr9"),
    ZYDIS_MAKE_SHORTSTRING("dr10"),
    ZYDIS_MAKE_SHORTSTRING("dr11"),
    ZYDIS_MAKE_SHORTSTRING("dr12"),
    ZYDIS_MAKE_SHORTSTRING("dr13"),
    ZYDIS_MAKE_SHORTSTRING("dr14"),
    ZYDIS_MAKE_SHORTSTRING("dr15"),
    // Mask registers
    ZYDIS_MAKE_SHORTSTRING("k0"),
    ZYDIS_MAKE_SHORTSTRING("k1"),
    ZYDIS_MAKE_SHORTSTRING("k2"),
    ZYDIS_MAKE_SHORTSTRING("k3"),
    ZYDIS_MAKE_SHORTSTRING("k4"),
    ZYDIS_MAKE_SHORTSTRING("k5"),
    ZYDIS_MAKE_SHORTSTRING("k6"),
    ZYDIS_MAKE_SHORTSTRING("k7"),
    // Bound registers
    ZYDIS_MAKE_SHORTSTRING("bnd0"),
    ZYDIS_MAKE_SHORTSTRING("bnd1"),
    ZYDIS_MAKE_SHORTSTRING("bnd2"),
    ZYDIS_MAKE_SHORTSTRING("bnd3"),
    ZYDIS_MAKE_SHORTSTRING("bndcfg"),
    ZYDIS_MAKE_SHORTSTRING("bndstatus"),
    // Uncategorized
    ZYDIS_MAKE_SHORTSTRING("mxcsr"),
    ZYDIS_MAKE_SHORTSTRING("pkru"),
    ZYDIS_MAKE_SHORTSTRING("xcr0"),
    ZYDIS_MAKE_SHORTSTRING("uif")
};

/* ============================================================================================== */
/* Register-class mapping                                                                         */
/* ============================================================================================== */

/**
 * Defines the `ZydisRegisterMapItem` struct.
 */
typedef struct ZydisRegisterLookupItem
{
    /**
     * The register class.
     */
    ZydisRegisterClass class;
    /**
     * The register id.
     */
    ZyanI8 id;
    /**
     * The width of register 16- and 32-bit mode.
     */
    ZydisRegisterWidth width;
    /**
     * The width of register in 64-bit mode.
     */
    ZydisRegisterWidth width64;
} ZydisRegisterLookupItem;


//
// Header: Generated/RegisterLookup.inc
//

static const ZydisRegisterLookupItem REG_LOOKUP[] =
{
    /* NONE       */ { ZYDIS_REGCLASS_INVALID, -1, 0, 0 },
    /* AL         */ { ZYDIS_REGCLASS_GPR8, 0, 8, 8 },
    /* CL         */ { ZYDIS_REGCLASS_GPR8, 1, 8, 8 },
    /* DL         */ { ZYDIS_REGCLASS_GPR8, 2, 8, 8 },
    /* BL         */ { ZYDIS_REGCLASS_GPR8, 3, 8, 8 },
    /* AH         */ { ZYDIS_REGCLASS_GPR8, 4, 8, 8 },
    /* CH         */ { ZYDIS_REGCLASS_GPR8, 5, 8, 8 },
    /* DH         */ { ZYDIS_REGCLASS_GPR8, 6, 8, 8 },
    /* BH         */ { ZYDIS_REGCLASS_GPR8, 7, 8, 8 },
    /* SPL        */ { ZYDIS_REGCLASS_GPR8, 8, 8, 8 },
    /* BPL        */ { ZYDIS_REGCLASS_GPR8, 9, 8, 8 },
    /* SIL        */ { ZYDIS_REGCLASS_GPR8, 10, 8, 8 },
    /* DIL        */ { ZYDIS_REGCLASS_GPR8, 11, 8, 8 },
    /* R8B        */ { ZYDIS_REGCLASS_GPR8, 12, 8, 8 },
    /* R9B        */ { ZYDIS_REGCLASS_GPR8, 13, 8, 8 },
    /* R10B       */ { ZYDIS_REGCLASS_GPR8, 14, 8, 8 },
    /* R11B       */ { ZYDIS_REGCLASS_GPR8, 15, 8, 8 },
    /* R12B       */ { ZYDIS_REGCLASS_GPR8, 16, 8, 8 },
    /* R13B       */ { ZYDIS_REGCLASS_GPR8, 17, 8, 8 },
    /* R14B       */ { ZYDIS_REGCLASS_GPR8, 18, 8, 8 },
    /* R15B       */ { ZYDIS_REGCLASS_GPR8, 19, 8, 8 },
    /* AX         */ { ZYDIS_REGCLASS_GPR16, 0, 16, 16 },
    /* CX         */ { ZYDIS_REGCLASS_GPR16, 1, 16, 16 },
    /* DX         */ { ZYDIS_REGCLASS_GPR16, 2, 16, 16 },
    /* BX         */ { ZYDIS_REGCLASS_GPR16, 3, 16, 16 },
    /* SP         */ { ZYDIS_REGCLASS_GPR16, 4, 16, 16 },
    /* BP         */ { ZYDIS_REGCLASS_GPR16, 5, 16, 16 },
    /* SI         */ { ZYDIS_REGCLASS_GPR16, 6, 16, 16 },
    /* DI         */ { ZYDIS_REGCLASS_GPR16, 7, 16, 16 },
    /* R8W        */ { ZYDIS_REGCLASS_GPR16, 8, 16, 16 },
    /* R9W        */ { ZYDIS_REGCLASS_GPR16, 9, 16, 16 },
    /* R10W       */ { ZYDIS_REGCLASS_GPR16, 10, 16, 16 },
    /* R11W       */ { ZYDIS_REGCLASS_GPR16, 11, 16, 16 },
    /* R12W       */ { ZYDIS_REGCLASS_GPR16, 12, 16, 16 },
    /* R13W       */ { ZYDIS_REGCLASS_GPR16, 13, 16, 16 },
    /* R14W       */ { ZYDIS_REGCLASS_GPR16, 14, 16, 16 },
    /* R15W       */ { ZYDIS_REGCLASS_GPR16, 15, 16, 16 },
    /* EAX        */ { ZYDIS_REGCLASS_GPR32, 0, 32, 32 },
    /* ECX        */ { ZYDIS_REGCLASS_GPR32, 1, 32, 32 },
    /* EDX        */ { ZYDIS_REGCLASS_GPR32, 2, 32, 32 },
    /* EBX        */ { ZYDIS_REGCLASS_GPR32, 3, 32, 32 },
    /* ESP        */ { ZYDIS_REGCLASS_GPR32, 4, 32, 32 },
    /* EBP        */ { ZYDIS_REGCLASS_GPR32, 5, 32, 32 },
    /* ESI        */ { ZYDIS_REGCLASS_GPR32, 6, 32, 32 },
    /* EDI        */ { ZYDIS_REGCLASS_GPR32, 7, 32, 32 },
    /* R8D        */ { ZYDIS_REGCLASS_GPR32, 8, 32, 32 },
    /* R9D        */ { ZYDIS_REGCLASS_GPR32, 9, 32, 32 },
    /* R10D       */ { ZYDIS_REGCLASS_GPR32, 10, 32, 32 },
    /* R11D       */ { ZYDIS_REGCLASS_GPR32, 11, 32, 32 },
    /* R12D       */ { ZYDIS_REGCLASS_GPR32, 12, 32, 32 },
    /* R13D       */ { ZYDIS_REGCLASS_GPR32, 13, 32, 32 },
    /* R14D       */ { ZYDIS_REGCLASS_GPR32, 14, 32, 32 },
    /* R15D       */ { ZYDIS_REGCLASS_GPR32, 15, 32, 32 },
    /* RAX        */ { ZYDIS_REGCLASS_GPR64, 0, 0, 64 },
    /* RCX        */ { ZYDIS_REGCLASS_GPR64, 1, 0, 64 },
    /* RDX        */ { ZYDIS_REGCLASS_GPR64, 2, 0, 64 },
    /* RBX        */ { ZYDIS_REGCLASS_GPR64, 3, 0, 64 },
    /* RSP        */ { ZYDIS_REGCLASS_GPR64, 4, 0, 64 },
    /* RBP        */ { ZYDIS_REGCLASS_GPR64, 5, 0, 64 },
    /* RSI        */ { ZYDIS_REGCLASS_GPR64, 6, 0, 64 },
    /* RDI        */ { ZYDIS_REGCLASS_GPR64, 7, 0, 64 },
    /* R8         */ { ZYDIS_REGCLASS_GPR64, 8, 0, 64 },
    /* R9         */ { ZYDIS_REGCLASS_GPR64, 9, 0, 64 },
    /* R10        */ { ZYDIS_REGCLASS_GPR64, 10, 0, 64 },
    /* R11        */ { ZYDIS_REGCLASS_GPR64, 11, 0, 64 },
    /* R12        */ { ZYDIS_REGCLASS_GPR64, 12, 0, 64 },
    /* R13        */ { ZYDIS_REGCLASS_GPR64, 13, 0, 64 },
    /* R14        */ { ZYDIS_REGCLASS_GPR64, 14, 0, 64 },
    /* R15        */ { ZYDIS_REGCLASS_GPR64, 15, 0, 64 },
    /* ST0        */ { ZYDIS_REGCLASS_X87, 0, 80, 80 },
    /* ST1        */ { ZYDIS_REGCLASS_X87, 1, 80, 80 },
    /* ST2        */ { ZYDIS_REGCLASS_X87, 2, 80, 80 },
    /* ST3        */ { ZYDIS_REGCLASS_X87, 3, 80, 80 },
    /* ST4        */ { ZYDIS_REGCLASS_X87, 4, 80, 80 },
    /* ST5        */ { ZYDIS_REGCLASS_X87, 5, 80, 80 },
    /* ST6        */ { ZYDIS_REGCLASS_X87, 6, 80, 80 },
    /* ST7        */ { ZYDIS_REGCLASS_X87, 7, 80, 80 },
    /* X87CONTROL */ { ZYDIS_REGCLASS_INVALID, -1, 16, 16 },
    /* X87STATUS  */ { ZYDIS_REGCLASS_INVALID, -1, 16, 16 },
    /* X87TAG     */ { ZYDIS_REGCLASS_INVALID, -1, 16, 16 },
    /* MM0        */ { ZYDIS_REGCLASS_MMX, 0, 64, 64 },
    /* MM1        */ { ZYDIS_REGCLASS_MMX, 1, 64, 64 },
    /* MM2        */ { ZYDIS_REGCLASS_MMX, 2, 64, 64 },
    /* MM3        */ { ZYDIS_REGCLASS_MMX, 3, 64, 64 },
    /* MM4        */ { ZYDIS_REGCLASS_MMX, 4, 64, 64 },
    /* MM5        */ { ZYDIS_REGCLASS_MMX, 5, 64, 64 },
    /* MM6        */ { ZYDIS_REGCLASS_MMX, 6, 64, 64 },
    /* MM7        */ { ZYDIS_REGCLASS_MMX, 7, 64, 64 },
    /* XMM0       */ { ZYDIS_REGCLASS_XMM, 0, 128, 128 },
    /* XMM1       */ { ZYDIS_REGCLASS_XMM, 1, 128, 128 },
    /* XMM2       */ { ZYDIS_REGCLASS_XMM, 2, 128, 128 },
    /* XMM3       */ { ZYDIS_REGCLASS_XMM, 3, 128, 128 },
    /* XMM4       */ { ZYDIS_REGCLASS_XMM, 4, 128, 128 },
    /* XMM5       */ { ZYDIS_REGCLASS_XMM, 5, 128, 128 },
    /* XMM6       */ { ZYDIS_REGCLASS_XMM, 6, 128, 128 },
    /* XMM7       */ { ZYDIS_REGCLASS_XMM, 7, 128, 128 },
    /* XMM8       */ { ZYDIS_REGCLASS_XMM, 8, 128, 128 },
    /* XMM9       */ { ZYDIS_REGCLASS_XMM, 9, 128, 128 },
    /* XMM10      */ { ZYDIS_REGCLASS_XMM, 10, 128, 128 },
    /* XMM11      */ { ZYDIS_REGCLASS_XMM, 11, 128, 128 },
    /* XMM12      */ { ZYDIS_REGCLASS_XMM, 12, 128, 128 },
    /* XMM13      */ { ZYDIS_REGCLASS_XMM, 13, 128, 128 },
    /* XMM14      */ { ZYDIS_REGCLASS_XMM, 14, 128, 128 },
    /* XMM15      */ { ZYDIS_REGCLASS_XMM, 15, 128, 128 },
    /* XMM16      */ { ZYDIS_REGCLASS_XMM, 16, 128, 128 },
    /* XMM17      */ { ZYDIS_REGCLASS_XMM, 17, 128, 128 },
    /* XMM18      */ { ZYDIS_REGCLASS_XMM, 18, 128, 128 },
    /* XMM19      */ { ZYDIS_REGCLASS_XMM, 19, 128, 128 },
    /* XMM20      */ { ZYDIS_REGCLASS_XMM, 20, 128, 128 },
    /* XMM21      */ { ZYDIS_REGCLASS_XMM, 21, 128, 128 },
    /* XMM22      */ { ZYDIS_REGCLASS_XMM, 22, 128, 128 },
    /* XMM23      */ { ZYDIS_REGCLASS_XMM, 23, 128, 128 },
    /* XMM24      */ { ZYDIS_REGCLASS_XMM, 24, 128, 128 },
    /* XMM25      */ { ZYDIS_REGCLASS_XMM, 25, 128, 128 },
    /* XMM26      */ { ZYDIS_REGCLASS_XMM, 26, 128, 128 },
    /* XMM27      */ { ZYDIS_REGCLASS_XMM, 27, 128, 128 },
    /* XMM28      */ { ZYDIS_REGCLASS_XMM, 28, 128, 128 },
    /* XMM29      */ { ZYDIS_REGCLASS_XMM, 29, 128, 128 },
    /* XMM30      */ { ZYDIS_REGCLASS_XMM, 30, 128, 128 },
    /* XMM31      */ { ZYDIS_REGCLASS_XMM, 31, 128, 128 },
    /* YMM0       */ { ZYDIS_REGCLASS_YMM, 0, 256, 256 },
    /* YMM1       */ { ZYDIS_REGCLASS_YMM, 1, 256, 256 },
    /* YMM2       */ { ZYDIS_REGCLASS_YMM, 2, 256, 256 },
    /* YMM3       */ { ZYDIS_REGCLASS_YMM, 3, 256, 256 },
    /* YMM4       */ { ZYDIS_REGCLASS_YMM, 4, 256, 256 },
    /* YMM5       */ { ZYDIS_REGCLASS_YMM, 5, 256, 256 },
    /* YMM6       */ { ZYDIS_REGCLASS_YMM, 6, 256, 256 },
    /* YMM7       */ { ZYDIS_REGCLASS_YMM, 7, 256, 256 },
    /* YMM8       */ { ZYDIS_REGCLASS_YMM, 8, 256, 256 },
    /* YMM9       */ { ZYDIS_REGCLASS_YMM, 9, 256, 256 },
    /* YMM10      */ { ZYDIS_REGCLASS_YMM, 10, 256, 256 },
    /* YMM11      */ { ZYDIS_REGCLASS_YMM, 11, 256, 256 },
    /* YMM12      */ { ZYDIS_REGCLASS_YMM, 12, 256, 256 },
    /* YMM13      */ { ZYDIS_REGCLASS_YMM, 13, 256, 256 },
    /* YMM14      */ { ZYDIS_REGCLASS_YMM, 14, 256, 256 },
    /* YMM15      */ { ZYDIS_REGCLASS_YMM, 15, 256, 256 },
    /* YMM16      */ { ZYDIS_REGCLASS_YMM, 16, 256, 256 },
    /* YMM17      */ { ZYDIS_REGCLASS_YMM, 17, 256, 256 },
    /* YMM18      */ { ZYDIS_REGCLASS_YMM, 18, 256, 256 },
    /* YMM19      */ { ZYDIS_REGCLASS_YMM, 19, 256, 256 },
    /* YMM20      */ { ZYDIS_REGCLASS_YMM, 20, 256, 256 },
    /* YMM21      */ { ZYDIS_REGCLASS_YMM, 21, 256, 256 },
    /* YMM22      */ { ZYDIS_REGCLASS_YMM, 22, 256, 256 },
    /* YMM23      */ { ZYDIS_REGCLASS_YMM, 23, 256, 256 },
    /* YMM24      */ { ZYDIS_REGCLASS_YMM, 24, 256, 256 },
    /* YMM25      */ { ZYDIS_REGCLASS_YMM, 25, 256, 256 },
    /* YMM26      */ { ZYDIS_REGCLASS_YMM, 26, 256, 256 },
    /* YMM27      */ { ZYDIS_REGCLASS_YMM, 27, 256, 256 },
    /* YMM28      */ { ZYDIS_REGCLASS_YMM, 28, 256, 256 },
    /* YMM29      */ { ZYDIS_REGCLASS_YMM, 29, 256, 256 },
    /* YMM30      */ { ZYDIS_REGCLASS_YMM, 30, 256, 256 },
    /* YMM31      */ { ZYDIS_REGCLASS_YMM, 31, 256, 256 },
    /* ZMM0       */ { ZYDIS_REGCLASS_ZMM, 0, 512, 512 },
    /* ZMM1       */ { ZYDIS_REGCLASS_ZMM, 1, 512, 512 },
    /* ZMM2       */ { ZYDIS_REGCLASS_ZMM, 2, 512, 512 },
    /* ZMM3       */ { ZYDIS_REGCLASS_ZMM, 3, 512, 512 },
    /* ZMM4       */ { ZYDIS_REGCLASS_ZMM, 4, 512, 512 },
    /* ZMM5       */ { ZYDIS_REGCLASS_ZMM, 5, 512, 512 },
    /* ZMM6       */ { ZYDIS_REGCLASS_ZMM, 6, 512, 512 },
    /* ZMM7       */ { ZYDIS_REGCLASS_ZMM, 7, 512, 512 },
    /* ZMM8       */ { ZYDIS_REGCLASS_ZMM, 8, 512, 512 },
    /* ZMM9       */ { ZYDIS_REGCLASS_ZMM, 9, 512, 512 },
    /* ZMM10      */ { ZYDIS_REGCLASS_ZMM, 10, 512, 512 },
    /* ZMM11      */ { ZYDIS_REGCLASS_ZMM, 11, 512, 512 },
    /* ZMM12      */ { ZYDIS_REGCLASS_ZMM, 12, 512, 512 },
    /* ZMM13      */ { ZYDIS_REGCLASS_ZMM, 13, 512, 512 },
    /* ZMM14      */ { ZYDIS_REGCLASS_ZMM, 14, 512, 512 },
    /* ZMM15      */ { ZYDIS_REGCLASS_ZMM, 15, 512, 512 },
    /* ZMM16      */ { ZYDIS_REGCLASS_ZMM, 16, 512, 512 },
    /* ZMM17      */ { ZYDIS_REGCLASS_ZMM, 17, 512, 512 },
    /* ZMM18      */ { ZYDIS_REGCLASS_ZMM, 18, 512, 512 },
    /* ZMM19      */ { ZYDIS_REGCLASS_ZMM, 19, 512, 512 },
    /* ZMM20      */ { ZYDIS_REGCLASS_ZMM, 20, 512, 512 },
    /* ZMM21      */ { ZYDIS_REGCLASS_ZMM, 21, 512, 512 },
    /* ZMM22      */ { ZYDIS_REGCLASS_ZMM, 22, 512, 512 },
    /* ZMM23      */ { ZYDIS_REGCLASS_ZMM, 23, 512, 512 },
    /* ZMM24      */ { ZYDIS_REGCLASS_ZMM, 24, 512, 512 },
    /* ZMM25      */ { ZYDIS_REGCLASS_ZMM, 25, 512, 512 },
    /* ZMM26      */ { ZYDIS_REGCLASS_ZMM, 26, 512, 512 },
    /* ZMM27      */ { ZYDIS_REGCLASS_ZMM, 27, 512, 512 },
    /* ZMM28      */ { ZYDIS_REGCLASS_ZMM, 28, 512, 512 },
    /* ZMM29      */ { ZYDIS_REGCLASS_ZMM, 29, 512, 512 },
    /* ZMM30      */ { ZYDIS_REGCLASS_ZMM, 30, 512, 512 },
    /* ZMM31      */ { ZYDIS_REGCLASS_ZMM, 31, 512, 512 },
    /* TMM0       */ { ZYDIS_REGCLASS_TMM, 0, 8192, 8192 },
    /* TMM1       */ { ZYDIS_REGCLASS_TMM, 1, 8192, 8192 },
    /* TMM2       */ { ZYDIS_REGCLASS_TMM, 2, 8192, 8192 },
    /* TMM3       */ { ZYDIS_REGCLASS_TMM, 3, 8192, 8192 },
    /* TMM4       */ { ZYDIS_REGCLASS_TMM, 4, 8192, 8192 },
    /* TMM5       */ { ZYDIS_REGCLASS_TMM, 5, 8192, 8192 },
    /* TMM6       */ { ZYDIS_REGCLASS_TMM, 6, 8192, 8192 },
    /* TMM7       */ { ZYDIS_REGCLASS_TMM, 7, 8192, 8192 },
    /* FLAGS      */ { ZYDIS_REGCLASS_FLAGS, -1, 16, 16 },
    /* EFLAGS     */ { ZYDIS_REGCLASS_FLAGS, -1, 32, 32 },
    /* RFLAGS     */ { ZYDIS_REGCLASS_FLAGS, -1, 0, 64 },
    /* IP         */ { ZYDIS_REGCLASS_IP, -1, 16, 16 },
    /* EIP        */ { ZYDIS_REGCLASS_IP, -1, 32, 32 },
    /* RIP        */ { ZYDIS_REGCLASS_IP, -1, 0, 64 },
    /* ES         */ { ZYDIS_REGCLASS_SEGMENT, 0, 16, 16 },
    /* CS         */ { ZYDIS_REGCLASS_SEGMENT, 1, 16, 16 },
    /* SS         */ { ZYDIS_REGCLASS_SEGMENT, 2, 16, 16 },
    /* DS         */ { ZYDIS_REGCLASS_SEGMENT, 3, 16, 16 },
    /* FS         */ { ZYDIS_REGCLASS_SEGMENT, 4, 16, 16 },
    /* GS         */ { ZYDIS_REGCLASS_SEGMENT, 5, 16, 16 },
    /* GDTR       */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* LDTR       */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* IDTR       */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* TR         */ { ZYDIS_REGCLASS_TABLE, -1, 0, 0 },
    /* TR0        */ { ZYDIS_REGCLASS_TEST, 0, 32, 32 },
    /* TR1        */ { ZYDIS_REGCLASS_TEST, 1, 32, 32 },
    /* TR2        */ { ZYDIS_REGCLASS_TEST, 2, 32, 32 },
    /* TR3        */ { ZYDIS_REGCLASS_TEST, 3, 32, 32 },
    /* TR4        */ { ZYDIS_REGCLASS_TEST, 4, 32, 32 },
    /* TR5        */ { ZYDIS_REGCLASS_TEST, 5, 32, 32 },
    /* TR6        */ { ZYDIS_REGCLASS_TEST, 6, 32, 32 },
    /* TR7        */ { ZYDIS_REGCLASS_TEST, 7, 32, 32 },
    /* CR0        */ { ZYDIS_REGCLASS_CONTROL, 0, 32, 64 },
    /* CR1        */ { ZYDIS_REGCLASS_CONTROL, 1, 32, 64 },
    /* CR2        */ { ZYDIS_REGCLASS_CONTROL, 2, 32, 64 },
    /* CR3        */ { ZYDIS_REGCLASS_CONTROL, 3, 32, 64 },
    /* CR4        */ { ZYDIS_REGCLASS_CONTROL, 4, 32, 64 },
    /* CR5        */ { ZYDIS_REGCLASS_CONTROL, 5, 32, 64 },
    /* CR6        */ { ZYDIS_REGCLASS_CONTROL, 6, 32, 64 },
    /* CR7        */ { ZYDIS_REGCLASS_CONTROL, 7, 32, 64 },
    /* CR8        */ { ZYDIS_REGCLASS_CONTROL, 8, 32, 64 },
    /* CR9        */ { ZYDIS_REGCLASS_CONTROL, 9, 32, 64 },
    /* CR10       */ { ZYDIS_REGCLASS_CONTROL, 10, 32, 64 },
    /* CR11       */ { ZYDIS_REGCLASS_CONTROL, 11, 32, 64 },
    /* CR12       */ { ZYDIS_REGCLASS_CONTROL, 12, 32, 64 },
    /* CR13       */ { ZYDIS_REGCLASS_CONTROL, 13, 32, 64 },
    /* CR14       */ { ZYDIS_REGCLASS_CONTROL, 14, 32, 64 },
    /* CR15       */ { ZYDIS_REGCLASS_CONTROL, 15, 32, 64 },
    /* DR0        */ { ZYDIS_REGCLASS_DEBUG, 0, 32, 64 },
    /* DR1        */ { ZYDIS_REGCLASS_DEBUG, 1, 32, 64 },
    /* DR2        */ { ZYDIS_REGCLASS_DEBUG, 2, 32, 64 },
    /* DR3        */ { ZYDIS_REGCLASS_DEBUG, 3, 32, 64 },
    /* DR4        */ { ZYDIS_REGCLASS_DEBUG, 4, 32, 64 },
    /* DR5        */ { ZYDIS_REGCLASS_DEBUG, 5, 32, 64 },
    /* DR6        */ { ZYDIS_REGCLASS_DEBUG, 6, 32, 64 },
    /* DR7        */ { ZYDIS_REGCLASS_DEBUG, 7, 32, 64 },
    /* DR8        */ { ZYDIS_REGCLASS_DEBUG, 8, 32, 64 },
    /* DR9        */ { ZYDIS_REGCLASS_DEBUG, 9, 32, 64 },
    /* DR10       */ { ZYDIS_REGCLASS_DEBUG, 10, 32, 64 },
    /* DR11       */ { ZYDIS_REGCLASS_DEBUG, 11, 32, 64 },
    /* DR12       */ { ZYDIS_REGCLASS_DEBUG, 12, 32, 64 },
    /* DR13       */ { ZYDIS_REGCLASS_DEBUG, 13, 32, 64 },
    /* DR14       */ { ZYDIS_REGCLASS_DEBUG, 14, 32, 64 },
    /* DR15       */ { ZYDIS_REGCLASS_DEBUG, 15, 32, 64 },
    /* K0         */ { ZYDIS_REGCLASS_MASK, 0, 64, 64 },
    /* K1         */ { ZYDIS_REGCLASS_MASK, 1, 64, 64 },
    /* K2         */ { ZYDIS_REGCLASS_MASK, 2, 64, 64 },
    /* K3         */ { ZYDIS_REGCLASS_MASK, 3, 64, 64 },
    /* K4         */ { ZYDIS_REGCLASS_MASK, 4, 64, 64 },
    /* K5         */ { ZYDIS_REGCLASS_MASK, 5, 64, 64 },
    /* K6         */ { ZYDIS_REGCLASS_MASK, 6, 64, 64 },
    /* K7         */ { ZYDIS_REGCLASS_MASK, 7, 64, 64 },
    /* BND0       */ { ZYDIS_REGCLASS_BOUND, 0, 128, 128 },
    /* BND1       */ { ZYDIS_REGCLASS_BOUND, 1, 128, 128 },
    /* BND2       */ { ZYDIS_REGCLASS_BOUND, 2, 128, 128 },
    /* BND3       */ { ZYDIS_REGCLASS_BOUND, 3, 128, 128 },
    /* BNDCFG     */ { ZYDIS_REGCLASS_INVALID, -1, 64, 64 },
    /* BNDSTATUS  */ { ZYDIS_REGCLASS_INVALID, -1, 64, 64 },
    /* MXCSR      */ { ZYDIS_REGCLASS_INVALID, -1, 32, 32 },
    /* PKRU       */ { ZYDIS_REGCLASS_INVALID, -1, 32, 32 },
    /* XCR0       */ { ZYDIS_REGCLASS_INVALID, -1, 64, 64 },
    /* UIF        */ { ZYDIS_REGCLASS_INVALID, -1, 1, 1 }
};

/**
 * Defines the `ZydisRegisterClassLookupItem` struct.
 */
typedef struct ZydisRegisterClassLookupItem_
{
    /**
     * The lowest register of the current class.
     */
    ZydisRegister lo;
    /**
     * The highest register of the current class.
     */
    ZydisRegister hi;
    /**
     * The width of registers of the current class in 16- and 32-bit mode.
     */
    ZydisRegisterWidth width;
    /**
     * The width of registers of the current class in 64-bit mode.
     */
    ZydisRegisterWidth width64;
} ZydisRegisterClassLookupItem;


//
// Header: Generated/RegisterClassLookup.inc
//

static const ZydisRegisterClassLookupItem REG_CLASS_LOOKUP[] =
{
    /* INVALID */ { ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE, 0, 0 },
    /* GPR8    */ { ZYDIS_REGISTER_AL, ZYDIS_REGISTER_R15B, 8, 8 },
    /* GPR16   */ { ZYDIS_REGISTER_AX, ZYDIS_REGISTER_R15W, 16, 16 },
    /* GPR32   */ { ZYDIS_REGISTER_EAX, ZYDIS_REGISTER_R15D, 32, 32 },
    /* GPR64   */ { ZYDIS_REGISTER_RAX, ZYDIS_REGISTER_R15, 0, 64 },
    /* X87     */ { ZYDIS_REGISTER_ST0, ZYDIS_REGISTER_ST7, 80, 80 },
    /* MMX     */ { ZYDIS_REGISTER_MM0, ZYDIS_REGISTER_MM7, 64, 64 },
    /* XMM     */ { ZYDIS_REGISTER_XMM0, ZYDIS_REGISTER_XMM31, 128, 128 },
    /* YMM     */ { ZYDIS_REGISTER_YMM0, ZYDIS_REGISTER_YMM31, 256, 256 },
    /* ZMM     */ { ZYDIS_REGISTER_ZMM0, ZYDIS_REGISTER_ZMM31, 512, 512 },
    /* TMM     */ { ZYDIS_REGISTER_TMM0, ZYDIS_REGISTER_TMM7, 8192, 8192 },
    /* FLAGS   */ { ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE, 0, 0 },
    /* IP      */ { ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE, 0, 0 },
    /* SEGMENT */ { ZYDIS_REGISTER_ES, ZYDIS_REGISTER_GS, 16, 16 },
    /* TABLE   */ { ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE, 0, 0 },
    /* TEST    */ { ZYDIS_REGISTER_TR0, ZYDIS_REGISTER_TR7, 32, 32 },
    /* CONTROL */ { ZYDIS_REGISTER_CR0, ZYDIS_REGISTER_CR15, 32, 64 },
    /* DEBUG   */ { ZYDIS_REGISTER_DR0, ZYDIS_REGISTER_DR15, 32, 64 },
    /* MASK    */ { ZYDIS_REGISTER_K0, ZYDIS_REGISTER_K7, 64, 64 },
    /* BOUND   */ { ZYDIS_REGISTER_BND0, ZYDIS_REGISTER_BND3, 128, 128 }
};

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Register                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZydisRegister ZydisRegisterEncode(ZydisRegisterClass register_class, ZyanU8 id)
{
    if((register_class == ZYDIS_REGCLASS_INVALID) ||
            (register_class == ZYDIS_REGCLASS_FLAGS) ||
            (register_class == ZYDIS_REGCLASS_IP))
    {
        return ZYDIS_REGISTER_NONE;
    }

    if((ZyanUSize)register_class >= ZYAN_ARRAY_LENGTH(REG_CLASS_LOOKUP))
    {
        return ZYDIS_REGISTER_NONE;
    }

    const ZydisRegisterClassLookupItem* item = &REG_CLASS_LOOKUP[register_class];
    if(id <= (item->hi - item->lo))
    {
        return item->lo + id;
    }

    return ZYDIS_REGISTER_NONE;
}

ZyanI8 ZydisRegisterGetId(ZydisRegister reg)
{
    if((ZyanUSize)reg >= ZYAN_ARRAY_LENGTH(REG_LOOKUP))
    {
        return -1;
    }

    return REG_LOOKUP[reg].id;
}

ZydisRegisterClass ZydisRegisterGetClass(ZydisRegister reg)
{
    if((ZyanUSize)reg >= ZYAN_ARRAY_LENGTH(REG_LOOKUP))
    {
        return ZYDIS_REGCLASS_INVALID;
    }

    return REG_LOOKUP[reg].class;
}

ZydisRegisterWidth ZydisRegisterGetWidth(ZydisMachineMode mode, ZydisRegister reg)
{
    if((ZyanUSize)reg >= ZYAN_ARRAY_LENGTH(REG_LOOKUP))
    {
        return 0;
    }

    return (mode == ZYDIS_MACHINE_MODE_LONG_64)
           ? REG_LOOKUP[reg].width64
           : REG_LOOKUP[reg].width;
}

ZydisRegister ZydisRegisterGetLargestEnclosing(ZydisMachineMode mode, ZydisRegister reg)
{
    if((ZyanUSize)reg >= ZYAN_ARRAY_LENGTH(REG_LOOKUP))
    {
        return ZYDIS_REGISTER_NONE;
    }

    static const ZyanU8 GPR8_MAPPING[20] =
    {
        /* AL   */  0,
        /* CL   */  1,
        /* DL   */  2,
        /* BL   */  3,
        /* AH   */  0,
        /* CH   */  1,
        /* DH   */  2,
        /* BH   */  3,
        /* SPL  */  4,
        /* BPL  */  5,
        /* SIL  */  6,
        /* DIL  */  7,
        /* R8B  */  8,
        /* R9B  */  9,
        /* R10B */ 10,
        /* R11B */ 11,
        /* R12B */ 12,
        /* R13B */ 13,
        /* R14B */ 14,
        /* R15B */ 15,
    };

    const ZydisRegisterClass reg_class = REG_LOOKUP[reg].class;
    if((reg_class == ZYDIS_REGCLASS_INVALID) ||
            ((reg_class == ZYDIS_REGCLASS_GPR64) && (mode != ZYDIS_MACHINE_MODE_LONG_64)))
    {
        return ZYDIS_REGISTER_NONE;
    }

    ZyanU8 reg_id = REG_LOOKUP[reg].id;
    switch(reg_class)
    {
    case ZYDIS_REGCLASS_GPR8:
        reg_id = GPR8_MAPPING[reg_id];
        ZYAN_FALLTHROUGH;
    case ZYDIS_REGCLASS_GPR16:
    case ZYDIS_REGCLASS_GPR32:
    case ZYDIS_REGCLASS_GPR64:
        switch(mode)
        {
        case ZYDIS_MACHINE_MODE_LONG_64:
            return REG_CLASS_LOOKUP[ZYDIS_REGCLASS_GPR64].lo + reg_id;
        case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
        case ZYDIS_MACHINE_MODE_LEGACY_32:
            return REG_CLASS_LOOKUP[ZYDIS_REGCLASS_GPR32].lo + reg_id;
        case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
        case ZYDIS_MACHINE_MODE_LEGACY_16:
        case ZYDIS_MACHINE_MODE_REAL_16:
            return REG_CLASS_LOOKUP[ZYDIS_REGCLASS_GPR16].lo + reg_id;
        default:
            return ZYDIS_REGISTER_NONE;
        }
    case ZYDIS_REGCLASS_XMM:
    case ZYDIS_REGCLASS_YMM:
    case ZYDIS_REGCLASS_ZMM:
#if defined(ZYDIS_DISABLE_AVX512) && defined(ZYDIS_DISABLE_KNC)
        return REG_CLASS_LOOKUP[ZYDIS_REGCLASS_YMM].lo + reg_id;
#else
        return REG_CLASS_LOOKUP[ZYDIS_REGCLASS_ZMM].lo + reg_id;
#endif
    default:
        return ZYDIS_REGISTER_NONE;
    }
}

const char* ZydisRegisterGetString(ZydisRegister reg)
{
    if((ZyanUSize)reg >= ZYAN_ARRAY_LENGTH(STR_REGISTERS))
    {
        return ZYAN_NULL;
    }

    return STR_REGISTERS[reg].data;
}

const ZydisShortString* ZydisRegisterGetStringWrapped(ZydisRegister reg)
{
    if((ZyanUSize)reg >= ZYAN_ARRAY_LENGTH(STR_REGISTERS))
    {
        return ZYAN_NULL;
    }

    return &STR_REGISTERS[reg];
}

/* ---------------------------------------------------------------------------------------------- */
/* Register class                                                                                 */
/* ---------------------------------------------------------------------------------------------- */

ZydisRegisterWidth ZydisRegisterClassGetWidth(ZydisMachineMode mode,
        ZydisRegisterClass register_class)
{
    if((ZyanUSize)register_class >= ZYAN_ARRAY_LENGTH(REG_CLASS_LOOKUP))
    {
        return 0;
    }

    return (mode == ZYDIS_MACHINE_MODE_LONG_64)
           ? REG_CLASS_LOOKUP[register_class].width64
           : REG_CLASS_LOOKUP[register_class].width;
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/FormatterBuffer.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


//
// Header: Zydis/Internal/String.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

/**
 * @file
 * Provides some internal, more performant, but unsafe helper functions for the `ZyanString`
 * data-type.
 *
 * Most of these functions are very similar to the ones in `Zycore/String.h`, but inlined and
 * without optional overhead like parameter-validation checks, etc ...
 *
 * The `ZyanString` data-type is able to dynamically allocate memory on the heap, but as `Zydis` is
 * designed to be a non-'malloc'ing library, all functions in this file assume that the instances
 * they are operating on are created with a user-defined static-buffer.
 */

#ifndef ZYDIS_INTERNAL_STRING_H
#define ZYDIS_INTERNAL_STRING_H


//
// Header: Zycore/Format.h
//
// Include stack:
//   - Zydis/Internal/String.h
//

/***************************************************************************************************

  Zyan Core Library (Zycore-C)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

/**
 * @file
 * Provides helper functions for performant number to string conversion.
 */

#ifndef ZYCORE_FORMAT_H
#define ZYCORE_FORMAT_H


#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Helpers                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Get the absolute value of a 64 bit int.
 *
 * @param x The value to process.
 * @return  The absolute, unsigned value.
 *
 * This gracefully deals with the special case of `x` being `INT_MAX`.
 */
ZYAN_INLINE ZyanU64 ZyanAbsI64(ZyanI64 x)
{
    // INT_MIN special case. Can't use the value directly because GCC thinks
    // it's too big for an INT64 literal, however is perfectly happy to accept
    // this expression. This is also hit INT64_MIN is defined in `stdint.h`.
    if(x == (-0x7fffffffffffffff - 1))
    {
        return 0x8000000000000000u;
    }

    return (ZyanU64)(x < 0 ? -x : x);
}

/* ---------------------------------------------------------------------------------------------- */
/* Insertion                                                                                      */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Inserts formatted text in the destination string at the given `index`.
 *
 * @param   string  The destination string.
 * @param   index   The insert index.
 * @param   format  The format string.
 * @param   ...     The format arguments.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYAN_PRINTF_ATTR(3, 4)
ZYCORE_EXPORT ZyanStatus ZyanStringInsertFormat(ZyanString* string, ZyanUSize index,
        const char* format, ...);

/* ---------------------------------------------------------------------------------------------- */

/**
 * Formats the given unsigned ordinal `value` to its decimal text-representation and
 * inserts it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   index           The insert index.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringInsertDecU(ZyanString* string, ZyanUSize index, ZyanU64 value,
        ZyanU8 padding_length);

/**
 * Formats the given signed ordinal `value` to its decimal text-representation and
 * inserts it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   index           The insert index.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   force_sign      Set `ZYAN_TRUE`, to force printing of the `+` sign for positive numbers.
 * @param   prefix          The string to use as prefix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringInsertDecS(ZyanString* string, ZyanUSize index, ZyanI64 value,
        ZyanU8 padding_length, ZyanBool force_sign, const ZyanString* prefix);

/**
 * Formats the given unsigned ordinal `value` to its hexadecimal text-representation and
 * inserts it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   index           The insert index.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   uppercase       Set `ZYAN_TRUE` to use uppercase letters ('A'-'F') instead of lowercase
 *                          ones ('a'-'f').
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringInsertHexU(ZyanString* string, ZyanUSize index, ZyanU64 value,
        ZyanU8 padding_length, ZyanBool uppercase);

/**
 * Formats the given signed ordinal `value` to its hexadecimal text-representation and
 * inserts it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   index           The insert index.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   uppercase       Set `ZYAN_TRUE` to use uppercase letters ('A'-'F') instead of lowercase
 *                          ones ('a'-'f').
 * @param   force_sign      Set `ZYAN_TRUE`, to force printing of the `+` sign for positive numbers.
 * @param   prefix          The string to use as prefix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringInsertHexS(ZyanString* string, ZyanUSize index, ZyanI64 value,
        ZyanU8 padding_length, ZyanBool uppercase, ZyanBool force_sign, const ZyanString* prefix);

/* ---------------------------------------------------------------------------------------------- */
/* Appending                                                                                      */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYAN_NO_LIBC

/**
 * Appends formatted text to the destination string.
 *
 * @param   string  The destination string.
 * @param   format  The format string.
 * @param   ...     The format arguments.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYAN_PRINTF_ATTR(2, 3)
ZYCORE_EXPORT ZYAN_REQUIRES_LIBC ZyanStatus ZyanStringAppendFormat(
    ZyanString* string, const char* format, ...);

#endif // ZYAN_NO_LIBC

/* ---------------------------------------------------------------------------------------------- */

/**
 * Formats the given unsigned ordinal `value` to its decimal text-representation and
 * appends it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringAppendDecU(ZyanString* string, ZyanU64 value,
        ZyanU8 padding_length);

/**
 * Formats the given signed ordinal `value` to its decimal text-representation and
 * appends it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   force_sign      Set `ZYAN_TRUE`, to force printing of the `+` sign for positive numbers.
 * @param   prefix          The string to use as prefix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringAppendDecS(ZyanString* string, ZyanI64 value,
        ZyanU8 padding_length, ZyanBool force_sign, const ZyanStringView* prefix);

/**
 * Formats the given unsigned ordinal `value` to its hexadecimal text-representation and
 * appends it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   uppercase       Set `ZYAN_TRUE` to use uppercase letters ('A'-'F') instead of lowercase
 *                          ones ('a'-'f').
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringAppendHexU(ZyanString* string, ZyanU64 value,
        ZyanU8 padding_length, ZyanBool uppercase);

/**
 * Formats the given signed ordinal `value` to its hexadecimal text-representation and
 * appends it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   value           The value.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   uppercase       Set `ZYAN_TRUE` to use uppercase letters ('A'-'F') instead of lowercase
 *                          ones ('a'-'f').
 * @param   force_sign      Set `ZYAN_TRUE`, to force printing of the `+` sign for positive numbers.
 * @param   prefix          The string to use as prefix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYCORE_EXPORT ZyanStatus ZyanStringAppendHexS(ZyanString* string, ZyanI64 value,
        ZyanU8 padding_length, ZyanBool uppercase, ZyanBool force_sign, const ZyanStringView* prefix);

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif // ZYCORE_FORMAT_H

#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Enums and types                                                                                */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Letter Case                                                                                    */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisLetterCase` enum.
 */
typedef enum ZydisLetterCase_
{
    /**
     * Uses the given text "as is".
     */
    ZYDIS_LETTER_CASE_DEFAULT,
    /**
     * Converts the given text to lowercase letters.
     */
    ZYDIS_LETTER_CASE_LOWER,
    /**
     * Converts the given text to uppercase letters.
     */
    ZYDIS_LETTER_CASE_UPPER,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_LETTER_CASE_MAX_VALUE = ZYDIS_LETTER_CASE_UPPER,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_LETTER_CASE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_LETTER_CASE_MAX_VALUE)
} ZydisLetterCase;

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Macros                                                                                         */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Internal macros                                                                                */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Checks for a terminating '\0' character at the end of the string data.
 */
#define ZYDIS_STRING_ASSERT_NULLTERMINATION(string) \
      ZYAN_ASSERT(*(char*)((ZyanU8*)(string)->vector.data + (string)->vector.size - 1) == '\0');

/**
 * Writes a terminating '\0' character at the end of the string data.
 */
#define ZYDIS_STRING_NULLTERMINATE(string) \
      *(char*)((ZyanU8*)(string)->vector.data + (string)->vector.size - 1) = '\0';

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Internal Functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Appending                                                                                      */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Appends the content of the source string to the end of the destination string.
 *
 * @param   destination The destination string.
 * @param   source      The source string.
 *
 * @return  A zyan status code.
 */
ZYAN_INLINE ZyanStatus ZydisStringAppend(ZyanString* destination, const ZyanStringView* source)
{
    ZYAN_ASSERT(destination && source);
    ZYAN_ASSERT(!destination->vector.allocator);
    ZYAN_ASSERT(destination->vector.size && source->string.vector.size);

    if(destination->vector.size + source->string.vector.size - 1 > destination->vector.capacity)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZYAN_MEMCPY((char*)destination->vector.data + destination->vector.size - 1,
                source->string.vector.data, source->string.vector.size - 1);

    destination->vector.size += source->string.vector.size - 1;
    ZYDIS_STRING_NULLTERMINATE(destination);

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Appends the content of the source string to the end of the destination
 * string, converting the characters to the specified letter-case.
 *
 * @param   destination The destination string.
 * @param   source      The source string.
 * @param   letter_case The desired letter-case.
 *
 * @return  A zyan status code.
 */
ZYAN_INLINE ZyanStatus ZydisStringAppendCase(ZyanString* destination, const ZyanStringView* source,
        ZydisLetterCase letter_case)
{
    ZYAN_ASSERT(destination && source);
    ZYAN_ASSERT(!destination->vector.allocator);
    ZYAN_ASSERT(destination->vector.size && source->string.vector.size);

    if(destination->vector.size + source->string.vector.size - 1 > destination->vector.capacity)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZYAN_MEMCPY((char*)destination->vector.data + destination->vector.size - 1,
                source->string.vector.data, source->string.vector.size - 1);

    switch(letter_case)
    {
    case ZYDIS_LETTER_CASE_DEFAULT:
        break;
    case ZYDIS_LETTER_CASE_LOWER:
    {
        const ZyanUSize index = destination->vector.size - 1;
        const ZyanUSize count = source->string.vector.size - 1;
        char* s = (char*)destination->vector.data + index;
        for(ZyanUSize i = index; i < index + count; ++i)
        {
            const char c = *s;
            if((c >= 'A') && (c <= 'Z'))
            {
                *s = c | 32;
            }
            ++s;
        }
        break;
    }
    case ZYDIS_LETTER_CASE_UPPER:
    {
        const ZyanUSize index = destination->vector.size - 1;
        const ZyanUSize count = source->string.vector.size - 1;
        char* s = (char*)destination->vector.data + index;
        for(ZyanUSize i = index; i < index + count; ++i)
        {
            const char c = *s;
            if((c >= 'a') && (c <= 'z'))
            {
                *s = c & ~32;
            }
            ++s;
        }
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }

    destination->vector.size += source->string.vector.size - 1;
    ZYDIS_STRING_NULLTERMINATE(destination);

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Appends the content of the source short-string to the end of the destination string.
 *
 * @param   destination The destination string.
 * @param   source      The source string.
 *
 * @return  A zyan status code.
 */
ZYAN_INLINE ZyanStatus ZydisStringAppendShort(ZyanString* destination,
        const ZydisShortString* source)
{
    ZYAN_ASSERT(destination && source);
    ZYAN_ASSERT(!destination->vector.allocator);
    ZYAN_ASSERT(destination->vector.size && source->size);

    if(destination->vector.size + source->size > destination->vector.capacity)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZYAN_MEMCPY((char*)destination->vector.data + destination->vector.size - 1, source->data,
                (ZyanUSize)source->size + 1);

    destination->vector.size += source->size;
    ZYDIS_STRING_ASSERT_NULLTERMINATION(destination);

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Appends the content of the source short-string to the end of the destination string,
 * converting the characters to the specified letter-case.
 *
 * @param   destination The destination string.
 * @param   source      The source string.
 * @param   letter_case The desired letter-case.
 *
 * @return  A zyan status code.
 */
ZYAN_INLINE ZyanStatus ZydisStringAppendShortCase(ZyanString* destination,
        const ZydisShortString* source, ZydisLetterCase letter_case)
{
    ZYAN_ASSERT(destination && source);
    ZYAN_ASSERT(!destination->vector.allocator);
    ZYAN_ASSERT(destination->vector.size && source->size);

    if(destination->vector.size + source->size > destination->vector.capacity)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZYAN_MEMCPY((char*)destination->vector.data + destination->vector.size - 1, source->data,
                (ZyanUSize)source->size + 1);

    switch(letter_case)
    {
    case ZYDIS_LETTER_CASE_DEFAULT:
        break;
    case ZYDIS_LETTER_CASE_LOWER:
    {
        const ZyanUSize index = destination->vector.size - 1;
        const ZyanUSize count = source->size;
        char* s = (char*)destination->vector.data + index;
        for(ZyanUSize i = index; i < index + count; ++i)
        {
            const char c = *s;
            if((c >= 'A') && (c <= 'Z'))
            {
                *s = c | 32;
            }
            ++s;
        }
        break;
    }
    case ZYDIS_LETTER_CASE_UPPER:
    {
        const ZyanUSize index = destination->vector.size - 1;
        const ZyanUSize count = source->size;
        char* s = (char*)destination->vector.data + index;
        for(ZyanUSize i = index; i < index + count; ++i)
        {
            const char c = *s;
            if((c >= 'a') && (c <= 'z'))
            {
                *s = c & ~32;
            }
            ++s;
        }
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }

    destination->vector.size += source->size;
    ZYDIS_STRING_ASSERT_NULLTERMINATION(destination);

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Formatting                                                                                     */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Formats the given unsigned ordinal `value` to its decimal text-representation and
 * appends it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   value           The value to append.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   prefix          The string to use as prefix or `ZYAN_NULL`, if not needed.
 * @param   suffix          The string to use as suffix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZyanStatus ZydisStringAppendDecU(ZyanString* string, ZyanU64 value, ZyanU8 padding_length,
                                 const ZyanStringView* prefix, const ZyanStringView* suffix);

/**
 * Formats the given signed ordinal `value` to its decimal text-representation and
 * appends it to the `string`.
 *
 * @param   string          A pointer to the `ZyanString` instance.
 * @param   value           The value to append.
 * @param   padding_length  Padds the converted value with leading zeros, if the number of chars is
 *                          less than the `padding_length`.
 * @param   force_sign      Enable this option to print the `+` sign for positive numbers.
 * @param   prefix          The string to use as prefix or `ZYAN_NULL`, if not needed.
 * @param   suffix          The string to use as suffix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYAN_INLINE ZyanStatus ZydisStringAppendDecS(ZyanString* string, ZyanI64 value,
        ZyanU8 padding_length, ZyanBool force_sign, const ZyanStringView* prefix,
        const ZyanStringView* suffix)
{
    static const ZydisShortString str_add = ZYDIS_MAKE_SHORTSTRING("+");
    static const ZydisShortString str_sub = ZYDIS_MAKE_SHORTSTRING("-");

    if(value < 0)
    {
        ZYAN_CHECK(ZydisStringAppendShort(string, &str_sub));
        if(prefix)
        {
            ZYAN_CHECK(ZydisStringAppend(string, prefix));
        }
        return ZydisStringAppendDecU(string, ZyanAbsI64(value), padding_length,
                                     (const ZyanStringView*)ZYAN_NULL, suffix);
    }

    if(force_sign)
    {
        ZYAN_ASSERT(value >= 0);
        ZYAN_CHECK(ZydisStringAppendShort(string, &str_add));
    }
    return ZydisStringAppendDecU(string, value, padding_length, prefix, suffix);
}

/**
 * Formats the given unsigned ordinal `value` to its hexadecimal text-representation and
 * appends it to the `string`.
 *
 * @param   string                  A pointer to the `ZyanString` instance.
 * @param   value                   The value to append.
 * @param   padding_length          Pads the converted value with leading zeros if the number of
 *                                  chars is less than the `padding_length`.
 * @param   force_leading_number    Enable this option to prepend a leading `0` if the first
 *                                  character is non-numeric.
 * @param   uppercase               Enable this option to use uppercase letters ('A'-'F') instead
 *                                  of lowercase ones ('a'-'f').
 * @param   prefix                  The string to use as prefix or `ZYAN_NULL`, if not needed.
 * @param   suffix                  The string to use as suffix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail, if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZyanStatus ZydisStringAppendHexU(ZyanString* string, ZyanU64 value, ZyanU8 padding_length,
                                 ZyanBool force_leading_number, ZyanBool uppercase, const ZyanStringView* prefix,
                                 const ZyanStringView* suffix);

/**
 * Formats the given signed ordinal `value` to its hexadecimal text-representation and
 * appends it to the `string`.
 *
 * @param   string                  A pointer to the `ZyanString` instance.
 * @param   value                   The value to append.
 * @param   padding_length          Padds the converted value with leading zeros, if the number of
 *                                  chars is less than the `padding_length` (the sign char does not
 *                                  count).
 * @param   force_leading_number    Enable this option to prepend a leading `0`, if the first
 *                                  character is non-numeric.
 * @param   uppercase               Enable this option to use uppercase letters ('A'-'F') instead
 *                                  of lowercase ones ('a'-'f').
 * @param   force_sign              Enable this option to print the `+` sign for positive numbers.
 * @param   prefix                  The string to use as prefix or `ZYAN_NULL`, if not needed.
 * @param   suffix                  The string to use as suffix or `ZYAN_NULL`, if not needed.
 *
 * @return  A zyan status code.
 *
 * This function will fail if the `ZYAN_STRING_IS_IMMUTABLE` flag is set for the specified
 * `ZyanString` instance.
 */
ZYAN_INLINE ZyanStatus ZydisStringAppendHexS(ZyanString* string, ZyanI64 value,
        ZyanU8 padding_length, ZyanBool force_leading_number, ZyanBool uppercase, ZyanBool force_sign,
        const ZyanStringView* prefix, const ZyanStringView* suffix)
{
    static const ZydisShortString str_add = ZYDIS_MAKE_SHORTSTRING("+");
    static const ZydisShortString str_sub = ZYDIS_MAKE_SHORTSTRING("-");

    if(value < 0)
    {
        ZYAN_CHECK(ZydisStringAppendShort(string, &str_sub));
        if(prefix)
        {
            ZYAN_CHECK(ZydisStringAppend(string, prefix));
        }
        return ZydisStringAppendHexU(string, ZyanAbsI64(value), padding_length,
                                     force_leading_number, uppercase, (const ZyanStringView*)ZYAN_NULL, suffix);
    }

    if(force_sign)
    {
        ZYAN_ASSERT(value >= 0);
        ZYAN_CHECK(ZydisStringAppendShort(string, &str_add));
    }
    return ZydisStringAppendHexU(string, value, padding_length, force_leading_number, uppercase,
                                 prefix, suffix);
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif // ZYDIS_INTERNAL_STRING_H

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Token                                                                                          */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterTokenGetValue(const ZydisFormatterToken* token,
                                       ZydisTokenType* type, ZyanConstCharPointer* value)
{
    if(!token || !type || !value)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    *type = token->type;
    *value = (ZyanConstCharPointer)((ZyanU8*)token + sizeof(ZydisFormatterToken));

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterTokenNext(ZydisFormatterTokenConst** token)
{
    if(!token || !*token)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    const ZyanU8 next = (*token)->next;
    if(!next)
    {
        return ZYAN_STATUS_OUT_OF_RANGE;
    }
    *token = (ZydisFormatterTokenConst*)((ZyanU8*)*token + sizeof(ZydisFormatterToken) + next);

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Buffer                                                                                         */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBufferGetToken(const ZydisFormatterBuffer* buffer,
                                        ZydisFormatterTokenConst** token)
{
    if(!buffer || !token)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    *token = ((ZydisFormatterTokenConst*)buffer->string.vector.data - 1);
    if((*token)->type == ZYDIS_TOKEN_INVALID)
    {
        return ZYAN_STATUS_INVALID_OPERATION;
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBufferGetString(ZydisFormatterBuffer* buffer, ZyanString** string)
{
    if(!buffer || !string)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if(buffer->is_token_list &&
            ((ZydisFormatterTokenConst*)buffer->string.vector.data - 1)->type == ZYDIS_TOKEN_INVALID)
    {
        return ZYAN_STATUS_INVALID_OPERATION;
    }

    ZYAN_ASSERT(buffer->string.vector.data);
    ZYAN_ASSERT(buffer->string.vector.size);

    *string = &buffer->string;

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBufferAppend(ZydisFormatterBuffer* buffer, ZydisTokenType type)
{
    if(!buffer)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if(!buffer->is_token_list)
    {
        return ZYAN_STATUS_SUCCESS;
    }

    const ZyanUSize len = buffer->string.vector.size;
    ZYAN_ASSERT((len > 0) && (len < 256));
    if(buffer->capacity <= len + sizeof(ZydisFormatterToken))
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZydisFormatterToken* const last  = (ZydisFormatterToken*)buffer->string.vector.data - 1;
    last->next = (ZyanU8)len;

    const ZyanUSize delta = len + sizeof(ZydisFormatterToken);
    buffer->capacity -= delta;
    buffer->string.vector.data = (ZyanU8*)buffer->string.vector.data + delta;
    buffer->string.vector.size = 1;
    buffer->string.vector.capacity = ZYAN_MIN(buffer->capacity, 255);
    *(char*)buffer->string.vector.data = '\0';

    ZydisFormatterToken* const token = (ZydisFormatterToken*)buffer->string.vector.data - 1;
    token->type = type;
    token->next = 0;

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBufferRemember(const ZydisFormatterBuffer* buffer, ZyanUPointer* state)
{
    if(!buffer || !state)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if(buffer->is_token_list)
    {
        *state = (ZyanUPointer)buffer->string.vector.data;
    }
    else
    {
        *state = (ZyanUPointer)buffer->string.vector.size;
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBufferRestore(ZydisFormatterBuffer* buffer, ZyanUPointer state)
{
    if(!buffer)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if(buffer->is_token_list)
    {
        const ZyanUSize delta = (ZyanUPointer)buffer->string.vector.data - state;
        buffer->capacity += delta;
        buffer->string.vector.data = (void*)state;
        buffer->string.vector.size = 1; // TODO: Restore size?
        buffer->string.vector.capacity = ZYAN_MIN(buffer->capacity, 255);
        *(char*)buffer->string.vector.data = '\0';
    }
    else
    {
        buffer->string.vector.size = (ZyanUSize)state;
        ZYDIS_STRING_NULLTERMINATE(&buffer->string);
    }

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/String.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


/* ============================================================================================== */
/* Constants                                                                                      */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Defines                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

#define ZYDIS_MAXCHARS_DEC_32 10
#define ZYDIS_MAXCHARS_DEC_64 20
#define ZYDIS_MAXCHARS_HEX_32  8
#define ZYDIS_MAXCHARS_HEX_64 16

/* ---------------------------------------------------------------------------------------------- */
/* Lookup Tables                                                                                  */
/* ---------------------------------------------------------------------------------------------- */

static const char* const DECIMAL_LOOKUP =
    "00010203040506070809"
    "10111213141516171819"
    "20212223242526272829"
    "30313233343536373839"
    "40414243444546474849"
    "50515253545556575859"
    "60616263646566676869"
    "70717273747576777879"
    "80818283848586878889"
    "90919293949596979899";

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Internal Functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Decimal                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

#if defined(ZYAN_X86) || defined(ZYAN_ARM) || defined(ZYAN_EMSCRIPTEN) || defined(ZYAN_WASM) || defined(ZYAN_PPC)
ZyanStatus ZydisStringAppendDecU32(ZyanString* string, ZyanU32 value, ZyanU8 padding_length)
{
    ZYAN_ASSERT(string);
    ZYAN_ASSERT(!string->vector.allocator);

    char buffer[ZYDIS_MAXCHARS_DEC_32];
    char* buffer_end = &buffer[ZYDIS_MAXCHARS_DEC_32];
    char* buffer_write_pointer = buffer_end;
    while(value >= 100)
    {
        const ZyanU32 value_old = value;
        buffer_write_pointer -= 2;
        value /= 100;
        ZYAN_MEMCPY(buffer_write_pointer, &DECIMAL_LOOKUP[(value_old - (value * 100)) * 2], 2);
    }
    buffer_write_pointer -= 2;
    ZYAN_MEMCPY(buffer_write_pointer, &DECIMAL_LOOKUP[value * 2], 2);

    const ZyanUSize offset_odd    = (ZyanUSize)(value < 10);
    const ZyanUSize length_number = buffer_end - buffer_write_pointer - offset_odd;
    const ZyanUSize length_total  = ZYAN_MAX(length_number, padding_length);
    const ZyanUSize length_target = string->vector.size;

    if(string->vector.size + length_total > string->vector.capacity)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZyanUSize offset_write = 0;
    if(padding_length > length_number)
    {
        offset_write = padding_length - length_number;
        ZYAN_MEMSET((char*)string->vector.data + length_target - 1, '0', offset_write);
    }

    ZYAN_MEMCPY((char*)string->vector.data + length_target + offset_write - 1,
                buffer_write_pointer + offset_odd, length_number);
    string->vector.size = length_target + length_total;
    ZYDIS_STRING_NULLTERMINATE(string);

    return ZYAN_STATUS_SUCCESS;
}
#endif

ZyanStatus ZydisStringAppendDecU64(ZyanString* string, ZyanU64 value, ZyanU8 padding_length)
{
    ZYAN_ASSERT(string);
    ZYAN_ASSERT(!string->vector.allocator);

    char buffer[ZYDIS_MAXCHARS_DEC_64];
    char* buffer_end = &buffer[ZYDIS_MAXCHARS_DEC_64];
    char* buffer_write_pointer = buffer_end;
    while(value >= 100)
    {
        const ZyanU64 value_old = value;
        buffer_write_pointer -= 2;
        ZYAN_DIV64(value, 100);
        ZYAN_MEMCPY(buffer_write_pointer, &DECIMAL_LOOKUP[(value_old - (value * 100)) * 2], 2);
    }
    buffer_write_pointer -= 2;
    ZYAN_MEMCPY(buffer_write_pointer, &DECIMAL_LOOKUP[value * 2], 2);

    const ZyanUSize offset_odd    = (ZyanUSize)(value < 10);
    const ZyanUSize length_number = buffer_end - buffer_write_pointer - offset_odd;
    const ZyanUSize length_total  = ZYAN_MAX(length_number, padding_length);
    const ZyanUSize length_target = string->vector.size;

    if(string->vector.size + length_total > string->vector.capacity)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZyanUSize offset_write = 0;
    if(padding_length > length_number)
    {
        offset_write = padding_length - length_number;
        ZYAN_MEMSET((char*)string->vector.data + length_target - 1, '0', offset_write);
    }

    ZYAN_MEMCPY((char*)string->vector.data + length_target + offset_write - 1,
                buffer_write_pointer + offset_odd, length_number);
    string->vector.size = length_target + length_total;
    ZYDIS_STRING_NULLTERMINATE(string);

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Hexadecimal                                                                                    */
/* ---------------------------------------------------------------------------------------------- */

#if defined(ZYAN_X86) || defined(ZYAN_ARM) || defined(ZYAN_EMSCRIPTEN) || defined(ZYAN_WASM) || defined(ZYAN_PPC)
ZyanStatus ZydisStringAppendHexU32(ZyanString* string, ZyanU32 value, ZyanU8 padding_length,
                                   ZyanBool force_leading_number, ZyanBool uppercase)
{
    ZYAN_ASSERT(string);
    ZYAN_ASSERT(!string->vector.allocator);

    const ZyanUSize len = string->vector.size;
    const ZyanUSize remaining = string->vector.capacity - string->vector.size;

    if(remaining < (ZyanUSize)padding_length)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    if(!value)
    {
        const ZyanU8 n = (padding_length ? padding_length : 1);

        if(remaining < (ZyanUSize)n)
        {
            return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
        }

        ZYAN_MEMSET((char*)string->vector.data + len - 1, '0', n);
        string->vector.size = len + n;
        ZYDIS_STRING_NULLTERMINATE(string);

        return ZYAN_STATUS_SUCCESS;
    }

    ZyanU8 n = 0;
    char* buffer = ZYAN_NULL;
    for(ZyanI8 i = ZYDIS_MAXCHARS_HEX_32 - 1; i >= 0; --i)
    {
        const ZyanU8 v = (value >> i * 4) & 0x0F;
        if(!n)
        {
            if(!v)
            {
                continue;
            }
            const ZyanU8 zero = force_leading_number && (v > 9) && (padding_length <= i) ? 1 : 0;
            if(remaining <= (ZyanUSize)i + zero)
            {
                return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
            }
            buffer = (char*)string->vector.data + len - 1;
            if(zero)
            {
                buffer[n++] = '0';
            }
            if(padding_length > i)
            {
                n = padding_length - i - 1;
                ZYAN_MEMSET(buffer, '0', n);
            }
        }
        ZYAN_ASSERT(buffer);
        if(uppercase)
        {
            buffer[n++] = "0123456789ABCDEF"[v];
        }
        else
        {
            buffer[n++] = "0123456789abcdef"[v];
        }
    }
    string->vector.size = len + n;
    ZYDIS_STRING_NULLTERMINATE(string);

    return ZYAN_STATUS_SUCCESS;
}
#endif

ZyanStatus ZydisStringAppendHexU64(ZyanString* string, ZyanU64 value, ZyanU8 padding_length,
                                   ZyanBool force_leading_number, ZyanBool uppercase)
{
    ZYAN_ASSERT(string);
    ZYAN_ASSERT(!string->vector.allocator);

    const ZyanUSize len = string->vector.size;
    const ZyanUSize remaining = string->vector.capacity - string->vector.size;

    if(remaining < (ZyanUSize)padding_length)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    if(!value)
    {
        const ZyanU8 n = (padding_length ? padding_length : 1);

        if(remaining < (ZyanUSize)n)
        {
            return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
        }

        ZYAN_MEMSET((char*)string->vector.data + len - 1, '0', n);
        string->vector.size = len + n;
        ZYDIS_STRING_NULLTERMINATE(string);

        return ZYAN_STATUS_SUCCESS;
    }

    ZyanU8 n = 0;
    char* buffer = ZYAN_NULL;
    for(ZyanI8 i = ((value & 0xFFFFFFFF00000000) ?
                    ZYDIS_MAXCHARS_HEX_64 : ZYDIS_MAXCHARS_HEX_32) - 1; i >= 0; --i)
    {
        const ZyanU8 v = (value >> i * 4) & 0x0F;
        if(!n)
        {
            if(!v)
            {
                continue;
            }
            const ZyanU8 zero = force_leading_number && (v > 9) && (padding_length <= i) ? 1 : 0;
            if(remaining <= (ZyanUSize)i + zero)
            {
                return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
            }
            buffer = (char*)string->vector.data + len - 1;
            if(zero)
            {
                buffer[n++] = '0';
            }
            if(padding_length > i)
            {
                n = padding_length - i - 1;
                ZYAN_MEMSET(buffer, '0', n);
            }
        }
        ZYAN_ASSERT(buffer);
        if(uppercase)
        {
            buffer[n++] = "0123456789ABCDEF"[v];
        }
        else
        {
            buffer[n++] = "0123456789abcdef"[v];
        }
    }
    string->vector.size = len + n;
    ZYDIS_STRING_NULLTERMINATE(string);

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Public Functions                                                                               */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Formatting                                                                                     */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisStringAppendDecU(ZyanString* string, ZyanU64 value, ZyanU8 padding_length,
                                 const ZyanStringView* prefix, const ZyanStringView* suffix)
{
    if(prefix)
    {
        ZYAN_CHECK(ZydisStringAppend(string, prefix));
    }

#if defined(ZYAN_X64) || defined(ZYAN_AARCH64) || defined(ZYAN_PPC64) || defined(ZYAN_RISCV64)
    ZYAN_CHECK(ZydisStringAppendDecU64(string, value, padding_length));
#else
    if(value & 0xFFFFFFFF00000000)
    {
        ZYAN_CHECK(ZydisStringAppendDecU64(string, value, padding_length));
    }
    ZYAN_CHECK(ZydisStringAppendDecU32(string, (ZyanU32)value, padding_length));
#endif

    if(suffix)
    {
        return ZydisStringAppend(string, suffix);
    }
    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisStringAppendHexU(ZyanString* string, ZyanU64 value, ZyanU8 padding_length,
                                 ZyanBool force_leading_number, ZyanBool uppercase, const ZyanStringView* prefix,
                                 const ZyanStringView* suffix)
{
    if(prefix)
    {
        ZYAN_CHECK(ZydisStringAppend(string, prefix));
    }

#if defined(ZYAN_X64) || defined(ZYAN_AARCH64) || defined(ZYAN_PPC64) || defined(ZYAN_RISCV64)
    ZYAN_CHECK(ZydisStringAppendHexU64(string, value, padding_length, force_leading_number,
                                       uppercase));
#else
    if(value & 0xFFFFFFFF00000000)
    {
        ZYAN_CHECK(ZydisStringAppendHexU64(string, value, padding_length, force_leading_number,
                                           uppercase));
    }
    else
    {
        ZYAN_CHECK(ZydisStringAppendHexU32(string, (ZyanU32)value, padding_length,
                                           force_leading_number, uppercase));
    }
#endif

    if(suffix)
    {
        return ZydisStringAppend(string, suffix);
    }
    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/FormatterATT.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


//
// Header: Zydis/Internal/FormatterATT.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

/**
 * @file
 * Implements the `AT&T` style instruction-formatter.
 */

#ifndef ZYDIS_FORMATTER_ATT_H
#define ZYDIS_FORMATTER_ATT_H


//
// Header: Zydis/Internal/FormatterBase.h
//
// Include stack:
//   - Zydis/Internal/FormatterATT.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

/**
 * @file
 * Provides formatter functions that are shared between the different formatters.
 */

#ifndef ZYDIS_FORMATTER_BASE_H
#define ZYDIS_FORMATTER_BASE_H


#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Macros                                                                                         */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* String                                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Appends an unsigned numeric value to the given string.
 *
 * @param   formatter               A pointer to the `ZydisFormatter` instance.
 * @param   base                    The numeric base.
 * @param   str                     The destination string.
 * @param   value                   The value to append.
 * @param   padding_length          The padding length.
 * @param   force_leading_number    Enable this option to prepend a leading `0` if the first
 *                                  character is non-numeric.
 */
#define ZYDIS_STRING_APPEND_NUM_U(formatter, base, str, value, padding_length, \
    force_leading_number) \
    switch (base) \
    { \
    case ZYDIS_NUMERIC_BASE_DEC: \
        ZYAN_CHECK(ZydisStringAppendDecU(str, value, padding_length, \
            (formatter)->number_format[base][0].string, \
            (formatter)->number_format[base][1].string)); \
        break; \
    case ZYDIS_NUMERIC_BASE_HEX: \
        ZYAN_CHECK(ZydisStringAppendHexU(str, value, padding_length, force_leading_number, \
            (formatter)->hex_uppercase, \
            (formatter)->number_format[base][0].string, \
            (formatter)->number_format[base][1].string)); \
        break; \
    default: \
        return ZYAN_STATUS_INVALID_ARGUMENT; \
    }

/**
 * Appends a signed numeric value to the given string.
 *
 * @param   formatter               A pointer to the `ZydisFormatter` instance.
 * @param   base                    The numeric base.
 * @param   str                     The destination string.
 * @param   value                   The value to append.
 * @param   padding_length          The padding length.
 * @param   force_leading_number    Enable this option to prepend a leading `0`, if the first
 *                                  character is non-numeric.
 * @param   force_sign              Enable to print the '+' sign for positive numbers.
 */
#define ZYDIS_STRING_APPEND_NUM_S(formatter, base, str, value, padding_length, \
    force_leading_number, force_sign) \
    switch (base) \
    { \
    case ZYDIS_NUMERIC_BASE_DEC: \
        ZYAN_CHECK(ZydisStringAppendDecS(str, value, padding_length, force_sign, \
            (formatter)->number_format[base][0].string, \
            (formatter)->number_format[base][1].string)); \
        break; \
    case ZYDIS_NUMERIC_BASE_HEX: \
        ZYAN_CHECK(ZydisStringAppendHexS(str, value, padding_length, force_leading_number,  \
            (formatter)->hex_uppercase, force_sign, \
            (formatter)->number_format[base][0].string, \
            (formatter)->number_format[base][1].string)); \
        break; \
    default: \
        return ZYAN_STATUS_INVALID_ARGUMENT; \
    }

/* ---------------------------------------------------------------------------------------------- */
/* Buffer                                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Invokes the `ZydisFormatterBufferAppend` routine, if tokenization is enabled for the
 * current pass.
 *
 * @param   buffer  A pointer to the `ZydisFormatterBuffer` struct.
 * @param   type    The token type.
 *
 * Using this macro instead of direct calls to `ZydisFormatterBufferAppend` greatly improves the
 * performance for non-tokenizing passes.
 */
#define ZYDIS_BUFFER_APPEND_TOKEN(buffer, type) \
    if ((buffer)->is_token_list) \
    { \
        ZYAN_CHECK(ZydisFormatterBufferAppend(buffer, type)); \
    }

/**
 * Returns a snapshot of the buffer-state.
 *
 * @param   buffer  A pointer to the `ZydisFormatterBuffer` struct.
 * @param   state   Receives a snapshot of the buffer-state.
 *
 * Using this macro instead of direct calls to `ZydisFormatterBufferRemember` improves the
 * performance for non-tokenizing passes.
 */
#define ZYDIS_BUFFER_REMEMBER(buffer, state) \
    if ((buffer)->is_token_list) \
    { \
        (state) = (ZyanUPointer)(buffer)->string.vector.data; \
    } else \
    { \
        (state) = (ZyanUPointer)(buffer)->string.vector.size; \
    }

/**
 * Appends a string (`STR_`-prefix) or a predefined token-list (`TOK_`-prefix).
 *
 * @param   buffer  A pointer to the `ZydisFormatterBuffer` struct.
 * @param   name    The base name (without prefix) of the string- or token.
 */
#define ZYDIS_BUFFER_APPEND(buffer, name) \
    if ((buffer)->is_token_list) \
    { \
        ZYAN_CHECK(ZydisFormatterBufferAppendPredefined(buffer, TOK_ ## name)); \
    } else \
    { \
        ZYAN_CHECK(ZydisStringAppendShort(&buffer->string, &STR_ ## name)); \
    }

// TODO: Implement `letter_case` for predefined tokens

/**
 * Appends a string (`STR_`-prefix) or a predefined token-list (`TOK_`-prefix).
 *
 * @param   buffer      A pointer to the `ZydisFormatterBuffer` struct.
 * @param   name        The base name (without prefix) of the string- or token.
 * @param   letter_case The desired letter-case.
 */
#define ZYDIS_BUFFER_APPEND_CASE(buffer, name, letter_case) \
    if ((buffer)->is_token_list) \
    { \
        ZYAN_CHECK(ZydisFormatterBufferAppendPredefined(buffer, TOK_ ## name)); \
    } else \
    { \
        ZYAN_CHECK(ZydisStringAppendShortCase(&buffer->string, &STR_ ## name, letter_case)); \
    }

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Helper functions                                                                               */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Buffer                                                                                         */
/* ---------------------------------------------------------------------------------------------- */

// MSVC does not like the C99 flexible-array extension
#ifdef ZYAN_MSVC
#   pragma warning(push)
#   pragma warning(disable:4200)
#endif

#pragma pack(push, 1)

typedef struct ZydisPredefinedToken_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[];
} ZydisPredefinedToken;

#pragma pack(pop)

#ifdef ZYAN_MSVC
#   pragma warning(pop)
#endif

/**
 * Appends a predefined token-list to the `buffer`.
 *
 * @param   buffer  A pointer to the `ZydisFormatterBuffer` struct.
 * @param   data    A pointer to the `ZydisPredefinedToken` struct.
 *
 * @return  A zycore status code.
 *
 * This function is internally used to improve performance while adding static strings or multiple
 * tokens at once.
 */
ZYAN_INLINE ZyanStatus ZydisFormatterBufferAppendPredefined(ZydisFormatterBuffer* buffer,
        const ZydisPredefinedToken* data)
{
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(data);

    const ZyanUSize len = buffer->string.vector.size;
    ZYAN_ASSERT((len > 0) && (len < 256));
    if(buffer->capacity <= len + data->size)
    {
        return ZYAN_STATUS_INSUFFICIENT_BUFFER_SIZE;
    }

    ZydisFormatterToken* const last = (ZydisFormatterToken*)buffer->string.vector.data - 1;
    last->next = (ZyanU8)len;

    ZYAN_MEMCPY((ZyanU8*)buffer->string.vector.data + len, &data->data[0], data->size);

    const ZyanUSize delta = len + data->next;
    buffer->capacity -= delta;
    buffer->string.vector.data = (ZyanU8*)buffer->string.vector.data + delta;
    buffer->string.vector.size = data->size - data->next;
    buffer->string.vector.capacity = ZYAN_MIN(buffer->capacity, 255);

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* General                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Returns the size to be used as explicit size suffix (`AT&T`) or explicit typecast
 * (`INTEL`), if required.
 *
 * @param   formatter   A pointer to the `ZydisFormatter` instance.
 * @param   context     A pointer to the `ZydisFormatterContext` struct.
 * @param   operand     The instructions first memory operand.
 *
 * @return  Returns the explicit size, if required, or `0`, if not needed.
 *
 * This function always returns a size different to `0`, if the `ZYDIS_FORMATTER_PROP_FORCE_SIZE`
 * is set to `ZYAN_TRUE`.
 */
ZyanU32 ZydisFormatterHelperGetExplicitSize(const ZydisFormatter* formatter,
        ZydisFormatterContext* context, const ZydisDecodedOperand* operand);

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Formatter functions                                                                            */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Operands                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBaseFormatOperandREG(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterBaseFormatOperandPTR(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterBaseFormatOperandIMM(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

/* ---------------------------------------------------------------------------------------------- */
/* Elemental tokens                                                                               */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBasePrintAddressABS(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterBasePrintAddressREL(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterBasePrintIMM(const ZydisFormatter* formatter,
                                      ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

/* ---------------------------------------------------------------------------------------------- */
/* Optional tokens                                                                                */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBasePrintSegment(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterBasePrintPrefixes(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterBasePrintDecorator(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context, ZydisDecorator decorator);

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif // ZYDIS_FORMATTER_BASE_H

#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Formatter functions                                                                            */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Instruction                                                                                    */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterATTFormatInstruction(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

/* ---------------------------------------------------------------------------------------------- */
/* Operands                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterATTFormatOperandMEM(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

/* ---------------------------------------------------------------------------------------------- */
/* Elemental tokens                                                                               */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterATTPrintMnemonic(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterATTPrintRegister(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context, ZydisRegister reg);

ZyanStatus ZydisFormatterATTPrintAddressABS(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterATTPrintDISP(const ZydisFormatter* formatter,
                                      ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

ZyanStatus ZydisFormatterATTPrintIMM(const ZydisFormatter* formatter,
                                     ZydisFormatterBuffer* buffer, ZydisFormatterContext* context);

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Fomatter presets                                                                               */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* AT&T                                                                                           */
/* ---------------------------------------------------------------------------------------------- */

/**
 * The default formatter configuration for `AT&T` style disassembly.
 */
static const ZydisFormatter FORMATTER_ATT =
{
    /* style                    */ ZYDIS_FORMATTER_STYLE_ATT,
    /* force_memory_size        */ ZYAN_FALSE,
    /* force_memory_seg         */ ZYAN_FALSE,
    /* force_memory_scale       */ ZYAN_TRUE,
    /* force_relative_branches  */ ZYAN_FALSE,
    /* force_relative_riprel    */ ZYAN_FALSE,
    /* print_branch_size        */ ZYAN_FALSE,
    /* detailed_prefixes        */ ZYAN_FALSE,
    /* addr_base                */ ZYDIS_NUMERIC_BASE_HEX,
    /* addr_signedness          */ ZYDIS_SIGNEDNESS_SIGNED,
    /* addr_padding_absolute    */ ZYDIS_PADDING_AUTO,
    /* addr_padding_relative    */ 2,
    /* disp_base                */ ZYDIS_NUMERIC_BASE_HEX,
    /* disp_signedness          */ ZYDIS_SIGNEDNESS_SIGNED,
    /* disp_padding             */ 2,
    /* imm_base                 */ ZYDIS_NUMERIC_BASE_HEX,
    /* imm_signedness           */ ZYDIS_SIGNEDNESS_AUTO,
    /* imm_padding              */ 2,
    /* case_prefixes            */ ZYDIS_LETTER_CASE_DEFAULT,
    /* case_mnemonic            */ ZYDIS_LETTER_CASE_DEFAULT,
    /* case_registers           */ ZYDIS_LETTER_CASE_DEFAULT,
    /* case_typecasts           */ ZYDIS_LETTER_CASE_DEFAULT,
    /* case_decorators          */ ZYDIS_LETTER_CASE_DEFAULT,
    /* hex_uppercase            */ ZYAN_TRUE,
    /* hex_force_leading_number */ ZYAN_FALSE,
    /* number_format            */
    {
        // ZYDIS_NUMERIC_BASE_DEC
        {
            // Prefix
            {
                /* string       */ ZYAN_NULL,
                /* string_data  */ ZYAN_DEFINE_STRING_VIEW(""),
                /* buffer       */ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
            },
            // Suffix
            {
                /* string       */ ZYAN_NULL,
                /* string_data  */ ZYAN_DEFINE_STRING_VIEW(""),
                /* buffer       */ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
            }
        },
        // ZYDIS_NUMERIC_BASE_HEX
        {
            // Prefix
            {
                /* string       */ &FORMATTER_ATT.number_format[
                    ZYDIS_NUMERIC_BASE_HEX][0].string_data,
                /* string_data  */ ZYAN_DEFINE_STRING_VIEW("0x"),
                /* buffer       */ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
            },
            // Suffix
            {
                /* string       */ ZYAN_NULL,
                /* string_data  */ ZYAN_DEFINE_STRING_VIEW(""),
                /* buffer       */ { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
            }
        }
    },
    /* func_pre_instruction     */ ZYAN_NULL,
    /* func_post_instruction    */ ZYAN_NULL,
    /* func_format_instruction  */ &ZydisFormatterATTFormatInstruction,
    /* func_pre_operand         */ ZYAN_NULL,
    /* func_post_operand        */ ZYAN_NULL,
    /* func_format_operand_reg  */ &ZydisFormatterBaseFormatOperandREG,
    /* func_format_operand_mem  */ &ZydisFormatterATTFormatOperandMEM,
    /* func_format_operand_ptr  */ &ZydisFormatterBaseFormatOperandPTR,
    /* func_format_operand_imm  */ &ZydisFormatterBaseFormatOperandIMM,
    /* func_print_mnemonic      */ &ZydisFormatterATTPrintMnemonic,
    /* func_print_register      */ &ZydisFormatterATTPrintRegister,
    /* func_print_address_abs   */ &ZydisFormatterATTPrintAddressABS,
    /* func_print_address_rel   */ &ZydisFormatterBasePrintAddressREL,
    /* func_print_disp          */ &ZydisFormatterATTPrintDISP,
    /* func_print_imm           */ &ZydisFormatterATTPrintIMM,
    /* func_print_typecast      */ ZYAN_NULL,
    /* func_print_segment       */ &ZydisFormatterBasePrintSegment,
    /* func_print_prefixes      */ &ZydisFormatterBasePrintPrefixes,
    /* func_print_decorator     */ &ZydisFormatterBasePrintDecorator
};

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif // ZYDIS_FORMATTER_ATT_H

/* ============================================================================================== */
/* Constants                                                                                      */
/* ============================================================================================== */


//
// Header: Generated/FormatterStrings.inc
//

#pragma pack(push, 1)

static const ZydisShortString STR_ADD = ZYDIS_MAKE_SHORTSTRING("+");
static const struct ZydisPredefinedTokenADD_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_ADD = { 4, 2, { ZYDIS_TOKEN_DELIMITER, 0, '+', '\0' } };
static const ZydisPredefinedToken* const TOK_ADD = (const ZydisPredefinedToken* const) & TOK_DATA_ADD;

static const ZydisShortString STR_ADDR_RELATIVE = ZYDIS_MAKE_SHORTSTRING("$");
static const struct ZydisPredefinedTokenADDR_RELATIVE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_ADDR_RELATIVE = { 4, 2, { ZYDIS_TOKEN_ADDRESS_REL, 0, '$', '\0' } };
static const ZydisPredefinedToken* const TOK_ADDR_RELATIVE = (const ZydisPredefinedToken* const) & TOK_DATA_ADDR_RELATIVE;

static const ZydisShortString STR_DECO_1TO2 = ZYDIS_MAKE_SHORTSTRING(" {1to2}");
static const struct ZydisPredefinedTokenDECO_1TO2_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_1TO2 = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, '1', 't', 'o', '2', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_1TO2 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_1TO2;

static const ZydisShortString STR_DECO_1TO4 = ZYDIS_MAKE_SHORTSTRING(" {1to4}");
static const struct ZydisPredefinedTokenDECO_1TO4_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_1TO4 = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, '1', 't', 'o', '4', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_1TO4 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_1TO4;

static const ZydisShortString STR_DECO_1TO8 = ZYDIS_MAKE_SHORTSTRING(" {1to8}");
static const struct ZydisPredefinedTokenDECO_1TO8_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_1TO8 = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, '1', 't', 'o', '8', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_1TO8 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_1TO8;

static const ZydisShortString STR_DECO_1TO16 = ZYDIS_MAKE_SHORTSTRING(" {1to16}");
static const struct ZydisPredefinedTokenDECO_1TO16_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_1TO16 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, '1', 't', 'o', '1', '6', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_1TO16 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_1TO16;

static const ZydisShortString STR_DECO_1TO32 = ZYDIS_MAKE_SHORTSTRING(" {1to32}");
static const struct ZydisPredefinedTokenDECO_1TO32_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_1TO32 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, '1', 't', 'o', '3', '2', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_1TO32 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_1TO32;

static const ZydisShortString STR_DECO_1TO64 = ZYDIS_MAKE_SHORTSTRING(" {1to64}");
static const struct ZydisPredefinedTokenDECO_1TO64_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_1TO64 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, '1', 't', 'o', '6', '4', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_1TO64 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_1TO64;

static const ZydisShortString STR_DECO_4TO8 = ZYDIS_MAKE_SHORTSTRING(" {4to8}");
static const struct ZydisPredefinedTokenDECO_4TO8_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_4TO8 = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, '4', 't', 'o', '8', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_4TO8 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_4TO8;

static const ZydisShortString STR_DECO_4TO16 = ZYDIS_MAKE_SHORTSTRING(" {4to16}");
static const struct ZydisPredefinedTokenDECO_4TO16_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_4TO16 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, '4', 't', 'o', '1', '6', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_4TO16 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_4TO16;

static const ZydisShortString STR_DECO_8TO16 = ZYDIS_MAKE_SHORTSTRING(" {8to16}");
static const struct ZydisPredefinedTokenDECO_8TO16_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_8TO16 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, '8', 't', 'o', '1', '6', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_8TO16 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_8TO16;

static const ZydisShortString STR_DECO_AAAA = ZYDIS_MAKE_SHORTSTRING(" {aaaa}");
static const struct ZydisPredefinedTokenDECO_AAAA_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_AAAA = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'a', 'a', 'a', 'a', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_AAAA = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_AAAA;

static const ZydisShortString STR_DECO_BADC = ZYDIS_MAKE_SHORTSTRING(" {badc}");
static const struct ZydisPredefinedTokenDECO_BADC_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_BADC = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'b', 'a', 'd', 'c', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_BADC = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_BADC;

static const ZydisShortString STR_DECO_BBBB = ZYDIS_MAKE_SHORTSTRING(" {bbbb}");
static const struct ZydisPredefinedTokenDECO_BBBB_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_BBBB = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'b', 'b', 'b', 'b', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_BBBB = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_BBBB;

static const ZydisShortString STR_DECO_BEGIN = ZYDIS_MAKE_SHORTSTRING(" {");
static const struct ZydisPredefinedTokenDECO_BEGIN_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[8];
} TOK_DATA_DECO_BEGIN = { 8, 6, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 0, '{', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_BEGIN = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_BEGIN;

static const ZydisShortString STR_DECO_CCCC = ZYDIS_MAKE_SHORTSTRING(" {cccc}");
static const struct ZydisPredefinedTokenDECO_CCCC_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_CCCC = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'c', 'c', 'c', 'c', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_CCCC = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_CCCC;

static const ZydisShortString STR_DECO_CDAB = ZYDIS_MAKE_SHORTSTRING(" {cdab}");
static const struct ZydisPredefinedTokenDECO_CDAB_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_CDAB = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'c', 'd', 'a', 'b', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_CDAB = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_CDAB;

static const ZydisShortString STR_DECO_DACB = ZYDIS_MAKE_SHORTSTRING(" {dacb}");
static const struct ZydisPredefinedTokenDECO_DACB_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_DACB = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'd', 'a', 'c', 'b', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_DACB = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_DACB;

static const ZydisShortString STR_DECO_DDDD = ZYDIS_MAKE_SHORTSTRING(" {dddd}");
static const struct ZydisPredefinedTokenDECO_DDDD_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[19];
} TOK_DATA_DECO_DDDD = { 19, 17, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 5, 'd', 'd', 'd', 'd', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_DDDD = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_DDDD;

static const ZydisShortString STR_DECO_EH = ZYDIS_MAKE_SHORTSTRING(" {eh}");
static const struct ZydisPredefinedTokenDECO_EH_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[17];
} TOK_DATA_DECO_EH = { 17, 15, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 3, 'e', 'h', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_EH = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_EH;

static const ZydisShortString STR_DECO_END = ZYDIS_MAKE_SHORTSTRING("}");
static const struct ZydisPredefinedTokenDECO_END_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_DECO_END = { 4, 2, { ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_END = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_END;

static const ZydisShortString STR_DECO_FLOAT16 = ZYDIS_MAKE_SHORTSTRING(" {float16}");
static const struct ZydisPredefinedTokenDECO_FLOAT16_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[22];
} TOK_DATA_DECO_FLOAT16 = { 22, 20, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 8, 'f', 'l', 'o', 'a', 't', '1', '6', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_FLOAT16 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_FLOAT16;

static const ZydisShortString STR_DECO_RD = ZYDIS_MAKE_SHORTSTRING(" {rd}");
static const struct ZydisPredefinedTokenDECO_RD_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[17];
} TOK_DATA_DECO_RD = { 17, 15, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 3, 'r', 'd', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RD = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RD;

static const ZydisShortString STR_DECO_RD_SAE = ZYDIS_MAKE_SHORTSTRING(" {rd-sae}");
static const struct ZydisPredefinedTokenDECO_RD_SAE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[21];
} TOK_DATA_DECO_RD_SAE = { 21, 19, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 7, 'r', 'd', '-', 's', 'a', 'e', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RD_SAE = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RD_SAE;

static const ZydisShortString STR_DECO_RN = ZYDIS_MAKE_SHORTSTRING(" {rn}");
static const struct ZydisPredefinedTokenDECO_RN_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[17];
} TOK_DATA_DECO_RN = { 17, 15, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 3, 'r', 'n', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RN = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RN;

static const ZydisShortString STR_DECO_RN_SAE = ZYDIS_MAKE_SHORTSTRING(" {rn-sae}");
static const struct ZydisPredefinedTokenDECO_RN_SAE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[21];
} TOK_DATA_DECO_RN_SAE = { 21, 19, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 7, 'r', 'n', '-', 's', 'a', 'e', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RN_SAE = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RN_SAE;

static const ZydisShortString STR_DECO_RU = ZYDIS_MAKE_SHORTSTRING(" {ru}");
static const struct ZydisPredefinedTokenDECO_RU_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[17];
} TOK_DATA_DECO_RU = { 17, 15, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 3, 'r', 'u', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RU = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RU;

static const ZydisShortString STR_DECO_RU_SAE = ZYDIS_MAKE_SHORTSTRING(" {ru-sae}");
static const struct ZydisPredefinedTokenDECO_RU_SAE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[21];
} TOK_DATA_DECO_RU_SAE = { 21, 19, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 7, 'r', 'u', '-', 's', 'a', 'e', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RU_SAE = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RU_SAE;

static const ZydisShortString STR_DECO_RZ = ZYDIS_MAKE_SHORTSTRING(" {rz}");
static const struct ZydisPredefinedTokenDECO_RZ_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[17];
} TOK_DATA_DECO_RZ = { 17, 15, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 3, 'r', 'z', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RZ = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RZ;

static const ZydisShortString STR_DECO_RZ_SAE = ZYDIS_MAKE_SHORTSTRING(" {rz-sae}");
static const struct ZydisPredefinedTokenDECO_RZ_SAE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[21];
} TOK_DATA_DECO_RZ_SAE = { 21, 19, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 7, 'r', 'z', '-', 's', 'a', 'e', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_RZ_SAE = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_RZ_SAE;

static const ZydisShortString STR_DECO_SAE = ZYDIS_MAKE_SHORTSTRING(" {sae}");
static const struct ZydisPredefinedTokenDECO_SAE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[18];
} TOK_DATA_DECO_SAE = { 18, 16, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 4, 's', 'a', 'e', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_SAE = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_SAE;

static const ZydisShortString STR_DECO_SINT8 = ZYDIS_MAKE_SHORTSTRING(" {sint8}");
static const struct ZydisPredefinedTokenDECO_SINT8_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_SINT8 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, 's', 'i', 'n', 't', '8', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_SINT8 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_SINT8;

static const ZydisShortString STR_DECO_SINT16 = ZYDIS_MAKE_SHORTSTRING(" {sint16}");
static const struct ZydisPredefinedTokenDECO_SINT16_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[21];
} TOK_DATA_DECO_SINT16 = { 21, 19, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 7, 's', 'i', 'n', 't', '1', '6', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_SINT16 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_SINT16;

static const ZydisShortString STR_DECO_UINT8 = ZYDIS_MAKE_SHORTSTRING(" {uint8}");
static const struct ZydisPredefinedTokenDECO_UINT8_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[20];
} TOK_DATA_DECO_UINT8 = { 20, 18, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 6, 'u', 'i', 'n', 't', '8', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_UINT8 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_UINT8;

static const ZydisShortString STR_DECO_UINT16 = ZYDIS_MAKE_SHORTSTRING(" {uint16}");
static const struct ZydisPredefinedTokenDECO_UINT16_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[21];
} TOK_DATA_DECO_UINT16 = { 21, 19, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 7, 'u', 'i', 'n', 't', '1', '6', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_UINT16 = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_UINT16;

static const ZydisShortString STR_DECO_ZERO = ZYDIS_MAKE_SHORTSTRING(" {z}");
static const struct ZydisPredefinedTokenDECO_ZERO_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[16];
} TOK_DATA_DECO_ZERO = { 16, 14, { ZYDIS_TOKEN_WHITESPACE, 2, ' ', '\0', ZYDIS_TOKEN_PARENTHESIS_OPEN, 2, '{', '\0', ZYDIS_TOKEN_DECORATOR, 2, 'z', '\0', ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, '}', '\0' } };
static const ZydisPredefinedToken* const TOK_DECO_ZERO = (const ZydisPredefinedToken* const) & TOK_DATA_DECO_ZERO;

static const ZydisShortString STR_DELIM_MEMORY = ZYDIS_MAKE_SHORTSTRING(",");
static const struct ZydisPredefinedTokenDELIM_MEMORY_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_DELIM_MEMORY = { 4, 2, { ZYDIS_TOKEN_DELIMITER, 0, ',', '\0' } };
static const ZydisPredefinedToken* const TOK_DELIM_MEMORY = (const ZydisPredefinedToken* const) & TOK_DATA_DELIM_MEMORY;

static const ZydisShortString STR_DELIM_MNEMONIC = ZYDIS_MAKE_SHORTSTRING(" ");
static const struct ZydisPredefinedTokenDELIM_MNEMONIC_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_DELIM_MNEMONIC = { 4, 2, { ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_DELIM_MNEMONIC = (const ZydisPredefinedToken* const) & TOK_DATA_DELIM_MNEMONIC;

static const ZydisShortString STR_DELIM_OPERAND = ZYDIS_MAKE_SHORTSTRING(", ");
static const struct ZydisPredefinedTokenDELIM_OPERAND_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[8];
} TOK_DATA_DELIM_OPERAND = { 8, 6, { ZYDIS_TOKEN_DELIMITER, 2, ',', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_DELIM_OPERAND = (const ZydisPredefinedToken* const) & TOK_DATA_DELIM_OPERAND;

static const ZydisShortString STR_DELIM_SEGMENT = ZYDIS_MAKE_SHORTSTRING(":");
static const struct ZydisPredefinedTokenDELIM_SEGMENT_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_DELIM_SEGMENT = { 4, 2, { ZYDIS_TOKEN_DELIMITER, 0, ':', '\0' } };
static const ZydisPredefinedToken* const TOK_DELIM_SEGMENT = (const ZydisPredefinedToken* const) & TOK_DATA_DELIM_SEGMENT;

static const ZydisShortString STR_FAR = ZYDIS_MAKE_SHORTSTRING(" far");
static const ZydisShortString STR_FAR_ATT = ZYDIS_MAKE_SHORTSTRING("l");
static const ZydisShortString STR_IMMEDIATE = ZYDIS_MAKE_SHORTSTRING("$");
static const struct ZydisPredefinedTokenIMMEDIATE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_IMMEDIATE = { 4, 2, { ZYDIS_TOKEN_IMMEDIATE, 0, '$', '\0' } };
static const ZydisPredefinedToken* const TOK_IMMEDIATE = (const ZydisPredefinedToken* const) & TOK_DATA_IMMEDIATE;

static const ZydisShortString STR_INVALID_MNEMONIC = ZYDIS_MAKE_SHORTSTRING("invalid");
static const struct ZydisPredefinedTokenINVALID_MNEMONIC_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[10];
} TOK_DATA_INVALID_MNEMONIC = { 10, 2, { ZYDIS_TOKEN_MNEMONIC, 0, 'i', 'n', 'v', 'a', 'l', 'i', 'd', '\0' } };
static const ZydisPredefinedToken* const TOK_INVALID_MNEMONIC = (const ZydisPredefinedToken* const) & TOK_DATA_INVALID_MNEMONIC;

static const ZydisShortString STR_INVALID_REG = ZYDIS_MAKE_SHORTSTRING("invalid");
static const struct ZydisPredefinedTokenINVALID_REG_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[10];
} TOK_DATA_INVALID_REG = { 10, 2, { ZYDIS_TOKEN_REGISTER, 0, 'i', 'n', 'v', 'a', 'l', 'i', 'd', '\0' } };
static const ZydisPredefinedToken* const TOK_INVALID_REG = (const ZydisPredefinedToken* const) & TOK_DATA_INVALID_REG;

static const ZydisShortString STR_MEMORY_BEGIN_ATT = ZYDIS_MAKE_SHORTSTRING("(");
static const struct ZydisPredefinedTokenMEMORY_BEGIN_ATT_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_MEMORY_BEGIN_ATT = { 4, 2, { ZYDIS_TOKEN_PARENTHESIS_OPEN, 0, '(', '\0' } };
static const ZydisPredefinedToken* const TOK_MEMORY_BEGIN_ATT = (const ZydisPredefinedToken* const) & TOK_DATA_MEMORY_BEGIN_ATT;

static const ZydisShortString STR_MEMORY_BEGIN_INTEL = ZYDIS_MAKE_SHORTSTRING("[");
static const struct ZydisPredefinedTokenMEMORY_BEGIN_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_MEMORY_BEGIN_INTEL = { 4, 2, { ZYDIS_TOKEN_PARENTHESIS_OPEN, 0, '[', '\0' } };
static const ZydisPredefinedToken* const TOK_MEMORY_BEGIN_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_MEMORY_BEGIN_INTEL;

static const ZydisShortString STR_MEMORY_END_ATT = ZYDIS_MAKE_SHORTSTRING(")");
static const struct ZydisPredefinedTokenMEMORY_END_ATT_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_MEMORY_END_ATT = { 4, 2, { ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, ')', '\0' } };
static const ZydisPredefinedToken* const TOK_MEMORY_END_ATT = (const ZydisPredefinedToken* const) & TOK_DATA_MEMORY_END_ATT;

static const ZydisShortString STR_MEMORY_END_INTEL = ZYDIS_MAKE_SHORTSTRING("]");
static const struct ZydisPredefinedTokenMEMORY_END_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_MEMORY_END_INTEL = { 4, 2, { ZYDIS_TOKEN_PARENTHESIS_CLOSE, 0, ']', '\0' } };
static const ZydisPredefinedToken* const TOK_MEMORY_END_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_MEMORY_END_INTEL;

static const ZydisShortString STR_MUL = ZYDIS_MAKE_SHORTSTRING("*");
static const struct ZydisPredefinedTokenMUL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_MUL = { 4, 2, { ZYDIS_TOKEN_DELIMITER, 0, '*', '\0' } };
static const ZydisPredefinedToken* const TOK_MUL = (const ZydisPredefinedToken* const) & TOK_DATA_MUL;

static const ZydisShortString STR_NEAR = ZYDIS_MAKE_SHORTSTRING(" near");
static const ZydisShortString STR_PREF_BND = ZYDIS_MAKE_SHORTSTRING("bnd ");
static const struct ZydisPredefinedTokenPREF_BND_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[10];
} TOK_DATA_PREF_BND = { 10, 8, { ZYDIS_TOKEN_PREFIX, 4, 'b', 'n', 'd', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_BND = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_BND;

static const ZydisShortString STR_PREF_LOCK = ZYDIS_MAKE_SHORTSTRING("lock ");
static const struct ZydisPredefinedTokenPREF_LOCK_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[11];
} TOK_DATA_PREF_LOCK = { 11, 9, { ZYDIS_TOKEN_PREFIX, 5, 'l', 'o', 'c', 'k', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_LOCK = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_LOCK;

static const ZydisShortString STR_PREF_REP = ZYDIS_MAKE_SHORTSTRING("rep ");
static const struct ZydisPredefinedTokenPREF_REP_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[10];
} TOK_DATA_PREF_REP = { 10, 8, { ZYDIS_TOKEN_PREFIX, 4, 'r', 'e', 'p', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REP = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REP;

static const ZydisShortString STR_PREF_REPE = ZYDIS_MAKE_SHORTSTRING("repe ");
static const struct ZydisPredefinedTokenPREF_REPE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[11];
} TOK_DATA_PREF_REPE = { 11, 9, { ZYDIS_TOKEN_PREFIX, 5, 'r', 'e', 'p', 'e', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REPE = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REPE;

static const ZydisShortString STR_PREF_REPNE = ZYDIS_MAKE_SHORTSTRING("repne ");
static const struct ZydisPredefinedTokenPREF_REPNE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[12];
} TOK_DATA_PREF_REPNE = { 12, 10, { ZYDIS_TOKEN_PREFIX, 6, 'r', 'e', 'p', 'n', 'e', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REPNE = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REPNE;

static const ZydisShortString STR_PREF_REX_4A = ZYDIS_MAKE_SHORTSTRING("rex.wx ");
static const struct ZydisPredefinedTokenPREF_REX_4A_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[13];
} TOK_DATA_PREF_REX_4A = { 13, 11, { ZYDIS_TOKEN_PREFIX, 7, 'r', 'e', 'x', '.', 'w', 'x', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_4A = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_4A;

static const ZydisShortString STR_PREF_REX_4B = ZYDIS_MAKE_SHORTSTRING("rex.wxb ");
static const struct ZydisPredefinedTokenPREF_REX_4B_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[14];
} TOK_DATA_PREF_REX_4B = { 14, 12, { ZYDIS_TOKEN_PREFIX, 8, 'r', 'e', 'x', '.', 'w', 'x', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_4B = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_4B;

static const ZydisShortString STR_PREF_REX_4C = ZYDIS_MAKE_SHORTSTRING("rex.wr ");
static const struct ZydisPredefinedTokenPREF_REX_4C_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[13];
} TOK_DATA_PREF_REX_4C = { 13, 11, { ZYDIS_TOKEN_PREFIX, 7, 'r', 'e', 'x', '.', 'w', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_4C = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_4C;

static const ZydisShortString STR_PREF_REX_4D = ZYDIS_MAKE_SHORTSTRING("rex.wrb ");
static const struct ZydisPredefinedTokenPREF_REX_4D_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[14];
} TOK_DATA_PREF_REX_4D = { 14, 12, { ZYDIS_TOKEN_PREFIX, 8, 'r', 'e', 'x', '.', 'w', 'r', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_4D = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_4D;

static const ZydisShortString STR_PREF_REX_4E = ZYDIS_MAKE_SHORTSTRING("rex.wrx ");
static const struct ZydisPredefinedTokenPREF_REX_4E_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[14];
} TOK_DATA_PREF_REX_4E = { 14, 12, { ZYDIS_TOKEN_PREFIX, 8, 'r', 'e', 'x', '.', 'w', 'r', 'x', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_4E = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_4E;

static const ZydisShortString STR_PREF_REX_4F = ZYDIS_MAKE_SHORTSTRING("rex.wrxb ");
static const struct ZydisPredefinedTokenPREF_REX_4F_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[15];
} TOK_DATA_PREF_REX_4F = { 15, 13, { ZYDIS_TOKEN_PREFIX, 9, 'r', 'e', 'x', '.', 'w', 'r', 'x', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_4F = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_4F;

static const ZydisShortString STR_PREF_REX_40 = ZYDIS_MAKE_SHORTSTRING("rex ");
static const struct ZydisPredefinedTokenPREF_REX_40_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[10];
} TOK_DATA_PREF_REX_40 = { 10, 8, { ZYDIS_TOKEN_PREFIX, 4, 'r', 'e', 'x', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_40 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_40;

static const ZydisShortString STR_PREF_REX_41 = ZYDIS_MAKE_SHORTSTRING("rex.b ");
static const struct ZydisPredefinedTokenPREF_REX_41_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[12];
} TOK_DATA_PREF_REX_41 = { 12, 10, { ZYDIS_TOKEN_PREFIX, 6, 'r', 'e', 'x', '.', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_41 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_41;

static const ZydisShortString STR_PREF_REX_42 = ZYDIS_MAKE_SHORTSTRING("rex.x ");
static const struct ZydisPredefinedTokenPREF_REX_42_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[12];
} TOK_DATA_PREF_REX_42 = { 12, 10, { ZYDIS_TOKEN_PREFIX, 6, 'r', 'e', 'x', '.', 'x', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_42 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_42;

static const ZydisShortString STR_PREF_REX_43 = ZYDIS_MAKE_SHORTSTRING("rex.xb ");
static const struct ZydisPredefinedTokenPREF_REX_43_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[13];
} TOK_DATA_PREF_REX_43 = { 13, 11, { ZYDIS_TOKEN_PREFIX, 7, 'r', 'e', 'x', '.', 'x', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_43 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_43;

static const ZydisShortString STR_PREF_REX_44 = ZYDIS_MAKE_SHORTSTRING("rex.r ");
static const struct ZydisPredefinedTokenPREF_REX_44_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[12];
} TOK_DATA_PREF_REX_44 = { 12, 10, { ZYDIS_TOKEN_PREFIX, 6, 'r', 'e', 'x', '.', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_44 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_44;

static const ZydisShortString STR_PREF_REX_45 = ZYDIS_MAKE_SHORTSTRING("rex.rb ");
static const struct ZydisPredefinedTokenPREF_REX_45_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[13];
} TOK_DATA_PREF_REX_45 = { 13, 11, { ZYDIS_TOKEN_PREFIX, 7, 'r', 'e', 'x', '.', 'r', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_45 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_45;

static const ZydisShortString STR_PREF_REX_46 = ZYDIS_MAKE_SHORTSTRING("rex.rx ");
static const struct ZydisPredefinedTokenPREF_REX_46_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[13];
} TOK_DATA_PREF_REX_46 = { 13, 11, { ZYDIS_TOKEN_PREFIX, 7, 'r', 'e', 'x', '.', 'r', 'x', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_46 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_46;

static const ZydisShortString STR_PREF_REX_47 = ZYDIS_MAKE_SHORTSTRING("rex.rxb ");
static const struct ZydisPredefinedTokenPREF_REX_47_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[14];
} TOK_DATA_PREF_REX_47 = { 14, 12, { ZYDIS_TOKEN_PREFIX, 8, 'r', 'e', 'x', '.', 'r', 'x', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_47 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_47;

static const ZydisShortString STR_PREF_REX_48 = ZYDIS_MAKE_SHORTSTRING("rex.w ");
static const struct ZydisPredefinedTokenPREF_REX_48_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[12];
} TOK_DATA_PREF_REX_48 = { 12, 10, { ZYDIS_TOKEN_PREFIX, 6, 'r', 'e', 'x', '.', 'w', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_48 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_48;

static const ZydisShortString STR_PREF_REX_49 = ZYDIS_MAKE_SHORTSTRING("rex.wb ");
static const struct ZydisPredefinedTokenPREF_REX_49_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[13];
} TOK_DATA_PREF_REX_49 = { 13, 11, { ZYDIS_TOKEN_PREFIX, 7, 'r', 'e', 'x', '.', 'w', 'b', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_REX_49 = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_REX_49;

static const ZydisShortString STR_PREF_SEG_CS = ZYDIS_MAKE_SHORTSTRING("cs ");
static const struct ZydisPredefinedTokenPREF_SEG_CS_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[9];
} TOK_DATA_PREF_SEG_CS = { 9, 7, { ZYDIS_TOKEN_PREFIX, 3, 'c', 's', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_SEG_CS = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_SEG_CS;

static const ZydisShortString STR_PREF_SEG_DS = ZYDIS_MAKE_SHORTSTRING("ds ");
static const struct ZydisPredefinedTokenPREF_SEG_DS_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[9];
} TOK_DATA_PREF_SEG_DS = { 9, 7, { ZYDIS_TOKEN_PREFIX, 3, 'd', 's', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_SEG_DS = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_SEG_DS;

static const ZydisShortString STR_PREF_SEG_ES = ZYDIS_MAKE_SHORTSTRING("es ");
static const struct ZydisPredefinedTokenPREF_SEG_ES_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[9];
} TOK_DATA_PREF_SEG_ES = { 9, 7, { ZYDIS_TOKEN_PREFIX, 3, 'e', 's', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_SEG_ES = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_SEG_ES;

static const ZydisShortString STR_PREF_SEG_FS = ZYDIS_MAKE_SHORTSTRING("fs ");
static const struct ZydisPredefinedTokenPREF_SEG_FS_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[9];
} TOK_DATA_PREF_SEG_FS = { 9, 7, { ZYDIS_TOKEN_PREFIX, 3, 'f', 's', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_SEG_FS = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_SEG_FS;

static const ZydisShortString STR_PREF_SEG_GS = ZYDIS_MAKE_SHORTSTRING("gs ");
static const struct ZydisPredefinedTokenPREF_SEG_GS_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[9];
} TOK_DATA_PREF_SEG_GS = { 9, 7, { ZYDIS_TOKEN_PREFIX, 3, 'g', 's', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_SEG_GS = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_SEG_GS;

static const ZydisShortString STR_PREF_SEG_SS = ZYDIS_MAKE_SHORTSTRING("ss ");
static const struct ZydisPredefinedTokenPREF_SEG_SS_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[9];
} TOK_DATA_PREF_SEG_SS = { 9, 7, { ZYDIS_TOKEN_PREFIX, 3, 's', 's', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_SEG_SS = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_SEG_SS;

static const ZydisShortString STR_PREF_XACQUIRE = ZYDIS_MAKE_SHORTSTRING("xacquire ");
static const struct ZydisPredefinedTokenPREF_XACQUIRE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[15];
} TOK_DATA_PREF_XACQUIRE = { 15, 13, { ZYDIS_TOKEN_PREFIX, 9, 'x', 'a', 'c', 'q', 'u', 'i', 'r', 'e', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_XACQUIRE = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_XACQUIRE;

static const ZydisShortString STR_PREF_XRELEASE = ZYDIS_MAKE_SHORTSTRING("xrelease ");
static const struct ZydisPredefinedTokenPREF_XRELEASE_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[15];
} TOK_DATA_PREF_XRELEASE = { 15, 13, { ZYDIS_TOKEN_PREFIX, 9, 'x', 'r', 'e', 'l', 'e', 'a', 's', 'e', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_XRELEASE = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_XRELEASE;

static const ZydisShortString STR_PREF_NOTRACK = ZYDIS_MAKE_SHORTSTRING("notrack ");
static const struct ZydisPredefinedTokenPREF_NOTRACK_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[14];
} TOK_DATA_PREF_NOTRACK = { 14, 12, { ZYDIS_TOKEN_PREFIX, 8, 'n', 'o', 't', 'r', 'a', 'c', 'k', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_PREF_NOTRACK = (const ZydisPredefinedToken* const) & TOK_DATA_PREF_NOTRACK;

static const ZydisShortString STR_REGISTER = ZYDIS_MAKE_SHORTSTRING("%");
static const struct ZydisPredefinedTokenREGISTER_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_REGISTER = { 4, 2, { ZYDIS_TOKEN_REGISTER, 0, '%', '\0' } };
static const ZydisPredefinedToken* const TOK_REGISTER = (const ZydisPredefinedToken* const) & TOK_DATA_REGISTER;

static const ZydisShortString STR_SHORT = ZYDIS_MAKE_SHORTSTRING(" short");
static const ZydisShortString STR_SIZE_8_ATT = ZYDIS_MAKE_SHORTSTRING("b");
static const ZydisShortString STR_SIZE_8_INTEL = ZYDIS_MAKE_SHORTSTRING("byte ptr ");
static const struct ZydisPredefinedTokenSIZE_8_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[15];
} TOK_DATA_SIZE_8_INTEL = { 15, 13, { ZYDIS_TOKEN_TYPECAST, 9, 'b', 'y', 't', 'e', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_8_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_8_INTEL;

static const ZydisShortString STR_SIZE_16_ATT = ZYDIS_MAKE_SHORTSTRING("w");
static const ZydisShortString STR_SIZE_16_INTEL = ZYDIS_MAKE_SHORTSTRING("word ptr ");
static const struct ZydisPredefinedTokenSIZE_16_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[15];
} TOK_DATA_SIZE_16_INTEL = { 15, 13, { ZYDIS_TOKEN_TYPECAST, 9, 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_16_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_16_INTEL;

static const ZydisShortString STR_SIZE_32_ATT = ZYDIS_MAKE_SHORTSTRING("l");
static const ZydisShortString STR_SIZE_32_INTEL = ZYDIS_MAKE_SHORTSTRING("dword ptr ");
static const struct ZydisPredefinedTokenSIZE_32_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[16];
} TOK_DATA_SIZE_32_INTEL = { 16, 14, { ZYDIS_TOKEN_TYPECAST, 10, 'd', 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_32_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_32_INTEL;

static const ZydisShortString STR_SIZE_48 = ZYDIS_MAKE_SHORTSTRING("fword ptr ");
static const struct ZydisPredefinedTokenSIZE_48_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[16];
} TOK_DATA_SIZE_48 = { 16, 14, { ZYDIS_TOKEN_TYPECAST, 10, 'f', 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_48 = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_48;

static const ZydisShortString STR_SIZE_64_ATT = ZYDIS_MAKE_SHORTSTRING("q");
static const ZydisShortString STR_SIZE_64_INTEL = ZYDIS_MAKE_SHORTSTRING("qword ptr ");
static const struct ZydisPredefinedTokenSIZE_64_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[16];
} TOK_DATA_SIZE_64_INTEL = { 16, 14, { ZYDIS_TOKEN_TYPECAST, 10, 'q', 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_64_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_64_INTEL;

static const ZydisShortString STR_SIZE_80 = ZYDIS_MAKE_SHORTSTRING("tbyte ptr ");
static const struct ZydisPredefinedTokenSIZE_80_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[16];
} TOK_DATA_SIZE_80 = { 16, 14, { ZYDIS_TOKEN_TYPECAST, 10, 't', 'b', 'y', 't', 'e', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_80 = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_80;

static const ZydisShortString STR_SIZE_128_ATT = ZYDIS_MAKE_SHORTSTRING("x");
static const ZydisShortString STR_SIZE_128_INTEL = ZYDIS_MAKE_SHORTSTRING("xmmword ptr ");
static const struct ZydisPredefinedTokenSIZE_128_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[18];
} TOK_DATA_SIZE_128_INTEL = { 18, 16, { ZYDIS_TOKEN_TYPECAST, 12, 'x', 'm', 'm', 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_128_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_128_INTEL;

static const ZydisShortString STR_SIZE_256_ATT = ZYDIS_MAKE_SHORTSTRING("y");
static const ZydisShortString STR_SIZE_256_INTEL = ZYDIS_MAKE_SHORTSTRING("ymmword ptr ");
static const struct ZydisPredefinedTokenSIZE_256_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[18];
} TOK_DATA_SIZE_256_INTEL = { 18, 16, { ZYDIS_TOKEN_TYPECAST, 12, 'y', 'm', 'm', 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_256_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_256_INTEL;

static const ZydisShortString STR_SIZE_512_ATT = ZYDIS_MAKE_SHORTSTRING("z");
static const ZydisShortString STR_SIZE_512_INTEL = ZYDIS_MAKE_SHORTSTRING("zmmword ptr ");
static const struct ZydisPredefinedTokenSIZE_512_INTEL_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[18];
} TOK_DATA_SIZE_512_INTEL = { 18, 16, { ZYDIS_TOKEN_TYPECAST, 12, 'z', 'm', 'm', 'w', 'o', 'r', 'd', ' ', 'p', 't', 'r', '\0', ZYDIS_TOKEN_WHITESPACE, 0, ' ', '\0' } };
static const ZydisPredefinedToken* const TOK_SIZE_512_INTEL = (const ZydisPredefinedToken* const) & TOK_DATA_SIZE_512_INTEL;

static const ZydisShortString STR_SUB = ZYDIS_MAKE_SHORTSTRING("-");
static const struct ZydisPredefinedTokenSUB_
{
    ZyanU8 size;
    ZyanU8 next;
    ZyanU8 data[4];
} TOK_DATA_SUB = { 4, 2, { ZYDIS_TOKEN_DELIMITER, 0, '-', '\0' } };
static const ZydisPredefinedToken* const TOK_SUB = (const ZydisPredefinedToken* const) & TOK_DATA_SUB;

static const ZydisShortString STR_WHITESPACE = ZYDIS_MAKE_SHORTSTRING(" ");
#pragma pack(pop)

/* ============================================================================================== */
/* Formatter functions                                                                            */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Instruction                                                                                    */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterATTFormatInstruction(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(context->instruction);
    ZYAN_ASSERT(context->operands);

    ZYAN_CHECK(formatter->func_print_prefixes(formatter, buffer, context));
    ZYAN_CHECK(formatter->func_print_mnemonic(formatter, buffer, context));

    ZyanUPointer state_mnemonic;
    ZYDIS_BUFFER_REMEMBER(buffer, state_mnemonic);

    const ZyanI8 c = (ZyanI8)context->instruction->operand_count_visible - 1;
    for(ZyanI8 i = c; i >= 0; --i)
    {
        const ZydisDecodedOperand* const operand = &context->operands[i];

        // Print embedded-mask registers as decorator instead of a regular operand
        if((i == 1) && (operand->type == ZYDIS_OPERAND_TYPE_REGISTER) &&
                (operand->encoding == ZYDIS_OPERAND_ENCODING_MASK))
        {
            continue;
        }

        ZyanUPointer buffer_state;
        ZYDIS_BUFFER_REMEMBER(buffer, buffer_state);

        if(buffer_state != state_mnemonic)
        {
            ZYDIS_BUFFER_APPEND(buffer, DELIM_OPERAND);
        }
        else
        {
            ZYDIS_BUFFER_APPEND(buffer, DELIM_MNEMONIC);
        }

        // Set current operand
        context->operand = operand;

        ZyanStatus status;
        if(formatter->func_pre_operand)
        {
            status = formatter->func_pre_operand(formatter, buffer, context);
            if(status == ZYDIS_STATUS_SKIP_TOKEN)
            {
                ZYAN_CHECK(ZydisFormatterBufferRestore(buffer, buffer_state));
                continue;
            }
            if(!ZYAN_SUCCESS(status))
            {
                return status;
            }
        }

        switch(operand->type)
        {
        case ZYDIS_OPERAND_TYPE_REGISTER:
            status = formatter->func_format_operand_reg(formatter, buffer, context);
            break;
        case ZYDIS_OPERAND_TYPE_MEMORY:
            status = formatter->func_format_operand_mem(formatter, buffer, context);
            break;
        case ZYDIS_OPERAND_TYPE_POINTER:
            status = formatter->func_format_operand_ptr(formatter, buffer, context);
            break;
        case ZYDIS_OPERAND_TYPE_IMMEDIATE:
            status = formatter->func_format_operand_imm(formatter, buffer, context);
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
        if(status == ZYDIS_STATUS_SKIP_TOKEN)
        {
            ZYAN_CHECK(ZydisFormatterBufferRestore(buffer, buffer_state));
            continue;
        }
        if(!ZYAN_SUCCESS(status))
        {
            return status;
        }

        if(formatter->func_post_operand)
        {
            status = formatter->func_post_operand(formatter, buffer, context);
            if(status == ZYDIS_STATUS_SKIP_TOKEN)
            {
                ZYAN_CHECK(ZydisFormatterBufferRestore(buffer, buffer_state));
                continue;
            }
            if(ZYAN_SUCCESS(status))
            {
                return status;
            }
        }

#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
        if((context->instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
                (context->instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX))
        {
            if((i == 0) &&
                    (context->instruction->operand_count_visible > 1) &&
                    (context->operands[1].encoding == ZYDIS_OPERAND_ENCODING_MASK))
            {
                ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                           ZYDIS_DECORATOR_MASK));
            }
            if(operand->type == ZYDIS_OPERAND_TYPE_MEMORY)
            {
                ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                           ZYDIS_DECORATOR_BC));
                if(context->instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX)
                {
                    ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                               ZYDIS_DECORATOR_CONVERSION));
                    ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                               ZYDIS_DECORATOR_EH));
                }
            }
            else
            {
                ZyanBool decorate_operand;
                if(i == (context->instruction->operand_count_visible - 1))
                {
                    decorate_operand = operand->type != ZYDIS_OPERAND_TYPE_IMMEDIATE;
                }
                else
                {
                    decorate_operand =
                        (context->instruction->operand_count_visible > (i + 1)) &&
                        ((context->operands[i + 1].type == ZYDIS_OPERAND_TYPE_IMMEDIATE) ||
                         (context->operands[i + 1].visibility == ZYDIS_OPERAND_VISIBILITY_HIDDEN));
                }
                if(decorate_operand)
                {
                    if(context->instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX)
                    {
                        ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                                   ZYDIS_DECORATOR_SWIZZLE));
                    }
                    ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                               ZYDIS_DECORATOR_RC));
                    ZYAN_CHECK(formatter->func_print_decorator(formatter, buffer, context,
                               ZYDIS_DECORATOR_SAE));
                }
            }
        }
#endif
    }

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Operands                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterATTFormatOperandMEM(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZYAN_CHECK(formatter->func_print_segment(formatter, buffer, context));

    const ZyanBool absolute = !formatter->force_relative_riprel &&
                              (context->runtime_address != ZYDIS_RUNTIME_ADDRESS_NONE);
    if(absolute && context->operand->mem.disp.has_displacement &&
            (context->operand->mem.index == ZYDIS_REGISTER_NONE) &&
            ((context->operand->mem.base  == ZYDIS_REGISTER_NONE) ||
             (context->operand->mem.base  == ZYDIS_REGISTER_EIP) ||
             (context->operand->mem.base  == ZYDIS_REGISTER_RIP)))
    {
        // EIP/RIP-relative or absolute-displacement address operand
        ZYAN_CHECK(formatter->func_print_address_abs(formatter, buffer, context));
    }
    else
    {
        const ZyanBool should_print_reg = context->operand->mem.base != ZYDIS_REGISTER_NONE;
        const ZyanBool should_print_idx = context->operand->mem.index != ZYDIS_REGISTER_NONE;
        const ZyanBool neither_reg_nor_idx = !should_print_reg && !should_print_idx;

        // Regular memory operand
        if(neither_reg_nor_idx)
        {
            ZYAN_CHECK(formatter->func_print_address_abs(formatter, buffer, context));
        }
        else if(context->operand->mem.disp.has_displacement && context->operand->mem.disp.value)
        {
            ZYAN_CHECK(formatter->func_print_disp(formatter, buffer, context));
        }

        if(neither_reg_nor_idx)
        {
            return ZYAN_STATUS_SUCCESS;
        }

        ZYDIS_BUFFER_APPEND(buffer, MEMORY_BEGIN_ATT);

        if(should_print_reg)
        {
            ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                       context->operand->mem.base));
        }
        if(should_print_idx)
        {
            ZYDIS_BUFFER_APPEND(buffer, DELIM_MEMORY);
            ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                       context->operand->mem.index));
            if(context->operand->mem.scale &&
                    (context->operand->mem.type != ZYDIS_MEMOP_TYPE_MIB) &&
                    ((context->operand->mem.scale > 1) || formatter->force_memory_scale))
            {
                ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_DELIMITER);
                ZYDIS_BUFFER_APPEND(buffer, DELIM_MEMORY);
                ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_IMMEDIATE);
                ZYAN_CHECK(ZydisStringAppendDecU(&buffer->string, context->operand->mem.scale, 0,
                                                 ZYAN_NULL, ZYAN_NULL));
            }
        }

        ZYDIS_BUFFER_APPEND(buffer, MEMORY_END_ATT);
        return ZYAN_STATUS_SUCCESS;
    }

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Elemental tokens                                                                               */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterATTPrintMnemonic(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(context->instruction);
    ZYAN_ASSERT(context->operands);

    const ZydisShortString* mnemonic = ZydisMnemonicGetStringWrapped(
                                           context->instruction->mnemonic);
    if(!mnemonic)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, INVALID_MNEMONIC, formatter->case_mnemonic);
        return ZYAN_STATUS_SUCCESS;
    }

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_MNEMONIC);
    if(context->instruction->meta.branch_type == ZYDIS_BRANCH_TYPE_FAR)
    {
        ZYAN_CHECK(ZydisStringAppendShortCase(&buffer->string, &STR_FAR_ATT,
                                              formatter->case_mnemonic));
    }
    ZYAN_CHECK(ZydisStringAppendShortCase(&buffer->string, mnemonic, formatter->case_mnemonic));

    // Append operand-size suffix
    ZyanU32 size = 0;
    for(ZyanU8 i = 0; i < context->instruction->operand_count_visible; ++i)
    {
        const ZydisDecodedOperand* const operand = &context->operands[i];
        if((operand->type == ZYDIS_OPERAND_TYPE_MEMORY) &&
                ((operand->mem.type == ZYDIS_MEMOP_TYPE_MEM) ||
                 (operand->mem.type == ZYDIS_MEMOP_TYPE_VSIB)))
        {
            size = ZydisFormatterHelperGetExplicitSize(formatter, context, operand);
            break;
        }
    }

    switch(size)
    {
    case   8:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_8_ATT);
        break;
    case  16:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_16_ATT);
        break;
    case  32:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_32_ATT);
        break;
    case  64:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_64_ATT);
        break;
    case 128:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_128_ATT);
        break;
    case 256:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_256_ATT);
        break;
    case 512:
        ZydisStringAppendShort(&buffer->string, &STR_SIZE_512_ATT);
        break;
    default:
        break;
    }

    if(formatter->print_branch_size)
    {
        switch(context->instruction->meta.branch_type)
        {
        case ZYDIS_BRANCH_TYPE_NONE:
            break;
        case ZYDIS_BRANCH_TYPE_SHORT:
            return ZydisStringAppendShortCase(&buffer->string, &STR_SHORT,
                                              formatter->case_mnemonic);
        case ZYDIS_BRANCH_TYPE_NEAR:
            return ZydisStringAppendShortCase(&buffer->string, &STR_NEAR,
                                              formatter->case_mnemonic);
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterATTPrintRegister(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context, ZydisRegister reg)
{
    ZYAN_UNUSED(context);

    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZYDIS_BUFFER_APPEND(buffer, REGISTER);
    const ZydisShortString* str = ZydisRegisterGetStringWrapped(reg);
    if(!str)
    {
        return ZydisStringAppendShortCase(&buffer->string, &STR_INVALID_REG,
                                          formatter->case_registers);
    }
    return ZydisStringAppendShortCase(&buffer->string, str, formatter->case_registers);
}

ZyanStatus ZydisFormatterATTPrintAddressABS(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    if((context->instruction->meta.branch_type != ZYDIS_BRANCH_TYPE_NONE) &&
            (context->operand->type == ZYDIS_OPERAND_TYPE_MEMORY))
    {
        ZYDIS_BUFFER_APPEND(buffer, MUL);
    }

    return ZydisFormatterBasePrintAddressABS(formatter, buffer, context);
}

ZyanStatus ZydisFormatterATTPrintDISP(const ZydisFormatter* formatter,
                                      ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_DISPLACEMENT);
    switch(formatter->disp_signedness)
    {
    case ZYDIS_SIGNEDNESS_AUTO:
    case ZYDIS_SIGNEDNESS_SIGNED:
        ZYDIS_STRING_APPEND_NUM_S(formatter, formatter->disp_base, &buffer->string,
                                  context->operand->mem.disp.value, formatter->disp_padding,
                                  formatter->hex_force_leading_number, ZYAN_FALSE);
        break;
    case ZYDIS_SIGNEDNESS_UNSIGNED:
        ZYDIS_STRING_APPEND_NUM_U(formatter, formatter->disp_base, &buffer->string,
                                  context->operand->mem.disp.value, formatter->disp_padding,
                                  formatter->hex_force_leading_number);
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterATTPrintIMM(const ZydisFormatter* formatter,
                                     ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZYDIS_BUFFER_APPEND(buffer, IMMEDIATE);
    return ZydisFormatterBasePrintIMM(formatter, buffer, context);
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/MetaInfo.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


/* ============================================================================================== */
/* Enum strings                                                                                   */
/* ============================================================================================== */


//
// Header: Generated/EnumInstructionCategory.inc
//

static const char* STR_INSTRUCTIONCATEGORY[] =
{
    "INVALID",
    "ADOX_ADCX",
    "AES",
    "AMD3DNOW",
    "AMX_TILE",
    "AVX",
    "AVX2",
    "AVX2GATHER",
    "AVX512",
    "AVX512_4FMAPS",
    "AVX512_4VNNIW",
    "AVX512_BITALG",
    "AVX512_VBMI",
    "AVX512_VP2INTERSECT",
    "AVX_IFMA",
    "BINARY",
    "BITBYTE",
    "BLEND",
    "BMI1",
    "BMI2",
    "BROADCAST",
    "CALL",
    "CET",
    "CLDEMOTE",
    "CLFLUSHOPT",
    "CLWB",
    "CLZERO",
    "CMOV",
    "COMPRESS",
    "COND_BR",
    "CONFLICT",
    "CONVERT",
    "DATAXFER",
    "DECIMAL",
    "ENQCMD",
    "EXPAND",
    "FCMOV",
    "FLAGOP",
    "FMA4",
    "FP16",
    "GATHER",
    "GFNI",
    "HRESET",
    "IFMA",
    "INTERRUPT",
    "IO",
    "IOSTRINGOP",
    "KEYLOCKER",
    "KEYLOCKER_WIDE",
    "KMASK",
    "KNC",
    "KNCMASK",
    "KNCSCALAR",
    "LEGACY",
    "LOGICAL",
    "LOGICAL_FP",
    "LZCNT",
    "MISC",
    "MMX",
    "MOVDIR",
    "MPX",
    "MSRLIST",
    "NOP",
    "PADLOCK",
    "PCLMULQDQ",
    "PCONFIG",
    "PKU",
    "POP",
    "PREFETCH",
    "PREFETCHWT1",
    "PT",
    "PUSH",
    "RDPID",
    "RDPRU",
    "RDRAND",
    "RDSEED",
    "RDWRFSGS",
    "RET",
    "ROTATE",
    "SCATTER",
    "SEGOP",
    "SEMAPHORE",
    "SERIALIZE",
    "SETCC",
    "SGX",
    "SHA",
    "SHIFT",
    "SMAP",
    "SSE",
    "STRINGOP",
    "STTNI",
    "SYSCALL",
    "SYSRET",
    "SYSTEM",
    "TBM",
    "TSX_LDTRK",
    "UFMA",
    "UINTR",
    "UNCOND_BR",
    "VAES",
    "VBMI2",
    "VEX",
    "VFMA",
    "VPCLMULQDQ",
    "VTX",
    "WAITPKG",
    "WIDENOP",
    "WRMSRNS",
    "X87_ALU",
    "XOP",
    "XSAVE",
    "XSAVEOPT"
};

//
// Header: Generated/EnumISASet.inc
//

static const char* STR_ISASET[] =
{
    "INVALID",
    "ADOX_ADCX",
    "AES",
    "AMD",
    "AMD3DNOW",
    "AMD_INVLPGB",
    "AMX_BF16",
    "AMX_FP16",
    "AMX_INT8",
    "AMX_TILE",
    "AVX",
    "AVX2",
    "AVX2GATHER",
    "AVX512BW_128",
    "AVX512BW_128N",
    "AVX512BW_256",
    "AVX512BW_512",
    "AVX512BW_KOP",
    "AVX512CD_128",
    "AVX512CD_256",
    "AVX512CD_512",
    "AVX512DQ_128",
    "AVX512DQ_128N",
    "AVX512DQ_256",
    "AVX512DQ_512",
    "AVX512DQ_KOP",
    "AVX512DQ_SCALAR",
    "AVX512ER_512",
    "AVX512ER_SCALAR",
    "AVX512F_128",
    "AVX512F_128N",
    "AVX512F_256",
    "AVX512F_512",
    "AVX512F_KOP",
    "AVX512F_SCALAR",
    "AVX512PF_512",
    "AVX512_4FMAPS_512",
    "AVX512_4FMAPS_SCALAR",
    "AVX512_4VNNIW_512",
    "AVX512_BF16_128",
    "AVX512_BF16_256",
    "AVX512_BF16_512",
    "AVX512_BITALG_128",
    "AVX512_BITALG_256",
    "AVX512_BITALG_512",
    "AVX512_FP16_128",
    "AVX512_FP16_128N",
    "AVX512_FP16_256",
    "AVX512_FP16_512",
    "AVX512_FP16_SCALAR",
    "AVX512_GFNI_128",
    "AVX512_GFNI_256",
    "AVX512_GFNI_512",
    "AVX512_IFMA_128",
    "AVX512_IFMA_256",
    "AVX512_IFMA_512",
    "AVX512_VAES_128",
    "AVX512_VAES_256",
    "AVX512_VAES_512",
    "AVX512_VBMI2_128",
    "AVX512_VBMI2_256",
    "AVX512_VBMI2_512",
    "AVX512_VBMI_128",
    "AVX512_VBMI_256",
    "AVX512_VBMI_512",
    "AVX512_VNNI_128",
    "AVX512_VNNI_256",
    "AVX512_VNNI_512",
    "AVX512_VP2INTERSECT_128",
    "AVX512_VP2INTERSECT_256",
    "AVX512_VP2INTERSECT_512",
    "AVX512_VPCLMULQDQ_128",
    "AVX512_VPCLMULQDQ_256",
    "AVX512_VPCLMULQDQ_512",
    "AVX512_VPOPCNTDQ_128",
    "AVX512_VPOPCNTDQ_256",
    "AVX512_VPOPCNTDQ_512",
    "AVXAES",
    "AVX_GFNI",
    "AVX_IFMA",
    "AVX_NE_CONVERT",
    "AVX_VNNI",
    "AVX_VNNI_INT8",
    "BMI1",
    "BMI2",
    "CET",
    "CLDEMOTE",
    "CLFLUSHOPT",
    "CLFSH",
    "CLWB",
    "CLZERO",
    "CMOV",
    "CMPXCHG16B",
    "ENQCMD",
    "F16C",
    "FAT_NOP",
    "FCMOV",
    "FCOMI",
    "FMA",
    "FMA4",
    "FXSAVE",
    "FXSAVE64",
    "GFNI",
    "HRESET",
    "I186",
    "I286PROTECTED",
    "I286REAL",
    "I386",
    "I486",
    "I486REAL",
    "I86",
    "ICACHE_PREFETCH",
    "INVPCID",
    "KEYLOCKER",
    "KEYLOCKER_WIDE",
    "KNCE",
    "KNCJKBR",
    "KNCSTREAM",
    "KNCV",
    "KNC_MISC",
    "KNC_PF_HINT",
    "LAHF",
    "LONGMODE",
    "LWP",
    "LZCNT",
    "MCOMMIT",
    "MONITOR",
    "MONITORX",
    "MOVBE",
    "MOVDIR",
    "MPX",
    "MSRLIST",
    "PADLOCK_ACE",
    "PADLOCK_PHE",
    "PADLOCK_PMM",
    "PADLOCK_RNG",
    "PAUSE",
    "PCLMULQDQ",
    "PCONFIG",
    "PENTIUMMMX",
    "PENTIUMREAL",
    "PKU",
    "POPCNT",
    "PPRO",
    "PREFETCHWT1",
    "PREFETCH_NOP",
    "PT",
    "RAO_INT",
    "RDPID",
    "RDPMC",
    "RDPRU",
    "RDRAND",
    "RDSEED",
    "RDTSCP",
    "RDWRFSGS",
    "RTM",
    "SERIALIZE",
    "SGX",
    "SGX_ENCLV",
    "SHA",
    "SMAP",
    "SMX",
    "SNP",
    "SSE",
    "SSE2",
    "SSE2MMX",
    "SSE3",
    "SSE3X87",
    "SSE4",
    "SSE42",
    "SSE4A",
    "SSEMXCSR",
    "SSE_PREFETCH",
    "SSSE3",
    "SSSE3MMX",
    "SVM",
    "TBM",
    "TDX",
    "TSX_LDTRK",
    "UINTR",
    "VAES",
    "VMFUNC",
    "VPCLMULQDQ",
    "VTX",
    "WAITPKG",
    "WRMSRNS",
    "X87",
    "XOP",
    "XSAVE",
    "XSAVEC",
    "XSAVEOPT",
    "XSAVES"
};

//
// Header: Generated/EnumISAExt.inc
//

static const char* STR_ISAEXT[] =
{
    "INVALID",
    "ADOX_ADCX",
    "AES",
    "AMD3DNOW",
    "AMD3DNOW_PREFETCH",
    "AMD_INVLPGB",
    "AMX_BF16",
    "AMX_FP16",
    "AMX_INT8",
    "AMX_TILE",
    "AVX",
    "AVX2",
    "AVX2GATHER",
    "AVX512EVEX",
    "AVX512VEX",
    "AVXAES",
    "AVX_IFMA",
    "AVX_NE_CONVERT",
    "AVX_VNNI",
    "AVX_VNNI_INT8",
    "BASE",
    "BMI1",
    "BMI2",
    "CET",
    "CLDEMOTE",
    "CLFLUSHOPT",
    "CLFSH",
    "CLWB",
    "CLZERO",
    "ENQCMD",
    "F16C",
    "FMA",
    "FMA4",
    "GFNI",
    "HRESET",
    "ICACHE_PREFETCH",
    "INVPCID",
    "KEYLOCKER",
    "KEYLOCKER_WIDE",
    "KNC",
    "KNCE",
    "KNCV",
    "LONGMODE",
    "LZCNT",
    "MCOMMIT",
    "MMX",
    "MONITOR",
    "MONITORX",
    "MOVBE",
    "MOVDIR",
    "MPX",
    "MSRLIST",
    "PADLOCK",
    "PAUSE",
    "PCLMULQDQ",
    "PCONFIG",
    "PKU",
    "PREFETCHWT1",
    "PT",
    "RAO_INT",
    "RDPID",
    "RDPRU",
    "RDRAND",
    "RDSEED",
    "RDTSCP",
    "RDWRFSGS",
    "RTM",
    "SERIALIZE",
    "SGX",
    "SGX_ENCLV",
    "SHA",
    "SMAP",
    "SMX",
    "SNP",
    "SSE",
    "SSE2",
    "SSE3",
    "SSE4",
    "SSE4A",
    "SSSE3",
    "SVM",
    "TBM",
    "TDX",
    "TSX_LDTRK",
    "UINTR",
    "VAES",
    "VMFUNC",
    "VPCLMULQDQ",
    "VTX",
    "WAITPKG",
    "WRMSRNS",
    "X87",
    "XOP",
    "XSAVE",
    "XSAVEC",
    "XSAVEOPT",
    "XSAVES"
};

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

const char* ZydisCategoryGetString(ZydisInstructionCategory category)
{
    if((ZyanUSize)category >= ZYAN_ARRAY_LENGTH(STR_INSTRUCTIONCATEGORY))
    {
        return ZYAN_NULL;
    }
    return STR_INSTRUCTIONCATEGORY[category];
}

const char* ZydisISASetGetString(ZydisISASet isa_set)
{
    if((ZyanUSize)isa_set >= ZYAN_ARRAY_LENGTH(STR_ISASET))
    {
        return ZYAN_NULL;
    }
    return STR_ISASET[isa_set];
}

const char* ZydisISAExtGetString(ZydisISAExt isa_ext)
{
    if((ZyanUSize)isa_ext >= ZYAN_ARRAY_LENGTH(STR_ISAEXT))
    {
        return ZYAN_NULL;
    }
    return STR_ISAEXT[isa_ext];
}

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/Utils.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Address calculation                                                                            */
/* ---------------------------------------------------------------------------------------------- */

// Signed integer overflow is expected behavior in this function, for wrapping around the
// instruction pointer on jumps right at the end of the address space.
ZYAN_NO_SANITIZE("signed-integer-overflow")
ZyanStatus ZydisCalcAbsoluteAddress(const ZydisDecodedInstruction* instruction,
                                    const ZydisDecodedOperand* operand, ZyanU64 runtime_address, ZyanU64* result_address)
{
    if(!instruction || !operand || !result_address)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    switch(operand->type)
    {
    case ZYDIS_OPERAND_TYPE_MEMORY:
        if(!operand->mem.disp.has_displacement)
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
        if(operand->mem.base == ZYDIS_REGISTER_EIP)
        {
            *result_address = ((ZyanU32)runtime_address + instruction->length +
                               (ZyanU32)operand->mem.disp.value);
            return ZYAN_STATUS_SUCCESS;
        }
        if(operand->mem.base == ZYDIS_REGISTER_RIP)
        {
            *result_address = (ZyanU64)(runtime_address + instruction->length +
                                        operand->mem.disp.value);
            return ZYAN_STATUS_SUCCESS;
        }
        if((operand->mem.base == ZYDIS_REGISTER_NONE) &&
                (operand->mem.index == ZYDIS_REGISTER_NONE))
        {
            switch(instruction->address_width)
            {
            case 16:
                *result_address = (ZyanU64)operand->mem.disp.value & 0x000000000000FFFF;
                return ZYAN_STATUS_SUCCESS;
            case 32:
                *result_address = (ZyanU64)operand->mem.disp.value & 0x00000000FFFFFFFF;
                return ZYAN_STATUS_SUCCESS;
            case 64:
                *result_address = (ZyanU64)operand->mem.disp.value;
                return ZYAN_STATUS_SUCCESS;
            default:
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
        }
        break;
    case ZYDIS_OPERAND_TYPE_IMMEDIATE:
        if(operand->imm.is_signed && operand->imm.is_relative)
        {
            *result_address = (ZyanU64)((ZyanI64)runtime_address + instruction->length +
                                        operand->imm.value.s);
            switch(instruction->machine_mode)
            {
            case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
            case ZYDIS_MACHINE_MODE_LEGACY_16:
            case ZYDIS_MACHINE_MODE_REAL_16:
            case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
            case ZYDIS_MACHINE_MODE_LEGACY_32:
                // `XBEGIN` is a special case as it doesn't truncate computed address
                // This behavior is documented by Intel (SDM Vol. 2C):
                // Use of the 16-bit operand size does not cause this address to be truncated to
                // 16 bits, unlike a near jump to a relative offset.
                if((instruction->operand_width == 16) &&
                        (instruction->mnemonic != ZYDIS_MNEMONIC_XBEGIN))
                {
                    *result_address &= 0xFFFF;
                }
                break;
            case ZYDIS_MACHINE_MODE_LONG_64:
                break;
            default:
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
            return ZYAN_STATUS_SUCCESS;
        }
        break;
    default:
        break;
    }

    return ZYAN_STATUS_INVALID_ARGUMENT;
}

ZyanStatus ZydisCalcAbsoluteAddressEx(const ZydisDecodedInstruction* instruction,
                                      const ZydisDecodedOperand* operand, ZyanU64 runtime_address,
                                      const ZydisRegisterContext* register_context, ZyanU64* result_address)
{
    // TODO: Test this with AGEN/MIB operands
    // TODO: Add support for Gather/Scatter instructions

    if(!instruction || !operand || !register_context || !result_address)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if((operand->type != ZYDIS_OPERAND_TYPE_MEMORY) ||
            ((operand->mem.base == ZYDIS_REGISTER_NONE) &&
             (operand->mem.index == ZYDIS_REGISTER_NONE)) ||
            (operand->mem.base == ZYDIS_REGISTER_EIP) ||
            (operand->mem.base == ZYDIS_REGISTER_RIP))
    {
        return ZydisCalcAbsoluteAddress(instruction, operand, runtime_address, result_address);
    }

    ZyanU64 value = operand->mem.disp.value;
    if(operand->mem.base)
    {
        value += register_context->values[operand->mem.base];
    }
    if(operand->mem.index)
    {
        value += register_context->values[operand->mem.index] * operand->mem.scale;
    }

    switch(instruction->address_width)
    {
    case 16:
        *result_address = value & 0x000000000000FFFF;
        return ZYAN_STATUS_SUCCESS;
    case 32:
        *result_address = value & 0x00000000FFFFFFFF;
        return ZYAN_STATUS_SUCCESS;
    case 64:
        *result_address = value;
        return ZYAN_STATUS_SUCCESS;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
}

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/FormatterBase.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


/* ============================================================================================== */
/* Constants                                                                                      */
/* ============================================================================================== */


static const ZydisShortString* const STR_PREF_REX[16] =
{
    &STR_PREF_REX_40,
    &STR_PREF_REX_41,
    &STR_PREF_REX_42,
    &STR_PREF_REX_43,
    &STR_PREF_REX_44,
    &STR_PREF_REX_45,
    &STR_PREF_REX_46,
    &STR_PREF_REX_47,
    &STR_PREF_REX_48,
    &STR_PREF_REX_49,
    &STR_PREF_REX_4A,
    &STR_PREF_REX_4B,
    &STR_PREF_REX_4C,
    &STR_PREF_REX_4D,
    &STR_PREF_REX_4E,
    &STR_PREF_REX_4F
};

static const ZydisPredefinedToken* const TOK_PREF_REX[16] =
{
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_40,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_41,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_42,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_43,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_44,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_45,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_46,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_47,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_48,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_49,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_4A,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_4B,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_4C,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_4D,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_4E,
    (const ZydisPredefinedToken * const) & TOK_DATA_PREF_REX_4F
};

/* ============================================================================================== */
/* Helper functions                                                                               */
/* ============================================================================================== */

ZyanU32 ZydisFormatterHelperGetExplicitSize(const ZydisFormatter* formatter,
        ZydisFormatterContext* context, const ZydisDecodedOperand* operand)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(operand);

    ZYAN_ASSERT(operand->type == ZYDIS_OPERAND_TYPE_MEMORY);
    ZYAN_ASSERT((operand->mem.type == ZYDIS_MEMOP_TYPE_MEM) ||
                (operand->mem.type == ZYDIS_MEMOP_TYPE_VSIB));

    if(formatter->force_memory_size)
    {
        return operand->size;
    }

    if(!context->operands)
    {
        // Single operand formatting. We can not derive the explicit size by using the other
        // operands.
        return 0;
    }

    switch(operand->id)
    {
    case 0:
        if(context->instruction->operand_count_visible < 2)
        {
            return 0;
        }
        if((context->operands[1].type == ZYDIS_OPERAND_TYPE_UNUSED) ||
                (context->operands[1].type == ZYDIS_OPERAND_TYPE_IMMEDIATE))
        {
            return context->operands[0].size;
        }
        if(context->operands[0].size != context->operands[1].size)
        {
            return context->operands[0].size;
        }
        if((context->operands[1].type == ZYDIS_OPERAND_TYPE_REGISTER) &&
                (context->operands[1].visibility == ZYDIS_OPERAND_VISIBILITY_IMPLICIT) &&
                (context->operands[1].reg.value == ZYDIS_REGISTER_CL))
        {
            return context->operands[0].size;
        }
        break;
    case 1:
    case 2:
        if(context->operands[operand->id - 1].size !=
                context->operands[operand->id].size)
        {
            return context->operands[operand->id].size;
        }
        break;
    default:
        break;
    }

    return 0;
}

/* ============================================================================================== */
/* Formatter functions                                                                            */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Operands                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBaseFormatOperandREG(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    return formatter->func_print_register(formatter, buffer, context, context->operand->reg.value);
}

ZyanStatus ZydisFormatterBaseFormatOperandPTR(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_IMMEDIATE);
    ZYDIS_STRING_APPEND_NUM_U(formatter, formatter->addr_base, &buffer->string,
                              context->operand->ptr.segment, 4, formatter->hex_force_leading_number);
    ZYDIS_BUFFER_APPEND(buffer, DELIM_SEGMENT);

    ZyanU8 padding;
    switch(context->instruction->operand_width)
    {
    case 16:
        padding = 4;
        break;
    case 32:
        padding = 8;
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_IMMEDIATE);
    ZYDIS_STRING_APPEND_NUM_U(formatter, formatter->addr_base, &buffer->string,
                              context->operand->ptr.offset, padding, formatter->hex_force_leading_number);

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBaseFormatOperandIMM(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    // The immediate operand contains an address
    if(context->operand->imm.is_relative)
    {
        const ZyanBool absolute = !formatter->force_relative_branches &&
                                  (context->runtime_address != ZYDIS_RUNTIME_ADDRESS_NONE);
        if(absolute)
        {
            return formatter->func_print_address_abs(formatter, buffer, context);
        }
        return formatter->func_print_address_rel(formatter, buffer, context);
    }

    // The immediate operand contains an actual ordinal value
    return formatter->func_print_imm(formatter, buffer, context);
}

/* ---------------------------------------------------------------------------------------------- */
/* Elemental tokens                                                                               */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBasePrintAddressABS(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZyanU64 address;
    ZYAN_CHECK(ZydisCalcAbsoluteAddress(context->instruction, context->operand,
                                        context->runtime_address, &address));
    ZyanU8 padding = (formatter->addr_padding_absolute ==
                      ZYDIS_PADDING_AUTO) ? 0 : (ZyanU8)formatter->addr_padding_absolute;
    if((formatter->addr_padding_absolute == ZYDIS_PADDING_AUTO) &&
            (formatter->addr_base == ZYDIS_NUMERIC_BASE_HEX))
    {
        switch(context->instruction->stack_width)
        {
        case 16:
            padding =  4;
            address = (ZyanU16)address;
            break;
        case 32:
            padding =  8;
            address = (ZyanU32)address;
            break;
        case 64:
            padding = 16;
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_ADDRESS_ABS);
    ZYDIS_STRING_APPEND_NUM_U(formatter, formatter->addr_base, &buffer->string, address, padding,
                              formatter->hex_force_leading_number);

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBasePrintAddressREL(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZyanU64 address;
    ZYAN_CHECK(ZydisCalcAbsoluteAddress(context->instruction, context->operand, 0, &address));

    ZyanU8 padding = (formatter->addr_padding_relative ==
                      ZYDIS_PADDING_AUTO) ? 0 : (ZyanU8)formatter->addr_padding_relative;
    if((formatter->addr_padding_relative == ZYDIS_PADDING_AUTO) &&
            (formatter->addr_base == ZYDIS_NUMERIC_BASE_HEX))
    {
        switch(context->instruction->stack_width)
        {
        case 16:
            padding =  4;
            address = (ZyanU16)address;
            break;
        case 32:
            padding =  8;
            address = (ZyanU32)address;
            break;
        case 64:
            padding = 16;
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
    }

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_ADDRESS_REL);
    switch(formatter->addr_signedness)
    {
    case ZYDIS_SIGNEDNESS_AUTO:
    case ZYDIS_SIGNEDNESS_SIGNED:
        ZYDIS_STRING_APPEND_NUM_S(formatter, formatter->addr_base, &buffer->string, address,
                                  padding, formatter->hex_force_leading_number, ZYAN_TRUE);
        break;
    case ZYDIS_SIGNEDNESS_UNSIGNED:
        ZYAN_CHECK(ZydisStringAppendShort(&buffer->string, &STR_ADD));
        ZYDIS_STRING_APPEND_NUM_U(formatter, formatter->addr_base, &buffer->string, address,
                                  padding, formatter->hex_force_leading_number);
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBasePrintIMM(const ZydisFormatter* formatter,
                                      ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_IMMEDIATE);

    const ZyanBool is_signed =
        (formatter->imm_signedness == ZYDIS_SIGNEDNESS_SIGNED) ||
        (formatter->imm_signedness == ZYDIS_SIGNEDNESS_AUTO && (context->operand->imm.is_signed));
    if(is_signed && (context->operand->imm.value.s < 0))
    {
        ZYDIS_STRING_APPEND_NUM_S(formatter, formatter->imm_base, &buffer->string,
                                  context->operand->imm.value.s, formatter->imm_padding,
                                  formatter->hex_force_leading_number, ZYAN_FALSE);
        return ZYAN_STATUS_SUCCESS;
    }
    ZyanU64 value;
    ZyanU8 padding = (formatter->imm_padding ==
                      ZYDIS_PADDING_AUTO) ? 0 : (ZyanU8)formatter->imm_padding;
    switch(context->instruction->operand_width)
    {
    case 8:
        if(formatter->imm_padding == ZYDIS_PADDING_AUTO)
        {
            padding =  2;
        }
        value = (ZyanU8)context->operand->imm.value.u;
        break;
    case 16:
        if(formatter->imm_padding == ZYDIS_PADDING_AUTO)
        {
            padding =  4;
        }
        value = (ZyanU16)context->operand->imm.value.u;
        break;
    case 32:
        if(formatter->imm_padding == ZYDIS_PADDING_AUTO)
        {
            padding =  8;
        }
        value = (ZyanU32)context->operand->imm.value.u;
        break;
    case 64:
        if(formatter->imm_padding == ZYDIS_PADDING_AUTO)
        {
            padding = 16;
        }
        value = (ZyanU64)context->operand->imm.value.u;
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    ZYDIS_STRING_APPEND_NUM_U(formatter, formatter->imm_base, &buffer->string, value, padding,
                              formatter->hex_force_leading_number);

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Optional tokens                                                                                */
/* ---------------------------------------------------------------------------------------------- */

ZyanStatus ZydisFormatterBasePrintSegment(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    ZyanBool printed_segment = ZYAN_FALSE;
    switch(context->operand->mem.segment)
    {
    case ZYDIS_REGISTER_ES:
    case ZYDIS_REGISTER_CS:
    case ZYDIS_REGISTER_FS:
    case ZYDIS_REGISTER_GS:
        ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                   context->operand->mem.segment));
        printed_segment = ZYAN_TRUE;
        break;
    case ZYDIS_REGISTER_SS:
        if((formatter->force_memory_segment) ||
                (context->instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_SS))
        {
            ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                       context->operand->mem.segment));
            printed_segment = ZYAN_TRUE;
        }
        break;
    case ZYDIS_REGISTER_DS:
        if((formatter->force_memory_segment) ||
                (context->instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_DS))
        {
            ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                       context->operand->mem.segment));
            printed_segment = ZYAN_TRUE;
        }
        break;
    default:
        break;
    }
    if(printed_segment)
    {
        ZYDIS_BUFFER_APPEND(buffer, DELIM_SEGMENT);
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBasePrintPrefixes(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

    if(formatter->detailed_prefixes)
    {
        for(ZyanU8 i = 0; i < context->instruction->raw.prefix_count; ++i)
        {
            const ZyanU8 value = context->instruction->raw.prefixes[i].value;
            switch(context->instruction->raw.prefixes[i].type)
            {
            case ZYDIS_PREFIX_TYPE_IGNORED:
            case ZYDIS_PREFIX_TYPE_MANDATORY:
            {
                if((value & 0xF0) == 0x40)
                {
                    if(buffer->is_token_list)
                    {
                        // TODO: Case
                        ZYAN_CHECK(ZydisFormatterBufferAppendPredefined(buffer,
                                   TOK_PREF_REX[value & 0x0F]));
                    }
                    else
                    {
                        ZYAN_CHECK(ZydisStringAppendShortCase(&buffer->string,
                                                              STR_PREF_REX[value & 0x0F], formatter->case_prefixes));
                    }
                }
                else
                {
                    switch(value)
                    {
                    case 0xF0:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_LOCK, formatter->case_prefixes);
                        break;
                    case 0x2E:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_SEG_CS, formatter->case_prefixes);
                        break;
                    case 0x36:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_SEG_SS, formatter->case_prefixes);
                        break;
                    case 0x3E:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_SEG_DS, formatter->case_prefixes);
                        break;
                    case 0x26:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_SEG_ES, formatter->case_prefixes);
                        break;
                    case 0x64:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_SEG_FS, formatter->case_prefixes);
                        break;
                    case 0x65:
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_SEG_GS, formatter->case_prefixes);
                        break;
                    default:
                        ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_PREFIX);
                        ZYAN_CHECK(ZydisStringAppendHexU(&buffer->string, value, 0,
                                                         formatter->hex_force_leading_number, formatter->hex_uppercase,
                                                         ZYAN_NULL, ZYAN_NULL));
                        ZYDIS_BUFFER_APPEND_TOKEN(buffer, ZYDIS_TOKEN_WHITESPACE);
                        ZYAN_CHECK(ZydisStringAppendShort(&buffer->string, &STR_WHITESPACE));
                        break;
                    }
                }
                break;
            }
            case ZYDIS_PREFIX_TYPE_EFFECTIVE:
                switch(value)
                {
                case 0xF0:
                    ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_LOCK, formatter->case_prefixes);
                    break;
                case 0xF2:
                    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_XACQUIRE)
                    {
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_XACQUIRE, formatter->case_prefixes);
                    }
                    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_REPNE)
                    {
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_REPNE, formatter->case_prefixes);
                    }

                    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_BND)
                    {
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_BND, formatter->case_prefixes);
                    }
                    break;
                case 0xF3:
                    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_XRELEASE)
                    {
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_XRELEASE, formatter->case_prefixes);
                    }
                    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_REP)
                    {
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_REP, formatter->case_prefixes);
                    }
                    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_REPE)
                    {
                        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_REPE, formatter->case_prefixes);
                    }
                    break;
                default:
                    break;
                }
                break;
            default:
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
        }
        return ZYAN_STATUS_SUCCESS;
    }

    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_XACQUIRE)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_XACQUIRE, formatter->case_prefixes);
    }
    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_XRELEASE)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_XRELEASE, formatter->case_prefixes);
    }

    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_LOCK)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_LOCK, formatter->case_prefixes);
    }

    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_BND)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_BND, formatter->case_prefixes);
    }

    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_NOTRACK)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_NOTRACK, formatter->case_prefixes);
    }

    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_REP)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_REP, formatter->case_prefixes);
        return ZYAN_STATUS_SUCCESS;
    }
    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_REPE)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_REPE, formatter->case_prefixes);
        return ZYAN_STATUS_SUCCESS;
    }
    if(context->instruction->attributes & ZYDIS_ATTRIB_HAS_REPNE)
    {
        ZYDIS_BUFFER_APPEND_CASE(buffer, PREF_REPNE, formatter->case_prefixes);
        return ZYAN_STATUS_SUCCESS;
    }

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisFormatterBasePrintDecorator(const ZydisFormatter* formatter,
        ZydisFormatterBuffer* buffer, ZydisFormatterContext* context, ZydisDecorator decorator)
{
    ZYAN_ASSERT(formatter);
    ZYAN_ASSERT(buffer);
    ZYAN_ASSERT(context);

#if defined(ZYDIS_DISABLE_AVX512) && defined(ZYDIS_DISABLE_KNC)
    ZYAN_UNUSED(formatter);
    ZYAN_UNUSED(buffer);
    ZYAN_UNUSED(context);
#endif

    switch(decorator)
    {
    case ZYDIS_DECORATOR_MASK:
    {
#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
        if(context->instruction->avx.mask.reg != ZYDIS_REGISTER_K0)
        {
            if(buffer->is_token_list)
            {
                ZYDIS_BUFFER_APPEND(buffer, DECO_BEGIN);
                ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                           context->instruction->avx.mask.reg));
                ZYDIS_BUFFER_APPEND(buffer, DECO_END);
            }
            else
            {
                ZYAN_CHECK(ZydisStringAppendShort(&buffer->string, &STR_DECO_BEGIN));
                ZYAN_CHECK(formatter->func_print_register(formatter, buffer, context,
                           context->instruction->avx.mask.reg));
                ZYAN_CHECK(ZydisStringAppendShort(&buffer->string, &STR_DECO_END));
            }

            // Only print the zeroing decorator, if the instruction is not a "zeroing masking only"
            // instruction (e.g. `vcmpsd`)
            if((context->instruction->avx.mask.mode == ZYDIS_MASK_MODE_ZEROING ||
                    context->instruction->avx.mask.mode == ZYDIS_MASK_MODE_CONTROL_ZEROING) &&
                    (context->instruction->raw.evex.z))
            {
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_ZERO, formatter->case_decorators);
            }
        }
#endif
        break;
    }
    case ZYDIS_DECORATOR_BC:
#if !defined(ZYDIS_DISABLE_AVX512)
        if(!context->instruction->avx.broadcast.is_static)
        {
            switch(context->instruction->avx.broadcast.mode)
            {
            case ZYDIS_BROADCAST_MODE_INVALID:
                break;
            case ZYDIS_BROADCAST_MODE_1_TO_2:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_1TO2, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_1_TO_4:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_1TO4, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_1_TO_8:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_1TO8, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_1_TO_16:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_1TO16, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_1_TO_32:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_1TO32, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_1_TO_64:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_1TO64, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_4_TO_8:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_4TO8, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_4_TO_16:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_4TO16, formatter->case_decorators);
                break;
            case ZYDIS_BROADCAST_MODE_8_TO_16:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_8TO16, formatter->case_decorators);
                break;
            default:
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
        }
#endif
        break;
    case ZYDIS_DECORATOR_RC:
#if !defined(ZYDIS_DISABLE_AVX512)
        if(context->instruction->avx.has_sae)
        {
            switch(context->instruction->avx.rounding.mode)
            {
            case ZYDIS_ROUNDING_MODE_INVALID:
                break;
            case ZYDIS_ROUNDING_MODE_RN:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RN_SAE, formatter->case_decorators);
                break;
            case ZYDIS_ROUNDING_MODE_RD:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RD_SAE, formatter->case_decorators);
                break;
            case ZYDIS_ROUNDING_MODE_RU:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RU_SAE, formatter->case_decorators);
                break;
            case ZYDIS_ROUNDING_MODE_RZ:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RZ_SAE, formatter->case_decorators);
                break;
            default:
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
        }
        else
        {
            switch(context->instruction->avx.rounding.mode)
            {
            case ZYDIS_ROUNDING_MODE_INVALID:
                break;
            case ZYDIS_ROUNDING_MODE_RN:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RN, formatter->case_decorators);
                break;
            case ZYDIS_ROUNDING_MODE_RD:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RD, formatter->case_decorators);
                break;
            case ZYDIS_ROUNDING_MODE_RU:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RU, formatter->case_decorators);
                break;
            case ZYDIS_ROUNDING_MODE_RZ:
                ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_RZ, formatter->case_decorators);
                break;
            default:
                return ZYAN_STATUS_INVALID_ARGUMENT;
            }
        }
#endif
        break;
    case ZYDIS_DECORATOR_SAE:
#if !defined(ZYDIS_DISABLE_AVX512)
        if(context->instruction->avx.has_sae && !context->instruction->avx.rounding.mode)
        {
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_SAE, formatter->case_decorators);
        }
#endif
        break;
    case ZYDIS_DECORATOR_SWIZZLE:
#if !defined(ZYDIS_DISABLE_KNC)
        switch(context->instruction->avx.swizzle.mode)
        {
        case ZYDIS_SWIZZLE_MODE_INVALID:
        case ZYDIS_SWIZZLE_MODE_DCBA:
            // Nothing to do here
            break;
        case ZYDIS_SWIZZLE_MODE_CDAB:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_CDAB, formatter->case_decorators);
            break;
        case ZYDIS_SWIZZLE_MODE_BADC:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_BADC, formatter->case_decorators);
            break;
        case ZYDIS_SWIZZLE_MODE_DACB:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_DACB, formatter->case_decorators);
            break;
        case ZYDIS_SWIZZLE_MODE_AAAA:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_AAAA, formatter->case_decorators);
            break;
        case ZYDIS_SWIZZLE_MODE_BBBB:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_BBBB, formatter->case_decorators);
            break;
        case ZYDIS_SWIZZLE_MODE_CCCC:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_CCCC, formatter->case_decorators);
            break;
        case ZYDIS_SWIZZLE_MODE_DDDD:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_DDDD, formatter->case_decorators);
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
#endif
        break;
    case ZYDIS_DECORATOR_CONVERSION:
#if !defined(ZYDIS_DISABLE_KNC)
        switch(context->instruction->avx.conversion.mode)
        {
        case ZYDIS_CONVERSION_MODE_INVALID:
            break;
        case ZYDIS_CONVERSION_MODE_FLOAT16:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_FLOAT16, formatter->case_decorators);
            break;
        case ZYDIS_CONVERSION_MODE_SINT8:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_SINT8, formatter->case_decorators);
            break;
        case ZYDIS_CONVERSION_MODE_UINT8:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_UINT8, formatter->case_decorators);
            break;
        case ZYDIS_CONVERSION_MODE_SINT16:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_SINT16, formatter->case_decorators);
            break;
        case ZYDIS_CONVERSION_MODE_UINT16:
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_UINT16, formatter->case_decorators);
            break;
        default:
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
#endif
        break;
    case ZYDIS_DECORATOR_EH:
#if !defined(ZYDIS_DISABLE_KNC)
        if(context->instruction->avx.has_eviction_hint)
        {
            ZYDIS_BUFFER_APPEND_CASE(buffer, DECO_EH, formatter->case_decorators);
        }
#endif
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/Mnemonic.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


//
// Header: Generated/EnumMnemonic.inc
//

static const ZydisShortString STR_MNEMONIC[] =
{
    ZYDIS_MAKE_SHORTSTRING("invalid"),
    ZYDIS_MAKE_SHORTSTRING("aaa"),
    ZYDIS_MAKE_SHORTSTRING("aad"),
    ZYDIS_MAKE_SHORTSTRING("aadd"),
    ZYDIS_MAKE_SHORTSTRING("aam"),
    ZYDIS_MAKE_SHORTSTRING("aand"),
    ZYDIS_MAKE_SHORTSTRING("aas"),
    ZYDIS_MAKE_SHORTSTRING("adc"),
    ZYDIS_MAKE_SHORTSTRING("adcx"),
    ZYDIS_MAKE_SHORTSTRING("add"),
    ZYDIS_MAKE_SHORTSTRING("addpd"),
    ZYDIS_MAKE_SHORTSTRING("addps"),
    ZYDIS_MAKE_SHORTSTRING("addsd"),
    ZYDIS_MAKE_SHORTSTRING("addss"),
    ZYDIS_MAKE_SHORTSTRING("addsubpd"),
    ZYDIS_MAKE_SHORTSTRING("addsubps"),
    ZYDIS_MAKE_SHORTSTRING("adox"),
    ZYDIS_MAKE_SHORTSTRING("aesdec"),
    ZYDIS_MAKE_SHORTSTRING("aesdec128kl"),
    ZYDIS_MAKE_SHORTSTRING("aesdec256kl"),
    ZYDIS_MAKE_SHORTSTRING("aesdeclast"),
    ZYDIS_MAKE_SHORTSTRING("aesdecwide128kl"),
    ZYDIS_MAKE_SHORTSTRING("aesdecwide256kl"),
    ZYDIS_MAKE_SHORTSTRING("aesenc"),
    ZYDIS_MAKE_SHORTSTRING("aesenc128kl"),
    ZYDIS_MAKE_SHORTSTRING("aesenc256kl"),
    ZYDIS_MAKE_SHORTSTRING("aesenclast"),
    ZYDIS_MAKE_SHORTSTRING("aesencwide128kl"),
    ZYDIS_MAKE_SHORTSTRING("aesencwide256kl"),
    ZYDIS_MAKE_SHORTSTRING("aesimc"),
    ZYDIS_MAKE_SHORTSTRING("aeskeygenassist"),
    ZYDIS_MAKE_SHORTSTRING("and"),
    ZYDIS_MAKE_SHORTSTRING("andn"),
    ZYDIS_MAKE_SHORTSTRING("andnpd"),
    ZYDIS_MAKE_SHORTSTRING("andnps"),
    ZYDIS_MAKE_SHORTSTRING("andpd"),
    ZYDIS_MAKE_SHORTSTRING("andps"),
    ZYDIS_MAKE_SHORTSTRING("aor"),
    ZYDIS_MAKE_SHORTSTRING("arpl"),
    ZYDIS_MAKE_SHORTSTRING("axor"),
    ZYDIS_MAKE_SHORTSTRING("bextr"),
    ZYDIS_MAKE_SHORTSTRING("blcfill"),
    ZYDIS_MAKE_SHORTSTRING("blci"),
    ZYDIS_MAKE_SHORTSTRING("blcic"),
    ZYDIS_MAKE_SHORTSTRING("blcmsk"),
    ZYDIS_MAKE_SHORTSTRING("blcs"),
    ZYDIS_MAKE_SHORTSTRING("blendpd"),
    ZYDIS_MAKE_SHORTSTRING("blendps"),
    ZYDIS_MAKE_SHORTSTRING("blendvpd"),
    ZYDIS_MAKE_SHORTSTRING("blendvps"),
    ZYDIS_MAKE_SHORTSTRING("blsfill"),
    ZYDIS_MAKE_SHORTSTRING("blsi"),
    ZYDIS_MAKE_SHORTSTRING("blsic"),
    ZYDIS_MAKE_SHORTSTRING("blsmsk"),
    ZYDIS_MAKE_SHORTSTRING("blsr"),
    ZYDIS_MAKE_SHORTSTRING("bndcl"),
    ZYDIS_MAKE_SHORTSTRING("bndcn"),
    ZYDIS_MAKE_SHORTSTRING("bndcu"),
    ZYDIS_MAKE_SHORTSTRING("bndldx"),
    ZYDIS_MAKE_SHORTSTRING("bndmk"),
    ZYDIS_MAKE_SHORTSTRING("bndmov"),
    ZYDIS_MAKE_SHORTSTRING("bndstx"),
    ZYDIS_MAKE_SHORTSTRING("bound"),
    ZYDIS_MAKE_SHORTSTRING("bsf"),
    ZYDIS_MAKE_SHORTSTRING("bsr"),
    ZYDIS_MAKE_SHORTSTRING("bswap"),
    ZYDIS_MAKE_SHORTSTRING("bt"),
    ZYDIS_MAKE_SHORTSTRING("btc"),
    ZYDIS_MAKE_SHORTSTRING("btr"),
    ZYDIS_MAKE_SHORTSTRING("bts"),
    ZYDIS_MAKE_SHORTSTRING("bzhi"),
    ZYDIS_MAKE_SHORTSTRING("call"),
    ZYDIS_MAKE_SHORTSTRING("cbw"),
    ZYDIS_MAKE_SHORTSTRING("cdq"),
    ZYDIS_MAKE_SHORTSTRING("cdqe"),
    ZYDIS_MAKE_SHORTSTRING("clac"),
    ZYDIS_MAKE_SHORTSTRING("clc"),
    ZYDIS_MAKE_SHORTSTRING("cld"),
    ZYDIS_MAKE_SHORTSTRING("cldemote"),
    ZYDIS_MAKE_SHORTSTRING("clevict0"),
    ZYDIS_MAKE_SHORTSTRING("clevict1"),
    ZYDIS_MAKE_SHORTSTRING("clflush"),
    ZYDIS_MAKE_SHORTSTRING("clflushopt"),
    ZYDIS_MAKE_SHORTSTRING("clgi"),
    ZYDIS_MAKE_SHORTSTRING("cli"),
    ZYDIS_MAKE_SHORTSTRING("clrssbsy"),
    ZYDIS_MAKE_SHORTSTRING("clts"),
    ZYDIS_MAKE_SHORTSTRING("clui"),
    ZYDIS_MAKE_SHORTSTRING("clwb"),
    ZYDIS_MAKE_SHORTSTRING("clzero"),
    ZYDIS_MAKE_SHORTSTRING("cmc"),
    ZYDIS_MAKE_SHORTSTRING("cmovb"),
    ZYDIS_MAKE_SHORTSTRING("cmovbe"),
    ZYDIS_MAKE_SHORTSTRING("cmovl"),
    ZYDIS_MAKE_SHORTSTRING("cmovle"),
    ZYDIS_MAKE_SHORTSTRING("cmovnb"),
    ZYDIS_MAKE_SHORTSTRING("cmovnbe"),
    ZYDIS_MAKE_SHORTSTRING("cmovnl"),
    ZYDIS_MAKE_SHORTSTRING("cmovnle"),
    ZYDIS_MAKE_SHORTSTRING("cmovno"),
    ZYDIS_MAKE_SHORTSTRING("cmovnp"),
    ZYDIS_MAKE_SHORTSTRING("cmovns"),
    ZYDIS_MAKE_SHORTSTRING("cmovnz"),
    ZYDIS_MAKE_SHORTSTRING("cmovo"),
    ZYDIS_MAKE_SHORTSTRING("cmovp"),
    ZYDIS_MAKE_SHORTSTRING("cmovs"),
    ZYDIS_MAKE_SHORTSTRING("cmovz"),
    ZYDIS_MAKE_SHORTSTRING("cmp"),
    ZYDIS_MAKE_SHORTSTRING("cmppd"),
    ZYDIS_MAKE_SHORTSTRING("cmpps"),
    ZYDIS_MAKE_SHORTSTRING("cmpsb"),
    ZYDIS_MAKE_SHORTSTRING("cmpsd"),
    ZYDIS_MAKE_SHORTSTRING("cmpsq"),
    ZYDIS_MAKE_SHORTSTRING("cmpss"),
    ZYDIS_MAKE_SHORTSTRING("cmpsw"),
    ZYDIS_MAKE_SHORTSTRING("cmpxchg"),
    ZYDIS_MAKE_SHORTSTRING("cmpxchg16b"),
    ZYDIS_MAKE_SHORTSTRING("cmpxchg8b"),
    ZYDIS_MAKE_SHORTSTRING("comisd"),
    ZYDIS_MAKE_SHORTSTRING("comiss"),
    ZYDIS_MAKE_SHORTSTRING("cpuid"),
    ZYDIS_MAKE_SHORTSTRING("cqo"),
    ZYDIS_MAKE_SHORTSTRING("crc32"),
    ZYDIS_MAKE_SHORTSTRING("cvtdq2pd"),
    ZYDIS_MAKE_SHORTSTRING("cvtdq2ps"),
    ZYDIS_MAKE_SHORTSTRING("cvtpd2dq"),
    ZYDIS_MAKE_SHORTSTRING("cvtpd2pi"),
    ZYDIS_MAKE_SHORTSTRING("cvtpd2ps"),
    ZYDIS_MAKE_SHORTSTRING("cvtpi2pd"),
    ZYDIS_MAKE_SHORTSTRING("cvtpi2ps"),
    ZYDIS_MAKE_SHORTSTRING("cvtps2dq"),
    ZYDIS_MAKE_SHORTSTRING("cvtps2pd"),
    ZYDIS_MAKE_SHORTSTRING("cvtps2pi"),
    ZYDIS_MAKE_SHORTSTRING("cvtsd2si"),
    ZYDIS_MAKE_SHORTSTRING("cvtsd2ss"),
    ZYDIS_MAKE_SHORTSTRING("cvtsi2sd"),
    ZYDIS_MAKE_SHORTSTRING("cvtsi2ss"),
    ZYDIS_MAKE_SHORTSTRING("cvtss2sd"),
    ZYDIS_MAKE_SHORTSTRING("cvtss2si"),
    ZYDIS_MAKE_SHORTSTRING("cvttpd2dq"),
    ZYDIS_MAKE_SHORTSTRING("cvttpd2pi"),
    ZYDIS_MAKE_SHORTSTRING("cvttps2dq"),
    ZYDIS_MAKE_SHORTSTRING("cvttps2pi"),
    ZYDIS_MAKE_SHORTSTRING("cvttsd2si"),
    ZYDIS_MAKE_SHORTSTRING("cvttss2si"),
    ZYDIS_MAKE_SHORTSTRING("cwd"),
    ZYDIS_MAKE_SHORTSTRING("cwde"),
    ZYDIS_MAKE_SHORTSTRING("daa"),
    ZYDIS_MAKE_SHORTSTRING("das"),
    ZYDIS_MAKE_SHORTSTRING("dec"),
    ZYDIS_MAKE_SHORTSTRING("delay"),
    ZYDIS_MAKE_SHORTSTRING("div"),
    ZYDIS_MAKE_SHORTSTRING("divpd"),
    ZYDIS_MAKE_SHORTSTRING("divps"),
    ZYDIS_MAKE_SHORTSTRING("divsd"),
    ZYDIS_MAKE_SHORTSTRING("divss"),
    ZYDIS_MAKE_SHORTSTRING("dppd"),
    ZYDIS_MAKE_SHORTSTRING("dpps"),
    ZYDIS_MAKE_SHORTSTRING("emms"),
    ZYDIS_MAKE_SHORTSTRING("encls"),
    ZYDIS_MAKE_SHORTSTRING("enclu"),
    ZYDIS_MAKE_SHORTSTRING("enclv"),
    ZYDIS_MAKE_SHORTSTRING("encodekey128"),
    ZYDIS_MAKE_SHORTSTRING("encodekey256"),
    ZYDIS_MAKE_SHORTSTRING("endbr32"),
    ZYDIS_MAKE_SHORTSTRING("endbr64"),
    ZYDIS_MAKE_SHORTSTRING("enqcmd"),
    ZYDIS_MAKE_SHORTSTRING("enqcmds"),
    ZYDIS_MAKE_SHORTSTRING("enter"),
    ZYDIS_MAKE_SHORTSTRING("extractps"),
    ZYDIS_MAKE_SHORTSTRING("extrq"),
    ZYDIS_MAKE_SHORTSTRING("f2xm1"),
    ZYDIS_MAKE_SHORTSTRING("fabs"),
    ZYDIS_MAKE_SHORTSTRING("fadd"),
    ZYDIS_MAKE_SHORTSTRING("faddp"),
    ZYDIS_MAKE_SHORTSTRING("fbld"),
    ZYDIS_MAKE_SHORTSTRING("fbstp"),
    ZYDIS_MAKE_SHORTSTRING("fchs"),
    ZYDIS_MAKE_SHORTSTRING("fcmovb"),
    ZYDIS_MAKE_SHORTSTRING("fcmovbe"),
    ZYDIS_MAKE_SHORTSTRING("fcmove"),
    ZYDIS_MAKE_SHORTSTRING("fcmovnb"),
    ZYDIS_MAKE_SHORTSTRING("fcmovnbe"),
    ZYDIS_MAKE_SHORTSTRING("fcmovne"),
    ZYDIS_MAKE_SHORTSTRING("fcmovnu"),
    ZYDIS_MAKE_SHORTSTRING("fcmovu"),
    ZYDIS_MAKE_SHORTSTRING("fcom"),
    ZYDIS_MAKE_SHORTSTRING("fcomi"),
    ZYDIS_MAKE_SHORTSTRING("fcomip"),
    ZYDIS_MAKE_SHORTSTRING("fcomp"),
    ZYDIS_MAKE_SHORTSTRING("fcompp"),
    ZYDIS_MAKE_SHORTSTRING("fcos"),
    ZYDIS_MAKE_SHORTSTRING("fdecstp"),
    ZYDIS_MAKE_SHORTSTRING("fdisi8087_nop"),
    ZYDIS_MAKE_SHORTSTRING("fdiv"),
    ZYDIS_MAKE_SHORTSTRING("fdivp"),
    ZYDIS_MAKE_SHORTSTRING("fdivr"),
    ZYDIS_MAKE_SHORTSTRING("fdivrp"),
    ZYDIS_MAKE_SHORTSTRING("femms"),
    ZYDIS_MAKE_SHORTSTRING("feni8087_nop"),
    ZYDIS_MAKE_SHORTSTRING("ffree"),
    ZYDIS_MAKE_SHORTSTRING("ffreep"),
    ZYDIS_MAKE_SHORTSTRING("fiadd"),
    ZYDIS_MAKE_SHORTSTRING("ficom"),
    ZYDIS_MAKE_SHORTSTRING("ficomp"),
    ZYDIS_MAKE_SHORTSTRING("fidiv"),
    ZYDIS_MAKE_SHORTSTRING("fidivr"),
    ZYDIS_MAKE_SHORTSTRING("fild"),
    ZYDIS_MAKE_SHORTSTRING("fimul"),
    ZYDIS_MAKE_SHORTSTRING("fincstp"),
    ZYDIS_MAKE_SHORTSTRING("fist"),
    ZYDIS_MAKE_SHORTSTRING("fistp"),
    ZYDIS_MAKE_SHORTSTRING("fisttp"),
    ZYDIS_MAKE_SHORTSTRING("fisub"),
    ZYDIS_MAKE_SHORTSTRING("fisubr"),
    ZYDIS_MAKE_SHORTSTRING("fld"),
    ZYDIS_MAKE_SHORTSTRING("fld1"),
    ZYDIS_MAKE_SHORTSTRING("fldcw"),
    ZYDIS_MAKE_SHORTSTRING("fldenv"),
    ZYDIS_MAKE_SHORTSTRING("fldl2e"),
    ZYDIS_MAKE_SHORTSTRING("fldl2t"),
    ZYDIS_MAKE_SHORTSTRING("fldlg2"),
    ZYDIS_MAKE_SHORTSTRING("fldln2"),
    ZYDIS_MAKE_SHORTSTRING("fldpi"),
    ZYDIS_MAKE_SHORTSTRING("fldz"),
    ZYDIS_MAKE_SHORTSTRING("fmul"),
    ZYDIS_MAKE_SHORTSTRING("fmulp"),
    ZYDIS_MAKE_SHORTSTRING("fnclex"),
    ZYDIS_MAKE_SHORTSTRING("fninit"),
    ZYDIS_MAKE_SHORTSTRING("fnop"),
    ZYDIS_MAKE_SHORTSTRING("fnsave"),
    ZYDIS_MAKE_SHORTSTRING("fnstcw"),
    ZYDIS_MAKE_SHORTSTRING("fnstenv"),
    ZYDIS_MAKE_SHORTSTRING("fnstsw"),
    ZYDIS_MAKE_SHORTSTRING("fpatan"),
    ZYDIS_MAKE_SHORTSTRING("fprem"),
    ZYDIS_MAKE_SHORTSTRING("fprem1"),
    ZYDIS_MAKE_SHORTSTRING("fptan"),
    ZYDIS_MAKE_SHORTSTRING("frndint"),
    ZYDIS_MAKE_SHORTSTRING("frstor"),
    ZYDIS_MAKE_SHORTSTRING("fscale"),
    ZYDIS_MAKE_SHORTSTRING("fsetpm287_nop"),
    ZYDIS_MAKE_SHORTSTRING("fsin"),
    ZYDIS_MAKE_SHORTSTRING("fsincos"),
    ZYDIS_MAKE_SHORTSTRING("fsqrt"),
    ZYDIS_MAKE_SHORTSTRING("fst"),
    ZYDIS_MAKE_SHORTSTRING("fstp"),
    ZYDIS_MAKE_SHORTSTRING("fstpnce"),
    ZYDIS_MAKE_SHORTSTRING("fsub"),
    ZYDIS_MAKE_SHORTSTRING("fsubp"),
    ZYDIS_MAKE_SHORTSTRING("fsubr"),
    ZYDIS_MAKE_SHORTSTRING("fsubrp"),
    ZYDIS_MAKE_SHORTSTRING("ftst"),
    ZYDIS_MAKE_SHORTSTRING("fucom"),
    ZYDIS_MAKE_SHORTSTRING("fucomi"),
    ZYDIS_MAKE_SHORTSTRING("fucomip"),
    ZYDIS_MAKE_SHORTSTRING("fucomp"),
    ZYDIS_MAKE_SHORTSTRING("fucompp"),
    ZYDIS_MAKE_SHORTSTRING("fwait"),
    ZYDIS_MAKE_SHORTSTRING("fxam"),
    ZYDIS_MAKE_SHORTSTRING("fxch"),
    ZYDIS_MAKE_SHORTSTRING("fxrstor"),
    ZYDIS_MAKE_SHORTSTRING("fxrstor64"),
    ZYDIS_MAKE_SHORTSTRING("fxsave"),
    ZYDIS_MAKE_SHORTSTRING("fxsave64"),
    ZYDIS_MAKE_SHORTSTRING("fxtract"),
    ZYDIS_MAKE_SHORTSTRING("fyl2x"),
    ZYDIS_MAKE_SHORTSTRING("fyl2xp1"),
    ZYDIS_MAKE_SHORTSTRING("getsec"),
    ZYDIS_MAKE_SHORTSTRING("gf2p8affineinvqb"),
    ZYDIS_MAKE_SHORTSTRING("gf2p8affineqb"),
    ZYDIS_MAKE_SHORTSTRING("gf2p8mulb"),
    ZYDIS_MAKE_SHORTSTRING("haddpd"),
    ZYDIS_MAKE_SHORTSTRING("haddps"),
    ZYDIS_MAKE_SHORTSTRING("hlt"),
    ZYDIS_MAKE_SHORTSTRING("hreset"),
    ZYDIS_MAKE_SHORTSTRING("hsubpd"),
    ZYDIS_MAKE_SHORTSTRING("hsubps"),
    ZYDIS_MAKE_SHORTSTRING("idiv"),
    ZYDIS_MAKE_SHORTSTRING("imul"),
    ZYDIS_MAKE_SHORTSTRING("in"),
    ZYDIS_MAKE_SHORTSTRING("inc"),
    ZYDIS_MAKE_SHORTSTRING("incsspd"),
    ZYDIS_MAKE_SHORTSTRING("incsspq"),
    ZYDIS_MAKE_SHORTSTRING("insb"),
    ZYDIS_MAKE_SHORTSTRING("insd"),
    ZYDIS_MAKE_SHORTSTRING("insertps"),
    ZYDIS_MAKE_SHORTSTRING("insertq"),
    ZYDIS_MAKE_SHORTSTRING("insw"),
    ZYDIS_MAKE_SHORTSTRING("int"),
    ZYDIS_MAKE_SHORTSTRING("int1"),
    ZYDIS_MAKE_SHORTSTRING("int3"),
    ZYDIS_MAKE_SHORTSTRING("into"),
    ZYDIS_MAKE_SHORTSTRING("invd"),
    ZYDIS_MAKE_SHORTSTRING("invept"),
    ZYDIS_MAKE_SHORTSTRING("invlpg"),
    ZYDIS_MAKE_SHORTSTRING("invlpga"),
    ZYDIS_MAKE_SHORTSTRING("invlpgb"),
    ZYDIS_MAKE_SHORTSTRING("invpcid"),
    ZYDIS_MAKE_SHORTSTRING("invvpid"),
    ZYDIS_MAKE_SHORTSTRING("iret"),
    ZYDIS_MAKE_SHORTSTRING("iretd"),
    ZYDIS_MAKE_SHORTSTRING("iretq"),
    ZYDIS_MAKE_SHORTSTRING("jb"),
    ZYDIS_MAKE_SHORTSTRING("jbe"),
    ZYDIS_MAKE_SHORTSTRING("jcxz"),
    ZYDIS_MAKE_SHORTSTRING("jecxz"),
    ZYDIS_MAKE_SHORTSTRING("jknzd"),
    ZYDIS_MAKE_SHORTSTRING("jkzd"),
    ZYDIS_MAKE_SHORTSTRING("jl"),
    ZYDIS_MAKE_SHORTSTRING("jle"),
    ZYDIS_MAKE_SHORTSTRING("jmp"),
    ZYDIS_MAKE_SHORTSTRING("jnb"),
    ZYDIS_MAKE_SHORTSTRING("jnbe"),
    ZYDIS_MAKE_SHORTSTRING("jnl"),
    ZYDIS_MAKE_SHORTSTRING("jnle"),
    ZYDIS_MAKE_SHORTSTRING("jno"),
    ZYDIS_MAKE_SHORTSTRING("jnp"),
    ZYDIS_MAKE_SHORTSTRING("jns"),
    ZYDIS_MAKE_SHORTSTRING("jnz"),
    ZYDIS_MAKE_SHORTSTRING("jo"),
    ZYDIS_MAKE_SHORTSTRING("jp"),
    ZYDIS_MAKE_SHORTSTRING("jrcxz"),
    ZYDIS_MAKE_SHORTSTRING("js"),
    ZYDIS_MAKE_SHORTSTRING("jz"),
    ZYDIS_MAKE_SHORTSTRING("kaddb"),
    ZYDIS_MAKE_SHORTSTRING("kaddd"),
    ZYDIS_MAKE_SHORTSTRING("kaddq"),
    ZYDIS_MAKE_SHORTSTRING("kaddw"),
    ZYDIS_MAKE_SHORTSTRING("kand"),
    ZYDIS_MAKE_SHORTSTRING("kandb"),
    ZYDIS_MAKE_SHORTSTRING("kandd"),
    ZYDIS_MAKE_SHORTSTRING("kandn"),
    ZYDIS_MAKE_SHORTSTRING("kandnb"),
    ZYDIS_MAKE_SHORTSTRING("kandnd"),
    ZYDIS_MAKE_SHORTSTRING("kandnq"),
    ZYDIS_MAKE_SHORTSTRING("kandnr"),
    ZYDIS_MAKE_SHORTSTRING("kandnw"),
    ZYDIS_MAKE_SHORTSTRING("kandq"),
    ZYDIS_MAKE_SHORTSTRING("kandw"),
    ZYDIS_MAKE_SHORTSTRING("kconcath"),
    ZYDIS_MAKE_SHORTSTRING("kconcatl"),
    ZYDIS_MAKE_SHORTSTRING("kextract"),
    ZYDIS_MAKE_SHORTSTRING("kmerge2l1h"),
    ZYDIS_MAKE_SHORTSTRING("kmerge2l1l"),
    ZYDIS_MAKE_SHORTSTRING("kmov"),
    ZYDIS_MAKE_SHORTSTRING("kmovb"),
    ZYDIS_MAKE_SHORTSTRING("kmovd"),
    ZYDIS_MAKE_SHORTSTRING("kmovq"),
    ZYDIS_MAKE_SHORTSTRING("kmovw"),
    ZYDIS_MAKE_SHORTSTRING("knot"),
    ZYDIS_MAKE_SHORTSTRING("knotb"),
    ZYDIS_MAKE_SHORTSTRING("knotd"),
    ZYDIS_MAKE_SHORTSTRING("knotq"),
    ZYDIS_MAKE_SHORTSTRING("knotw"),
    ZYDIS_MAKE_SHORTSTRING("kor"),
    ZYDIS_MAKE_SHORTSTRING("korb"),
    ZYDIS_MAKE_SHORTSTRING("kord"),
    ZYDIS_MAKE_SHORTSTRING("korq"),
    ZYDIS_MAKE_SHORTSTRING("kortest"),
    ZYDIS_MAKE_SHORTSTRING("kortestb"),
    ZYDIS_MAKE_SHORTSTRING("kortestd"),
    ZYDIS_MAKE_SHORTSTRING("kortestq"),
    ZYDIS_MAKE_SHORTSTRING("kortestw"),
    ZYDIS_MAKE_SHORTSTRING("korw"),
    ZYDIS_MAKE_SHORTSTRING("kshiftlb"),
    ZYDIS_MAKE_SHORTSTRING("kshiftld"),
    ZYDIS_MAKE_SHORTSTRING("kshiftlq"),
    ZYDIS_MAKE_SHORTSTRING("kshiftlw"),
    ZYDIS_MAKE_SHORTSTRING("kshiftrb"),
    ZYDIS_MAKE_SHORTSTRING("kshiftrd"),
    ZYDIS_MAKE_SHORTSTRING("kshiftrq"),
    ZYDIS_MAKE_SHORTSTRING("kshiftrw"),
    ZYDIS_MAKE_SHORTSTRING("ktestb"),
    ZYDIS_MAKE_SHORTSTRING("ktestd"),
    ZYDIS_MAKE_SHORTSTRING("ktestq"),
    ZYDIS_MAKE_SHORTSTRING("ktestw"),
    ZYDIS_MAKE_SHORTSTRING("kunpckbw"),
    ZYDIS_MAKE_SHORTSTRING("kunpckdq"),
    ZYDIS_MAKE_SHORTSTRING("kunpckwd"),
    ZYDIS_MAKE_SHORTSTRING("kxnor"),
    ZYDIS_MAKE_SHORTSTRING("kxnorb"),
    ZYDIS_MAKE_SHORTSTRING("kxnord"),
    ZYDIS_MAKE_SHORTSTRING("kxnorq"),
    ZYDIS_MAKE_SHORTSTRING("kxnorw"),
    ZYDIS_MAKE_SHORTSTRING("kxor"),
    ZYDIS_MAKE_SHORTSTRING("kxorb"),
    ZYDIS_MAKE_SHORTSTRING("kxord"),
    ZYDIS_MAKE_SHORTSTRING("kxorq"),
    ZYDIS_MAKE_SHORTSTRING("kxorw"),
    ZYDIS_MAKE_SHORTSTRING("lahf"),
    ZYDIS_MAKE_SHORTSTRING("lar"),
    ZYDIS_MAKE_SHORTSTRING("lddqu"),
    ZYDIS_MAKE_SHORTSTRING("ldmxcsr"),
    ZYDIS_MAKE_SHORTSTRING("lds"),
    ZYDIS_MAKE_SHORTSTRING("ldtilecfg"),
    ZYDIS_MAKE_SHORTSTRING("lea"),
    ZYDIS_MAKE_SHORTSTRING("leave"),
    ZYDIS_MAKE_SHORTSTRING("les"),
    ZYDIS_MAKE_SHORTSTRING("lfence"),
    ZYDIS_MAKE_SHORTSTRING("lfs"),
    ZYDIS_MAKE_SHORTSTRING("lgdt"),
    ZYDIS_MAKE_SHORTSTRING("lgs"),
    ZYDIS_MAKE_SHORTSTRING("lidt"),
    ZYDIS_MAKE_SHORTSTRING("lldt"),
    ZYDIS_MAKE_SHORTSTRING("llwpcb"),
    ZYDIS_MAKE_SHORTSTRING("lmsw"),
    ZYDIS_MAKE_SHORTSTRING("loadiwkey"),
    ZYDIS_MAKE_SHORTSTRING("lodsb"),
    ZYDIS_MAKE_SHORTSTRING("lodsd"),
    ZYDIS_MAKE_SHORTSTRING("lodsq"),
    ZYDIS_MAKE_SHORTSTRING("lodsw"),
    ZYDIS_MAKE_SHORTSTRING("loop"),
    ZYDIS_MAKE_SHORTSTRING("loope"),
    ZYDIS_MAKE_SHORTSTRING("loopne"),
    ZYDIS_MAKE_SHORTSTRING("lsl"),
    ZYDIS_MAKE_SHORTSTRING("lss"),
    ZYDIS_MAKE_SHORTSTRING("ltr"),
    ZYDIS_MAKE_SHORTSTRING("lwpins"),
    ZYDIS_MAKE_SHORTSTRING("lwpval"),
    ZYDIS_MAKE_SHORTSTRING("lzcnt"),
    ZYDIS_MAKE_SHORTSTRING("maskmovdqu"),
    ZYDIS_MAKE_SHORTSTRING("maskmovq"),
    ZYDIS_MAKE_SHORTSTRING("maxpd"),
    ZYDIS_MAKE_SHORTSTRING("maxps"),
    ZYDIS_MAKE_SHORTSTRING("maxsd"),
    ZYDIS_MAKE_SHORTSTRING("maxss"),
    ZYDIS_MAKE_SHORTSTRING("mcommit"),
    ZYDIS_MAKE_SHORTSTRING("mfence"),
    ZYDIS_MAKE_SHORTSTRING("minpd"),
    ZYDIS_MAKE_SHORTSTRING("minps"),
    ZYDIS_MAKE_SHORTSTRING("minsd"),
    ZYDIS_MAKE_SHORTSTRING("minss"),
    ZYDIS_MAKE_SHORTSTRING("monitor"),
    ZYDIS_MAKE_SHORTSTRING("monitorx"),
    ZYDIS_MAKE_SHORTSTRING("montmul"),
    ZYDIS_MAKE_SHORTSTRING("mov"),
    ZYDIS_MAKE_SHORTSTRING("movapd"),
    ZYDIS_MAKE_SHORTSTRING("movaps"),
    ZYDIS_MAKE_SHORTSTRING("movbe"),
    ZYDIS_MAKE_SHORTSTRING("movd"),
    ZYDIS_MAKE_SHORTSTRING("movddup"),
    ZYDIS_MAKE_SHORTSTRING("movdir64b"),
    ZYDIS_MAKE_SHORTSTRING("movdiri"),
    ZYDIS_MAKE_SHORTSTRING("movdq2q"),
    ZYDIS_MAKE_SHORTSTRING("movdqa"),
    ZYDIS_MAKE_SHORTSTRING("movdqu"),
    ZYDIS_MAKE_SHORTSTRING("movhlps"),
    ZYDIS_MAKE_SHORTSTRING("movhpd"),
    ZYDIS_MAKE_SHORTSTRING("movhps"),
    ZYDIS_MAKE_SHORTSTRING("movlhps"),
    ZYDIS_MAKE_SHORTSTRING("movlpd"),
    ZYDIS_MAKE_SHORTSTRING("movlps"),
    ZYDIS_MAKE_SHORTSTRING("movmskpd"),
    ZYDIS_MAKE_SHORTSTRING("movmskps"),
    ZYDIS_MAKE_SHORTSTRING("movntdq"),
    ZYDIS_MAKE_SHORTSTRING("movntdqa"),
    ZYDIS_MAKE_SHORTSTRING("movnti"),
    ZYDIS_MAKE_SHORTSTRING("movntpd"),
    ZYDIS_MAKE_SHORTSTRING("movntps"),
    ZYDIS_MAKE_SHORTSTRING("movntq"),
    ZYDIS_MAKE_SHORTSTRING("movntsd"),
    ZYDIS_MAKE_SHORTSTRING("movntss"),
    ZYDIS_MAKE_SHORTSTRING("movq"),
    ZYDIS_MAKE_SHORTSTRING("movq2dq"),
    ZYDIS_MAKE_SHORTSTRING("movsb"),
    ZYDIS_MAKE_SHORTSTRING("movsd"),
    ZYDIS_MAKE_SHORTSTRING("movshdup"),
    ZYDIS_MAKE_SHORTSTRING("movsldup"),
    ZYDIS_MAKE_SHORTSTRING("movsq"),
    ZYDIS_MAKE_SHORTSTRING("movss"),
    ZYDIS_MAKE_SHORTSTRING("movsw"),
    ZYDIS_MAKE_SHORTSTRING("movsx"),
    ZYDIS_MAKE_SHORTSTRING("movsxd"),
    ZYDIS_MAKE_SHORTSTRING("movupd"),
    ZYDIS_MAKE_SHORTSTRING("movups"),
    ZYDIS_MAKE_SHORTSTRING("movzx"),
    ZYDIS_MAKE_SHORTSTRING("mpsadbw"),
    ZYDIS_MAKE_SHORTSTRING("mul"),
    ZYDIS_MAKE_SHORTSTRING("mulpd"),
    ZYDIS_MAKE_SHORTSTRING("mulps"),
    ZYDIS_MAKE_SHORTSTRING("mulsd"),
    ZYDIS_MAKE_SHORTSTRING("mulss"),
    ZYDIS_MAKE_SHORTSTRING("mulx"),
    ZYDIS_MAKE_SHORTSTRING("mwait"),
    ZYDIS_MAKE_SHORTSTRING("mwaitx"),
    ZYDIS_MAKE_SHORTSTRING("neg"),
    ZYDIS_MAKE_SHORTSTRING("nop"),
    ZYDIS_MAKE_SHORTSTRING("not"),
    ZYDIS_MAKE_SHORTSTRING("or"),
    ZYDIS_MAKE_SHORTSTRING("orpd"),
    ZYDIS_MAKE_SHORTSTRING("orps"),
    ZYDIS_MAKE_SHORTSTRING("out"),
    ZYDIS_MAKE_SHORTSTRING("outsb"),
    ZYDIS_MAKE_SHORTSTRING("outsd"),
    ZYDIS_MAKE_SHORTSTRING("outsw"),
    ZYDIS_MAKE_SHORTSTRING("pabsb"),
    ZYDIS_MAKE_SHORTSTRING("pabsd"),
    ZYDIS_MAKE_SHORTSTRING("pabsw"),
    ZYDIS_MAKE_SHORTSTRING("packssdw"),
    ZYDIS_MAKE_SHORTSTRING("packsswb"),
    ZYDIS_MAKE_SHORTSTRING("packusdw"),
    ZYDIS_MAKE_SHORTSTRING("packuswb"),
    ZYDIS_MAKE_SHORTSTRING("paddb"),
    ZYDIS_MAKE_SHORTSTRING("paddd"),
    ZYDIS_MAKE_SHORTSTRING("paddq"),
    ZYDIS_MAKE_SHORTSTRING("paddsb"),
    ZYDIS_MAKE_SHORTSTRING("paddsw"),
    ZYDIS_MAKE_SHORTSTRING("paddusb"),
    ZYDIS_MAKE_SHORTSTRING("paddusw"),
    ZYDIS_MAKE_SHORTSTRING("paddw"),
    ZYDIS_MAKE_SHORTSTRING("palignr"),
    ZYDIS_MAKE_SHORTSTRING("pand"),
    ZYDIS_MAKE_SHORTSTRING("pandn"),
    ZYDIS_MAKE_SHORTSTRING("pause"),
    ZYDIS_MAKE_SHORTSTRING("pavgb"),
    ZYDIS_MAKE_SHORTSTRING("pavgusb"),
    ZYDIS_MAKE_SHORTSTRING("pavgw"),
    ZYDIS_MAKE_SHORTSTRING("pblendvb"),
    ZYDIS_MAKE_SHORTSTRING("pblendw"),
    ZYDIS_MAKE_SHORTSTRING("pclmulqdq"),
    ZYDIS_MAKE_SHORTSTRING("pcmpeqb"),
    ZYDIS_MAKE_SHORTSTRING("pcmpeqd"),
    ZYDIS_MAKE_SHORTSTRING("pcmpeqq"),
    ZYDIS_MAKE_SHORTSTRING("pcmpeqw"),
    ZYDIS_MAKE_SHORTSTRING("pcmpestri"),
    ZYDIS_MAKE_SHORTSTRING("pcmpestrm"),
    ZYDIS_MAKE_SHORTSTRING("pcmpgtb"),
    ZYDIS_MAKE_SHORTSTRING("pcmpgtd"),
    ZYDIS_MAKE_SHORTSTRING("pcmpgtq"),
    ZYDIS_MAKE_SHORTSTRING("pcmpgtw"),
    ZYDIS_MAKE_SHORTSTRING("pcmpistri"),
    ZYDIS_MAKE_SHORTSTRING("pcmpistrm"),
    ZYDIS_MAKE_SHORTSTRING("pconfig"),
    ZYDIS_MAKE_SHORTSTRING("pdep"),
    ZYDIS_MAKE_SHORTSTRING("pext"),
    ZYDIS_MAKE_SHORTSTRING("pextrb"),
    ZYDIS_MAKE_SHORTSTRING("pextrd"),
    ZYDIS_MAKE_SHORTSTRING("pextrq"),
    ZYDIS_MAKE_SHORTSTRING("pextrw"),
    ZYDIS_MAKE_SHORTSTRING("pf2id"),
    ZYDIS_MAKE_SHORTSTRING("pf2iw"),
    ZYDIS_MAKE_SHORTSTRING("pfacc"),
    ZYDIS_MAKE_SHORTSTRING("pfadd"),
    ZYDIS_MAKE_SHORTSTRING("pfcmpeq"),
    ZYDIS_MAKE_SHORTSTRING("pfcmpge"),
    ZYDIS_MAKE_SHORTSTRING("pfcmpgt"),
    ZYDIS_MAKE_SHORTSTRING("pfcpit1"),
    ZYDIS_MAKE_SHORTSTRING("pfmax"),
    ZYDIS_MAKE_SHORTSTRING("pfmin"),
    ZYDIS_MAKE_SHORTSTRING("pfmul"),
    ZYDIS_MAKE_SHORTSTRING("pfnacc"),
    ZYDIS_MAKE_SHORTSTRING("pfpnacc"),
    ZYDIS_MAKE_SHORTSTRING("pfrcp"),
    ZYDIS_MAKE_SHORTSTRING("pfrcpit2"),
    ZYDIS_MAKE_SHORTSTRING("pfrsqit1"),
    ZYDIS_MAKE_SHORTSTRING("pfsqrt"),
    ZYDIS_MAKE_SHORTSTRING("pfsub"),
    ZYDIS_MAKE_SHORTSTRING("pfsubr"),
    ZYDIS_MAKE_SHORTSTRING("phaddd"),
    ZYDIS_MAKE_SHORTSTRING("phaddsw"),
    ZYDIS_MAKE_SHORTSTRING("phaddw"),
    ZYDIS_MAKE_SHORTSTRING("phminposuw"),
    ZYDIS_MAKE_SHORTSTRING("phsubd"),
    ZYDIS_MAKE_SHORTSTRING("phsubsw"),
    ZYDIS_MAKE_SHORTSTRING("phsubw"),
    ZYDIS_MAKE_SHORTSTRING("pi2fd"),
    ZYDIS_MAKE_SHORTSTRING("pi2fw"),
    ZYDIS_MAKE_SHORTSTRING("pinsrb"),
    ZYDIS_MAKE_SHORTSTRING("pinsrd"),
    ZYDIS_MAKE_SHORTSTRING("pinsrq"),
    ZYDIS_MAKE_SHORTSTRING("pinsrw"),
    ZYDIS_MAKE_SHORTSTRING("pmaddubsw"),
    ZYDIS_MAKE_SHORTSTRING("pmaddwd"),
    ZYDIS_MAKE_SHORTSTRING("pmaxsb"),
    ZYDIS_MAKE_SHORTSTRING("pmaxsd"),
    ZYDIS_MAKE_SHORTSTRING("pmaxsw"),
    ZYDIS_MAKE_SHORTSTRING("pmaxub"),
    ZYDIS_MAKE_SHORTSTRING("pmaxud"),
    ZYDIS_MAKE_SHORTSTRING("pmaxuw"),
    ZYDIS_MAKE_SHORTSTRING("pminsb"),
    ZYDIS_MAKE_SHORTSTRING("pminsd"),
    ZYDIS_MAKE_SHORTSTRING("pminsw"),
    ZYDIS_MAKE_SHORTSTRING("pminub"),
    ZYDIS_MAKE_SHORTSTRING("pminud"),
    ZYDIS_MAKE_SHORTSTRING("pminuw"),
    ZYDIS_MAKE_SHORTSTRING("pmovmskb"),
    ZYDIS_MAKE_SHORTSTRING("pmovsxbd"),
    ZYDIS_MAKE_SHORTSTRING("pmovsxbq"),
    ZYDIS_MAKE_SHORTSTRING("pmovsxbw"),
    ZYDIS_MAKE_SHORTSTRING("pmovsxdq"),
    ZYDIS_MAKE_SHORTSTRING("pmovsxwd"),
    ZYDIS_MAKE_SHORTSTRING("pmovsxwq"),
    ZYDIS_MAKE_SHORTSTRING("pmovzxbd"),
    ZYDIS_MAKE_SHORTSTRING("pmovzxbq"),
    ZYDIS_MAKE_SHORTSTRING("pmovzxbw"),
    ZYDIS_MAKE_SHORTSTRING("pmovzxdq"),
    ZYDIS_MAKE_SHORTSTRING("pmovzxwd"),
    ZYDIS_MAKE_SHORTSTRING("pmovzxwq"),
    ZYDIS_MAKE_SHORTSTRING("pmuldq"),
    ZYDIS_MAKE_SHORTSTRING("pmulhrsw"),
    ZYDIS_MAKE_SHORTSTRING("pmulhrw"),
    ZYDIS_MAKE_SHORTSTRING("pmulhuw"),
    ZYDIS_MAKE_SHORTSTRING("pmulhw"),
    ZYDIS_MAKE_SHORTSTRING("pmulld"),
    ZYDIS_MAKE_SHORTSTRING("pmullw"),
    ZYDIS_MAKE_SHORTSTRING("pmuludq"),
    ZYDIS_MAKE_SHORTSTRING("pop"),
    ZYDIS_MAKE_SHORTSTRING("popa"),
    ZYDIS_MAKE_SHORTSTRING("popad"),
    ZYDIS_MAKE_SHORTSTRING("popcnt"),
    ZYDIS_MAKE_SHORTSTRING("popf"),
    ZYDIS_MAKE_SHORTSTRING("popfd"),
    ZYDIS_MAKE_SHORTSTRING("popfq"),
    ZYDIS_MAKE_SHORTSTRING("por"),
    ZYDIS_MAKE_SHORTSTRING("prefetch"),
    ZYDIS_MAKE_SHORTSTRING("prefetchit0"),
    ZYDIS_MAKE_SHORTSTRING("prefetchit1"),
    ZYDIS_MAKE_SHORTSTRING("prefetchnta"),
    ZYDIS_MAKE_SHORTSTRING("prefetcht0"),
    ZYDIS_MAKE_SHORTSTRING("prefetcht1"),
    ZYDIS_MAKE_SHORTSTRING("prefetcht2"),
    ZYDIS_MAKE_SHORTSTRING("prefetchw"),
    ZYDIS_MAKE_SHORTSTRING("prefetchwt1"),
    ZYDIS_MAKE_SHORTSTRING("psadbw"),
    ZYDIS_MAKE_SHORTSTRING("pshufb"),
    ZYDIS_MAKE_SHORTSTRING("pshufd"),
    ZYDIS_MAKE_SHORTSTRING("pshufhw"),
    ZYDIS_MAKE_SHORTSTRING("pshuflw"),
    ZYDIS_MAKE_SHORTSTRING("pshufw"),
    ZYDIS_MAKE_SHORTSTRING("psignb"),
    ZYDIS_MAKE_SHORTSTRING("psignd"),
    ZYDIS_MAKE_SHORTSTRING("psignw"),
    ZYDIS_MAKE_SHORTSTRING("pslld"),
    ZYDIS_MAKE_SHORTSTRING("pslldq"),
    ZYDIS_MAKE_SHORTSTRING("psllq"),
    ZYDIS_MAKE_SHORTSTRING("psllw"),
    ZYDIS_MAKE_SHORTSTRING("psmash"),
    ZYDIS_MAKE_SHORTSTRING("psrad"),
    ZYDIS_MAKE_SHORTSTRING("psraw"),
    ZYDIS_MAKE_SHORTSTRING("psrld"),
    ZYDIS_MAKE_SHORTSTRING("psrldq"),
    ZYDIS_MAKE_SHORTSTRING("psrlq"),
    ZYDIS_MAKE_SHORTSTRING("psrlw"),
    ZYDIS_MAKE_SHORTSTRING("psubb"),
    ZYDIS_MAKE_SHORTSTRING("psubd"),
    ZYDIS_MAKE_SHORTSTRING("psubq"),
    ZYDIS_MAKE_SHORTSTRING("psubsb"),
    ZYDIS_MAKE_SHORTSTRING("psubsw"),
    ZYDIS_MAKE_SHORTSTRING("psubusb"),
    ZYDIS_MAKE_SHORTSTRING("psubusw"),
    ZYDIS_MAKE_SHORTSTRING("psubw"),
    ZYDIS_MAKE_SHORTSTRING("pswapd"),
    ZYDIS_MAKE_SHORTSTRING("ptest"),
    ZYDIS_MAKE_SHORTSTRING("ptwrite"),
    ZYDIS_MAKE_SHORTSTRING("punpckhbw"),
    ZYDIS_MAKE_SHORTSTRING("punpckhdq"),
    ZYDIS_MAKE_SHORTSTRING("punpckhqdq"),
    ZYDIS_MAKE_SHORTSTRING("punpckhwd"),
    ZYDIS_MAKE_SHORTSTRING("punpcklbw"),
    ZYDIS_MAKE_SHORTSTRING("punpckldq"),
    ZYDIS_MAKE_SHORTSTRING("punpcklqdq"),
    ZYDIS_MAKE_SHORTSTRING("punpcklwd"),
    ZYDIS_MAKE_SHORTSTRING("push"),
    ZYDIS_MAKE_SHORTSTRING("pusha"),
    ZYDIS_MAKE_SHORTSTRING("pushad"),
    ZYDIS_MAKE_SHORTSTRING("pushf"),
    ZYDIS_MAKE_SHORTSTRING("pushfd"),
    ZYDIS_MAKE_SHORTSTRING("pushfq"),
    ZYDIS_MAKE_SHORTSTRING("pvalidate"),
    ZYDIS_MAKE_SHORTSTRING("pxor"),
    ZYDIS_MAKE_SHORTSTRING("rcl"),
    ZYDIS_MAKE_SHORTSTRING("rcpps"),
    ZYDIS_MAKE_SHORTSTRING("rcpss"),
    ZYDIS_MAKE_SHORTSTRING("rcr"),
    ZYDIS_MAKE_SHORTSTRING("rdfsbase"),
    ZYDIS_MAKE_SHORTSTRING("rdgsbase"),
    ZYDIS_MAKE_SHORTSTRING("rdmsr"),
    ZYDIS_MAKE_SHORTSTRING("rdmsrlist"),
    ZYDIS_MAKE_SHORTSTRING("rdpid"),
    ZYDIS_MAKE_SHORTSTRING("rdpkru"),
    ZYDIS_MAKE_SHORTSTRING("rdpmc"),
    ZYDIS_MAKE_SHORTSTRING("rdpru"),
    ZYDIS_MAKE_SHORTSTRING("rdrand"),
    ZYDIS_MAKE_SHORTSTRING("rdseed"),
    ZYDIS_MAKE_SHORTSTRING("rdsspd"),
    ZYDIS_MAKE_SHORTSTRING("rdsspq"),
    ZYDIS_MAKE_SHORTSTRING("rdtsc"),
    ZYDIS_MAKE_SHORTSTRING("rdtscp"),
    ZYDIS_MAKE_SHORTSTRING("ret"),
    ZYDIS_MAKE_SHORTSTRING("rmpadjust"),
    ZYDIS_MAKE_SHORTSTRING("rmpupdate"),
    ZYDIS_MAKE_SHORTSTRING("rol"),
    ZYDIS_MAKE_SHORTSTRING("ror"),
    ZYDIS_MAKE_SHORTSTRING("rorx"),
    ZYDIS_MAKE_SHORTSTRING("roundpd"),
    ZYDIS_MAKE_SHORTSTRING("roundps"),
    ZYDIS_MAKE_SHORTSTRING("roundsd"),
    ZYDIS_MAKE_SHORTSTRING("roundss"),
    ZYDIS_MAKE_SHORTSTRING("rsm"),
    ZYDIS_MAKE_SHORTSTRING("rsqrtps"),
    ZYDIS_MAKE_SHORTSTRING("rsqrtss"),
    ZYDIS_MAKE_SHORTSTRING("rstorssp"),
    ZYDIS_MAKE_SHORTSTRING("sahf"),
    ZYDIS_MAKE_SHORTSTRING("salc"),
    ZYDIS_MAKE_SHORTSTRING("sar"),
    ZYDIS_MAKE_SHORTSTRING("sarx"),
    ZYDIS_MAKE_SHORTSTRING("saveprevssp"),
    ZYDIS_MAKE_SHORTSTRING("sbb"),
    ZYDIS_MAKE_SHORTSTRING("scasb"),
    ZYDIS_MAKE_SHORTSTRING("scasd"),
    ZYDIS_MAKE_SHORTSTRING("scasq"),
    ZYDIS_MAKE_SHORTSTRING("scasw"),
    ZYDIS_MAKE_SHORTSTRING("seamcall"),
    ZYDIS_MAKE_SHORTSTRING("seamops"),
    ZYDIS_MAKE_SHORTSTRING("seamret"),
    ZYDIS_MAKE_SHORTSTRING("senduipi"),
    ZYDIS_MAKE_SHORTSTRING("serialize"),
    ZYDIS_MAKE_SHORTSTRING("setb"),
    ZYDIS_MAKE_SHORTSTRING("setbe"),
    ZYDIS_MAKE_SHORTSTRING("setl"),
    ZYDIS_MAKE_SHORTSTRING("setle"),
    ZYDIS_MAKE_SHORTSTRING("setnb"),
    ZYDIS_MAKE_SHORTSTRING("setnbe"),
    ZYDIS_MAKE_SHORTSTRING("setnl"),
    ZYDIS_MAKE_SHORTSTRING("setnle"),
    ZYDIS_MAKE_SHORTSTRING("setno"),
    ZYDIS_MAKE_SHORTSTRING("setnp"),
    ZYDIS_MAKE_SHORTSTRING("setns"),
    ZYDIS_MAKE_SHORTSTRING("setnz"),
    ZYDIS_MAKE_SHORTSTRING("seto"),
    ZYDIS_MAKE_SHORTSTRING("setp"),
    ZYDIS_MAKE_SHORTSTRING("sets"),
    ZYDIS_MAKE_SHORTSTRING("setssbsy"),
    ZYDIS_MAKE_SHORTSTRING("setz"),
    ZYDIS_MAKE_SHORTSTRING("sfence"),
    ZYDIS_MAKE_SHORTSTRING("sgdt"),
    ZYDIS_MAKE_SHORTSTRING("sha1msg1"),
    ZYDIS_MAKE_SHORTSTRING("sha1msg2"),
    ZYDIS_MAKE_SHORTSTRING("sha1nexte"),
    ZYDIS_MAKE_SHORTSTRING("sha1rnds4"),
    ZYDIS_MAKE_SHORTSTRING("sha256msg1"),
    ZYDIS_MAKE_SHORTSTRING("sha256msg2"),
    ZYDIS_MAKE_SHORTSTRING("sha256rnds2"),
    ZYDIS_MAKE_SHORTSTRING("shl"),
    ZYDIS_MAKE_SHORTSTRING("shld"),
    ZYDIS_MAKE_SHORTSTRING("shlx"),
    ZYDIS_MAKE_SHORTSTRING("shr"),
    ZYDIS_MAKE_SHORTSTRING("shrd"),
    ZYDIS_MAKE_SHORTSTRING("shrx"),
    ZYDIS_MAKE_SHORTSTRING("shufpd"),
    ZYDIS_MAKE_SHORTSTRING("shufps"),
    ZYDIS_MAKE_SHORTSTRING("sidt"),
    ZYDIS_MAKE_SHORTSTRING("skinit"),
    ZYDIS_MAKE_SHORTSTRING("sldt"),
    ZYDIS_MAKE_SHORTSTRING("slwpcb"),
    ZYDIS_MAKE_SHORTSTRING("smsw"),
    ZYDIS_MAKE_SHORTSTRING("spflt"),
    ZYDIS_MAKE_SHORTSTRING("sqrtpd"),
    ZYDIS_MAKE_SHORTSTRING("sqrtps"),
    ZYDIS_MAKE_SHORTSTRING("sqrtsd"),
    ZYDIS_MAKE_SHORTSTRING("sqrtss"),
    ZYDIS_MAKE_SHORTSTRING("stac"),
    ZYDIS_MAKE_SHORTSTRING("stc"),
    ZYDIS_MAKE_SHORTSTRING("std"),
    ZYDIS_MAKE_SHORTSTRING("stgi"),
    ZYDIS_MAKE_SHORTSTRING("sti"),
    ZYDIS_MAKE_SHORTSTRING("stmxcsr"),
    ZYDIS_MAKE_SHORTSTRING("stosb"),
    ZYDIS_MAKE_SHORTSTRING("stosd"),
    ZYDIS_MAKE_SHORTSTRING("stosq"),
    ZYDIS_MAKE_SHORTSTRING("stosw"),
    ZYDIS_MAKE_SHORTSTRING("str"),
    ZYDIS_MAKE_SHORTSTRING("sttilecfg"),
    ZYDIS_MAKE_SHORTSTRING("stui"),
    ZYDIS_MAKE_SHORTSTRING("sub"),
    ZYDIS_MAKE_SHORTSTRING("subpd"),
    ZYDIS_MAKE_SHORTSTRING("subps"),
    ZYDIS_MAKE_SHORTSTRING("subsd"),
    ZYDIS_MAKE_SHORTSTRING("subss"),
    ZYDIS_MAKE_SHORTSTRING("swapgs"),
    ZYDIS_MAKE_SHORTSTRING("syscall"),
    ZYDIS_MAKE_SHORTSTRING("sysenter"),
    ZYDIS_MAKE_SHORTSTRING("sysexit"),
    ZYDIS_MAKE_SHORTSTRING("sysret"),
    ZYDIS_MAKE_SHORTSTRING("t1mskc"),
    ZYDIS_MAKE_SHORTSTRING("tdcall"),
    ZYDIS_MAKE_SHORTSTRING("tdpbf16ps"),
    ZYDIS_MAKE_SHORTSTRING("tdpbssd"),
    ZYDIS_MAKE_SHORTSTRING("tdpbsud"),
    ZYDIS_MAKE_SHORTSTRING("tdpbusd"),
    ZYDIS_MAKE_SHORTSTRING("tdpbuud"),
    ZYDIS_MAKE_SHORTSTRING("tdpfp16ps"),
    ZYDIS_MAKE_SHORTSTRING("test"),
    ZYDIS_MAKE_SHORTSTRING("testui"),
    ZYDIS_MAKE_SHORTSTRING("tileloadd"),
    ZYDIS_MAKE_SHORTSTRING("tileloaddt1"),
    ZYDIS_MAKE_SHORTSTRING("tilerelease"),
    ZYDIS_MAKE_SHORTSTRING("tilestored"),
    ZYDIS_MAKE_SHORTSTRING("tilezero"),
    ZYDIS_MAKE_SHORTSTRING("tlbsync"),
    ZYDIS_MAKE_SHORTSTRING("tpause"),
    ZYDIS_MAKE_SHORTSTRING("tzcnt"),
    ZYDIS_MAKE_SHORTSTRING("tzcnti"),
    ZYDIS_MAKE_SHORTSTRING("tzmsk"),
    ZYDIS_MAKE_SHORTSTRING("ucomisd"),
    ZYDIS_MAKE_SHORTSTRING("ucomiss"),
    ZYDIS_MAKE_SHORTSTRING("ud0"),
    ZYDIS_MAKE_SHORTSTRING("ud1"),
    ZYDIS_MAKE_SHORTSTRING("ud2"),
    ZYDIS_MAKE_SHORTSTRING("uiret"),
    ZYDIS_MAKE_SHORTSTRING("umonitor"),
    ZYDIS_MAKE_SHORTSTRING("umwait"),
    ZYDIS_MAKE_SHORTSTRING("unpckhpd"),
    ZYDIS_MAKE_SHORTSTRING("unpckhps"),
    ZYDIS_MAKE_SHORTSTRING("unpcklpd"),
    ZYDIS_MAKE_SHORTSTRING("unpcklps"),
    ZYDIS_MAKE_SHORTSTRING("v4fmaddps"),
    ZYDIS_MAKE_SHORTSTRING("v4fmaddss"),
    ZYDIS_MAKE_SHORTSTRING("v4fnmaddps"),
    ZYDIS_MAKE_SHORTSTRING("v4fnmaddss"),
    ZYDIS_MAKE_SHORTSTRING("vaddnpd"),
    ZYDIS_MAKE_SHORTSTRING("vaddnps"),
    ZYDIS_MAKE_SHORTSTRING("vaddpd"),
    ZYDIS_MAKE_SHORTSTRING("vaddph"),
    ZYDIS_MAKE_SHORTSTRING("vaddps"),
    ZYDIS_MAKE_SHORTSTRING("vaddsd"),
    ZYDIS_MAKE_SHORTSTRING("vaddsetsps"),
    ZYDIS_MAKE_SHORTSTRING("vaddsh"),
    ZYDIS_MAKE_SHORTSTRING("vaddss"),
    ZYDIS_MAKE_SHORTSTRING("vaddsubpd"),
    ZYDIS_MAKE_SHORTSTRING("vaddsubps"),
    ZYDIS_MAKE_SHORTSTRING("vaesdec"),
    ZYDIS_MAKE_SHORTSTRING("vaesdeclast"),
    ZYDIS_MAKE_SHORTSTRING("vaesenc"),
    ZYDIS_MAKE_SHORTSTRING("vaesenclast"),
    ZYDIS_MAKE_SHORTSTRING("vaesimc"),
    ZYDIS_MAKE_SHORTSTRING("vaeskeygenassist"),
    ZYDIS_MAKE_SHORTSTRING("valignd"),
    ZYDIS_MAKE_SHORTSTRING("valignq"),
    ZYDIS_MAKE_SHORTSTRING("vandnpd"),
    ZYDIS_MAKE_SHORTSTRING("vandnps"),
    ZYDIS_MAKE_SHORTSTRING("vandpd"),
    ZYDIS_MAKE_SHORTSTRING("vandps"),
    ZYDIS_MAKE_SHORTSTRING("vbcstnebf162ps"),
    ZYDIS_MAKE_SHORTSTRING("vbcstnesh2ps"),
    ZYDIS_MAKE_SHORTSTRING("vblendmpd"),
    ZYDIS_MAKE_SHORTSTRING("vblendmps"),
    ZYDIS_MAKE_SHORTSTRING("vblendpd"),
    ZYDIS_MAKE_SHORTSTRING("vblendps"),
    ZYDIS_MAKE_SHORTSTRING("vblendvpd"),
    ZYDIS_MAKE_SHORTSTRING("vblendvps"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastf128"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastf32x2"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastf32x4"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastf32x8"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastf64x2"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastf64x4"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcasti128"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcasti32x2"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcasti32x4"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcasti32x8"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcasti64x2"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcasti64x4"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastsd"),
    ZYDIS_MAKE_SHORTSTRING("vbroadcastss"),
    ZYDIS_MAKE_SHORTSTRING("vcmppd"),
    ZYDIS_MAKE_SHORTSTRING("vcmpph"),
    ZYDIS_MAKE_SHORTSTRING("vcmpps"),
    ZYDIS_MAKE_SHORTSTRING("vcmpsd"),
    ZYDIS_MAKE_SHORTSTRING("vcmpsh"),
    ZYDIS_MAKE_SHORTSTRING("vcmpss"),
    ZYDIS_MAKE_SHORTSTRING("vcomisd"),
    ZYDIS_MAKE_SHORTSTRING("vcomish"),
    ZYDIS_MAKE_SHORTSTRING("vcomiss"),
    ZYDIS_MAKE_SHORTSTRING("vcompresspd"),
    ZYDIS_MAKE_SHORTSTRING("vcompressps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtdq2pd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtdq2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtdq2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtfxpntdq2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtfxpntpd2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtfxpntpd2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtfxpntps2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtfxpntps2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtfxpntudq2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtne2ps2bf16"),
    ZYDIS_MAKE_SHORTSTRING("vcvtneebf162ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtneeph2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtneobf162ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtneoph2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtneps2bf16"),
    ZYDIS_MAKE_SHORTSTRING("vcvtpd2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtpd2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtpd2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtpd2qq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtpd2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtpd2uqq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2pd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2psx"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2qq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2uqq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2uw"),
    ZYDIS_MAKE_SHORTSTRING("vcvtph2w"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2pd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2phx"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2qq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtps2uqq"),
    ZYDIS_MAKE_SHORTSTRING("vcvtqq2pd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtqq2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtqq2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsd2sh"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsd2si"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsd2ss"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsd2usi"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsh2sd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsh2si"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsh2ss"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsh2usi"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsi2sd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsi2sh"),
    ZYDIS_MAKE_SHORTSTRING("vcvtsi2ss"),
    ZYDIS_MAKE_SHORTSTRING("vcvtss2sd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtss2sh"),
    ZYDIS_MAKE_SHORTSTRING("vcvtss2si"),
    ZYDIS_MAKE_SHORTSTRING("vcvtss2usi"),
    ZYDIS_MAKE_SHORTSTRING("vcvttpd2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttpd2qq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttpd2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttpd2uqq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttph2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttph2qq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttph2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttph2uqq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttph2uw"),
    ZYDIS_MAKE_SHORTSTRING("vcvttph2w"),
    ZYDIS_MAKE_SHORTSTRING("vcvttps2dq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttps2qq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttps2udq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttps2uqq"),
    ZYDIS_MAKE_SHORTSTRING("vcvttsd2si"),
    ZYDIS_MAKE_SHORTSTRING("vcvttsd2usi"),
    ZYDIS_MAKE_SHORTSTRING("vcvttsh2si"),
    ZYDIS_MAKE_SHORTSTRING("vcvttsh2usi"),
    ZYDIS_MAKE_SHORTSTRING("vcvttss2si"),
    ZYDIS_MAKE_SHORTSTRING("vcvttss2usi"),
    ZYDIS_MAKE_SHORTSTRING("vcvtudq2pd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtudq2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtudq2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtuqq2pd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtuqq2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtuqq2ps"),
    ZYDIS_MAKE_SHORTSTRING("vcvtusi2sd"),
    ZYDIS_MAKE_SHORTSTRING("vcvtusi2sh"),
    ZYDIS_MAKE_SHORTSTRING("vcvtusi2ss"),
    ZYDIS_MAKE_SHORTSTRING("vcvtuw2ph"),
    ZYDIS_MAKE_SHORTSTRING("vcvtw2ph"),
    ZYDIS_MAKE_SHORTSTRING("vdbpsadbw"),
    ZYDIS_MAKE_SHORTSTRING("vdivpd"),
    ZYDIS_MAKE_SHORTSTRING("vdivph"),
    ZYDIS_MAKE_SHORTSTRING("vdivps"),
    ZYDIS_MAKE_SHORTSTRING("vdivsd"),
    ZYDIS_MAKE_SHORTSTRING("vdivsh"),
    ZYDIS_MAKE_SHORTSTRING("vdivss"),
    ZYDIS_MAKE_SHORTSTRING("vdpbf16ps"),
    ZYDIS_MAKE_SHORTSTRING("vdppd"),
    ZYDIS_MAKE_SHORTSTRING("vdpps"),
    ZYDIS_MAKE_SHORTSTRING("verr"),
    ZYDIS_MAKE_SHORTSTRING("verw"),
    ZYDIS_MAKE_SHORTSTRING("vexp223ps"),
    ZYDIS_MAKE_SHORTSTRING("vexp2pd"),
    ZYDIS_MAKE_SHORTSTRING("vexp2ps"),
    ZYDIS_MAKE_SHORTSTRING("vexpandpd"),
    ZYDIS_MAKE_SHORTSTRING("vexpandps"),
    ZYDIS_MAKE_SHORTSTRING("vextractf128"),
    ZYDIS_MAKE_SHORTSTRING("vextractf32x4"),
    ZYDIS_MAKE_SHORTSTRING("vextractf32x8"),
    ZYDIS_MAKE_SHORTSTRING("vextractf64x2"),
    ZYDIS_MAKE_SHORTSTRING("vextractf64x4"),
    ZYDIS_MAKE_SHORTSTRING("vextracti128"),
    ZYDIS_MAKE_SHORTSTRING("vextracti32x4"),
    ZYDIS_MAKE_SHORTSTRING("vextracti32x8"),
    ZYDIS_MAKE_SHORTSTRING("vextracti64x2"),
    ZYDIS_MAKE_SHORTSTRING("vextracti64x4"),
    ZYDIS_MAKE_SHORTSTRING("vextractps"),
    ZYDIS_MAKE_SHORTSTRING("vfcmaddcph"),
    ZYDIS_MAKE_SHORTSTRING("vfcmaddcsh"),
    ZYDIS_MAKE_SHORTSTRING("vfcmulcph"),
    ZYDIS_MAKE_SHORTSTRING("vfcmulcsh"),
    ZYDIS_MAKE_SHORTSTRING("vfixupimmpd"),
    ZYDIS_MAKE_SHORTSTRING("vfixupimmps"),
    ZYDIS_MAKE_SHORTSTRING("vfixupimmsd"),
    ZYDIS_MAKE_SHORTSTRING("vfixupimmss"),
    ZYDIS_MAKE_SHORTSTRING("vfixupnanpd"),
    ZYDIS_MAKE_SHORTSTRING("vfixupnanps"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd132pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd132ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd132ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd132sd"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd132sh"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd132ss"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd213pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd213ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd213ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd213sd"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd213sh"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd213ss"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd231pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd231ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd231ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd231sd"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd231sh"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd231ss"),
    ZYDIS_MAKE_SHORTSTRING("vfmadd233ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddcph"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddcsh"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddpd"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddps"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsd"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddss"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub132pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub132ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub132ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub213pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub213ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub213ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub231pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub231ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsub231ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsubpd"),
    ZYDIS_MAKE_SHORTSTRING("vfmaddsubps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub132pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub132ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub132ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub132sd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub132sh"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub132ss"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub213pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub213ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub213ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub213sd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub213sh"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub213ss"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub231pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub231ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub231ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub231sd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub231sh"),
    ZYDIS_MAKE_SHORTSTRING("vfmsub231ss"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd132pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd132ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd132ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd213pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd213ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd213ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd231pd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd231ph"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubadd231ps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubaddpd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubaddps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubpd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubps"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubsd"),
    ZYDIS_MAKE_SHORTSTRING("vfmsubss"),
    ZYDIS_MAKE_SHORTSTRING("vfmulcph"),
    ZYDIS_MAKE_SHORTSTRING("vfmulcsh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd132pd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd132ph"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd132ps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd132sd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd132sh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd132ss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd213pd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd213ph"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd213ps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd213sd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd213sh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd213ss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd231pd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd231ph"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd231ps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd231sd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd231sh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmadd231ss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmaddpd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmaddps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmaddsd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmaddss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub132pd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub132ph"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub132ps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub132sd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub132sh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub132ss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub213pd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub213ph"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub213ps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub213sd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub213sh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub213ss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub231pd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub231ph"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub231ps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub231sd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub231sh"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsub231ss"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsubpd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsubps"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsubsd"),
    ZYDIS_MAKE_SHORTSTRING("vfnmsubss"),
    ZYDIS_MAKE_SHORTSTRING("vfpclasspd"),
    ZYDIS_MAKE_SHORTSTRING("vfpclassph"),
    ZYDIS_MAKE_SHORTSTRING("vfpclassps"),
    ZYDIS_MAKE_SHORTSTRING("vfpclasssd"),
    ZYDIS_MAKE_SHORTSTRING("vfpclasssh"),
    ZYDIS_MAKE_SHORTSTRING("vfpclassss"),
    ZYDIS_MAKE_SHORTSTRING("vfrczpd"),
    ZYDIS_MAKE_SHORTSTRING("vfrczps"),
    ZYDIS_MAKE_SHORTSTRING("vfrczsd"),
    ZYDIS_MAKE_SHORTSTRING("vfrczss"),
    ZYDIS_MAKE_SHORTSTRING("vgatherdpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherdps"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf0dpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf0dps"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf0hintdpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf0hintdps"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf0qpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf0qps"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf1dpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf1dps"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf1qpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherpf1qps"),
    ZYDIS_MAKE_SHORTSTRING("vgatherqpd"),
    ZYDIS_MAKE_SHORTSTRING("vgatherqps"),
    ZYDIS_MAKE_SHORTSTRING("vgetexppd"),
    ZYDIS_MAKE_SHORTSTRING("vgetexpph"),
    ZYDIS_MAKE_SHORTSTRING("vgetexpps"),
    ZYDIS_MAKE_SHORTSTRING("vgetexpsd"),
    ZYDIS_MAKE_SHORTSTRING("vgetexpsh"),
    ZYDIS_MAKE_SHORTSTRING("vgetexpss"),
    ZYDIS_MAKE_SHORTSTRING("vgetmantpd"),
    ZYDIS_MAKE_SHORTSTRING("vgetmantph"),
    ZYDIS_MAKE_SHORTSTRING("vgetmantps"),
    ZYDIS_MAKE_SHORTSTRING("vgetmantsd"),
    ZYDIS_MAKE_SHORTSTRING("vgetmantsh"),
    ZYDIS_MAKE_SHORTSTRING("vgetmantss"),
    ZYDIS_MAKE_SHORTSTRING("vgf2p8affineinvqb"),
    ZYDIS_MAKE_SHORTSTRING("vgf2p8affineqb"),
    ZYDIS_MAKE_SHORTSTRING("vgf2p8mulb"),
    ZYDIS_MAKE_SHORTSTRING("vgmaxabsps"),
    ZYDIS_MAKE_SHORTSTRING("vgmaxpd"),
    ZYDIS_MAKE_SHORTSTRING("vgmaxps"),
    ZYDIS_MAKE_SHORTSTRING("vgminpd"),
    ZYDIS_MAKE_SHORTSTRING("vgminps"),
    ZYDIS_MAKE_SHORTSTRING("vhaddpd"),
    ZYDIS_MAKE_SHORTSTRING("vhaddps"),
    ZYDIS_MAKE_SHORTSTRING("vhsubpd"),
    ZYDIS_MAKE_SHORTSTRING("vhsubps"),
    ZYDIS_MAKE_SHORTSTRING("vinsertf128"),
    ZYDIS_MAKE_SHORTSTRING("vinsertf32x4"),
    ZYDIS_MAKE_SHORTSTRING("vinsertf32x8"),
    ZYDIS_MAKE_SHORTSTRING("vinsertf64x2"),
    ZYDIS_MAKE_SHORTSTRING("vinsertf64x4"),
    ZYDIS_MAKE_SHORTSTRING("vinserti128"),
    ZYDIS_MAKE_SHORTSTRING("vinserti32x4"),
    ZYDIS_MAKE_SHORTSTRING("vinserti32x8"),
    ZYDIS_MAKE_SHORTSTRING("vinserti64x2"),
    ZYDIS_MAKE_SHORTSTRING("vinserti64x4"),
    ZYDIS_MAKE_SHORTSTRING("vinsertps"),
    ZYDIS_MAKE_SHORTSTRING("vlddqu"),
    ZYDIS_MAKE_SHORTSTRING("vldmxcsr"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpackhd"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpackhpd"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpackhps"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpackhq"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpackld"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpacklpd"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpacklps"),
    ZYDIS_MAKE_SHORTSTRING("vloadunpacklq"),
    ZYDIS_MAKE_SHORTSTRING("vlog2ps"),
    ZYDIS_MAKE_SHORTSTRING("vmaskmovdqu"),
    ZYDIS_MAKE_SHORTSTRING("vmaskmovpd"),
    ZYDIS_MAKE_SHORTSTRING("vmaskmovps"),
    ZYDIS_MAKE_SHORTSTRING("vmaxpd"),
    ZYDIS_MAKE_SHORTSTRING("vmaxph"),
    ZYDIS_MAKE_SHORTSTRING("vmaxps"),
    ZYDIS_MAKE_SHORTSTRING("vmaxsd"),
    ZYDIS_MAKE_SHORTSTRING("vmaxsh"),
    ZYDIS_MAKE_SHORTSTRING("vmaxss"),
    ZYDIS_MAKE_SHORTSTRING("vmcall"),
    ZYDIS_MAKE_SHORTSTRING("vmclear"),
    ZYDIS_MAKE_SHORTSTRING("vmfunc"),
    ZYDIS_MAKE_SHORTSTRING("vminpd"),
    ZYDIS_MAKE_SHORTSTRING("vminph"),
    ZYDIS_MAKE_SHORTSTRING("vminps"),
    ZYDIS_MAKE_SHORTSTRING("vminsd"),
    ZYDIS_MAKE_SHORTSTRING("vminsh"),
    ZYDIS_MAKE_SHORTSTRING("vminss"),
    ZYDIS_MAKE_SHORTSTRING("vmlaunch"),
    ZYDIS_MAKE_SHORTSTRING("vmload"),
    ZYDIS_MAKE_SHORTSTRING("vmmcall"),
    ZYDIS_MAKE_SHORTSTRING("vmovapd"),
    ZYDIS_MAKE_SHORTSTRING("vmovaps"),
    ZYDIS_MAKE_SHORTSTRING("vmovd"),
    ZYDIS_MAKE_SHORTSTRING("vmovddup"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqa"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqa32"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqa64"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqu"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqu16"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqu32"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqu64"),
    ZYDIS_MAKE_SHORTSTRING("vmovdqu8"),
    ZYDIS_MAKE_SHORTSTRING("vmovhlps"),
    ZYDIS_MAKE_SHORTSTRING("vmovhpd"),
    ZYDIS_MAKE_SHORTSTRING("vmovhps"),
    ZYDIS_MAKE_SHORTSTRING("vmovlhps"),
    ZYDIS_MAKE_SHORTSTRING("vmovlpd"),
    ZYDIS_MAKE_SHORTSTRING("vmovlps"),
    ZYDIS_MAKE_SHORTSTRING("vmovmskpd"),
    ZYDIS_MAKE_SHORTSTRING("vmovmskps"),
    ZYDIS_MAKE_SHORTSTRING("vmovnrapd"),
    ZYDIS_MAKE_SHORTSTRING("vmovnraps"),
    ZYDIS_MAKE_SHORTSTRING("vmovnrngoapd"),
    ZYDIS_MAKE_SHORTSTRING("vmovnrngoaps"),
    ZYDIS_MAKE_SHORTSTRING("vmovntdq"),
    ZYDIS_MAKE_SHORTSTRING("vmovntdqa"),
    ZYDIS_MAKE_SHORTSTRING("vmovntpd"),
    ZYDIS_MAKE_SHORTSTRING("vmovntps"),
    ZYDIS_MAKE_SHORTSTRING("vmovq"),
    ZYDIS_MAKE_SHORTSTRING("vmovsd"),
    ZYDIS_MAKE_SHORTSTRING("vmovsh"),
    ZYDIS_MAKE_SHORTSTRING("vmovshdup"),
    ZYDIS_MAKE_SHORTSTRING("vmovsldup"),
    ZYDIS_MAKE_SHORTSTRING("vmovss"),
    ZYDIS_MAKE_SHORTSTRING("vmovupd"),
    ZYDIS_MAKE_SHORTSTRING("vmovups"),
    ZYDIS_MAKE_SHORTSTRING("vmovw"),
    ZYDIS_MAKE_SHORTSTRING("vmpsadbw"),
    ZYDIS_MAKE_SHORTSTRING("vmptrld"),
    ZYDIS_MAKE_SHORTSTRING("vmptrst"),
    ZYDIS_MAKE_SHORTSTRING("vmread"),
    ZYDIS_MAKE_SHORTSTRING("vmresume"),
    ZYDIS_MAKE_SHORTSTRING("vmrun"),
    ZYDIS_MAKE_SHORTSTRING("vmsave"),
    ZYDIS_MAKE_SHORTSTRING("vmulpd"),
    ZYDIS_MAKE_SHORTSTRING("vmulph"),
    ZYDIS_MAKE_SHORTSTRING("vmulps"),
    ZYDIS_MAKE_SHORTSTRING("vmulsd"),
    ZYDIS_MAKE_SHORTSTRING("vmulsh"),
    ZYDIS_MAKE_SHORTSTRING("vmulss"),
    ZYDIS_MAKE_SHORTSTRING("vmwrite"),
    ZYDIS_MAKE_SHORTSTRING("vmxoff"),
    ZYDIS_MAKE_SHORTSTRING("vmxon"),
    ZYDIS_MAKE_SHORTSTRING("vorpd"),
    ZYDIS_MAKE_SHORTSTRING("vorps"),
    ZYDIS_MAKE_SHORTSTRING("vp2intersectd"),
    ZYDIS_MAKE_SHORTSTRING("vp2intersectq"),
    ZYDIS_MAKE_SHORTSTRING("vp4dpwssd"),
    ZYDIS_MAKE_SHORTSTRING("vp4dpwssds"),
    ZYDIS_MAKE_SHORTSTRING("vpabsb"),
    ZYDIS_MAKE_SHORTSTRING("vpabsd"),
    ZYDIS_MAKE_SHORTSTRING("vpabsq"),
    ZYDIS_MAKE_SHORTSTRING("vpabsw"),
    ZYDIS_MAKE_SHORTSTRING("vpackssdw"),
    ZYDIS_MAKE_SHORTSTRING("vpacksswb"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorehd"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorehpd"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorehps"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorehq"),
    ZYDIS_MAKE_SHORTSTRING("vpackstoreld"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorelpd"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorelps"),
    ZYDIS_MAKE_SHORTSTRING("vpackstorelq"),
    ZYDIS_MAKE_SHORTSTRING("vpackusdw"),
    ZYDIS_MAKE_SHORTSTRING("vpackuswb"),
    ZYDIS_MAKE_SHORTSTRING("vpadcd"),
    ZYDIS_MAKE_SHORTSTRING("vpaddb"),
    ZYDIS_MAKE_SHORTSTRING("vpaddd"),
    ZYDIS_MAKE_SHORTSTRING("vpaddq"),
    ZYDIS_MAKE_SHORTSTRING("vpaddsb"),
    ZYDIS_MAKE_SHORTSTRING("vpaddsetcd"),
    ZYDIS_MAKE_SHORTSTRING("vpaddsetsd"),
    ZYDIS_MAKE_SHORTSTRING("vpaddsw"),
    ZYDIS_MAKE_SHORTSTRING("vpaddusb"),
    ZYDIS_MAKE_SHORTSTRING("vpaddusw"),
    ZYDIS_MAKE_SHORTSTRING("vpaddw"),
    ZYDIS_MAKE_SHORTSTRING("vpalignr"),
    ZYDIS_MAKE_SHORTSTRING("vpand"),
    ZYDIS_MAKE_SHORTSTRING("vpandd"),
    ZYDIS_MAKE_SHORTSTRING("vpandn"),
    ZYDIS_MAKE_SHORTSTRING("vpandnd"),
    ZYDIS_MAKE_SHORTSTRING("vpandnq"),
    ZYDIS_MAKE_SHORTSTRING("vpandq"),
    ZYDIS_MAKE_SHORTSTRING("vpavgb"),
    ZYDIS_MAKE_SHORTSTRING("vpavgw"),
    ZYDIS_MAKE_SHORTSTRING("vpblendd"),
    ZYDIS_MAKE_SHORTSTRING("vpblendmb"),
    ZYDIS_MAKE_SHORTSTRING("vpblendmd"),
    ZYDIS_MAKE_SHORTSTRING("vpblendmq"),
    ZYDIS_MAKE_SHORTSTRING("vpblendmw"),
    ZYDIS_MAKE_SHORTSTRING("vpblendvb"),
    ZYDIS_MAKE_SHORTSTRING("vpblendw"),
    ZYDIS_MAKE_SHORTSTRING("vpbroadcastb"),
    ZYDIS_MAKE_SHORTSTRING("vpbroadcastd"),
    ZYDIS_MAKE_SHORTSTRING("vpbroadcastmb2q"),
    ZYDIS_MAKE_SHORTSTRING("vpbroadcastmw2d"),
    ZYDIS_MAKE_SHORTSTRING("vpbroadcastq"),
    ZYDIS_MAKE_SHORTSTRING("vpbroadcastw"),
    ZYDIS_MAKE_SHORTSTRING("vpclmulqdq"),
    ZYDIS_MAKE_SHORTSTRING("vpcmov"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpb"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpd"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpeqb"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpeqd"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpeqq"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpeqw"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpestri"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpestrm"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpgtb"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpgtd"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpgtq"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpgtw"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpistri"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpistrm"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpltd"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpq"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpub"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpud"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpuq"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpuw"),
    ZYDIS_MAKE_SHORTSTRING("vpcmpw"),
    ZYDIS_MAKE_SHORTSTRING("vpcomb"),
    ZYDIS_MAKE_SHORTSTRING("vpcomd"),
    ZYDIS_MAKE_SHORTSTRING("vpcompressb"),
    ZYDIS_MAKE_SHORTSTRING("vpcompressd"),
    ZYDIS_MAKE_SHORTSTRING("vpcompressq"),
    ZYDIS_MAKE_SHORTSTRING("vpcompressw"),
    ZYDIS_MAKE_SHORTSTRING("vpcomq"),
    ZYDIS_MAKE_SHORTSTRING("vpcomub"),
    ZYDIS_MAKE_SHORTSTRING("vpcomud"),
    ZYDIS_MAKE_SHORTSTRING("vpcomuq"),
    ZYDIS_MAKE_SHORTSTRING("vpcomuw"),
    ZYDIS_MAKE_SHORTSTRING("vpcomw"),
    ZYDIS_MAKE_SHORTSTRING("vpconflictd"),
    ZYDIS_MAKE_SHORTSTRING("vpconflictq"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbssd"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbssds"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbsud"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbsuds"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbusd"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbusds"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbuud"),
    ZYDIS_MAKE_SHORTSTRING("vpdpbuuds"),
    ZYDIS_MAKE_SHORTSTRING("vpdpwssd"),
    ZYDIS_MAKE_SHORTSTRING("vpdpwssds"),
    ZYDIS_MAKE_SHORTSTRING("vperm2f128"),
    ZYDIS_MAKE_SHORTSTRING("vperm2i128"),
    ZYDIS_MAKE_SHORTSTRING("vpermb"),
    ZYDIS_MAKE_SHORTSTRING("vpermd"),
    ZYDIS_MAKE_SHORTSTRING("vpermf32x4"),
    ZYDIS_MAKE_SHORTSTRING("vpermi2b"),
    ZYDIS_MAKE_SHORTSTRING("vpermi2d"),
    ZYDIS_MAKE_SHORTSTRING("vpermi2pd"),
    ZYDIS_MAKE_SHORTSTRING("vpermi2ps"),
    ZYDIS_MAKE_SHORTSTRING("vpermi2q"),
    ZYDIS_MAKE_SHORTSTRING("vpermi2w"),
    ZYDIS_MAKE_SHORTSTRING("vpermil2pd"),
    ZYDIS_MAKE_SHORTSTRING("vpermil2ps"),
    ZYDIS_MAKE_SHORTSTRING("vpermilpd"),
    ZYDIS_MAKE_SHORTSTRING("vpermilps"),
    ZYDIS_MAKE_SHORTSTRING("vpermpd"),
    ZYDIS_MAKE_SHORTSTRING("vpermps"),
    ZYDIS_MAKE_SHORTSTRING("vpermq"),
    ZYDIS_MAKE_SHORTSTRING("vpermt2b"),
    ZYDIS_MAKE_SHORTSTRING("vpermt2d"),
    ZYDIS_MAKE_SHORTSTRING("vpermt2pd"),
    ZYDIS_MAKE_SHORTSTRING("vpermt2ps"),
    ZYDIS_MAKE_SHORTSTRING("vpermt2q"),
    ZYDIS_MAKE_SHORTSTRING("vpermt2w"),
    ZYDIS_MAKE_SHORTSTRING("vpermw"),
    ZYDIS_MAKE_SHORTSTRING("vpexpandb"),
    ZYDIS_MAKE_SHORTSTRING("vpexpandd"),
    ZYDIS_MAKE_SHORTSTRING("vpexpandq"),
    ZYDIS_MAKE_SHORTSTRING("vpexpandw"),
    ZYDIS_MAKE_SHORTSTRING("vpextrb"),
    ZYDIS_MAKE_SHORTSTRING("vpextrd"),
    ZYDIS_MAKE_SHORTSTRING("vpextrq"),
    ZYDIS_MAKE_SHORTSTRING("vpextrw"),
    ZYDIS_MAKE_SHORTSTRING("vpgatherdd"),
    ZYDIS_MAKE_SHORTSTRING("vpgatherdq"),
    ZYDIS_MAKE_SHORTSTRING("vpgatherqd"),
    ZYDIS_MAKE_SHORTSTRING("vpgatherqq"),
    ZYDIS_MAKE_SHORTSTRING("vphaddbd"),
    ZYDIS_MAKE_SHORTSTRING("vphaddbq"),
    ZYDIS_MAKE_SHORTSTRING("vphaddbw"),
    ZYDIS_MAKE_SHORTSTRING("vphaddd"),
    ZYDIS_MAKE_SHORTSTRING("vphadddq"),
    ZYDIS_MAKE_SHORTSTRING("vphaddsw"),
    ZYDIS_MAKE_SHORTSTRING("vphaddubd"),
    ZYDIS_MAKE_SHORTSTRING("vphaddubq"),
    ZYDIS_MAKE_SHORTSTRING("vphaddubw"),
    ZYDIS_MAKE_SHORTSTRING("vphaddudq"),
    ZYDIS_MAKE_SHORTSTRING("vphadduwd"),
    ZYDIS_MAKE_SHORTSTRING("vphadduwq"),
    ZYDIS_MAKE_SHORTSTRING("vphaddw"),
    ZYDIS_MAKE_SHORTSTRING("vphaddwd"),
    ZYDIS_MAKE_SHORTSTRING("vphaddwq"),
    ZYDIS_MAKE_SHORTSTRING("vphminposuw"),
    ZYDIS_MAKE_SHORTSTRING("vphsubbw"),
    ZYDIS_MAKE_SHORTSTRING("vphsubd"),
    ZYDIS_MAKE_SHORTSTRING("vphsubdq"),
    ZYDIS_MAKE_SHORTSTRING("vphsubsw"),
    ZYDIS_MAKE_SHORTSTRING("vphsubw"),
    ZYDIS_MAKE_SHORTSTRING("vphsubwd"),
    ZYDIS_MAKE_SHORTSTRING("vpinsrb"),
    ZYDIS_MAKE_SHORTSTRING("vpinsrd"),
    ZYDIS_MAKE_SHORTSTRING("vpinsrq"),
    ZYDIS_MAKE_SHORTSTRING("vpinsrw"),
    ZYDIS_MAKE_SHORTSTRING("vplzcntd"),
    ZYDIS_MAKE_SHORTSTRING("vplzcntq"),
    ZYDIS_MAKE_SHORTSTRING("vpmacsdd"),
    ZYDIS_MAKE_SHORTSTRING("vpmacsdqh"),
    ZYDIS_MAKE_SHORTSTRING("vpmacsdql"),
    ZYDIS_MAKE_SHORTSTRING("vpmacssdd"),
    ZYDIS_MAKE_SHORTSTRING("vpmacssdqh"),
    ZYDIS_MAKE_SHORTSTRING("vpmacssdql"),
    ZYDIS_MAKE_SHORTSTRING("vpmacsswd"),
    ZYDIS_MAKE_SHORTSTRING("vpmacssww"),
    ZYDIS_MAKE_SHORTSTRING("vpmacswd"),
    ZYDIS_MAKE_SHORTSTRING("vpmacsww"),
    ZYDIS_MAKE_SHORTSTRING("vpmadcsswd"),
    ZYDIS_MAKE_SHORTSTRING("vpmadcswd"),
    ZYDIS_MAKE_SHORTSTRING("vpmadd231d"),
    ZYDIS_MAKE_SHORTSTRING("vpmadd233d"),
    ZYDIS_MAKE_SHORTSTRING("vpmadd52huq"),
    ZYDIS_MAKE_SHORTSTRING("vpmadd52luq"),
    ZYDIS_MAKE_SHORTSTRING("vpmaddubsw"),
    ZYDIS_MAKE_SHORTSTRING("vpmaddwd"),
    ZYDIS_MAKE_SHORTSTRING("vpmaskmovd"),
    ZYDIS_MAKE_SHORTSTRING("vpmaskmovq"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxsb"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxsd"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxsq"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxsw"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxub"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxud"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxuq"),
    ZYDIS_MAKE_SHORTSTRING("vpmaxuw"),
    ZYDIS_MAKE_SHORTSTRING("vpminsb"),
    ZYDIS_MAKE_SHORTSTRING("vpminsd"),
    ZYDIS_MAKE_SHORTSTRING("vpminsq"),
    ZYDIS_MAKE_SHORTSTRING("vpminsw"),
    ZYDIS_MAKE_SHORTSTRING("vpminub"),
    ZYDIS_MAKE_SHORTSTRING("vpminud"),
    ZYDIS_MAKE_SHORTSTRING("vpminuq"),
    ZYDIS_MAKE_SHORTSTRING("vpminuw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovb2m"),
    ZYDIS_MAKE_SHORTSTRING("vpmovd2m"),
    ZYDIS_MAKE_SHORTSTRING("vpmovdb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovdw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovm2b"),
    ZYDIS_MAKE_SHORTSTRING("vpmovm2d"),
    ZYDIS_MAKE_SHORTSTRING("vpmovm2q"),
    ZYDIS_MAKE_SHORTSTRING("vpmovm2w"),
    ZYDIS_MAKE_SHORTSTRING("vpmovmskb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovq2m"),
    ZYDIS_MAKE_SHORTSTRING("vpmovqb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovqd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovqw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsdb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsdw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsqb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsqd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsqw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovswb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsxbd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsxbq"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsxbw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsxdq"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsxwd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovsxwq"),
    ZYDIS_MAKE_SHORTSTRING("vpmovusdb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovusdw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovusqb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovusqd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovusqw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovuswb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovw2m"),
    ZYDIS_MAKE_SHORTSTRING("vpmovwb"),
    ZYDIS_MAKE_SHORTSTRING("vpmovzxbd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovzxbq"),
    ZYDIS_MAKE_SHORTSTRING("vpmovzxbw"),
    ZYDIS_MAKE_SHORTSTRING("vpmovzxdq"),
    ZYDIS_MAKE_SHORTSTRING("vpmovzxwd"),
    ZYDIS_MAKE_SHORTSTRING("vpmovzxwq"),
    ZYDIS_MAKE_SHORTSTRING("vpmuldq"),
    ZYDIS_MAKE_SHORTSTRING("vpmulhd"),
    ZYDIS_MAKE_SHORTSTRING("vpmulhrsw"),
    ZYDIS_MAKE_SHORTSTRING("vpmulhud"),
    ZYDIS_MAKE_SHORTSTRING("vpmulhuw"),
    ZYDIS_MAKE_SHORTSTRING("vpmulhw"),
    ZYDIS_MAKE_SHORTSTRING("vpmulld"),
    ZYDIS_MAKE_SHORTSTRING("vpmullq"),
    ZYDIS_MAKE_SHORTSTRING("vpmullw"),
    ZYDIS_MAKE_SHORTSTRING("vpmultishiftqb"),
    ZYDIS_MAKE_SHORTSTRING("vpmuludq"),
    ZYDIS_MAKE_SHORTSTRING("vpopcntb"),
    ZYDIS_MAKE_SHORTSTRING("vpopcntd"),
    ZYDIS_MAKE_SHORTSTRING("vpopcntq"),
    ZYDIS_MAKE_SHORTSTRING("vpopcntw"),
    ZYDIS_MAKE_SHORTSTRING("vpor"),
    ZYDIS_MAKE_SHORTSTRING("vpord"),
    ZYDIS_MAKE_SHORTSTRING("vporq"),
    ZYDIS_MAKE_SHORTSTRING("vpperm"),
    ZYDIS_MAKE_SHORTSTRING("vprefetch0"),
    ZYDIS_MAKE_SHORTSTRING("vprefetch1"),
    ZYDIS_MAKE_SHORTSTRING("vprefetch2"),
    ZYDIS_MAKE_SHORTSTRING("vprefetche0"),
    ZYDIS_MAKE_SHORTSTRING("vprefetche1"),
    ZYDIS_MAKE_SHORTSTRING("vprefetche2"),
    ZYDIS_MAKE_SHORTSTRING("vprefetchenta"),
    ZYDIS_MAKE_SHORTSTRING("vprefetchnta"),
    ZYDIS_MAKE_SHORTSTRING("vprold"),
    ZYDIS_MAKE_SHORTSTRING("vprolq"),
    ZYDIS_MAKE_SHORTSTRING("vprolvd"),
    ZYDIS_MAKE_SHORTSTRING("vprolvq"),
    ZYDIS_MAKE_SHORTSTRING("vprord"),
    ZYDIS_MAKE_SHORTSTRING("vprorq"),
    ZYDIS_MAKE_SHORTSTRING("vprorvd"),
    ZYDIS_MAKE_SHORTSTRING("vprorvq"),
    ZYDIS_MAKE_SHORTSTRING("vprotb"),
    ZYDIS_MAKE_SHORTSTRING("vprotd"),
    ZYDIS_MAKE_SHORTSTRING("vprotq"),
    ZYDIS_MAKE_SHORTSTRING("vprotw"),
    ZYDIS_MAKE_SHORTSTRING("vpsadbw"),
    ZYDIS_MAKE_SHORTSTRING("vpsbbd"),
    ZYDIS_MAKE_SHORTSTRING("vpsbbrd"),
    ZYDIS_MAKE_SHORTSTRING("vpscatterdd"),
    ZYDIS_MAKE_SHORTSTRING("vpscatterdq"),
    ZYDIS_MAKE_SHORTSTRING("vpscatterqd"),
    ZYDIS_MAKE_SHORTSTRING("vpscatterqq"),
    ZYDIS_MAKE_SHORTSTRING("vpshab"),
    ZYDIS_MAKE_SHORTSTRING("vpshad"),
    ZYDIS_MAKE_SHORTSTRING("vpshaq"),
    ZYDIS_MAKE_SHORTSTRING("vpshaw"),
    ZYDIS_MAKE_SHORTSTRING("vpshlb"),
    ZYDIS_MAKE_SHORTSTRING("vpshld"),
    ZYDIS_MAKE_SHORTSTRING("vpshldd"),
    ZYDIS_MAKE_SHORTSTRING("vpshldq"),
    ZYDIS_MAKE_SHORTSTRING("vpshldvd"),
    ZYDIS_MAKE_SHORTSTRING("vpshldvq"),
    ZYDIS_MAKE_SHORTSTRING("vpshldvw"),
    ZYDIS_MAKE_SHORTSTRING("vpshldw"),
    ZYDIS_MAKE_SHORTSTRING("vpshlq"),
    ZYDIS_MAKE_SHORTSTRING("vpshlw"),
    ZYDIS_MAKE_SHORTSTRING("vpshrdd"),
    ZYDIS_MAKE_SHORTSTRING("vpshrdq"),
    ZYDIS_MAKE_SHORTSTRING("vpshrdvd"),
    ZYDIS_MAKE_SHORTSTRING("vpshrdvq"),
    ZYDIS_MAKE_SHORTSTRING("vpshrdvw"),
    ZYDIS_MAKE_SHORTSTRING("vpshrdw"),
    ZYDIS_MAKE_SHORTSTRING("vpshufb"),
    ZYDIS_MAKE_SHORTSTRING("vpshufbitqmb"),
    ZYDIS_MAKE_SHORTSTRING("vpshufd"),
    ZYDIS_MAKE_SHORTSTRING("vpshufhw"),
    ZYDIS_MAKE_SHORTSTRING("vpshuflw"),
    ZYDIS_MAKE_SHORTSTRING("vpsignb"),
    ZYDIS_MAKE_SHORTSTRING("vpsignd"),
    ZYDIS_MAKE_SHORTSTRING("vpsignw"),
    ZYDIS_MAKE_SHORTSTRING("vpslld"),
    ZYDIS_MAKE_SHORTSTRING("vpslldq"),
    ZYDIS_MAKE_SHORTSTRING("vpsllq"),
    ZYDIS_MAKE_SHORTSTRING("vpsllvd"),
    ZYDIS_MAKE_SHORTSTRING("vpsllvq"),
    ZYDIS_MAKE_SHORTSTRING("vpsllvw"),
    ZYDIS_MAKE_SHORTSTRING("vpsllw"),
    ZYDIS_MAKE_SHORTSTRING("vpsrad"),
    ZYDIS_MAKE_SHORTSTRING("vpsraq"),
    ZYDIS_MAKE_SHORTSTRING("vpsravd"),
    ZYDIS_MAKE_SHORTSTRING("vpsravq"),
    ZYDIS_MAKE_SHORTSTRING("vpsravw"),
    ZYDIS_MAKE_SHORTSTRING("vpsraw"),
    ZYDIS_MAKE_SHORTSTRING("vpsrld"),
    ZYDIS_MAKE_SHORTSTRING("vpsrldq"),
    ZYDIS_MAKE_SHORTSTRING("vpsrlq"),
    ZYDIS_MAKE_SHORTSTRING("vpsrlvd"),
    ZYDIS_MAKE_SHORTSTRING("vpsrlvq"),
    ZYDIS_MAKE_SHORTSTRING("vpsrlvw"),
    ZYDIS_MAKE_SHORTSTRING("vpsrlw"),
    ZYDIS_MAKE_SHORTSTRING("vpsubb"),
    ZYDIS_MAKE_SHORTSTRING("vpsubd"),
    ZYDIS_MAKE_SHORTSTRING("vpsubq"),
    ZYDIS_MAKE_SHORTSTRING("vpsubrd"),
    ZYDIS_MAKE_SHORTSTRING("vpsubrsetbd"),
    ZYDIS_MAKE_SHORTSTRING("vpsubsb"),
    ZYDIS_MAKE_SHORTSTRING("vpsubsetbd"),
    ZYDIS_MAKE_SHORTSTRING("vpsubsw"),
    ZYDIS_MAKE_SHORTSTRING("vpsubusb"),
    ZYDIS_MAKE_SHORTSTRING("vpsubusw"),
    ZYDIS_MAKE_SHORTSTRING("vpsubw"),
    ZYDIS_MAKE_SHORTSTRING("vpternlogd"),
    ZYDIS_MAKE_SHORTSTRING("vpternlogq"),
    ZYDIS_MAKE_SHORTSTRING("vptest"),
    ZYDIS_MAKE_SHORTSTRING("vptestmb"),
    ZYDIS_MAKE_SHORTSTRING("vptestmd"),
    ZYDIS_MAKE_SHORTSTRING("vptestmq"),
    ZYDIS_MAKE_SHORTSTRING("vptestmw"),
    ZYDIS_MAKE_SHORTSTRING("vptestnmb"),
    ZYDIS_MAKE_SHORTSTRING("vptestnmd"),
    ZYDIS_MAKE_SHORTSTRING("vptestnmq"),
    ZYDIS_MAKE_SHORTSTRING("vptestnmw"),
    ZYDIS_MAKE_SHORTSTRING("vpunpckhbw"),
    ZYDIS_MAKE_SHORTSTRING("vpunpckhdq"),
    ZYDIS_MAKE_SHORTSTRING("vpunpckhqdq"),
    ZYDIS_MAKE_SHORTSTRING("vpunpckhwd"),
    ZYDIS_MAKE_SHORTSTRING("vpunpcklbw"),
    ZYDIS_MAKE_SHORTSTRING("vpunpckldq"),
    ZYDIS_MAKE_SHORTSTRING("vpunpcklqdq"),
    ZYDIS_MAKE_SHORTSTRING("vpunpcklwd"),
    ZYDIS_MAKE_SHORTSTRING("vpxor"),
    ZYDIS_MAKE_SHORTSTRING("vpxord"),
    ZYDIS_MAKE_SHORTSTRING("vpxorq"),
    ZYDIS_MAKE_SHORTSTRING("vrangepd"),
    ZYDIS_MAKE_SHORTSTRING("vrangeps"),
    ZYDIS_MAKE_SHORTSTRING("vrangesd"),
    ZYDIS_MAKE_SHORTSTRING("vrangess"),
    ZYDIS_MAKE_SHORTSTRING("vrcp14pd"),
    ZYDIS_MAKE_SHORTSTRING("vrcp14ps"),
    ZYDIS_MAKE_SHORTSTRING("vrcp14sd"),
    ZYDIS_MAKE_SHORTSTRING("vrcp14ss"),
    ZYDIS_MAKE_SHORTSTRING("vrcp23ps"),
    ZYDIS_MAKE_SHORTSTRING("vrcp28pd"),
    ZYDIS_MAKE_SHORTSTRING("vrcp28ps"),
    ZYDIS_MAKE_SHORTSTRING("vrcp28sd"),
    ZYDIS_MAKE_SHORTSTRING("vrcp28ss"),
    ZYDIS_MAKE_SHORTSTRING("vrcpph"),
    ZYDIS_MAKE_SHORTSTRING("vrcpps"),
    ZYDIS_MAKE_SHORTSTRING("vrcpsh"),
    ZYDIS_MAKE_SHORTSTRING("vrcpss"),
    ZYDIS_MAKE_SHORTSTRING("vreducepd"),
    ZYDIS_MAKE_SHORTSTRING("vreduceph"),
    ZYDIS_MAKE_SHORTSTRING("vreduceps"),
    ZYDIS_MAKE_SHORTSTRING("vreducesd"),
    ZYDIS_MAKE_SHORTSTRING("vreducesh"),
    ZYDIS_MAKE_SHORTSTRING("vreducess"),
    ZYDIS_MAKE_SHORTSTRING("vrndfxpntpd"),
    ZYDIS_MAKE_SHORTSTRING("vrndfxpntps"),
    ZYDIS_MAKE_SHORTSTRING("vrndscalepd"),
    ZYDIS_MAKE_SHORTSTRING("vrndscaleph"),
    ZYDIS_MAKE_SHORTSTRING("vrndscaleps"),
    ZYDIS_MAKE_SHORTSTRING("vrndscalesd"),
    ZYDIS_MAKE_SHORTSTRING("vrndscalesh"),
    ZYDIS_MAKE_SHORTSTRING("vrndscaless"),
    ZYDIS_MAKE_SHORTSTRING("vroundpd"),
    ZYDIS_MAKE_SHORTSTRING("vroundps"),
    ZYDIS_MAKE_SHORTSTRING("vroundsd"),
    ZYDIS_MAKE_SHORTSTRING("vroundss"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt14pd"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt14ps"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt14sd"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt14ss"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt23ps"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt28pd"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt28ps"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt28sd"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrt28ss"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrtph"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrtps"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrtsh"),
    ZYDIS_MAKE_SHORTSTRING("vrsqrtss"),
    ZYDIS_MAKE_SHORTSTRING("vscalefpd"),
    ZYDIS_MAKE_SHORTSTRING("vscalefph"),
    ZYDIS_MAKE_SHORTSTRING("vscalefps"),
    ZYDIS_MAKE_SHORTSTRING("vscalefsd"),
    ZYDIS_MAKE_SHORTSTRING("vscalefsh"),
    ZYDIS_MAKE_SHORTSTRING("vscalefss"),
    ZYDIS_MAKE_SHORTSTRING("vscaleps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterdpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterdps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf0dpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf0dps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf0hintdpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf0hintdps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf0qpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf0qps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf1dpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf1dps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf1qpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterpf1qps"),
    ZYDIS_MAKE_SHORTSTRING("vscatterqpd"),
    ZYDIS_MAKE_SHORTSTRING("vscatterqps"),
    ZYDIS_MAKE_SHORTSTRING("vshuff32x4"),
    ZYDIS_MAKE_SHORTSTRING("vshuff64x2"),
    ZYDIS_MAKE_SHORTSTRING("vshufi32x4"),
    ZYDIS_MAKE_SHORTSTRING("vshufi64x2"),
    ZYDIS_MAKE_SHORTSTRING("vshufpd"),
    ZYDIS_MAKE_SHORTSTRING("vshufps"),
    ZYDIS_MAKE_SHORTSTRING("vsqrtpd"),
    ZYDIS_MAKE_SHORTSTRING("vsqrtph"),
    ZYDIS_MAKE_SHORTSTRING("vsqrtps"),
    ZYDIS_MAKE_SHORTSTRING("vsqrtsd"),
    ZYDIS_MAKE_SHORTSTRING("vsqrtsh"),
    ZYDIS_MAKE_SHORTSTRING("vsqrtss"),
    ZYDIS_MAKE_SHORTSTRING("vstmxcsr"),
    ZYDIS_MAKE_SHORTSTRING("vsubpd"),
    ZYDIS_MAKE_SHORTSTRING("vsubph"),
    ZYDIS_MAKE_SHORTSTRING("vsubps"),
    ZYDIS_MAKE_SHORTSTRING("vsubrpd"),
    ZYDIS_MAKE_SHORTSTRING("vsubrps"),
    ZYDIS_MAKE_SHORTSTRING("vsubsd"),
    ZYDIS_MAKE_SHORTSTRING("vsubsh"),
    ZYDIS_MAKE_SHORTSTRING("vsubss"),
    ZYDIS_MAKE_SHORTSTRING("vtestpd"),
    ZYDIS_MAKE_SHORTSTRING("vtestps"),
    ZYDIS_MAKE_SHORTSTRING("vucomisd"),
    ZYDIS_MAKE_SHORTSTRING("vucomish"),
    ZYDIS_MAKE_SHORTSTRING("vucomiss"),
    ZYDIS_MAKE_SHORTSTRING("vunpckhpd"),
    ZYDIS_MAKE_SHORTSTRING("vunpckhps"),
    ZYDIS_MAKE_SHORTSTRING("vunpcklpd"),
    ZYDIS_MAKE_SHORTSTRING("vunpcklps"),
    ZYDIS_MAKE_SHORTSTRING("vxorpd"),
    ZYDIS_MAKE_SHORTSTRING("vxorps"),
    ZYDIS_MAKE_SHORTSTRING("vzeroall"),
    ZYDIS_MAKE_SHORTSTRING("vzeroupper"),
    ZYDIS_MAKE_SHORTSTRING("wbinvd"),
    ZYDIS_MAKE_SHORTSTRING("wrfsbase"),
    ZYDIS_MAKE_SHORTSTRING("wrgsbase"),
    ZYDIS_MAKE_SHORTSTRING("wrmsr"),
    ZYDIS_MAKE_SHORTSTRING("wrmsrlist"),
    ZYDIS_MAKE_SHORTSTRING("wrmsrns"),
    ZYDIS_MAKE_SHORTSTRING("wrpkru"),
    ZYDIS_MAKE_SHORTSTRING("wrssd"),
    ZYDIS_MAKE_SHORTSTRING("wrssq"),
    ZYDIS_MAKE_SHORTSTRING("wrussd"),
    ZYDIS_MAKE_SHORTSTRING("wrussq"),
    ZYDIS_MAKE_SHORTSTRING("xabort"),
    ZYDIS_MAKE_SHORTSTRING("xadd"),
    ZYDIS_MAKE_SHORTSTRING("xbegin"),
    ZYDIS_MAKE_SHORTSTRING("xchg"),
    ZYDIS_MAKE_SHORTSTRING("xcrypt_cbc"),
    ZYDIS_MAKE_SHORTSTRING("xcrypt_cfb"),
    ZYDIS_MAKE_SHORTSTRING("xcrypt_ctr"),
    ZYDIS_MAKE_SHORTSTRING("xcrypt_ecb"),
    ZYDIS_MAKE_SHORTSTRING("xcrypt_ofb"),
    ZYDIS_MAKE_SHORTSTRING("xend"),
    ZYDIS_MAKE_SHORTSTRING("xgetbv"),
    ZYDIS_MAKE_SHORTSTRING("xlat"),
    ZYDIS_MAKE_SHORTSTRING("xor"),
    ZYDIS_MAKE_SHORTSTRING("xorpd"),
    ZYDIS_MAKE_SHORTSTRING("xorps"),
    ZYDIS_MAKE_SHORTSTRING("xresldtrk"),
    ZYDIS_MAKE_SHORTSTRING("xrstor"),
    ZYDIS_MAKE_SHORTSTRING("xrstor64"),
    ZYDIS_MAKE_SHORTSTRING("xrstors"),
    ZYDIS_MAKE_SHORTSTRING("xrstors64"),
    ZYDIS_MAKE_SHORTSTRING("xsave"),
    ZYDIS_MAKE_SHORTSTRING("xsave64"),
    ZYDIS_MAKE_SHORTSTRING("xsavec"),
    ZYDIS_MAKE_SHORTSTRING("xsavec64"),
    ZYDIS_MAKE_SHORTSTRING("xsaveopt"),
    ZYDIS_MAKE_SHORTSTRING("xsaveopt64"),
    ZYDIS_MAKE_SHORTSTRING("xsaves"),
    ZYDIS_MAKE_SHORTSTRING("xsaves64"),
    ZYDIS_MAKE_SHORTSTRING("xsetbv"),
    ZYDIS_MAKE_SHORTSTRING("xsha1"),
    ZYDIS_MAKE_SHORTSTRING("xsha256"),
    ZYDIS_MAKE_SHORTSTRING("xstore"),
    ZYDIS_MAKE_SHORTSTRING("xsusldtrk"),
    ZYDIS_MAKE_SHORTSTRING("xtest")
};

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

const char* ZydisMnemonicGetString(ZydisMnemonic mnemonic)
{
    if((ZyanUSize)mnemonic >= ZYAN_ARRAY_LENGTH(STR_MNEMONIC))
    {
        return ZYAN_NULL;
    }
    return (const char*)STR_MNEMONIC[mnemonic].data;
}

const ZydisShortString* ZydisMnemonicGetStringWrapped(ZydisMnemonic mnemonic)
{
    if((ZyanUSize)mnemonic >= ZYAN_ARRAY_LENGTH(STR_MNEMONIC))
    {
        return ZYAN_NULL;
    }
    return &STR_MNEMONIC[mnemonic];
}

/* ============================================================================================== */

//
// Source file: /Users/admin/Projects/zydis/src/DecoderData.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


//
// Header: Zydis/Internal/DecoderData.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

#ifndef ZYDIS_INTERNAL_DECODERDATA_H
#define ZYDIS_INTERNAL_DECODERDATA_H


#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Enums and types                                                                                */
/* ============================================================================================== */

// MSVC does not like types other than (un-)signed int for bit-fields
#ifdef ZYAN_MSVC
#   pragma warning(push)
#   pragma warning(disable:4214)
#endif

#pragma pack(push, 1)

/* ---------------------------------------------------------------------------------------------- */
/* Decoder tree                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderTreeNodeType` data-type.
 */
typedef ZyanU8 ZydisDecoderTreeNodeType;

/**
 * Values that represent zydis decoder tree node types.
 */
enum ZydisDecoderTreeNodeTypes
{
    ZYDIS_NODETYPE_INVALID                  = 0x00,
    /**
     * Reference to an instruction-definition.
     */
    ZYDIS_NODETYPE_DEFINITION_MASK          = 0x80,
    /**
     * Reference to an XOP-map filter.
     */
    ZYDIS_NODETYPE_FILTER_XOP               = 0x01,
    /**
     * Reference to an VEX-map filter.
     */
    ZYDIS_NODETYPE_FILTER_VEX               = 0x02,
    /**
     * Reference to an EVEX/MVEX-map filter.
     */
    ZYDIS_NODETYPE_FILTER_EMVEX             = 0x03,
    /**
     * Reference to an opcode filter.
     */
    ZYDIS_NODETYPE_FILTER_OPCODE            = 0x04,
    /**
     * Reference to an instruction-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE              = 0x05,
    /**
     * Reference to an compacted instruction-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_COMPACT      = 0x06,
    /**
     * Reference to a ModRM.mod filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_MOD         = 0x07,
    /**
     * Reference to a compacted ModRM.mod filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT = 0x08,
    /**
     * Reference to a ModRM.reg filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_REG         = 0x09,
    /**
     * Reference to a ModRM.rm filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_RM          = 0x0A,
    /**
     * Reference to a PrefixGroup1 filter.
     */
    ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1     = 0x0B,
    /**
     * Reference to a mandatory-prefix filter.
     */
    ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX  = 0x0C,
    /**
     * Reference to an operand-size filter.
     */
    ZYDIS_NODETYPE_FILTER_OPERAND_SIZE      = 0x0D,
    /**
     * Reference to an address-size filter.
     */
    ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE      = 0x0E,
    /**
     * Reference to a vector-length filter.
     */
    ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH     = 0x0F,
    /**
     * Reference to an REX/VEX/EVEX.W filter.
     */
    ZYDIS_NODETYPE_FILTER_REX_W             = 0x10,
    /**
     * Reference to an REX/VEX/EVEX.B filter.
     */
    ZYDIS_NODETYPE_FILTER_REX_B             = 0x11,
    /**
     * Reference to an EVEX.b filter.
     */
    ZYDIS_NODETYPE_FILTER_EVEX_B            = 0x12,
    /**
     * Reference to an MVEX.E filter.
     */
    ZYDIS_NODETYPE_FILTER_MVEX_E            = 0x13,
    /**
     * Reference to a AMD-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_AMD          = 0x14,
    /**
     * Reference to a KNC-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_KNC          = 0x15,
    /**
     * Reference to a MPX-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_MPX          = 0x16,
    /**
     * Reference to a CET-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_CET          = 0x17,
    /**
     * Reference to a LZCNT-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_LZCNT        = 0x18,
    /**
     * Reference to a TZCNT-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_TZCNT        = 0x19,
    /**
     * Reference to a WBNOINVD-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_WBNOINVD     = 0x1A,
    /**
     * Reference to a CLDEMOTE-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_CLDEMOTE     = 0x1B,
    /**
     * Reference to a IPREFETCH-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_IPREFETCH    = 0x1C
};

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderTreeNodeValue` data-type.
 */
typedef ZyanU16 ZydisDecoderTreeNodeValue;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderTreeNode` struct.
 */
typedef struct ZydisDecoderTreeNode_
{
    ZydisDecoderTreeNodeType type;
    ZydisDecoderTreeNodeValue value;
} ZydisDecoderTreeNode;

/* ---------------------------------------------------------------------------------------------- */

#pragma pack(pop)

#ifdef ZYAN_MSVC
#   pragma warning(pop)
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Physical instruction encoding info                                                             */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInstructionEncodingFlags` data-type.
 */
typedef ZyanU8 ZydisInstructionEncodingFlags;

/**
 * The instruction has an optional modrm byte.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_MODRM      0x01

/**
 * The instruction has an optional displacement value.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_DISP       0x02

/**
 * The instruction has an optional immediate value.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_IMM0       0x04

/**
 * The instruction has a second optional immediate value.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_IMM1       0x08

/**
 * The instruction ignores the value of `modrm.mod` and always assumes `modrm.mod == 3`
 *          ("reg, reg" - form).
 *
 *          Instructions with this flag can't have a SIB byte or a displacement value.
 */
#define ZYDIS_INSTR_ENC_FLAG_FORCE_REG_FORM 0x10

/**
 * Defines the `ZydisInstructionEncodingInfo` struct.
 */
typedef struct ZydisInstructionEncodingInfo_
{
    /**
     * Contains flags with information about the physical instruction-encoding.
     */
    ZydisInstructionEncodingFlags flags;
    /**
     * Displacement info.
     */
    struct
    {
        /**
         * The size of the displacement value.
         */
        ZyanU8 size[3];
    } disp;
    /**
     * Immediate info.
     */
    struct
    {
        /**
         * The size of the immediate value.
         */
        ZyanU8 size[3];
        /**
         * Signals, if the value is signed.
         */
        ZyanBool is_signed;
        /**
         * Signals, if the value is a relative offset.
         */
        ZyanBool is_relative;
    } imm[2];
} ZydisInstructionEncodingInfo;

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Functions                                                                                      */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Decoder tree                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

extern const ZydisDecoderTreeNode zydis_decoder_tree_root;

/**
 * Returns the root node of the instruction tree.
 *
 * @return  The root node of the instruction tree.
 */
ZYAN_INLINE const ZydisDecoderTreeNode* ZydisDecoderTreeGetRootNode(void)
{
    return &zydis_decoder_tree_root;
}

/**
 * Returns the child node of `parent` specified by `index`.
 *
 * @param   parent  The parent node.
 * @param   index   The index of the child node to retrieve.
 *
 * @return  The specified child node.
 */
ZYDIS_NO_EXPORT const ZydisDecoderTreeNode* ZydisDecoderTreeGetChildNode(
    const ZydisDecoderTreeNode* parent, ZyanU16 index);

/**
 * Returns information about optional instruction parts (like modrm, displacement or
 * immediates) for the instruction that is linked to the given `node`.
 *
 * @param   node    The instruction definition node.
 * @param   info    A pointer to the `ZydisInstructionParts` struct.
 */
ZYDIS_NO_EXPORT void ZydisGetInstructionEncodingInfo(const ZydisDecoderTreeNode* node,
        const ZydisInstructionEncodingInfo** info);

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* ZYDIS_INTERNAL_DECODERDATA_H */

/* ============================================================================================== */
/* Data tables                                                                                    */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Physical instruction encodings                                                                 */
/* ---------------------------------------------------------------------------------------------- */


//
// Header: Generated/InstructionEncodings.inc
//

static const ZydisInstructionEncodingInfo INSTR_ENCODINGS[] =
{
    { 0, { { 0, 0, 0 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM, { { 0, 0, 0 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_DISP, { { 16, 32, 64 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 16, 16 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 64 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 32, 32, 32 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 32, 32, 32 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_FORCE_REG_FORM, { { 0, 0, 0 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0 | ZYDIS_INSTR_ENC_FLAG_HAS_IMM1, { { 0, 0, 0 } }, { { { 16, 16, 16 }, ZYAN_FALSE, ZYAN_FALSE }, { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0 | ZYDIS_INSTR_ENC_FLAG_HAS_IMM1, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_FALSE, ZYAN_FALSE }, { { 16, 16, 16 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0 | ZYDIS_INSTR_ENC_FLAG_HAS_IMM1, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE }, { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE } } }
};

/* ---------------------------------------------------------------------------------------------- */
/* Decoder tree                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

#define ZYDIS_INVALID \
    { ZYDIS_NODETYPE_INVALID, 0x00000000 }
#define ZYDIS_FILTER(type, id) \
    { type, id }
#define ZYDIS_DEFINITION(encoding_id, id) \
    { ZYDIS_NODETYPE_DEFINITION_MASK | encoding_id, id }


//
// Header: Generated/DecoderTables.inc
//

const ZydisDecoderTreeNode FILTERS_XOP[][13] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x22), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_VEX[][17] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x24), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x25), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x27), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x28), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x743), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x24), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x26), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x29), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2B), ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_EMVEX[][49] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x159), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x6), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x10), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x11), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x12), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x13), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x14), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x16), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x17), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x19), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1F) }
};

const ZydisDecoderTreeNode FILTERS_OPCODE[][256] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3), ZYDIS_DEFINITION(0x5, 0x26), ZYDIS_DEFINITION(0x6, 0x27), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7), ZYDIS_DEFINITION(0x5, 0x3F6), ZYDIS_DEFINITION(0x6, 0x3F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x141), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x142), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x143), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x144), ZYDIS_DEFINITION(0x5, 0x10), ZYDIS_DEFINITION(0x6, 0x11), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x59), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x145), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x146), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x147), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x148), ZYDIS_DEFINITION(0x5, 0x64B), ZYDIS_DEFINITION(0x6, 0x64C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x149), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14C), ZYDIS_DEFINITION(0x5, 0x5C), ZYDIS_DEFINITION(0x6, 0x5D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x150), ZYDIS_DEFINITION(0x5, 0x6F4), ZYDIS_DEFINITION(0x6, 0x6F5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x151), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x152), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x153), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x154), ZYDIS_DEFINITION(0x5, 0x779), ZYDIS_DEFINITION(0x6, 0x77A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x155), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x156), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x157), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x158), ZYDIS_DEFINITION(0x5, 0xEF), ZYDIS_DEFINITION(0x6, 0xF0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x60), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x61), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x62), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x64), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x66), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x68), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6F), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_DEFINITION(0x0, 0x520), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x70), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EMVEX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x6, 0x5CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DD), ZYDIS_DEFINITION(0x5, 0x5CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_XOP, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A9), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_DEFINITION(0x0, 0x768), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCE), ZYDIS_DEFINITION(0x0, 0x20F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD0), ZYDIS_DEFINITION(0x0, 0x634), ZYDIS_DEFINITION(0x0, 0x2C5), ZYDIS_DEFINITION(0x2, 0x315), ZYDIS_DEFINITION(0x2, 0x316), ZYDIS_DEFINITION(0x2, 0x317), ZYDIS_DEFINITION(0x2, 0x318), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AD), ZYDIS_DEFINITION(0x5, 0x716), ZYDIS_DEFINITION(0x6, 0x717), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B3), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x5, 0x319), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_DEFINITION(0x7, 0x31A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x439), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43A), ZYDIS_DEFINITION(0x4, 0x608), ZYDIS_DEFINITION(0x0, 0x609), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VEX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VEX, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x744), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x745), ZYDIS_DEFINITION(0x11, 0x17C), ZYDIS_DEFINITION(0x0, 0x2CC), ZYDIS_DEFINITION(0x4, 0x60A), ZYDIS_DEFINITION(0x0, 0x60B), ZYDIS_DEFINITION(0x0, 0x259), ZYDIS_DEFINITION(0x3, 0x257), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x746), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x747), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x748), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x749), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x121), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x123), ZYDIS_DEFINITION(0x0, 0x770), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x750), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x751), ZYDIS_DEFINITION(0x8, 0x2E8), ZYDIS_DEFINITION(0x8, 0x2E7), ZYDIS_DEFINITION(0x8, 0x2E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x124), ZYDIS_DEFINITION(0x3, 0x23A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x25), ZYDIS_DEFINITION(0x3, 0x404), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x125), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x127), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x128), ZYDIS_DEFINITION(0x0, 0x23D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x27), ZYDIS_DEFINITION(0x0, 0x407), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x28), ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x258), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x226), ZYDIS_DEFINITION(0x0, 0xC6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x752), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x753), ZYDIS_DEFINITION(0x0, 0xBA), ZYDIS_DEFINITION(0x0, 0x6D8), ZYDIS_DEFINITION(0x0, 0xC0), ZYDIS_DEFINITION(0x0, 0x6DB), ZYDIS_DEFINITION(0x0, 0xBB), ZYDIS_DEFINITION(0x0, 0x6D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x754), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x755) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1D), ZYDIS_DEFINITION(0x0, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1E), ZYDIS_DEFINITION(0x0, 0x25B), ZYDIS_DEFINITION(0x0, 0x752), ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x72D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC), ZYDIS_DEFINITION(0x0, 0x1AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_MPX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_MPX, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E), ZYDIS_DEFINITION(0x0, 0x755), ZYDIS_DEFINITION(0x0, 0x606), ZYDIS_DEFINITION(0x0, 0x5FB), ZYDIS_DEFINITION(0x0, 0x600), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x30), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x3), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x45), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x47), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x49), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEE), ZYDIS_DEFINITION(0x0, 0x5D1), ZYDIS_DEFINITION(0x0, 0x523), ZYDIS_DEFINITION(0x0, 0x118), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF3), ZYDIS_DEFINITION(0x0, 0x5D2), ZYDIS_DEFINITION(0x0, 0x524), ZYDIS_DEFINITION(0x0, 0x62E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x100), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x102), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x104), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x106), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x107), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x108), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x110), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_DEFINITION(0x0, 0x9E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x111), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x113), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x114), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x115), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x116), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x117), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x118), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x119), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x121), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x123), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x124), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x125), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x127), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x128), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x129), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x131), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x132), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x133), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x134), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x135), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x136), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x137), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x138), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x139), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x140) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x75), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x76), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x77), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x78), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x79), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x80), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x81), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x82), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x83), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x84), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x85), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x87), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x89), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x90), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x91), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x92), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x93), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x94), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x95), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x96), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x97), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x98), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x99), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x160), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x161), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x162), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x163), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x164), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x165), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x166), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x167), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x168), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x169), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x170), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x171), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x172), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x173), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x174), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x175), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x176), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x177), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x178), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x179), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x180), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x181), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x182), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x183), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x184), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x185), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x186), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x187), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x188), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x190), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x191), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x192), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x193), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x194), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x195), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x196), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x197), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x198), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x199), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19B), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EA), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x200), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x201), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x202), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x203), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x204), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x205), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x206), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x207), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x208), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x209), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x210), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x211), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x212), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x213), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x214), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x215), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x216), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x217), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x218), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x219), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x220), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x221), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x222), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x223), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x224), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x225), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x226), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x227), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x228), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x229), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x230), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x231), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x232), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x233), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x234), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x235), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x236), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x237), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x238), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x239), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x240), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x241), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x242), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x243), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x244), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x245), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x246), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x247), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x248), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x249), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x250), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x251), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x252), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x253), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x254), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x255), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x256), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x257), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x258), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x259), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x260), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x261), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x262), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x263), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x264), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x265), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x266), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x267), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x268), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x269), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x270), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x271), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x272), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x273), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x274), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x275), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x276), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x277), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x278), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x279), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x280), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x281), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x282), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x283), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x284), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x285), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x286), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x287), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x288), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x289), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x290), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x291), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x292), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x293), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x294), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x295), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x296), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x297), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x298), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x299), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x300), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x301), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x302), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x303), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x304), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x305), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x306), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x307), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x308), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x309), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x310), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x311), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x312), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x313), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x314), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x315), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x316), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x317), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x318), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x319), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x320), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x321), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x322), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x323), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x324), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x325), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x326), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x327), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x328), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x329), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x330), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x331), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x332), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x333), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x334), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x335), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x336), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x337), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x338), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x339), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33B), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x340), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x341), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x342), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x343), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x344), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x345), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x346), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x347), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x348), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x349), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x350), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x351), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x352), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x353), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x354), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x355), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x356), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x357), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x358), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x359), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x360), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x361), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x362), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x363), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x364), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x365), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x366), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x367), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x368), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x369), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x370), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x371), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x372), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x373), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x374), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x375), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x376), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x377), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x378), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x379), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x380), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x381), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x382), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x383), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x384), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x385), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x386), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x387), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x388), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x389), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x390), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x391), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x392), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x393), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x394), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x395), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x396), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x397), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x398), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x399), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AE), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B1), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B3), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B4), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BD), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BE), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BF), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C1), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x448), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x449), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x450), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x451), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x452), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x453), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x454), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x455), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x456), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x457), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x458), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x459), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x460), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x461), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x44), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x45), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x470), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x471), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x472), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x473), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x474), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x475), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x476), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x477), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x478), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x479), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x480), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x481), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x482), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x483), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x484), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x485), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x486), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x487), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x488), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x489), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x46), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x490), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x491), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x492), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x493), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x494), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x495), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x496), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x497), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x498), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x456), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x457), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C6), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DE), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EC), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x500), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x501), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x502), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x503), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x504), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x505), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x506), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x507), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x508), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x509), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x510), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x511), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x51), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x520), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x521), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x522), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x523), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x524), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x525), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x526), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x527), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x528), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x529), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x530), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x531), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x532), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x533), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x534), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x535), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x536), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x537), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x538), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x539), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x540), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x541), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x542), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x543), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x544), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x545), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x546), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x547), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x548), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x549), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x550), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x551), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x552), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x553), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x554), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x555), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x556), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x557), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x558), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x559), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x560), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x561), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x562), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x563), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x564), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x565), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x566), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x567), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x568), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x569), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x570), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x571), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x572), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x573), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x574), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x575), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x576), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x577), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x578), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x579), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x580), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x581), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x582), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x583), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x584), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x585), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x586), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x587), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x588), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x589), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x590), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x591), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x592), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x593), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x594), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x595), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x596), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x52), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x35), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x599), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A3), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A4), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x37), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x39), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x630), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x633), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x636), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x640), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x643), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x646), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x655), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x658), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x679), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E6), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x600), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x601), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x102), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x104), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x602), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6EA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x603), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x604), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x605), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x606), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x53), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x609), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x610), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x611), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x612), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x613), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x614), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x615), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x616), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x617), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x111), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x715), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x716), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x717), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x718), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x719), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x618), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x619), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x61A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x61B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x61C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x54), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x61F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x620), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x621), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x622), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3B), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x625), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x626), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x627), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x628), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x629), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x62A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x62B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x62C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x62D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODE[][3] =
{
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODE_COMPACT[][2] =
{
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5C8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x51D) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5C9) },
    { ZYDIS_DEFINITION(0x1, 0x706), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x174), ZYDIS_DEFINITION(0x1, 0x175) },
    { ZYDIS_DEFINITION(0x1, 0x493), ZYDIS_DEFINITION(0x1, 0x494) },
    { ZYDIS_DEFINITION(0x1, 0x304), ZYDIS_DEFINITION(0x1, 0x305) },
    { ZYDIS_DEFINITION(0x1, 0x3AE), ZYDIS_DEFINITION(0x1, 0x3AF) },
    { ZYDIS_DEFINITION(0x1, 0x170), ZYDIS_DEFINITION(0x1, 0x171) },
    { ZYDIS_DEFINITION(0x1, 0x172), ZYDIS_DEFINITION(0x1, 0x173) },
    { ZYDIS_DEFINITION(0x1, 0x306), ZYDIS_DEFINITION(0x1, 0x307) },
    { ZYDIS_DEFINITION(0x1, 0x3B0), ZYDIS_DEFINITION(0x1, 0x3B1) },
    { ZYDIS_DEFINITION(0x1, 0x710), ZYDIS_DEFINITION(0x1, 0x711) },
    { ZYDIS_DEFINITION(0x1, 0x663), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x662), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x661), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x756), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x72E), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x720), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xC3), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6EB), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x60C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x568), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5FC), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x60D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x688), ZYDIS_DEFINITION(0x1, 0x689) },
    { ZYDIS_DEFINITION(0x1, 0x6C8), ZYDIS_DEFINITION(0x1, 0x6C9) },
    { ZYDIS_DEFINITION(0x1, 0x2D0), ZYDIS_DEFINITION(0x1, 0x2D1) },
    { ZYDIS_DEFINITION(0x1, 0x2D3), ZYDIS_DEFINITION(0x1, 0x2D4) },
    { ZYDIS_DEFINITION(0x0, 0x707), ZYDIS_DEFINITION(0x0, 0x708) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x0), ZYDIS_DEFINITION(0x0, 0x70F) },
    { ZYDIS_DEFINITION(0x1, 0x7C), ZYDIS_DEFINITION(0x1, 0x7E) },
    { ZYDIS_DEFINITION(0x1, 0x84), ZYDIS_DEFINITION(0x1, 0x86) },
    { ZYDIS_DEFINITION(0x1, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x0) },
    { ZYDIS_DEFINITION(0x1, 0x8D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x1) },
    { ZYDIS_DEFINITION(0x1, 0x7D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x2) },
    { ZYDIS_DEFINITION(0x1, 0x85), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x3) },
    { ZYDIS_DEFINITION(0x1, 0x80), ZYDIS_DEFINITION(0x1, 0x82) },
    { ZYDIS_DEFINITION(0x1, 0x92), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x4) },
    { ZYDIS_DEFINITION(0x1, 0x90), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x6) },
    { ZYDIS_DEFINITION(0x1, 0x81), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1) },
    { ZYDIS_DEFINITION(0x10, 0x31F), ZYDIS_DEFINITION(0x10, 0x320) },
    { ZYDIS_DEFINITION(0x10, 0x321), ZYDIS_DEFINITION(0x10, 0x322) },
    { ZYDIS_DEFINITION(0x10, 0x323), ZYDIS_DEFINITION(0x10, 0x324) },
    { ZYDIS_DEFINITION(0x10, 0x325), ZYDIS_DEFINITION(0x10, 0x326) },
    { ZYDIS_DEFINITION(0x0, 0x709), ZYDIS_DEFINITION(0x0, 0x70A) },
    { ZYDIS_DEFINITION(0x0, 0x70B), ZYDIS_DEFINITION(0x0, 0x70C) },
    { ZYDIS_DEFINITION(0x1, 0x25C), ZYDIS_DEFINITION(0x1, 0x25D) },
    { ZYDIS_DEFINITION(0x1, 0x263), ZYDIS_DEFINITION(0x1, 0x264) },
    { ZYDIS_DEFINITION(0x1, 0x261), ZYDIS_DEFINITION(0x1, 0x262) },
    { ZYDIS_DEFINITION(0x1, 0x343), ZYDIS_DEFINITION(0x1, 0x344) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21), ZYDIS_DEFINITION(0x1, 0x333) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22), ZYDIS_DEFINITION(0x1, 0x337) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23), ZYDIS_DEFINITION(0x1, 0x334) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24), ZYDIS_DEFINITION(0x1, 0x338) },
    { ZYDIS_DEFINITION(0x1, 0x745), ZYDIS_DEFINITION(0x1, 0x747) },
    { ZYDIS_DEFINITION(0x1, 0x746), ZYDIS_DEFINITION(0x1, 0x748) },
    { ZYDIS_DEFINITION(0x1, 0x74C), ZYDIS_DEFINITION(0x1, 0x74E) },
    { ZYDIS_DEFINITION(0x1, 0x74D), ZYDIS_DEFINITION(0x1, 0x74F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25), ZYDIS_DEFINITION(0x1, 0x33B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26), ZYDIS_DEFINITION(0x1, 0x33F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27), ZYDIS_DEFINITION(0x1, 0x33C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28), ZYDIS_DEFINITION(0x1, 0x340) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x0), ZYDIS_DEFINITION(0x9, 0x2B4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x1), ZYDIS_DEFINITION(0x9, 0x2A0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x2), ZYDIS_DEFINITION(0x9, 0x26C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x3), ZYDIS_DEFINITION(0x9, 0x28C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x4), ZYDIS_DEFINITION(0x9, 0x2C4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x5), ZYDIS_DEFINITION(0x9, 0x2AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x6), ZYDIS_DEFINITION(0x9, 0x271) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x7), ZYDIS_DEFINITION(0x9, 0x291) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x8), ZYDIS_DEFINITION(0x9, 0x2BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x9), ZYDIS_DEFINITION(0x9, 0x2AA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xA), ZYDIS_DEFINITION(0x9, 0x2B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xB), ZYDIS_DEFINITION(0x9, 0x2A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xC), ZYDIS_DEFINITION(0x9, 0x279) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xD), ZYDIS_DEFINITION(0x9, 0x296) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xE), ZYDIS_DEFINITION(0x9, 0x27E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xF), ZYDIS_DEFINITION(0x9, 0x29B) },
    { ZYDIS_DEFINITION(0x1, 0x5F9), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5FA), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x753), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x754), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x664), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5FD), ZYDIS_DEFINITION(0x1, 0x5FE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F), ZYDIS_DEFINITION(0x1, 0x113) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5CA) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x51E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5CB) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x51F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x158) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x159) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x7) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x15A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x83), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x84) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x87) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x348), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x349) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x351), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x352) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x354), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x355) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x357), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x358) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x371), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x372) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x374), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x375) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x377), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x378) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x380) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x382), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x383) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3DB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3EE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3EF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x410) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x412), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x413) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x415), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x416) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x418), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x419) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x41B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x41C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x434), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x435) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x437), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x438) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x442) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x444), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x445) },
    { ZYDIS_DEFINITION(0x1, 0x392), ZYDIS_DEFINITION(0x1, 0x70) },
    { ZYDIS_DEFINITION(0x1, 0x393), ZYDIS_DEFINITION(0x1, 0x71) },
    { ZYDIS_DEFINITION(0x8, 0x2B0), ZYDIS_DEFINITION(0x8, 0x2B1) },
    { ZYDIS_DEFINITION(0x8, 0x29C), ZYDIS_DEFINITION(0x8, 0x29D) },
    { ZYDIS_DEFINITION(0x8, 0x268), ZYDIS_DEFINITION(0x8, 0x269) },
    { ZYDIS_DEFINITION(0x8, 0x288), ZYDIS_DEFINITION(0x8, 0x289) },
    { ZYDIS_DEFINITION(0x8, 0x2C0), ZYDIS_DEFINITION(0x8, 0x2C1) },
    { ZYDIS_DEFINITION(0x8, 0x2AB), ZYDIS_DEFINITION(0x8, 0x2AC) },
    { ZYDIS_DEFINITION(0x8, 0x26D), ZYDIS_DEFINITION(0x8, 0x26E) },
    { ZYDIS_DEFINITION(0x8, 0x28D), ZYDIS_DEFINITION(0x8, 0x28E) },
    { ZYDIS_DEFINITION(0x8, 0x2BB), ZYDIS_DEFINITION(0x8, 0x2BC) },
    { ZYDIS_DEFINITION(0x8, 0x2A6), ZYDIS_DEFINITION(0x8, 0x2A7) },
    { ZYDIS_DEFINITION(0x8, 0x2B5), ZYDIS_DEFINITION(0x8, 0x2B6) },
    { ZYDIS_DEFINITION(0x8, 0x2A1), ZYDIS_DEFINITION(0x8, 0x2A2) },
    { ZYDIS_DEFINITION(0x8, 0x275), ZYDIS_DEFINITION(0x8, 0x276) },
    { ZYDIS_DEFINITION(0x8, 0x292), ZYDIS_DEFINITION(0x8, 0x293) },
    { ZYDIS_DEFINITION(0x8, 0x27A), ZYDIS_DEFINITION(0x8, 0x27B) },
    { ZYDIS_DEFINITION(0x8, 0x297), ZYDIS_DEFINITION(0x8, 0x298) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x2C) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x3FC) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x16) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x651) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x62) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x6FA) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x77F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0xF5) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x2D) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x3FD) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x17) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x652) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x63) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x6FB) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x780) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0xF6) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x12, 0xAF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x10) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x448), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x449), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x458), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x461), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x463), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x465), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x466), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x506), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x507), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x489), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x490), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x491), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x492), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x493) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x506), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x507) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x607), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x608), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x616), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x685), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x686) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x696), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x700), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x707), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x708) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x709), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x710) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x711), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x712) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x713), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x714) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x723), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x724) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x725), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x726) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x727), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x728), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x729), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x731), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x732), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x737), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x738), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x740) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x741), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x742) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CA) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x25A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x3, 0x4) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x3, 0x1) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x635) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x39) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x10), ZYDIS_DEFINITION(0x9, 0xB2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x11), ZYDIS_DEFINITION(0x9, 0x281) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x12, 0x282) },
    { ZYDIS_DEFINITION(0x8, 0x283), ZYDIS_DEFINITION(0x8, 0x284) }
};

const ZydisDecoderTreeNode FILTERS_PREFIX_GROUP1[][2] =
{
    { ZYDIS_DEFINITION(0x1, 0x32F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9E) },
    { ZYDIS_DEFINITION(0x1, 0x330), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x138) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x149) }
};

const ZydisDecoderTreeNode FILTERS_MODRM_MOD[][4] =
{
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODRM_MOD_COMPACT[][2] =
{
    { ZYDIS_DEFINITION(0x1, 0x1E), ZYDIS_DEFINITION(0x1, 0x1F) },
    { ZYDIS_DEFINITION(0x1, 0x20), ZYDIS_DEFINITION(0x1, 0x21) },
    { ZYDIS_DEFINITION(0x1, 0x22), ZYDIS_DEFINITION(0x1, 0x23) },
    { ZYDIS_DEFINITION(0x1, 0x24), ZYDIS_DEFINITION(0x1, 0x25) },
    { ZYDIS_DEFINITION(0x1, 0x3EE), ZYDIS_DEFINITION(0x1, 0x3EF) },
    { ZYDIS_DEFINITION(0x1, 0x3F0), ZYDIS_DEFINITION(0x1, 0x3F1) },
    { ZYDIS_DEFINITION(0x1, 0x3F2), ZYDIS_DEFINITION(0x1, 0x3F3) },
    { ZYDIS_DEFINITION(0x1, 0x3F4), ZYDIS_DEFINITION(0x1, 0x3F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1) },
    { ZYDIS_DEFINITION(0x1, 0x2C6), ZYDIS_DEFINITION(0x1, 0x2C7) },
    { ZYDIS_DEFINITION(0x1, 0x2E9), ZYDIS_DEFINITION(0x1, 0x2EA) },
    { ZYDIS_DEFINITION(0x1, 0x3B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0x2A), ZYDIS_DEFINITION(0x1, 0x2B) },
    { ZYDIS_DEFINITION(0x1, 0x28), ZYDIS_DEFINITION(0x1, 0x29) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x2), ZYDIS_DEFINITION(0x1, 0x3) },
    { ZYDIS_DEFINITION(0x1, 0x18), ZYDIS_DEFINITION(0x1, 0x19) },
    { ZYDIS_DEFINITION(0x1, 0x1A), ZYDIS_DEFINITION(0x1, 0x1B) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0x14), ZYDIS_DEFINITION(0x1, 0x15) },
    { ZYDIS_DEFINITION(0x1, 0x1C), ZYDIS_DEFINITION(0x1, 0x1D) },
    { ZYDIS_DEFINITION(0x1, 0x22), ZYDIS_DEFINITION(0x1, 0x23) },
    { ZYDIS_DEFINITION(0x1, 0x24), ZYDIS_DEFINITION(0x1, 0x25) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0xE), ZYDIS_DEFINITION(0x1, 0xF) },
    { ZYDIS_DEFINITION(0x1, 0x12), ZYDIS_DEFINITION(0x1, 0x13) },
    { ZYDIS_DEFINITION(0x1, 0x10), ZYDIS_DEFINITION(0x1, 0x11) },
    { ZYDIS_DEFINITION(0x1, 0x20), ZYDIS_DEFINITION(0x1, 0x21) },
    { ZYDIS_DEFINITION(0x1, 0x26), ZYDIS_DEFINITION(0x1, 0x27) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x16), ZYDIS_DEFINITION(0x1, 0x17) },
    { ZYDIS_DEFINITION(0x1, 0x1E), ZYDIS_DEFINITION(0x1, 0x1F) },
    { ZYDIS_DEFINITION(0x1, 0x2C), ZYDIS_DEFINITION(0x1, 0x2D) },
    { ZYDIS_DEFINITION(0x1, 0x2E), ZYDIS_DEFINITION(0x1, 0x2F) },
    { ZYDIS_DEFINITION(0x1, 0x0), ZYDIS_DEFINITION(0x1, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x3C4), ZYDIS_DEFINITION(0x1, 0x3C5) },
    { ZYDIS_DEFINITION(0x1, 0x3C6), ZYDIS_DEFINITION(0x1, 0x3C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11) },
    { ZYDIS_DEFINITION(0x1, 0x3C9), ZYDIS_DEFINITION(0x1, 0x3CA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13) },
    { ZYDIS_DEFINITION(0x1, 0x3CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CLDEMOTE, 0x0) },
    { ZYDIS_DEFINITION(0x1, 0x3CF), ZYDIS_DEFINITION(0x1, 0x3D0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15), ZYDIS_DEFINITION(0x1, 0x3D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x20) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x22) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x24) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x27) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x29) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x30), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x31) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x32), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x33) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x35) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x37) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x39) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x41) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x43) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x45) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x47) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x49) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x51) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x53) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x54), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x55) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x57) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x59) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x60) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x61), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x62) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x64) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x66) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x68) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x70) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x76) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x77), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x78) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x79), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x80) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x81) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x82) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x83) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x84), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x85) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x87) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x89) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x90), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x91) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x92) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x93), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x94) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x95), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x96) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x97), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x98) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x99), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA4) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA7), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDF), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xDF), ZYDIS_DEFINITION(0x1, 0xE0) },
    { ZYDIS_DEFINITION(0x1, 0xD7), ZYDIS_DEFINITION(0x1, 0xD8) },
    { ZYDIS_DEFINITION(0x1, 0xC7), ZYDIS_DEFINITION(0x1, 0xC8) },
    { ZYDIS_DEFINITION(0x1, 0xCF), ZYDIS_DEFINITION(0x1, 0xD0) },
    { ZYDIS_DEFINITION(0x1, 0xE5), ZYDIS_DEFINITION(0x1, 0xE6) },
    { ZYDIS_DEFINITION(0x1, 0xDD), ZYDIS_DEFINITION(0x1, 0xDE) },
    { ZYDIS_DEFINITION(0x1, 0xC9), ZYDIS_DEFINITION(0x1, 0xCA) },
    { ZYDIS_DEFINITION(0x1, 0xD1), ZYDIS_DEFINITION(0x1, 0xD2) },
    { ZYDIS_DEFINITION(0x1, 0xE3), ZYDIS_DEFINITION(0x1, 0xE4) },
    { ZYDIS_DEFINITION(0x1, 0xDB), ZYDIS_DEFINITION(0x1, 0xDC) },
    { ZYDIS_DEFINITION(0x1, 0xE1), ZYDIS_DEFINITION(0x1, 0xE2) },
    { ZYDIS_DEFINITION(0x1, 0xD9), ZYDIS_DEFINITION(0x1, 0xDA) },
    { ZYDIS_DEFINITION(0x1, 0xCB), ZYDIS_DEFINITION(0x1, 0xCC) },
    { ZYDIS_DEFINITION(0x1, 0xD3), ZYDIS_DEFINITION(0x1, 0xD4) },
    { ZYDIS_DEFINITION(0x1, 0xCD), ZYDIS_DEFINITION(0x1, 0xCE) },
    { ZYDIS_DEFINITION(0x1, 0xD5), ZYDIS_DEFINITION(0x1, 0xD6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x100) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x102) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x104) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x106) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x107), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x108) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x110) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x111), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x112) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x113), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x114) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x115), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x116) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x117), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x118) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x119), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x120) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x121), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x122), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x123), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x124), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x125) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x127) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x128), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x129) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x130) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x131), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x132) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x133), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x134) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x135), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x136) },
    { ZYDIS_DEFINITION(0x1, 0x67E), ZYDIS_DEFINITION(0x1, 0x67F) },
    { ZYDIS_DEFINITION(0x1, 0x676), ZYDIS_DEFINITION(0x1, 0x677) },
    { ZYDIS_DEFINITION(0x1, 0x666), ZYDIS_DEFINITION(0x1, 0x667) },
    { ZYDIS_DEFINITION(0x1, 0x66E), ZYDIS_DEFINITION(0x1, 0x66F) },
    { ZYDIS_DEFINITION(0x1, 0x685), ZYDIS_DEFINITION(0x1, 0x686) },
    { ZYDIS_DEFINITION(0x1, 0x67C), ZYDIS_DEFINITION(0x1, 0x67D) },
    { ZYDIS_DEFINITION(0x1, 0x668), ZYDIS_DEFINITION(0x1, 0x669) },
    { ZYDIS_DEFINITION(0x1, 0x670), ZYDIS_DEFINITION(0x1, 0x671) },
    { ZYDIS_DEFINITION(0x1, 0x682), ZYDIS_DEFINITION(0x1, 0x683) },
    { ZYDIS_DEFINITION(0x1, 0x67A), ZYDIS_DEFINITION(0x1, 0x67B) },
    { ZYDIS_DEFINITION(0x1, 0x680), ZYDIS_DEFINITION(0x1, 0x681) },
    { ZYDIS_DEFINITION(0x1, 0x678), ZYDIS_DEFINITION(0x1, 0x679) },
    { ZYDIS_DEFINITION(0x1, 0x66A), ZYDIS_DEFINITION(0x1, 0x66B) },
    { ZYDIS_DEFINITION(0x1, 0x672), ZYDIS_DEFINITION(0x1, 0x673) },
    { ZYDIS_DEFINITION(0x1, 0x66C), ZYDIS_DEFINITION(0x1, 0x66D) },
    { ZYDIS_DEFINITION(0x1, 0x674), ZYDIS_DEFINITION(0x1, 0x675) },
    { ZYDIS_DEFINITION(0x1, 0x9F), ZYDIS_DEFINITION(0x1, 0xA0) },
    { ZYDIS_DEFINITION(0xB, 0x6B0), ZYDIS_DEFINITION(0xB, 0x6B1) },
    { ZYDIS_DEFINITION(0x1, 0x6B2), ZYDIS_DEFINITION(0x1, 0x6B3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x137), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x2), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xAB), ZYDIS_DEFINITION(0x1, 0xAC) },
    { ZYDIS_DEFINITION(0xB, 0x6C0), ZYDIS_DEFINITION(0xB, 0x6C1) },
    { ZYDIS_DEFINITION(0x1, 0x6C2), ZYDIS_DEFINITION(0x1, 0x6C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x139), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13A) },
    { ZYDIS_DEFINITION(0x1, 0x238), ZYDIS_DEFINITION(0x1, 0x239) },
    { ZYDIS_DEFINITION(0x1, 0x10D), ZYDIS_DEFINITION(0x1, 0x10E) },
    { ZYDIS_DEFINITION(0x1, 0x10F), ZYDIS_DEFINITION(0x1, 0x110) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2EB) },
    { ZYDIS_DEFINITION(0x1, 0xA7), ZYDIS_DEFINITION(0x1, 0xA8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CF) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2D2) },
    { ZYDIS_DEFINITION(0x1, 0x39C), ZYDIS_DEFINITION(0x1, 0x39D) },
    { ZYDIS_DEFINITION(0x1, 0x39E), ZYDIS_DEFINITION(0x1, 0x39F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13C) },
    { ZYDIS_DEFINITION(0x1, 0x72B), ZYDIS_DEFINITION(0x1, 0x72C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x24) },
    { ZYDIS_DEFINITION(0x1, 0xA5), ZYDIS_DEFINITION(0x1, 0xA6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x140) },
    { ZYDIS_DEFINITION(0x1, 0x38E), ZYDIS_DEFINITION(0x1, 0x38F) },
    { ZYDIS_DEFINITION(0x1, 0x390), ZYDIS_DEFINITION(0x1, 0x391) },
    { ZYDIS_DEFINITION(0x1, 0x75E), ZYDIS_DEFINITION(0x1, 0x75F) },
    { ZYDIS_DEFINITION(0x1, 0x760), ZYDIS_DEFINITION(0x1, 0x761) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x141), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x142) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x143) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x144), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x145) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x146), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x147), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x148) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x150) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x151), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x152) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x153), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x154) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x155), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x156) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x157), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x158) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x159), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x160), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x161) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x162), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x163) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x164), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x165) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x166), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x167) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x168), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x169) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x170), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x171) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x172), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x173) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x174), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x175) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x176), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x177) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x178) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x179), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x180) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x181), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x182) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x183), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x184) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x185), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x186) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x187), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x188) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x189) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x190), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x191) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x192), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x193) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x194), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x195) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x196), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x197), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x198) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x199), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A4) },
    { ZYDIS_DEFINITION(0x1, 0x729), ZYDIS_DEFINITION(0x1, 0x72A) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0xE), ZYDIS_DEFINITION(0x1, 0xF) },
    { ZYDIS_DEFINITION(0x1, 0x643), ZYDIS_DEFINITION(0x1, 0x644) },
    { ZYDIS_DEFINITION(0x1, 0x645), ZYDIS_DEFINITION(0x1, 0x646) },
    { ZYDIS_DEFINITION(0x1, 0x647), ZYDIS_DEFINITION(0x1, 0x648) },
    { ZYDIS_DEFINITION(0x1, 0x649), ZYDIS_DEFINITION(0x1, 0x64A) },
    { ZYDIS_DEFINITION(0x1, 0x54), ZYDIS_DEFINITION(0x1, 0x55) },
    { ZYDIS_DEFINITION(0x1, 0x56), ZYDIS_DEFINITION(0x1, 0x57) },
    { ZYDIS_DEFINITION(0x1, 0x58), ZYDIS_DEFINITION(0x1, 0x59) },
    { ZYDIS_DEFINITION(0x1, 0x5A), ZYDIS_DEFINITION(0x1, 0x5B) },
    { ZYDIS_DEFINITION(0x1, 0x6EC), ZYDIS_DEFINITION(0x1, 0x6ED) },
    { ZYDIS_DEFINITION(0x1, 0x6EE), ZYDIS_DEFINITION(0x1, 0x6EF) },
    { ZYDIS_DEFINITION(0x1, 0x6F0), ZYDIS_DEFINITION(0x1, 0x6F1) },
    { ZYDIS_DEFINITION(0x1, 0x6F2), ZYDIS_DEFINITION(0x1, 0x6F3) },
    { ZYDIS_DEFINITION(0x1, 0x771), ZYDIS_DEFINITION(0x1, 0x772) },
    { ZYDIS_DEFINITION(0x1, 0x773), ZYDIS_DEFINITION(0x1, 0x774) },
    { ZYDIS_DEFINITION(0x1, 0x775), ZYDIS_DEFINITION(0x1, 0x776) },
    { ZYDIS_DEFINITION(0x1, 0x777), ZYDIS_DEFINITION(0x1, 0x778) },
    { ZYDIS_DEFINITION(0x1, 0xE7), ZYDIS_DEFINITION(0x1, 0xE8) },
    { ZYDIS_DEFINITION(0x1, 0xE9), ZYDIS_DEFINITION(0x1, 0xEA) },
    { ZYDIS_DEFINITION(0x1, 0xEB), ZYDIS_DEFINITION(0x1, 0xEC) },
    { ZYDIS_DEFINITION(0x1, 0xED), ZYDIS_DEFINITION(0x1, 0xEE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x70), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x71) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x72), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x73) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x74), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x75) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x76), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x77) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x78), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x79) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x80), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x81) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x82), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x83) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x84), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x85) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x87) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x89) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x90), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x91) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x92), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x93) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x94), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x95) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x96), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x97) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x98), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x99) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA4) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA9) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAA) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x76) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x78), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x79) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x30) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x100) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x102) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x104) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x106) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x107), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x108) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x110) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x111) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x113) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x114), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x115) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x116), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x117) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x118), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x119) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x100) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x102) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x104) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x106) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x121) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x111) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x113) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x123) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x124), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x125) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x127) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x128), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x129) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x131) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x132), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x133) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x134), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x135) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x136), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x137) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x138) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x139) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x131) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x134), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x135) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x136), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x137) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x138), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x139) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x140), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x141) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x142), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x143) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x144), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x145) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x146), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x147) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x148) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x149), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x150), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x151) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x152), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x153) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x154), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x155) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x156), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x157) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x158), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x159) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x150) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x151), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x152) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x153), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x154) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x160) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x155), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x156) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x163), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x164) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x157), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x158) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x167), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x168) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x159), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x160) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x161), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x162) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x163), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x164) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x165), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x166) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x167), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x168) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x169), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x170) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x171), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x172) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x173), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x174) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x175), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x176) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x177), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x178) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x179), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x180) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x181), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x182) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x183) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x184) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x185), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x186) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x187), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x188) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x190) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x191), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x192) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x193), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x194) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x195), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x196) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x197), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x198) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x199), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x20) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x21) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x200), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x201) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x31) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x32) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x210), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x211) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x212), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x213) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x214), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x215) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x26F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x270) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x271), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x272) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x273), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x274) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x275), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x276) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x216), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x217) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x218), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x219) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x220), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x221) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x222), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x223) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x224), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x225) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x226), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x227) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x283), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x284) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x285), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x286) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x287), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x288) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x228), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x229) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x290) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x230), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x231) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x232), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x233) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x234), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x235) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x236), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x237) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x238), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x239) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x240), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x241) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x242), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x243) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x244), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x245) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x246), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x247) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x248), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x249) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x250), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x251) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x252), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x253) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x254), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x255) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x256), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x257) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x258), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x259) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x260), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x261) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x262), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x263) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x264), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x265) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x266), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x267) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x268), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x269) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x270), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x271) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x272), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x273) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x274), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x275) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x276), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x277) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x278), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x279) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x280), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x281) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x306), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x307) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x282), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x283) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x284), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x285) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x286), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x287) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x288), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x289) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x290), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x291) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x292), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x293) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x294), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x295) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x296), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x297) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x298), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x299) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x36E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x36F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x300), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x301) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x302), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x303) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x304), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x305) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x306), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x307) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x308), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x309) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x310), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x311) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x312), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x313) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x314), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x315) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x316), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x317) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x318), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x319) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x320), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x321), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x322) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x323), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x324) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x325), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x326) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x327), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x328) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x329), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x330), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x331) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x332), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x333) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x334), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x335) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x336), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x337) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x338), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x339) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x340), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x341) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x342), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x343) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x344), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x345) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x346), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x347) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x348), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x349) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x350), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x351) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x352), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x353) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x354), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x355) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x356), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x357) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x358), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x359) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x360), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x361) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x362), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x363) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x364), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x365) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x366), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x367) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x368), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x369) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x370), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x371) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x372), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x373) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x374), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x375) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x376), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x377) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x378), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x379) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x431), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x432) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x380), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x381) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x382), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x383) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x384), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x385) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x386), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x387) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x388), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x389) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x390), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x391) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x392), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x393) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x394) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x395) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x396) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x397) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x398), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x399) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A5) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x33) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B4) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B5) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BC) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x35) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E4) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E5) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x400) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x401), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x402) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x403), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x404) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x405), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x406) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x407) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x408) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x409) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x410) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x411), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x412) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x413), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x414) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x415), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x416) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x417), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x418) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x419), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x420) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x421), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x422) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x423), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x424) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x425), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x426) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x429), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x430) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x433), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x434) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x435), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x436) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x437), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x438) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x439), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x440) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x442) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x443), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x444) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x445), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x446) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x447), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x448) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x36) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x450) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x451), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x452) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x453), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x454) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x455), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x456) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x457), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x458) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x459), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x460) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x461), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x462) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x463), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x464) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x465), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x466) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x467), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x468) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x469), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x470), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x471) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x37) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x472), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x473) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x474) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x38) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x475), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x476) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x477), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x478) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAD) },
    { ZYDIS_DEFINITION(0xE, 0x230), ZYDIS_DEFINITION(0xE, 0x231) },
    { ZYDIS_DEFINITION(0xD, 0x232), ZYDIS_DEFINITION(0xD, 0x233) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x39), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x40) },
    { ZYDIS_DEFINITION(0x1, 0x712), ZYDIS_DEFINITION(0x1, 0x713) },
    { ZYDIS_DEFINITION(0x1, 0x714), ZYDIS_DEFINITION(0x1, 0x715) },
    { ZYDIS_DEFINITION(0x1, 0x763), ZYDIS_DEFINITION(0x1, 0x764) },
    { ZYDIS_DEFINITION(0x1, 0x765), ZYDIS_DEFINITION(0x1, 0x766) },
    { ZYDIS_DEFINITION(0x1, 0x309), ZYDIS_DEFINITION(0x1, 0x30A) },
    { ZYDIS_DEFINITION(0x1, 0x30B), ZYDIS_DEFINITION(0x1, 0x30C) },
    { ZYDIS_DEFINITION(0x1, 0x30D), ZYDIS_DEFINITION(0x1, 0x30E) },
    { ZYDIS_DEFINITION(0x1, 0x30F), ZYDIS_DEFINITION(0x1, 0x310) },
    { ZYDIS_DEFINITION(0x1, 0x311), ZYDIS_DEFINITION(0x1, 0x312) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CB) },
    { ZYDIS_DEFINITION(0x1, 0x313), ZYDIS_DEFINITION(0x1, 0x314) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x42) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x479), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x480) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x481), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x482) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x483), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x484) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x485), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x486) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x487), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x488) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x489), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x490) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x491), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x492) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x493), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x494) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x495), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x496) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x497), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x498) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x499), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AE) },
    { ZYDIS_DEFINITION(0x1, 0x2), ZYDIS_DEFINITION(0x1, 0x3) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x18), ZYDIS_DEFINITION(0x1, 0x19) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0xE), ZYDIS_DEFINITION(0x1, 0xF) },
    { ZYDIS_DEFINITION(0x1, 0x16), ZYDIS_DEFINITION(0x1, 0x17) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x10), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x15), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F0) },
    { ZYDIS_DEFINITION(0xC, 0x0), ZYDIS_DEFINITION(0xC, 0x1) },
    { ZYDIS_DEFINITION(0xC, 0x11), ZYDIS_DEFINITION(0xC, 0x12) },
    { ZYDIS_DEFINITION(0xC, 0x13), ZYDIS_DEFINITION(0xC, 0x14) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x47), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x48) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x49), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD1) },
    { ZYDIS_DEFINITION(0x1, 0x37B), ZYDIS_DEFINITION(0x1, 0x37D) },
    { ZYDIS_DEFINITION(0x1, 0x37C), ZYDIS_DEFINITION(0x1, 0x37E) },
    { ZYDIS_DEFINITION(0x1, 0x37F), ZYDIS_DEFINITION(0x1, 0x381) },
    { ZYDIS_DEFINITION(0x1, 0x380), ZYDIS_DEFINITION(0x1, 0x382) },
    { ZYDIS_DEFINITION(0x1, 0x345), ZYDIS_DEFINITION(0x1, 0x34D) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34E) },
    { ZYDIS_DEFINITION(0x1, 0x667), ZYDIS_DEFINITION(0x1, 0x669) },
    { ZYDIS_DEFINITION(0x1, 0x668), ZYDIS_DEFINITION(0x1, 0x66A) },
    { ZYDIS_DEFINITION(0x1, 0x65F), ZYDIS_DEFINITION(0x1, 0x661) },
    { ZYDIS_DEFINITION(0x1, 0x660), ZYDIS_DEFINITION(0x1, 0x662) },
    { ZYDIS_DEFINITION(0x1, 0x34A), ZYDIS_DEFINITION(0x1, 0x348) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x349) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x565) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x55E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x55F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x560) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x564) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x561) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x562) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x563) },
    { ZYDIS_DEFINITION(0x1, 0x321), ZYDIS_DEFINITION(0x1, 0x323) },
    { ZYDIS_DEFINITION(0x1, 0x322), ZYDIS_DEFINITION(0x1, 0x324) },
    { ZYDIS_DEFINITION(0x1, 0x325), ZYDIS_DEFINITION(0x1, 0x327) },
    { ZYDIS_DEFINITION(0x1, 0x326), ZYDIS_DEFINITION(0x1, 0x328) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x359) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x35A) },
    { ZYDIS_DEFINITION(0x1, 0x659), ZYDIS_DEFINITION(0x1, 0x65A) },
    { ZYDIS_DEFINITION(0x1, 0x115), ZYDIS_DEFINITION(0x1, 0x116) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x500), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x501), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x502), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x503), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x504), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x505), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x351), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x352), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x63A), ZYDIS_DEFINITION(0x1, 0x63C) },
    { ZYDIS_DEFINITION(0x1, 0x63B), ZYDIS_DEFINITION(0x1, 0x63D) },
    { ZYDIS_DEFINITION(0x1, 0x628), ZYDIS_DEFINITION(0x1, 0x62A) },
    { ZYDIS_DEFINITION(0x1, 0x629), ZYDIS_DEFINITION(0x1, 0x62B) },
    { ZYDIS_DEFINITION(0x1, 0x616), ZYDIS_DEFINITION(0x1, 0x618) },
    { ZYDIS_DEFINITION(0x1, 0x617), ZYDIS_DEFINITION(0x1, 0x619) },
    { ZYDIS_DEFINITION(0x1, 0xE7), ZYDIS_DEFINITION(0x1, 0xE9) },
    { ZYDIS_DEFINITION(0x1, 0xE8), ZYDIS_DEFINITION(0x1, 0xEA) },
    { ZYDIS_DEFINITION(0x1, 0xDF), ZYDIS_DEFINITION(0x1, 0xE1) },
    { ZYDIS_DEFINITION(0x1, 0xE0), ZYDIS_DEFINITION(0x1, 0xE2) },
    { ZYDIS_DEFINITION(0x1, 0x397), ZYDIS_DEFINITION(0x1, 0x399) },
    { ZYDIS_DEFINITION(0x1, 0x398), ZYDIS_DEFINITION(0x1, 0x39A) },
    { ZYDIS_DEFINITION(0x1, 0x66F), ZYDIS_DEFINITION(0x1, 0x671) },
    { ZYDIS_DEFINITION(0x1, 0x670), ZYDIS_DEFINITION(0x1, 0x672) },
    { ZYDIS_DEFINITION(0x1, 0xB7), ZYDIS_DEFINITION(0x1, 0xB9) },
    { ZYDIS_DEFINITION(0x1, 0xB8), ZYDIS_DEFINITION(0x1, 0xBA) },
    { ZYDIS_DEFINITION(0x1, 0x38B), ZYDIS_DEFINITION(0x1, 0x38D) },
    { ZYDIS_DEFINITION(0x1, 0x38C), ZYDIS_DEFINITION(0x1, 0x38E) },
    { ZYDIS_DEFINITION(0x1, 0x13B), ZYDIS_DEFINITION(0x1, 0x13D) },
    { ZYDIS_DEFINITION(0x1, 0x13C), ZYDIS_DEFINITION(0x1, 0x13E) },
    { ZYDIS_DEFINITION(0x1, 0x11B), ZYDIS_DEFINITION(0x1, 0x11D) },
    { ZYDIS_DEFINITION(0x1, 0x11C), ZYDIS_DEFINITION(0x1, 0x11E) },
    { ZYDIS_DEFINITION(0x1, 0x647), ZYDIS_DEFINITION(0x1, 0x649) },
    { ZYDIS_DEFINITION(0x1, 0x648), ZYDIS_DEFINITION(0x1, 0x64A) },
    { ZYDIS_DEFINITION(0x1, 0x311), ZYDIS_DEFINITION(0x1, 0x313) },
    { ZYDIS_DEFINITION(0x1, 0x312), ZYDIS_DEFINITION(0x1, 0x314) },
    { ZYDIS_DEFINITION(0x1, 0x177), ZYDIS_DEFINITION(0x1, 0x179) },
    { ZYDIS_DEFINITION(0x1, 0x178), ZYDIS_DEFINITION(0x1, 0x17A) },
    { ZYDIS_DEFINITION(0x1, 0x305), ZYDIS_DEFINITION(0x1, 0x307) },
    { ZYDIS_DEFINITION(0x1, 0x306), ZYDIS_DEFINITION(0x1, 0x308) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x508), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x509) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x510), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x511), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x512), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x513), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x514), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x515), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F7) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x642) },
    { ZYDIS_DEFINITION(0xB, 0x10B), ZYDIS_DEFINITION(0xB, 0x10D) },
    { ZYDIS_DEFINITION(0xB, 0x10C), ZYDIS_DEFINITION(0xB, 0x10E) },
    { ZYDIS_DEFINITION(0xB, 0x632), ZYDIS_DEFINITION(0xB, 0x634) },
    { ZYDIS_DEFINITION(0xB, 0x633), ZYDIS_DEFINITION(0xB, 0x635) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x516), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x517) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x518) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x519) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x520) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x521), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x522) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x523), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x524) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x525), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x526) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x527), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x528) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x529) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52B) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52D) },
    { ZYDIS_DEFINITION(0x1, 0x12), ZYDIS_DEFINITION(0x1, 0x13) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0x373), ZYDIS_DEFINITION(0x1, 0x375) },
    { ZYDIS_DEFINITION(0x1, 0x374), ZYDIS_DEFINITION(0x1, 0x376) },
    { ZYDIS_DEFINITION(0x1, 0x377), ZYDIS_DEFINITION(0x1, 0x379) },
    { ZYDIS_DEFINITION(0x1, 0x378), ZYDIS_DEFINITION(0x1, 0x37A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34C) },
    { ZYDIS_DEFINITION(0x1, 0x663), ZYDIS_DEFINITION(0x1, 0x665) },
    { ZYDIS_DEFINITION(0x1, 0x664), ZYDIS_DEFINITION(0x1, 0x666) },
    { ZYDIS_DEFINITION(0x1, 0x65B), ZYDIS_DEFINITION(0x1, 0x65D) },
    { ZYDIS_DEFINITION(0x1, 0x65C), ZYDIS_DEFINITION(0x1, 0x65E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x346) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x347) },
    { ZYDIS_DEFINITION(0x1, 0x319), ZYDIS_DEFINITION(0x1, 0x31B) },
    { ZYDIS_DEFINITION(0x1, 0x31A), ZYDIS_DEFINITION(0x1, 0x31C) },
    { ZYDIS_DEFINITION(0x1, 0x31D), ZYDIS_DEFINITION(0x1, 0x31F) },
    { ZYDIS_DEFINITION(0x1, 0x31E), ZYDIS_DEFINITION(0x1, 0x320) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x357) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x358) },
    { ZYDIS_DEFINITION(0x1, 0x657), ZYDIS_DEFINITION(0x1, 0x658) },
    { ZYDIS_DEFINITION(0x1, 0x113), ZYDIS_DEFINITION(0x1, 0x114) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x530), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x531), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x532), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x533), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x534), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x535), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x34F), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x350), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x636), ZYDIS_DEFINITION(0x1, 0x638) },
    { ZYDIS_DEFINITION(0x1, 0x637), ZYDIS_DEFINITION(0x1, 0x639) },
    { ZYDIS_DEFINITION(0x1, 0xE3), ZYDIS_DEFINITION(0x1, 0xE5) },
    { ZYDIS_DEFINITION(0x1, 0xE4), ZYDIS_DEFINITION(0x1, 0xE6) },
    { ZYDIS_DEFINITION(0x1, 0xDB), ZYDIS_DEFINITION(0x1, 0xDD) },
    { ZYDIS_DEFINITION(0x1, 0xDC), ZYDIS_DEFINITION(0x1, 0xDE) },
    { ZYDIS_DEFINITION(0x1, 0x393), ZYDIS_DEFINITION(0x1, 0x395) },
    { ZYDIS_DEFINITION(0x1, 0x394), ZYDIS_DEFINITION(0x1, 0x396) },
    { ZYDIS_DEFINITION(0x1, 0x66B), ZYDIS_DEFINITION(0x1, 0x66D) },
    { ZYDIS_DEFINITION(0x1, 0x66C), ZYDIS_DEFINITION(0x1, 0x66E) },
    { ZYDIS_DEFINITION(0x1, 0xB3), ZYDIS_DEFINITION(0x1, 0xB5) },
    { ZYDIS_DEFINITION(0x1, 0xB4), ZYDIS_DEFINITION(0x1, 0xB6) },
    { ZYDIS_DEFINITION(0x1, 0x387), ZYDIS_DEFINITION(0x1, 0x389) },
    { ZYDIS_DEFINITION(0x1, 0x388), ZYDIS_DEFINITION(0x1, 0x38A) },
    { ZYDIS_DEFINITION(0x1, 0x12F), ZYDIS_DEFINITION(0x1, 0x131) },
    { ZYDIS_DEFINITION(0x1, 0x130), ZYDIS_DEFINITION(0x1, 0x132) },
    { ZYDIS_DEFINITION(0x1, 0x137), ZYDIS_DEFINITION(0x1, 0x139) },
    { ZYDIS_DEFINITION(0x1, 0x138), ZYDIS_DEFINITION(0x1, 0x13A) },
    { ZYDIS_DEFINITION(0x1, 0x643), ZYDIS_DEFINITION(0x1, 0x645) },
    { ZYDIS_DEFINITION(0x1, 0x644), ZYDIS_DEFINITION(0x1, 0x646) },
    { ZYDIS_DEFINITION(0x1, 0x30D), ZYDIS_DEFINITION(0x1, 0x30F) },
    { ZYDIS_DEFINITION(0x1, 0x30E), ZYDIS_DEFINITION(0x1, 0x310) },
    { ZYDIS_DEFINITION(0x1, 0x173), ZYDIS_DEFINITION(0x1, 0x175) },
    { ZYDIS_DEFINITION(0x1, 0x174), ZYDIS_DEFINITION(0x1, 0x176) },
    { ZYDIS_DEFINITION(0x1, 0x301), ZYDIS_DEFINITION(0x1, 0x303) },
    { ZYDIS_DEFINITION(0x1, 0x302), ZYDIS_DEFINITION(0x1, 0x304) },
    { ZYDIS_DEFINITION(0x1, 0x602), ZYDIS_DEFINITION(0x1, 0x604) },
    { ZYDIS_DEFINITION(0x1, 0x603), ZYDIS_DEFINITION(0x1, 0x605) },
    { ZYDIS_DEFINITION(0x1, 0x60E), ZYDIS_DEFINITION(0x1, 0x610) },
    { ZYDIS_DEFINITION(0x1, 0x60F), ZYDIS_DEFINITION(0x1, 0x611) },
    { ZYDIS_DEFINITION(0x1, 0x606), ZYDIS_DEFINITION(0x1, 0x608) },
    { ZYDIS_DEFINITION(0x1, 0x607), ZYDIS_DEFINITION(0x1, 0x609) },
    { ZYDIS_DEFINITION(0x1, 0x3AB), ZYDIS_DEFINITION(0x1, 0x3AD) },
    { ZYDIS_DEFINITION(0x1, 0x3AC), ZYDIS_DEFINITION(0x1, 0x3AE) },
    { ZYDIS_DEFINITION(0x1, 0x425), ZYDIS_DEFINITION(0x1, 0x427) },
    { ZYDIS_DEFINITION(0x1, 0x426), ZYDIS_DEFINITION(0x1, 0x428) },
    { ZYDIS_DEFINITION(0x1, 0x431), ZYDIS_DEFINITION(0x1, 0x433) },
    { ZYDIS_DEFINITION(0x1, 0x432), ZYDIS_DEFINITION(0x1, 0x434) },
    { ZYDIS_DEFINITION(0x1, 0x429), ZYDIS_DEFINITION(0x1, 0x42B) },
    { ZYDIS_DEFINITION(0x1, 0x42A), ZYDIS_DEFINITION(0x1, 0x42C) },
    { ZYDIS_DEFINITION(0x1, 0x3B3), ZYDIS_DEFINITION(0x1, 0x3B5) },
    { ZYDIS_DEFINITION(0x1, 0x3B4), ZYDIS_DEFINITION(0x1, 0x3B6) },
    { ZYDIS_DEFINITION(0x1, 0x5F2), ZYDIS_DEFINITION(0x1, 0x5F4) },
    { ZYDIS_DEFINITION(0x1, 0x5F3), ZYDIS_DEFINITION(0x1, 0x5F5) },
    { ZYDIS_DEFINITION(0x1, 0x5FE), ZYDIS_DEFINITION(0x1, 0x600) },
    { ZYDIS_DEFINITION(0x1, 0x5FF), ZYDIS_DEFINITION(0x1, 0x601) },
    { ZYDIS_DEFINITION(0x1, 0x5F6), ZYDIS_DEFINITION(0x1, 0x5F8) },
    { ZYDIS_DEFINITION(0x1, 0x5F7), ZYDIS_DEFINITION(0x1, 0x5F9) },
    { ZYDIS_DEFINITION(0x1, 0x3A7), ZYDIS_DEFINITION(0x1, 0x3A9) },
    { ZYDIS_DEFINITION(0x1, 0x3A8), ZYDIS_DEFINITION(0x1, 0x3AA) },
    { ZYDIS_DEFINITION(0x1, 0x60A), ZYDIS_DEFINITION(0x1, 0x60C) },
    { ZYDIS_DEFINITION(0x1, 0x60B), ZYDIS_DEFINITION(0x1, 0x60D) },
    { ZYDIS_DEFINITION(0x1, 0x5FA), ZYDIS_DEFINITION(0x1, 0x5FC) },
    { ZYDIS_DEFINITION(0x1, 0x5FB), ZYDIS_DEFINITION(0x1, 0x5FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x536), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x537) },
    { ZYDIS_DEFINITION(0x1, 0x32B), ZYDIS_DEFINITION(0x1, 0x32C) },
    { ZYDIS_DEFINITION(0x1, 0x335), ZYDIS_DEFINITION(0x1, 0x337) },
    { ZYDIS_DEFINITION(0x1, 0x336), ZYDIS_DEFINITION(0x1, 0x338) },
    { ZYDIS_DEFINITION(0xB, 0x56E), ZYDIS_DEFINITION(0xB, 0x570) },
    { ZYDIS_DEFINITION(0xB, 0x56F), ZYDIS_DEFINITION(0xB, 0x571) },
    { ZYDIS_DEFINITION(0xB, 0x5C8), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5C9), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5AC), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5AD), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x59C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x59D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5B2), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5B3), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5A2), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5A3), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x586), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x587), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5BA), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5BB), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5B8), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5B9), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x58E), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x58F), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x58C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x58D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x40B), ZYDIS_DEFINITION(0x1, 0x40D) },
    { ZYDIS_DEFINITION(0x1, 0x40C), ZYDIS_DEFINITION(0x1, 0x40E) },
    { ZYDIS_DEFINITION(0x1, 0x417), ZYDIS_DEFINITION(0x1, 0x419) },
    { ZYDIS_DEFINITION(0x1, 0x418), ZYDIS_DEFINITION(0x1, 0x41A) },
    { ZYDIS_DEFINITION(0x1, 0x40F), ZYDIS_DEFINITION(0x1, 0x411) },
    { ZYDIS_DEFINITION(0x1, 0x410), ZYDIS_DEFINITION(0x1, 0x412) },
    { ZYDIS_DEFINITION(0x1, 0x2DF), ZYDIS_DEFINITION(0x1, 0x2E1) },
    { ZYDIS_DEFINITION(0x1, 0x2E0), ZYDIS_DEFINITION(0x1, 0x2E2) },
    { ZYDIS_DEFINITION(0x1, 0x2E7), ZYDIS_DEFINITION(0x1, 0x2E9) },
    { ZYDIS_DEFINITION(0x1, 0x2E8), ZYDIS_DEFINITION(0x1, 0x2EA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x538), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x539) },
    { ZYDIS_DEFINITION(0x1, 0x32F), ZYDIS_DEFINITION(0x1, 0x330) },
    { ZYDIS_DEFINITION(0x1, 0x339), ZYDIS_DEFINITION(0x1, 0x33B) },
    { ZYDIS_DEFINITION(0x1, 0x33A), ZYDIS_DEFINITION(0x1, 0x33C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x540), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x107), ZYDIS_DEFINITION(0xB, 0x109) },
    { ZYDIS_DEFINITION(0xB, 0x108), ZYDIS_DEFINITION(0xB, 0x10A) },
    { ZYDIS_DEFINITION(0xB, 0x4C2), ZYDIS_DEFINITION(0xB, 0x4C3) },
    { ZYDIS_DEFINITION(0xB, 0x495), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x62E), ZYDIS_DEFINITION(0xB, 0x630) },
    { ZYDIS_DEFINITION(0xB, 0x62F), ZYDIS_DEFINITION(0xB, 0x631) },
    { ZYDIS_DEFINITION(0x1, 0xBF), ZYDIS_DEFINITION(0x1, 0xC1) },
    { ZYDIS_DEFINITION(0x1, 0xC0), ZYDIS_DEFINITION(0x1, 0xC2) },
    { ZYDIS_DEFINITION(0x1, 0x5CA), ZYDIS_DEFINITION(0x1, 0x5CC) },
    { ZYDIS_DEFINITION(0x1, 0x5CB), ZYDIS_DEFINITION(0x1, 0x5CD) },
    { ZYDIS_DEFINITION(0x1, 0x5B4), ZYDIS_DEFINITION(0x1, 0x5B6) },
    { ZYDIS_DEFINITION(0x1, 0x5B5), ZYDIS_DEFINITION(0x1, 0x5B7) },
    { ZYDIS_DEFINITION(0x1, 0x5BC), ZYDIS_DEFINITION(0x1, 0x5BE) },
    { ZYDIS_DEFINITION(0x1, 0x5BD), ZYDIS_DEFINITION(0x1, 0x5BF) },
    { ZYDIS_DEFINITION(0x1, 0x3BF), ZYDIS_DEFINITION(0x1, 0x3C1) },
    { ZYDIS_DEFINITION(0x1, 0x3C0), ZYDIS_DEFINITION(0x1, 0x3C2) },
    { ZYDIS_DEFINITION(0x1, 0x552), ZYDIS_DEFINITION(0x1, 0x554) },
    { ZYDIS_DEFINITION(0x1, 0x553), ZYDIS_DEFINITION(0x1, 0x555) },
    { ZYDIS_DEFINITION(0x1, 0x361), ZYDIS_DEFINITION(0x1, 0x362) },
    { ZYDIS_DEFINITION(0x1, 0x50C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x50D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5E2), ZYDIS_DEFINITION(0x1, 0x5E4) },
    { ZYDIS_DEFINITION(0x1, 0x5E3), ZYDIS_DEFINITION(0x1, 0x5E5) },
    { ZYDIS_DEFINITION(0x1, 0x5E6), ZYDIS_DEFINITION(0x1, 0x5E8) },
    { ZYDIS_DEFINITION(0x1, 0x5E7), ZYDIS_DEFINITION(0x1, 0x5E9) },
    { ZYDIS_DEFINITION(0x1, 0x500), ZYDIS_DEFINITION(0x1, 0x502) },
    { ZYDIS_DEFINITION(0x1, 0x501), ZYDIS_DEFINITION(0x1, 0x503) },
    { ZYDIS_DEFINITION(0x1, 0x3DB), ZYDIS_DEFINITION(0x1, 0x3DD) },
    { ZYDIS_DEFINITION(0x1, 0x3DC), ZYDIS_DEFINITION(0x1, 0x3DE) },
    { ZYDIS_DEFINITION(0x1, 0x3CB), ZYDIS_DEFINITION(0x1, 0x3CD) },
    { ZYDIS_DEFINITION(0x1, 0x3CC), ZYDIS_DEFINITION(0x1, 0x3CE) },
    { ZYDIS_DEFINITION(0x1, 0x3CF), ZYDIS_DEFINITION(0x1, 0x3D1) },
    { ZYDIS_DEFINITION(0x1, 0x3D0), ZYDIS_DEFINITION(0x1, 0x3D2) },
    { ZYDIS_DEFINITION(0x1, 0x4E8), ZYDIS_DEFINITION(0x1, 0x4EA) },
    { ZYDIS_DEFINITION(0x1, 0x4E9), ZYDIS_DEFINITION(0x1, 0x4EB) },
    { ZYDIS_DEFINITION(0x1, 0x3DF), ZYDIS_DEFINITION(0x1, 0x3E1) },
    { ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E2) },
    { ZYDIS_DEFINITION(0x1, 0x3E3), ZYDIS_DEFINITION(0x1, 0x3E5) },
    { ZYDIS_DEFINITION(0x1, 0x3E4), ZYDIS_DEFINITION(0x1, 0x3E6) },
    { ZYDIS_DEFINITION(0x1, 0x5AE), ZYDIS_DEFINITION(0x1, 0x5B0) },
    { ZYDIS_DEFINITION(0x1, 0x5AF), ZYDIS_DEFINITION(0x1, 0x5B1) },
    { ZYDIS_DEFINITION(0x1, 0x5A4), ZYDIS_DEFINITION(0x1, 0x5A6) },
    { ZYDIS_DEFINITION(0x1, 0x5A5), ZYDIS_DEFINITION(0x1, 0x5A7) },
    { ZYDIS_DEFINITION(0x1, 0x3E7), ZYDIS_DEFINITION(0x1, 0x3E9) },
    { ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3EA) },
    { ZYDIS_DEFINITION(0x1, 0x546), ZYDIS_DEFINITION(0x1, 0x548) },
    { ZYDIS_DEFINITION(0x1, 0x547), ZYDIS_DEFINITION(0x1, 0x549) },
    { ZYDIS_DEFINITION(0x1, 0x54A), ZYDIS_DEFINITION(0x1, 0x54C) },
    { ZYDIS_DEFINITION(0x1, 0x54B), ZYDIS_DEFINITION(0x1, 0x54D) },
    { ZYDIS_DEFINITION(0x1, 0x15F), ZYDIS_DEFINITION(0x1, 0x161) },
    { ZYDIS_DEFINITION(0x1, 0x160), ZYDIS_DEFINITION(0x1, 0x162) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x353) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x354) },
    { ZYDIS_DEFINITION(0x1, 0x5DA), ZYDIS_DEFINITION(0x1, 0x5DC) },
    { ZYDIS_DEFINITION(0x1, 0x5DB), ZYDIS_DEFINITION(0x1, 0x5DD) },
    { ZYDIS_DEFINITION(0x1, 0x5DE), ZYDIS_DEFINITION(0x1, 0x5E0) },
    { ZYDIS_DEFINITION(0x1, 0x5DF), ZYDIS_DEFINITION(0x1, 0x5E1) },
    { ZYDIS_DEFINITION(0x1, 0x4FC), ZYDIS_DEFINITION(0x1, 0x4FE) },
    { ZYDIS_DEFINITION(0x1, 0x4FD), ZYDIS_DEFINITION(0x1, 0x4FF) },
    { ZYDIS_DEFINITION(0x1, 0x55A), ZYDIS_DEFINITION(0x1, 0x55C) },
    { ZYDIS_DEFINITION(0x1, 0x55B), ZYDIS_DEFINITION(0x1, 0x55D) },
    { ZYDIS_DEFINITION(0x1, 0x3C3), ZYDIS_DEFINITION(0x1, 0x3C5) },
    { ZYDIS_DEFINITION(0x1, 0x3C4), ZYDIS_DEFINITION(0x1, 0x3C6) },
    { ZYDIS_DEFINITION(0x1, 0x3C7), ZYDIS_DEFINITION(0x1, 0x3C9) },
    { ZYDIS_DEFINITION(0x1, 0x3C8), ZYDIS_DEFINITION(0x1, 0x3CA) },
    { ZYDIS_DEFINITION(0x1, 0x4E4), ZYDIS_DEFINITION(0x1, 0x4E6) },
    { ZYDIS_DEFINITION(0x1, 0x4E5), ZYDIS_DEFINITION(0x1, 0x4E7) },
    { ZYDIS_DEFINITION(0x1, 0x612), ZYDIS_DEFINITION(0x1, 0x614) },
    { ZYDIS_DEFINITION(0x1, 0x613), ZYDIS_DEFINITION(0x1, 0x615) },
    { ZYDIS_DEFINITION(0x1, 0x59E), ZYDIS_DEFINITION(0x1, 0x5A0) },
    { ZYDIS_DEFINITION(0x1, 0x59F), ZYDIS_DEFINITION(0x1, 0x5A1) },
    { ZYDIS_DEFINITION(0x1, 0x588), ZYDIS_DEFINITION(0x1, 0x58A) },
    { ZYDIS_DEFINITION(0x1, 0x589), ZYDIS_DEFINITION(0x1, 0x58B) },
    { ZYDIS_DEFINITION(0x1, 0x590), ZYDIS_DEFINITION(0x1, 0x592) },
    { ZYDIS_DEFINITION(0x1, 0x591), ZYDIS_DEFINITION(0x1, 0x593) },
    { ZYDIS_DEFINITION(0x1, 0x556), ZYDIS_DEFINITION(0x1, 0x558) },
    { ZYDIS_DEFINITION(0x1, 0x557), ZYDIS_DEFINITION(0x1, 0x559) },
    { ZYDIS_DEFINITION(0x1, 0x4D0), ZYDIS_DEFINITION(0x1, 0x4D2) },
    { ZYDIS_DEFINITION(0x1, 0x4D1), ZYDIS_DEFINITION(0x1, 0x4D3) },
    { ZYDIS_DEFINITION(0x1, 0x566), ZYDIS_DEFINITION(0x1, 0x568) },
    { ZYDIS_DEFINITION(0x1, 0x567), ZYDIS_DEFINITION(0x1, 0x569) },
    { ZYDIS_DEFINITION(0x1, 0x2F8), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5CE), ZYDIS_DEFINITION(0x1, 0x5D0) },
    { ZYDIS_DEFINITION(0x1, 0x5CF), ZYDIS_DEFINITION(0x1, 0x5D1) },
    { ZYDIS_DEFINITION(0x1, 0x5EA), ZYDIS_DEFINITION(0x1, 0x5EC) },
    { ZYDIS_DEFINITION(0x1, 0x5EB), ZYDIS_DEFINITION(0x1, 0x5ED) },
    { ZYDIS_DEFINITION(0x1, 0x5D2), ZYDIS_DEFINITION(0x1, 0x5D4) },
    { ZYDIS_DEFINITION(0x1, 0x5D3), ZYDIS_DEFINITION(0x1, 0x5D5) },
    { ZYDIS_DEFINITION(0x1, 0x5D6), ZYDIS_DEFINITION(0x1, 0x5D8) },
    { ZYDIS_DEFINITION(0x1, 0x5D7), ZYDIS_DEFINITION(0x1, 0x5D9) },
    { ZYDIS_DEFINITION(0x1, 0x3B7), ZYDIS_DEFINITION(0x1, 0x3B9) },
    { ZYDIS_DEFINITION(0x1, 0x3B8), ZYDIS_DEFINITION(0x1, 0x3BA) },
    { ZYDIS_DEFINITION(0x1, 0x3D3), ZYDIS_DEFINITION(0x1, 0x3D5) },
    { ZYDIS_DEFINITION(0x1, 0x3D4), ZYDIS_DEFINITION(0x1, 0x3D6) },
    { ZYDIS_DEFINITION(0x1, 0x3BB), ZYDIS_DEFINITION(0x1, 0x3BD) },
    { ZYDIS_DEFINITION(0x1, 0x3BC), ZYDIS_DEFINITION(0x1, 0x3BE) },
    { ZYDIS_DEFINITION(0x1, 0x56A), ZYDIS_DEFINITION(0x1, 0x56C) },
    { ZYDIS_DEFINITION(0x1, 0x56B), ZYDIS_DEFINITION(0x1, 0x56D) },
    { ZYDIS_DEFINITION(0x1, 0x4A8), ZYDIS_DEFINITION(0x1, 0x4AA) },
    { ZYDIS_DEFINITION(0x1, 0x4A9), ZYDIS_DEFINITION(0x1, 0x4AB) },
    { ZYDIS_DEFINITION(0x1, 0x4A0), ZYDIS_DEFINITION(0x1, 0x4A2) },
    { ZYDIS_DEFINITION(0x1, 0x4A1), ZYDIS_DEFINITION(0x1, 0x4A3) },
    { ZYDIS_DEFINITION(0x1, 0x4A4), ZYDIS_DEFINITION(0x1, 0x4A6) },
    { ZYDIS_DEFINITION(0x1, 0x4A5), ZYDIS_DEFINITION(0x1, 0x4A7) },
    { ZYDIS_DEFINITION(0x1, 0x4CC), ZYDIS_DEFINITION(0x1, 0x4CE) },
    { ZYDIS_DEFINITION(0x1, 0x4CD), ZYDIS_DEFINITION(0x1, 0x4CF) },
    { ZYDIS_DEFINITION(0x1, 0x4B6), ZYDIS_DEFINITION(0x1, 0x4B8) },
    { ZYDIS_DEFINITION(0x1, 0x4B7), ZYDIS_DEFINITION(0x1, 0x4B9) },
    { ZYDIS_DEFINITION(0x1, 0x4AE), ZYDIS_DEFINITION(0x1, 0x4B0) },
    { ZYDIS_DEFINITION(0x1, 0x4AF), ZYDIS_DEFINITION(0x1, 0x4B1) },
    { ZYDIS_DEFINITION(0x1, 0x4B2), ZYDIS_DEFINITION(0x1, 0x4B4) },
    { ZYDIS_DEFINITION(0x1, 0x4B3), ZYDIS_DEFINITION(0x1, 0x4B5) },
    { ZYDIS_DEFINITION(0x1, 0x57A), ZYDIS_DEFINITION(0x1, 0x57C) },
    { ZYDIS_DEFINITION(0x1, 0x57B), ZYDIS_DEFINITION(0x1, 0x57D) },
    { ZYDIS_DEFINITION(0x1, 0x582), ZYDIS_DEFINITION(0x1, 0x584) },
    { ZYDIS_DEFINITION(0x1, 0x583), ZYDIS_DEFINITION(0x1, 0x585) },
    { ZYDIS_DEFINITION(0x1, 0x57E), ZYDIS_DEFINITION(0x1, 0x580) },
    { ZYDIS_DEFINITION(0x1, 0x57F), ZYDIS_DEFINITION(0x1, 0x581) },
    { ZYDIS_DEFINITION(0x1, 0x542), ZYDIS_DEFINITION(0x1, 0x544) },
    { ZYDIS_DEFINITION(0x1, 0x543), ZYDIS_DEFINITION(0x1, 0x545) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x541), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x542) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x543), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x544) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x545), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x546) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x547), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x548) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x549), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x550) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x551), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x552) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x553), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x554) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x555), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x556) },
    { ZYDIS_DEFINITION(0x1, 0x5EE), ZYDIS_DEFINITION(0x1, 0x5F0) },
    { ZYDIS_DEFINITION(0x1, 0x5EF), ZYDIS_DEFINITION(0x1, 0x5F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x557), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x558) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x559), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55D) },
    { ZYDIS_DEFINITION(0x1, 0x39B), ZYDIS_DEFINITION(0x1, 0x39D) },
    { ZYDIS_DEFINITION(0x1, 0x39C), ZYDIS_DEFINITION(0x1, 0x39E) },
    { ZYDIS_DEFINITION(0x1, 0x3A3), ZYDIS_DEFINITION(0x1, 0x3A5) },
    { ZYDIS_DEFINITION(0x1, 0x3A4), ZYDIS_DEFINITION(0x1, 0x3A6) },
    { ZYDIS_DEFINITION(0x1, 0x39F), ZYDIS_DEFINITION(0x1, 0x3A1) },
    { ZYDIS_DEFINITION(0x1, 0x3A0), ZYDIS_DEFINITION(0x1, 0x3A2) },
    { ZYDIS_DEFINITION(0x1, 0x516), ZYDIS_DEFINITION(0x1, 0x518) },
    { ZYDIS_DEFINITION(0x1, 0x517), ZYDIS_DEFINITION(0x1, 0x519) },
    { ZYDIS_DEFINITION(0x1, 0x50E), ZYDIS_DEFINITION(0x1, 0x510) },
    { ZYDIS_DEFINITION(0x1, 0x50F), ZYDIS_DEFINITION(0x1, 0x511) },
    { ZYDIS_DEFINITION(0x1, 0x512), ZYDIS_DEFINITION(0x1, 0x514) },
    { ZYDIS_DEFINITION(0x1, 0x513), ZYDIS_DEFINITION(0x1, 0x515) },
    { ZYDIS_DEFINITION(0x1, 0x51E), ZYDIS_DEFINITION(0x1, 0x520) },
    { ZYDIS_DEFINITION(0x1, 0x51F), ZYDIS_DEFINITION(0x1, 0x521) },
    { ZYDIS_DEFINITION(0x1, 0x522), ZYDIS_DEFINITION(0x1, 0x524) },
    { ZYDIS_DEFINITION(0x1, 0x523), ZYDIS_DEFINITION(0x1, 0x525) },
    { ZYDIS_DEFINITION(0x1, 0x51A), ZYDIS_DEFINITION(0x1, 0x51C) },
    { ZYDIS_DEFINITION(0x1, 0x51B), ZYDIS_DEFINITION(0x1, 0x51D) },
    { ZYDIS_DEFINITION(0x1, 0x53E), ZYDIS_DEFINITION(0x1, 0x540) },
    { ZYDIS_DEFINITION(0x1, 0x53F), ZYDIS_DEFINITION(0x1, 0x541) },
    { ZYDIS_DEFINITION(0x1, 0x413), ZYDIS_DEFINITION(0x1, 0x415) },
    { ZYDIS_DEFINITION(0x1, 0x414), ZYDIS_DEFINITION(0x1, 0x416) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x355) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x356) },
    { ZYDIS_DEFINITION(0x1, 0x3AF), ZYDIS_DEFINITION(0x1, 0x3B1) },
    { ZYDIS_DEFINITION(0x1, 0x3B0), ZYDIS_DEFINITION(0x1, 0x3B2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x560) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x561) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x562) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x563) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x564) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x565) },
    { ZYDIS_DEFINITION(0x1, 0x52E), ZYDIS_DEFINITION(0x1, 0x530) },
    { ZYDIS_DEFINITION(0x1, 0x52F), ZYDIS_DEFINITION(0x1, 0x531) },
    { ZYDIS_DEFINITION(0x1, 0x526), ZYDIS_DEFINITION(0x1, 0x528) },
    { ZYDIS_DEFINITION(0x1, 0x527), ZYDIS_DEFINITION(0x1, 0x529) },
    { ZYDIS_DEFINITION(0x1, 0x52A), ZYDIS_DEFINITION(0x1, 0x52C) },
    { ZYDIS_DEFINITION(0x1, 0x52B), ZYDIS_DEFINITION(0x1, 0x52D) },
    { ZYDIS_DEFINITION(0x1, 0x536), ZYDIS_DEFINITION(0x1, 0x538) },
    { ZYDIS_DEFINITION(0x1, 0x537), ZYDIS_DEFINITION(0x1, 0x539) },
    { ZYDIS_DEFINITION(0x1, 0x53A), ZYDIS_DEFINITION(0x1, 0x53C) },
    { ZYDIS_DEFINITION(0x1, 0x53B), ZYDIS_DEFINITION(0x1, 0x53D) },
    { ZYDIS_DEFINITION(0x1, 0x532), ZYDIS_DEFINITION(0x1, 0x534) },
    { ZYDIS_DEFINITION(0x1, 0x533), ZYDIS_DEFINITION(0x1, 0x535) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x566), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x567) },
    { ZYDIS_DEFINITION(0x1, 0x42D), ZYDIS_DEFINITION(0x1, 0x42F) },
    { ZYDIS_DEFINITION(0x1, 0x42E), ZYDIS_DEFINITION(0x1, 0x430) },
    { ZYDIS_DEFINITION(0x1, 0x4F4), ZYDIS_DEFINITION(0x1, 0x4F6) },
    { ZYDIS_DEFINITION(0x1, 0x4F5), ZYDIS_DEFINITION(0x1, 0x4F7) },
    { ZYDIS_DEFINITION(0x1, 0x4F8), ZYDIS_DEFINITION(0x1, 0x4FA) },
    { ZYDIS_DEFINITION(0x1, 0x4F9), ZYDIS_DEFINITION(0x1, 0x4FB) },
    { ZYDIS_DEFINITION(0x1, 0x508), ZYDIS_DEFINITION(0x1, 0x50A) },
    { ZYDIS_DEFINITION(0x1, 0x509), ZYDIS_DEFINITION(0x1, 0x50B) },
    { ZYDIS_DEFINITION(0x1, 0x504), ZYDIS_DEFINITION(0x1, 0x506) },
    { ZYDIS_DEFINITION(0x1, 0x505), ZYDIS_DEFINITION(0x1, 0x507) },
    { ZYDIS_DEFINITION(0x1, 0x4DC), ZYDIS_DEFINITION(0x1, 0x4DE) },
    { ZYDIS_DEFINITION(0x1, 0x4DD), ZYDIS_DEFINITION(0x1, 0x4DF) },
    { ZYDIS_DEFINITION(0x1, 0x4E0), ZYDIS_DEFINITION(0x1, 0x4E2) },
    { ZYDIS_DEFINITION(0x1, 0x4E1), ZYDIS_DEFINITION(0x1, 0x4E3) },
    { ZYDIS_DEFINITION(0x1, 0x4F0), ZYDIS_DEFINITION(0x1, 0x4F2) },
    { ZYDIS_DEFINITION(0x1, 0x4F1), ZYDIS_DEFINITION(0x1, 0x4F3) },
    { ZYDIS_DEFINITION(0x1, 0x4EC), ZYDIS_DEFINITION(0x1, 0x4EE) },
    { ZYDIS_DEFINITION(0x1, 0x4ED), ZYDIS_DEFINITION(0x1, 0x4EF) },
    { ZYDIS_DEFINITION(0x1, 0x54E), ZYDIS_DEFINITION(0x1, 0x550) },
    { ZYDIS_DEFINITION(0x1, 0x54F), ZYDIS_DEFINITION(0x1, 0x551) },
    { ZYDIS_DEFINITION(0x1, 0x4AC), ZYDIS_DEFINITION(0x1, 0x4AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x568), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x569) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x570), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x571) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x572), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x573) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x574) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x575) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x576), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x577) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x578), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x579) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x580), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x581) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x582), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x583) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x584), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x585) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x586), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x587) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x588), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x589) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x590), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x591) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x592), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x593) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x594), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x595) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x596), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x597) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x598) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x599) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E4) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E5) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x600), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x601) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x602), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x603) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x604), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x605) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x606), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x607) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x608), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x609) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x610), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x611) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x612), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x613) },
    { ZYDIS_DEFINITION(0x1, 0xD7), ZYDIS_DEFINITION(0x1, 0xD8) },
    { ZYDIS_DEFINITION(0x1, 0xCF), ZYDIS_DEFINITION(0x1, 0xD1) },
    { ZYDIS_DEFINITION(0x1, 0xD0), ZYDIS_DEFINITION(0x1, 0xD2) },
    { ZYDIS_DEFINITION(0x1, 0xD3), ZYDIS_DEFINITION(0x1, 0xD5) },
    { ZYDIS_DEFINITION(0x1, 0xD4), ZYDIS_DEFINITION(0x1, 0xD6) },
    { ZYDIS_DEFINITION(0x1, 0xC7), ZYDIS_DEFINITION(0x1, 0xC9) },
    { ZYDIS_DEFINITION(0x1, 0xC8), ZYDIS_DEFINITION(0x1, 0xCA) },
    { ZYDIS_DEFINITION(0x1, 0xCB), ZYDIS_DEFINITION(0x1, 0xCD) },
    { ZYDIS_DEFINITION(0x1, 0xCC), ZYDIS_DEFINITION(0x1, 0xCE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x614), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x615) },
    { ZYDIS_DEFINITION(0x1, 0x99), ZYDIS_DEFINITION(0x1, 0x9A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x616), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x617) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x618), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x619) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x620), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x621) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x622), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x623) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x624), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x625) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x626), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x627) },
    { ZYDIS_DEFINITION(0xB, 0x620), ZYDIS_DEFINITION(0xB, 0x622) },
    { ZYDIS_DEFINITION(0xB, 0x621), ZYDIS_DEFINITION(0xB, 0x623) },
    { ZYDIS_DEFINITION(0xB, 0x61C), ZYDIS_DEFINITION(0xB, 0x61E) },
    { ZYDIS_DEFINITION(0xB, 0x61D), ZYDIS_DEFINITION(0xB, 0x61F) },
    { ZYDIS_DEFINITION(0xB, 0x626), ZYDIS_DEFINITION(0xB, 0x627) },
    { ZYDIS_DEFINITION(0xB, 0x624), ZYDIS_DEFINITION(0xB, 0x625) },
    { ZYDIS_DEFINITION(0xB, 0xF3), ZYDIS_DEFINITION(0xB, 0xF5) },
    { ZYDIS_DEFINITION(0xB, 0xF4), ZYDIS_DEFINITION(0xB, 0xF6) },
    { ZYDIS_DEFINITION(0xB, 0xEF), ZYDIS_DEFINITION(0xB, 0xF1) },
    { ZYDIS_DEFINITION(0xB, 0xF0), ZYDIS_DEFINITION(0xB, 0xF2) },
    { ZYDIS_DEFINITION(0xB, 0x3F3), ZYDIS_DEFINITION(0xB, 0x3F5) },
    { ZYDIS_DEFINITION(0xB, 0x3F4), ZYDIS_DEFINITION(0xB, 0x3F6) },
    { ZYDIS_DEFINITION(0xB, 0x3D7), ZYDIS_DEFINITION(0xB, 0x3D9) },
    { ZYDIS_DEFINITION(0xB, 0x3D8), ZYDIS_DEFINITION(0xB, 0x3DA) },
    { ZYDIS_DEFINITION(0xB, 0x48D), ZYDIS_DEFINITION(0xB, 0x48E) },
    { ZYDIS_DEFINITION(0xB, 0x496), ZYDIS_DEFINITION(0xB, 0x497) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x628), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x629) },
    { ZYDIS_DEFINITION(0xB, 0x491), ZYDIS_DEFINITION(0xB, 0x492) },
    { ZYDIS_DEFINITION(0xB, 0x189), ZYDIS_DEFINITION(0xB, 0x18A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x630), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x631) },
    { ZYDIS_DEFINITION(0xB, 0x4BA), ZYDIS_DEFINITION(0xB, 0x4BB) },
    { ZYDIS_DEFINITION(0xB, 0x2F3), ZYDIS_DEFINITION(0xB, 0x2F4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x632), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x633) },
    { ZYDIS_DEFINITION(0xB, 0x4BE), ZYDIS_DEFINITION(0xB, 0x4BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x634), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x635), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x636), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x637), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x638), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x639) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x181), ZYDIS_DEFINITION(0xB, 0x183) },
    { ZYDIS_DEFINITION(0xB, 0x182), ZYDIS_DEFINITION(0xB, 0x184) },
    { ZYDIS_DEFINITION(0xB, 0x17F), ZYDIS_DEFINITION(0xB, 0x180) },
    { ZYDIS_DEFINITION(0xB, 0x383), ZYDIS_DEFINITION(0xB, 0x385) },
    { ZYDIS_DEFINITION(0xB, 0x384), ZYDIS_DEFINITION(0xB, 0x386) },
    { ZYDIS_DEFINITION(0xB, 0x407), ZYDIS_DEFINITION(0xB, 0x409) },
    { ZYDIS_DEFINITION(0xB, 0x408), ZYDIS_DEFINITION(0xB, 0x40A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x640) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x641), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x642) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x643), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x644) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x645), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x646) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x647), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x648) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x649), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x650) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x651), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x652) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x653), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x654) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x655), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x656) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x657), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x658) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x659), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x660) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x661), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x662) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x663), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x664) },
    { ZYDIS_DEFINITION(0xB, 0x423), ZYDIS_DEFINITION(0xB, 0x424) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x665), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x666) },
    { ZYDIS_DEFINITION(0xB, 0x437), ZYDIS_DEFINITION(0xB, 0x438) },
    { ZYDIS_DEFINITION(0xB, 0x435), ZYDIS_DEFINITION(0xB, 0x436) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x667), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x668) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x669), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x670) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x671), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x672) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x673), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x674) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x675), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x676) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x677), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x678) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x679), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x680) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x681), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x682) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x683), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x684) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x685), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x686) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x687), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x688) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x689), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x690) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x691), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x692) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x693), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x694) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x695), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x696) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x697), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x698) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x699), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69E) },
    { ZYDIS_DEFINITION(0xB, 0xD9), ZYDIS_DEFINITION(0xB, 0xDA) },
    { ZYDIS_DEFINITION(0x1, 0x36F), ZYDIS_DEFINITION(0x1, 0x370) },
    { ZYDIS_DEFINITION(0x1, 0x371), ZYDIS_DEFINITION(0x1, 0x372) },
    { ZYDIS_DEFINITION(0x1, 0x36B), ZYDIS_DEFINITION(0x1, 0x36D) },
    { ZYDIS_DEFINITION(0x1, 0x36C), ZYDIS_DEFINITION(0x1, 0x36E) },
    { ZYDIS_DEFINITION(0x1, 0x367), ZYDIS_DEFINITION(0x1, 0x369) },
    { ZYDIS_DEFINITION(0x1, 0x368), ZYDIS_DEFINITION(0x1, 0x36A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A0) },
    { ZYDIS_DEFINITION(0x1, 0x155), ZYDIS_DEFINITION(0x1, 0x156) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A2) },
    { ZYDIS_DEFINITION(0x1, 0x171), ZYDIS_DEFINITION(0x1, 0x172) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A4) },
    { ZYDIS_DEFINITION(0x1, 0x15D), ZYDIS_DEFINITION(0x1, 0x15E) },
    { ZYDIS_DEFINITION(0x1, 0x640), ZYDIS_DEFINITION(0x1, 0x641) },
    { ZYDIS_DEFINITION(0x1, 0x62C), ZYDIS_DEFINITION(0x1, 0x62D) },
    { ZYDIS_DEFINITION(0x1, 0x61A), ZYDIS_DEFINITION(0x1, 0x61B) },
    { ZYDIS_DEFINITION(0x1, 0xBD), ZYDIS_DEFINITION(0x1, 0xBE) },
    { ZYDIS_DEFINITION(0x1, 0x391), ZYDIS_DEFINITION(0x1, 0x392) },
    { ZYDIS_DEFINITION(0x1, 0x157), ZYDIS_DEFINITION(0x1, 0x158) },
    { ZYDIS_DEFINITION(0x1, 0x163), ZYDIS_DEFINITION(0x1, 0x165) },
    { ZYDIS_DEFINITION(0x1, 0x164), ZYDIS_DEFINITION(0x1, 0x166) },
    { ZYDIS_DEFINITION(0x1, 0x64D), ZYDIS_DEFINITION(0x1, 0x64E) },
    { ZYDIS_DEFINITION(0x1, 0x317), ZYDIS_DEFINITION(0x1, 0x318) },
    { ZYDIS_DEFINITION(0x1, 0x17D), ZYDIS_DEFINITION(0x1, 0x17E) },
    { ZYDIS_DEFINITION(0x1, 0x30B), ZYDIS_DEFINITION(0x1, 0x30C) },
    { ZYDIS_DEFINITION(0x1, 0x33D), ZYDIS_DEFINITION(0x1, 0x33F) },
    { ZYDIS_DEFINITION(0x1, 0x33E), ZYDIS_DEFINITION(0x1, 0x340) },
    { ZYDIS_DEFINITION(0xB, 0x572), ZYDIS_DEFINITION(0xB, 0x574) },
    { ZYDIS_DEFINITION(0xB, 0x573), ZYDIS_DEFINITION(0xB, 0x575) },
    { ZYDIS_DEFINITION(0x1, 0x35F), ZYDIS_DEFINITION(0x1, 0x360) },
    { ZYDIS_DEFINITION(0x1, 0x341), ZYDIS_DEFINITION(0x1, 0x343) },
    { ZYDIS_DEFINITION(0x1, 0x342), ZYDIS_DEFINITION(0x1, 0x344) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A5), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x15) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A8), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x111), ZYDIS_DEFINITION(0xB, 0x112) },
    { ZYDIS_DEFINITION(0x1, 0x117), ZYDIS_DEFINITION(0x1, 0x119) },
    { ZYDIS_DEFINITION(0x1, 0x118), ZYDIS_DEFINITION(0x1, 0x11A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B8) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B9) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6BA) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6BD) },
    { ZYDIS_DEFINITION(0x1, 0x85), ZYDIS_DEFINITION(0x1, 0x86) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6BF) },
    { ZYDIS_DEFINITION(0x1, 0x93), ZYDIS_DEFINITION(0x1, 0x94) },
    { ZYDIS_DEFINITION(0x1, 0x363), ZYDIS_DEFINITION(0x1, 0x364) },
    { ZYDIS_DEFINITION(0x1, 0x365), ZYDIS_DEFINITION(0x1, 0x366) },
    { ZYDIS_DEFINITION(0x1, 0x331), ZYDIS_DEFINITION(0x1, 0x333) },
    { ZYDIS_DEFINITION(0x1, 0x332), ZYDIS_DEFINITION(0x1, 0x334) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C1) },
    { ZYDIS_DEFINITION(0x1, 0x14F), ZYDIS_DEFINITION(0x1, 0x150) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C3) },
    { ZYDIS_DEFINITION(0x1, 0x16B), ZYDIS_DEFINITION(0x1, 0x16C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C5) },
    { ZYDIS_DEFINITION(0x1, 0x147), ZYDIS_DEFINITION(0x1, 0x148) },
    { ZYDIS_DEFINITION(0x1, 0x63E), ZYDIS_DEFINITION(0x1, 0x63F) },
    { ZYDIS_DEFINITION(0x1, 0xBB), ZYDIS_DEFINITION(0x1, 0xBC) },
    { ZYDIS_DEFINITION(0x1, 0x38F), ZYDIS_DEFINITION(0x1, 0x390) },
    { ZYDIS_DEFINITION(0x1, 0x149), ZYDIS_DEFINITION(0x1, 0x14A) },
    { ZYDIS_DEFINITION(0x1, 0x64B), ZYDIS_DEFINITION(0x1, 0x64C) },
    { ZYDIS_DEFINITION(0x1, 0x315), ZYDIS_DEFINITION(0x1, 0x316) },
    { ZYDIS_DEFINITION(0x1, 0x17B), ZYDIS_DEFINITION(0x1, 0x17C) },
    { ZYDIS_DEFINITION(0x1, 0x309), ZYDIS_DEFINITION(0x1, 0x30A) },
    { ZYDIS_DEFINITION(0xB, 0x576), ZYDIS_DEFINITION(0xB, 0x578) },
    { ZYDIS_DEFINITION(0xB, 0x577), ZYDIS_DEFINITION(0xB, 0x579) },
    { ZYDIS_DEFINITION(0x1, 0x2E3), ZYDIS_DEFINITION(0x1, 0x2E5) },
    { ZYDIS_DEFINITION(0x1, 0x2E4), ZYDIS_DEFINITION(0x1, 0x2E6) },
    { ZYDIS_DEFINITION(0x1, 0x2EB), ZYDIS_DEFINITION(0x1, 0x2ED) },
    { ZYDIS_DEFINITION(0x1, 0x2EC), ZYDIS_DEFINITION(0x1, 0x2EE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C6), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C7), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C8), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x14) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C9), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x10F), ZYDIS_DEFINITION(0xB, 0x110) },
    { ZYDIS_DEFINITION(0x1, 0xC3), ZYDIS_DEFINITION(0x1, 0xC5) },
    { ZYDIS_DEFINITION(0x1, 0xC4), ZYDIS_DEFINITION(0x1, 0xC6) },
    { ZYDIS_DEFINITION(0x1, 0x12B), ZYDIS_DEFINITION(0x1, 0x12D) },
    { ZYDIS_DEFINITION(0x1, 0x12C), ZYDIS_DEFINITION(0x1, 0x12E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F5) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6CA), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6CF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D5), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D9) },
    { ZYDIS_DEFINITION(0x1, 0x7F), ZYDIS_DEFINITION(0x1, 0x80) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6DB) },
    { ZYDIS_DEFINITION(0x1, 0x79), ZYDIS_DEFINITION(0x1, 0x7A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6DD) },
    { ZYDIS_DEFINITION(0x1, 0x9F), ZYDIS_DEFINITION(0x1, 0xA0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6DF) },
    { ZYDIS_DEFINITION(0xB, 0x8D), ZYDIS_DEFINITION(0xB, 0x8E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x55), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x56) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x57), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x58) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x59), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x60) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x61), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x62) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x64) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x66) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x68) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x70) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x76) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x77), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x78) }
};

const ZydisDecoderTreeNode FILTERS_MODRM_REG[][8] =
{
    { ZYDIS_DEFINITION(0x1, 0x6CB), ZYDIS_DEFINITION(0x1, 0x6E9), ZYDIS_DEFINITION(0x1, 0x2D5), ZYDIS_DEFINITION(0x1, 0x2EC), ZYDIS_DEFINITION(0x1, 0x739), ZYDIS_DEFINITION(0x1, 0x73B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6CC), ZYDIS_DEFINITION(0x1, 0x6EA), ZYDIS_DEFINITION(0x1, 0x2D6), ZYDIS_DEFINITION(0x1, 0x2ED), ZYDIS_DEFINITION(0x1, 0x73A), ZYDIS_DEFINITION(0x1, 0x73C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x0), ZYDIS_DEFINITION(0x1, 0x6CD), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xC), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x19), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1C), ZYDIS_DEFINITION(0x1, 0x6CE), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2D8), ZYDIS_DEFINITION(0x1, 0x25E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x633), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x530), ZYDIS_DEFINITION(0x1, 0x537), ZYDIS_DEFINITION(0x1, 0x538), ZYDIS_DEFINITION(0x1, 0x530), ZYDIS_DEFINITION(0x1, 0x530), ZYDIS_DEFINITION(0x1, 0x530), ZYDIS_DEFINITION(0x1, 0x530), ZYDIS_DEFINITION(0x1, 0x530) },
    { ZYDIS_DEFINITION(0x1, 0x3B8), ZYDIS_DEFINITION(0x1, 0x3B9), ZYDIS_DEFINITION(0x1, 0x3BA), ZYDIS_DEFINITION(0x1, 0x3BB), ZYDIS_DEFINITION(0x1, 0x3BC), ZYDIS_DEFINITION(0x1, 0x3BD), ZYDIS_DEFINITION(0x1, 0x3BE), ZYDIS_DEFINITION(0x1, 0x3BF) },
    { ZYDIS_DEFINITION(0x1, 0x533), ZYDIS_DEFINITION(0x1, 0x534), ZYDIS_DEFINITION(0x1, 0x535), ZYDIS_DEFINITION(0x1, 0x536), ZYDIS_DEFINITION(0x1, 0x3C0), ZYDIS_DEFINITION(0x1, 0x3C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_IPREFETCH, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_IPREFETCH, 0x1) },
    { ZYDIS_DEFINITION(0x1, 0xBC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2A), ZYDIS_DEFINITION(0x1, 0x3D6), ZYDIS_DEFINITION(0x1, 0x3D7), ZYDIS_DEFINITION(0x1, 0x3D8), ZYDIS_DEFINITION(0x1, 0x3D9), ZYDIS_DEFINITION(0x1, 0x3DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_KNC, 0x0), ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_KNC, 0x1), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E8) },
    { ZYDIS_DEFINITION(0x1, 0x4E), ZYDIS_DEFINITION(0x1, 0x46), ZYDIS_DEFINITION(0x1, 0x4F), ZYDIS_DEFINITION(0x1, 0x47), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x582), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x56F), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x562), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x583), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x570), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x563), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x575), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x569), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x555), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x576), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x56A), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x556), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x57C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x55C), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x57D), ZYDIS_DEFINITION(0xB, 0x57B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x55D), ZYDIS_DEFINITION(0xB, 0x55B) },
    { ZYDIS_DEFINITION(0x13, 0x17F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x10), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x11), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x12), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x13), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x14), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x16), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x17), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x19), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CE), ZYDIS_DEFINITION(0x1, 0x2FB), ZYDIS_DEFINITION(0x1, 0x687) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x722), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x51), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x53), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x54), ZYDIS_DEFINITION(0x1, 0x5AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29), ZYDIS_DEFINITION(0x1, 0x72F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x730), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B), ZYDIS_DEFINITION(0x1, 0x2C9), ZYDIS_DEFINITION(0x1, 0x6DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E), ZYDIS_DEFINITION(0x1, 0xBD) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xC4), ZYDIS_DEFINITION(0x1, 0xBE) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5AB), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xC1), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xA1), ZYDIS_DEFINITION(0xB, 0xAD), ZYDIS_DEFINITION(0xB, 0xA9), ZYDIS_DEFINITION(0xB, 0xA3) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xA2), ZYDIS_DEFINITION(0xB, 0xAE), ZYDIS_DEFINITION(0xB, 0xAA), ZYDIS_DEFINITION(0xB, 0xA4) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x602), ZYDIS_DEFINITION(0x1, 0x603) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x55), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x56) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x57), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32), ZYDIS_DEFINITION(0x1, 0x743), ZYDIS_DEFINITION(0x1, 0x744) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x73E), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x751), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x90), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x91), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x92), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE3), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE4), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEA), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x22), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x23), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x24), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x25), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x27), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x29), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x43E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x43F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x440), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x442), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x443), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x444), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x445) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CC), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CD), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CE), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CF), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x30), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x31), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x32), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x33), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x446) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x447) },
    { ZYDIS_DEFINITION(0xD, 0x28), ZYDIS_DEFINITION(0xD, 0x3F8), ZYDIS_DEFINITION(0xD, 0x12), ZYDIS_DEFINITION(0xD, 0x64D), ZYDIS_DEFINITION(0xD, 0x5E), ZYDIS_DEFINITION(0xD, 0x6F6), ZYDIS_DEFINITION(0xD, 0x77B), ZYDIS_DEFINITION(0xD, 0xF1) },
    { ZYDIS_DEFINITION(0xD, 0x29), ZYDIS_DEFINITION(0xD, 0x3F9), ZYDIS_DEFINITION(0xD, 0x13), ZYDIS_DEFINITION(0xD, 0x64E), ZYDIS_DEFINITION(0xD, 0x5F), ZYDIS_DEFINITION(0xD, 0x6F7), ZYDIS_DEFINITION(0xD, 0x77C), ZYDIS_DEFINITION(0xD, 0xF2) },
    { ZYDIS_DEFINITION(0xE, 0x2A), ZYDIS_DEFINITION(0xE, 0x3FA), ZYDIS_DEFINITION(0xE, 0x14), ZYDIS_DEFINITION(0xE, 0x64F), ZYDIS_DEFINITION(0xE, 0x60), ZYDIS_DEFINITION(0xE, 0x6F8), ZYDIS_DEFINITION(0xE, 0x77D), ZYDIS_DEFINITION(0xE, 0xF3) },
    { ZYDIS_DEFINITION(0xE, 0x2B), ZYDIS_DEFINITION(0xE, 0x3FB), ZYDIS_DEFINITION(0xE, 0x15), ZYDIS_DEFINITION(0xE, 0x650), ZYDIS_DEFINITION(0xE, 0x61), ZYDIS_DEFINITION(0xE, 0x6F9), ZYDIS_DEFINITION(0xE, 0x77E), ZYDIS_DEFINITION(0xE, 0xF4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCD) },
    { ZYDIS_DEFINITION(0xD, 0x2E), ZYDIS_DEFINITION(0xD, 0x3FE), ZYDIS_DEFINITION(0xD, 0x18), ZYDIS_DEFINITION(0xD, 0x653), ZYDIS_DEFINITION(0xD, 0x64), ZYDIS_DEFINITION(0xD, 0x6FC), ZYDIS_DEFINITION(0xD, 0x781), ZYDIS_DEFINITION(0xD, 0xF7) },
    { ZYDIS_DEFINITION(0xD, 0x2F), ZYDIS_DEFINITION(0xD, 0x3FF), ZYDIS_DEFINITION(0xD, 0x19), ZYDIS_DEFINITION(0xD, 0x654), ZYDIS_DEFINITION(0xD, 0x65), ZYDIS_DEFINITION(0xD, 0x6FD), ZYDIS_DEFINITION(0xD, 0x782), ZYDIS_DEFINITION(0xD, 0xF8) },
    { ZYDIS_DEFINITION(0x1, 0x521), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x522), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x462), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x463), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x464), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x465), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x466), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x467), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x468) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x469), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x60E), ZYDIS_DEFINITION(0xB, 0x61A), ZYDIS_DEFINITION(0xB, 0x5DD), ZYDIS_DEFINITION(0xB, 0x5ED), ZYDIS_DEFINITION(0xB, 0x698), ZYDIS_DEFINITION(0xB, 0x6B4), ZYDIS_DEFINITION(0xB, 0x699), ZYDIS_DEFINITION(0xB, 0x636) },
    { ZYDIS_DEFINITION(0xB, 0x60F), ZYDIS_DEFINITION(0xB, 0x61B), ZYDIS_DEFINITION(0xB, 0x5DE), ZYDIS_DEFINITION(0xB, 0x5EE), ZYDIS_DEFINITION(0xB, 0x69A), ZYDIS_DEFINITION(0xB, 0x6B5), ZYDIS_DEFINITION(0xB, 0x69B), ZYDIS_DEFINITION(0xB, 0x637) },
    { ZYDIS_DEFINITION(0xB, 0x610), ZYDIS_DEFINITION(0xB, 0x61C), ZYDIS_DEFINITION(0xB, 0x5DF), ZYDIS_DEFINITION(0xB, 0x5EF), ZYDIS_DEFINITION(0xB, 0x69C), ZYDIS_DEFINITION(0xB, 0x6B6), ZYDIS_DEFINITION(0xB, 0x69D), ZYDIS_DEFINITION(0xB, 0x638) },
    { ZYDIS_DEFINITION(0xB, 0x611), ZYDIS_DEFINITION(0xB, 0x61D), ZYDIS_DEFINITION(0xB, 0x5E0), ZYDIS_DEFINITION(0xB, 0x5F0), ZYDIS_DEFINITION(0xB, 0x69E), ZYDIS_DEFINITION(0xB, 0x6B7), ZYDIS_DEFINITION(0xB, 0x69F), ZYDIS_DEFINITION(0xB, 0x639) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x499), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A0) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x34), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x512), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x513), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x514), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x515), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x516), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x517), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x518), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x519), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x597), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x607), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x608) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x61D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x61E) },
    { ZYDIS_DEFINITION(0xD, 0x31B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3D) },
    { ZYDIS_DEFINITION(0xD, 0x31C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xE, 0x31D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3E) },
    { ZYDIS_DEFINITION(0xE, 0x31E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x612), ZYDIS_DEFINITION(0x1, 0x61E), ZYDIS_DEFINITION(0x1, 0x5E1), ZYDIS_DEFINITION(0x1, 0x5F1), ZYDIS_DEFINITION(0x1, 0x6A0), ZYDIS_DEFINITION(0x1, 0x6B8), ZYDIS_DEFINITION(0x1, 0x6A1), ZYDIS_DEFINITION(0x1, 0x63A) },
    { ZYDIS_DEFINITION(0x1, 0x613), ZYDIS_DEFINITION(0x1, 0x61F), ZYDIS_DEFINITION(0x1, 0x5E2), ZYDIS_DEFINITION(0x1, 0x5F2), ZYDIS_DEFINITION(0x1, 0x6A2), ZYDIS_DEFINITION(0x1, 0x6B9), ZYDIS_DEFINITION(0x1, 0x6A3), ZYDIS_DEFINITION(0x1, 0x63B) },
    { ZYDIS_DEFINITION(0x1, 0x614), ZYDIS_DEFINITION(0x1, 0x620), ZYDIS_DEFINITION(0x1, 0x5E3), ZYDIS_DEFINITION(0x1, 0x5F3), ZYDIS_DEFINITION(0x1, 0x6A4), ZYDIS_DEFINITION(0x1, 0x6BA), ZYDIS_DEFINITION(0x1, 0x6A5), ZYDIS_DEFINITION(0x1, 0x63C) },
    { ZYDIS_DEFINITION(0x1, 0x615), ZYDIS_DEFINITION(0x1, 0x621), ZYDIS_DEFINITION(0x1, 0x5E4), ZYDIS_DEFINITION(0x1, 0x5F4), ZYDIS_DEFINITION(0x1, 0x6A6), ZYDIS_DEFINITION(0x1, 0x6BB), ZYDIS_DEFINITION(0x1, 0x6A7), ZYDIS_DEFINITION(0x1, 0x63D) },
    { ZYDIS_DEFINITION(0x1, 0x616), ZYDIS_DEFINITION(0x1, 0x622), ZYDIS_DEFINITION(0x1, 0x5E5), ZYDIS_DEFINITION(0x1, 0x5F5), ZYDIS_DEFINITION(0x1, 0x6A8), ZYDIS_DEFINITION(0x1, 0x6BC), ZYDIS_DEFINITION(0x1, 0x6A9), ZYDIS_DEFINITION(0x1, 0x63E) },
    { ZYDIS_DEFINITION(0x1, 0x617), ZYDIS_DEFINITION(0x1, 0x623), ZYDIS_DEFINITION(0x1, 0x5E6), ZYDIS_DEFINITION(0x1, 0x5F6), ZYDIS_DEFINITION(0x1, 0x6AA), ZYDIS_DEFINITION(0x1, 0x6BD), ZYDIS_DEFINITION(0x1, 0x6AB), ZYDIS_DEFINITION(0x1, 0x63F) },
    { ZYDIS_DEFINITION(0x1, 0x618), ZYDIS_DEFINITION(0x1, 0x624), ZYDIS_DEFINITION(0x1, 0x5E7), ZYDIS_DEFINITION(0x1, 0x5F7), ZYDIS_DEFINITION(0x1, 0x6AC), ZYDIS_DEFINITION(0x1, 0x6BE), ZYDIS_DEFINITION(0x1, 0x6AD), ZYDIS_DEFINITION(0x1, 0x640) },
    { ZYDIS_DEFINITION(0x1, 0x619), ZYDIS_DEFINITION(0x1, 0x625), ZYDIS_DEFINITION(0x1, 0x5E8), ZYDIS_DEFINITION(0x1, 0x5F8), ZYDIS_DEFINITION(0x1, 0x6AE), ZYDIS_DEFINITION(0x1, 0x6BF), ZYDIS_DEFINITION(0x1, 0x6AF), ZYDIS_DEFINITION(0x1, 0x641) },
    { ZYDIS_DEFINITION(0x1, 0x183), ZYDIS_DEFINITION(0x1, 0x1DA), ZYDIS_DEFINITION(0x1, 0x193), ZYDIS_DEFINITION(0x1, 0x199), ZYDIS_DEFINITION(0x1, 0x1FF), ZYDIS_DEFINITION(0x1, 0x204), ZYDIS_DEFINITION(0x1, 0x1A2), ZYDIS_DEFINITION(0x1, 0x1A7) },
    { ZYDIS_DEFINITION(0x1, 0x184), ZYDIS_DEFINITION(0x1, 0x1DB), ZYDIS_DEFINITION(0x1, 0x194), ZYDIS_DEFINITION(0x1, 0x19A), ZYDIS_DEFINITION(0x1, 0x200), ZYDIS_DEFINITION(0x1, 0x205), ZYDIS_DEFINITION(0x1, 0x1A3), ZYDIS_DEFINITION(0x1, 0x1A8) },
    { ZYDIS_DEFINITION(0x1, 0x1CC), ZYDIS_DEFINITION(0x1, 0x211), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3F), ZYDIS_DEFINITION(0x1, 0x1FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x43) },
    { ZYDIS_DEFINITION(0x1, 0x1CD), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1F5), ZYDIS_DEFINITION(0x1, 0x1F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x21), ZYDIS_DEFINITION(0x1, 0x1D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x22), ZYDIS_DEFINITION(0x1, 0x1E4) },
    { ZYDIS_DEFINITION(0x1, 0x18B), ZYDIS_DEFINITION(0x1, 0x18D), ZYDIS_DEFINITION(0x1, 0x18C), ZYDIS_DEFINITION(0x1, 0x192), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x44), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1B0), ZYDIS_DEFINITION(0x1, 0x1BD), ZYDIS_DEFINITION(0x1, 0x1B2), ZYDIS_DEFINITION(0x1, 0x1B4), ZYDIS_DEFINITION(0x1, 0x1C8), ZYDIS_DEFINITION(0x1, 0x1CA), ZYDIS_DEFINITION(0x1, 0x1B6), ZYDIS_DEFINITION(0x1, 0x1B8) },
    { ZYDIS_DEFINITION(0x1, 0x18E), ZYDIS_DEFINITION(0x1, 0x190), ZYDIS_DEFINITION(0x1, 0x18F), ZYDIS_DEFINITION(0x1, 0x191), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x45), ZYDIS_DEFINITION(0x1, 0x20B), ZYDIS_DEFINITION(0x1, 0x197), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1BA), ZYDIS_DEFINITION(0x1, 0x1C5), ZYDIS_DEFINITION(0x1, 0x1C0), ZYDIS_DEFINITION(0x1, 0x1C2), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1CE), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1F9) },
    { ZYDIS_DEFINITION(0x1, 0x185), ZYDIS_DEFINITION(0x1, 0x1DC), ZYDIS_DEFINITION(0x1, 0x195), ZYDIS_DEFINITION(0x1, 0x19B), ZYDIS_DEFINITION(0x1, 0x206), ZYDIS_DEFINITION(0x1, 0x201), ZYDIS_DEFINITION(0x1, 0x1A9), ZYDIS_DEFINITION(0x1, 0x1A4) },
    { ZYDIS_DEFINITION(0x1, 0x186), ZYDIS_DEFINITION(0x1, 0x1DD), ZYDIS_DEFINITION(0x1, 0x196), ZYDIS_DEFINITION(0x1, 0x19C), ZYDIS_DEFINITION(0x1, 0x202), ZYDIS_DEFINITION(0x1, 0x207), ZYDIS_DEFINITION(0x1, 0x1A5), ZYDIS_DEFINITION(0x1, 0x1AA) },
    { ZYDIS_DEFINITION(0x1, 0x1AE), ZYDIS_DEFINITION(0x1, 0x212), ZYDIS_DEFINITION(0x1, 0x1F6), ZYDIS_DEFINITION(0x1, 0x1FA), ZYDIS_DEFINITION(0x1, 0x20A), ZYDIS_DEFINITION(0x1, 0x20D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1CF), ZYDIS_DEFINITION(0x1, 0x1C6), ZYDIS_DEFINITION(0x1, 0x1F7), ZYDIS_DEFINITION(0x1, 0x1FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x23), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x24), ZYDIS_DEFINITION(0x1, 0x1E7) },
    { ZYDIS_DEFINITION(0x1, 0x187), ZYDIS_DEFINITION(0x1, 0x1DE), ZYDIS_DEFINITION(0x1, 0x19D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x46), ZYDIS_DEFINITION(0x1, 0x208), ZYDIS_DEFINITION(0x1, 0x203), ZYDIS_DEFINITION(0x1, 0x1AB), ZYDIS_DEFINITION(0x1, 0x1A6) },
    { ZYDIS_DEFINITION(0x1, 0x1B1), ZYDIS_DEFINITION(0x1, 0x1BE), ZYDIS_DEFINITION(0x1, 0x1B3), ZYDIS_DEFINITION(0x1, 0x1B5), ZYDIS_DEFINITION(0x1, 0x1C9), ZYDIS_