require 'pry'
require 'pry-byebug'
require 'view_component/test_helpers'
require 'simplecov'
require 'action_controller'
require 'action_controller/test_case'

require File.expand_path("dummy/config/environment", __dir__)

if ENV.fetch('SIMPLECOV') { '1' } == '1'
  SimpleCov.add_filter('spec/dummy')
  SimpleCov.start
end

include GovukVisuallyHiddenHelper
include GovukLinkHelper
include GovukListHelper
include GovukBackToTopLinkHelper
include GovukSkipLinkHelper
include GovukExitThisPageLinkHelper
include TitleWithErrorPrefixHelper

module Pagy::UrlHelpers
  def request
    OpenStruct.new(GET: {}, session: nil, host: "https://somesite/", format: OpenStruct.new(html?: true))
  end
end

Dir[File.join('./spec', 'components', 'shared', '*.rb')].sort.each { |file| require file }

# This file was generated by the `rspec --init` command. Conventionally, all
# specs live under a `spec` directory, which RSpec adds to the `$LOAD_PATH`.
# The generated `.rspec` file contains `--require spec_helper` which will cause
# this file to always be loaded, without a need to explicitly require it in any
# files.
#
# Given that it is always loaded, you are encouraged to keep this file as
# light-weight as possible. Requiring heavyweight dependencies from this file
# will add to the boot time of your test suite on EVERY test run, even for an
# individual file that may not need all of that loaded. Instead, consider making
# a separate helper file that requires the additional dependencies and performs
# the additional setup, and require it from the spec files that actually need
# it.
#
# See http://rubydoc.info/gems/rspec-core/RSpec/Core/Configuration
RSpec.configure do |config|
  # rspec-expectations config goes here. You can use an alternate
  # assertion/expectation library such as wrong or the stdlib/minitest
  # assertions if you prefer.
  config.expect_with :rspec do |expectations|
    # This option will default to `true` in RSpec 4. It makes the `description`
    # and `failure_message` of custom matchers include text for helper methods
    # defined using `chain`, e.g.:
    #     be_bigger_than(2).and_smaller_than(4).description
    #     # => "be bigger than 2 and smaller than 4"
    # ...rather than:
    #     # => "be bigger than 2"
    expectations.include_chain_clauses_in_custom_matcher_descriptions = true
  end

  # rspec-mocks config goes here. You can use an alternate test double
  # library (such as bogus or mocha) by changing the `mock_with` option here.
  config.mock_with :rspec do |mocks|
    # Prevents you from mocking or stubbing a method that does not exist on
    # a real object. This is generally recommended, and will default to
    # `true` in RSpec 4.
    mocks.verify_partial_doubles = true
  end

  # This option will default to `:apply_to_host_groups` in RSpec 4 (and will
  # have no way to turn it off -- the option exists only for backwards
  # compatibility in RSpec 3). It causes shared context metadata to be
  # inherited by the metadata hash of host groups and examples, rather than
  # triggering implicit auto-inclusion in groups with matching metadata.
  config.shared_context_metadata_behavior = :apply_to_host_groups

  # Allow ViewComponents to be tested
  config.include ViewComponent::TestHelpers, type: :component
  config.include RSpecHtmlMatchers

  config.include_context "helpers"
  config.include_context "setup"
end
