module Examples
  module LinkHelpers
    def govuk_link_to_normal
      %(= govuk_link_to 'A regular hyperlink', '#')
    end

    def govuk_link_to_new_tab
      <<~NEW_TAB
        p.govuk-body
          = govuk_link_to('A link with the default new tab text',
            '#',
            new_tab: true)

        p.govuk-body
          = govuk_link_to('A link with custom new tab text',
            '#',
            new_tab: "(opens in a new window)")

        p.govuk-body
          = govuk_link_to('A link with custom new tab text',
            '#',
            new_tab: govuk_visually_hidden('(opens in a new window)'))

      NEW_TAB
    end

    def govuk_link_to_inverse
      %(= govuk_link_to('An inverse hyperlink', '#', inverse: true))
    end

    def govuk_link_to_muted
      %(= govuk_link_to('A muted hyperlink', '#', muted: true))
    end

    def govuk_link_other_styles
      <<~LINKS
        p.govuk-body
          = govuk_link_to('A hyperlink without an underline', '#', no_underline: true )

        p.govuk-body
          = govuk_link_to('A hyperlink without a visited state', '#', no_visited_state: true)

        p.govuk-body
          = govuk_link_to('A text-coloured hyperlink', '#', text_colour: true)
      LINKS
    end

    def govuk_button_to_normal
      %(= govuk_button_to 'A button', '#')
    end

    def govuk_button_link_to_normal
      %(= govuk_button_link_to 'A link styled like a button', '#')
    end

    def govuk_button_inverse
      <<~BUTTON
        = govuk_button_link_to('An inverse button', '#', inverse: true)
      BUTTON
    end

    def govuk_link_with_visually_hidden_text
      <<~VISUALLY_HIDDEN_LINK
        = govuk_link_to('View', '#', visually_hidden_suffix: 'account')
      VISUALLY_HIDDEN_LINK
    end

    def govuk_button_other_styles
      <<~BUTTONS
        .govuk-button-group
          = govuk_button_link_to('A disabled button', '#', disabled: true)
          = govuk_button_link_to('A secondary button', '#', secondary: true)
          = govuk_button_link_to('A warning button', '#', warning: true)
      BUTTONS
    end

    def govuk_link_classes_multiple
      <<~LINK
        p.govuk-body
          = link_to_if(true,
            'A regular link generated by Rails',
            '#',
            class: govuk_link_classes)

        p.govuk-body
          = link_to_if(true,
            'A muted and not underlined link generated by Rails',
            '#',
            class: govuk_link_classes(muted: true, no_underline: true))
      LINK
    end
  end
end
