### Contribution Guidelines
When contributing, please be sure to submit new files via a PR instead of editing someone else's. If you would like to request an edit from someone else, please open an issue and tag the contributor (check with git blame).

# One line wonders
A collection of one-line programs in various languages, performing various tasks.
**"One-Line"** is for those languages that support it; the aim is to create a runnable file the shortest a language can allow (i.e. no using ; instead of a new line and "minifying" it to be one line).

### Why?
Have some fun with coding every once in a while, and see how you can abuse the semantics of a language.

### Contributing
Anyone can contribute to this repo by opening a PR, your contribution will be open-source on Github. Don't know what to make? Try coding something that logs "Hello, world!" to the console!

### Hacktoberfest
Celebrate [Hacktoberfest](https://hacktoberfest.digitalocean.com/) together with a diverse community of developers from around the world!

PRs marked as spam will not be counted towards 5 PRs in the month of October for your **free Hacktoberfest T-Shirt!**

### Let's Get Started
1. Fork this repository
  - Click the Fork button in the top right of this page, then click on your profile image.
2. Clone to desktop `git clone https://github.com/your-username/one-line-wonders.git`
3. Checkout a branch `git checkout -b feature/branch-name`
4. Make yourself known
  - Add your bio to the CONTRIBUTORS.md file

    Name: [YOUR NAME](Github Link)</br>
    Place: Where are you from?</br>
    Coding Experience: Which programming languages do you know? What projects have you/do you worked on?</br>
    Email: name@example.com</br>

5. Add your one-line program's files. If a folder for your code's language does not exist, feel free to create it.
6. Commit and push `git add .; git commit -m "commit message"; git push origin branch-name;`
7. Create a new Pull Request from your fork
  - Click on the New Pull Request button located near the top of your repository.
8. Wait for your PR to be reviewed!

**Star this repository if you had fun** :star::tada:
