package com.wanyue.main.view.proxy.project;

import androidx.lifecycle.Observer;
import android.content.Intent;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.fastjson.JSONObject;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.jeremyliao.liveeventbus.LiveEventBus;
import com.wanyue.common.Constants;
import com.wanyue.common.custom.refresh.RxRefreshView;
import com.wanyue.common.proxy.RxViewProxy;
import com.wanyue.common.server.entity.Data;
import com.wanyue.detail.R;
import com.wanyue.detail.R2;
import com.wanyue.inside.event.InsideEvent;
import com.wanyue.main.adapter.ProjectListAdapter;
import com.wanyue.detail.business.IntentInsHelper;
import com.wanyue.inside.bean.ProjectBean;
import com.wanyue.inside.busniess.data.ProjectDataHelper;
import java.util.List;
import butterknife.BindView;
import io.reactivex.Observable;
import io.reactivex.functions.Function;

/*基础列表*/
public abstract class ProjectListProxy extends RxViewProxy implements BaseQuickAdapter.OnItemClickListener, BaseQuickAdapter.OnItemChildClickListener {
    @BindView(R2.id.refreshView)
    RxRefreshView<ProjectBean> mRefreshView;
    private ProjectListAdapter mProjectListAdapter;
    private boolean mIsFromTeacher;
    private String mEmptyHint;

    private boolean mNeedWatchGradleChange=true;
    @Override
    public int getLayoutId() {
        return R.layout.view_single_refresh;
    }
    @Override
    protected void initView(ViewGroup contentView) {
        super.initView(contentView);
        mProjectListAdapter=new ProjectListAdapter(null);
        mRefreshView.setAdapter(mProjectListAdapter);
        mRefreshView.setReclyViewSetting(RxRefreshView.ReclyViewSetting.createLinearSetting(getActivity()));
        mRefreshView.setDataListner(new RxRefreshView.DataListner<ProjectBean>() {
            @Override
            public Observable<List<ProjectBean>> loadData(int p) {
                return valueGetData(p);
            }
            @Override
            public void compelete(List<ProjectBean> data) {
            }
            @Override
            public void error(Throwable e) {
            }
        });

        if(!TextUtils.isEmpty(mEmptyHint)){
           mRefreshView.setNoDataTip(mEmptyHint);
        }

        mProjectListAdapter.setOnItemClickListener(this);
        mProjectListAdapter.setOnItemChildClickListener(this);

        if(mNeedWatchGradleChange){
            LiveEventBus.get(InsideEvent.GRADE).observe(getActivity(), new Observer<Object>() {
                @Override
                public void onChanged(@Nullable Object o) {
                    mRefreshView.initData();
                }
            });
        }
    }

    /*是否需要观察学级变化*/
    public void setNeedWatchGradleChange(boolean needWatchGradleChange) {
        mNeedWatchGradleChange = needWatchGradleChange;
    }

    private Observable<List<ProjectBean>> valueGetData(int p) {
      return getData(p).map(new Function<Data<JSONObject>, List<ProjectBean>>() {
          @Override
          public List<ProjectBean> apply(Data<JSONObject> jsonObjectData) throws Exception {
              return ProjectDataHelper.formatProject(jsonObjectData.getInfo());
          }
      }).compose(this.<List<ProjectBean>>bindUntilOnDestoryEvent());
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
         if(isVisibleToUser&&mRefreshView!=null){
            mRefreshView.initData();
         }
    }


    public void setEmptyHint(String emptyHint) {
        mEmptyHint = emptyHint;
    }

    public void initData(){
        if(mRefreshView!=null){
           mRefreshView.initData();
        }
    }
    public abstract Observable<Data<JSONObject>> getData(int p);


    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    public void setFromTeacher(boolean fromTeacher) {
        mIsFromTeacher = fromTeacher;
    }

    @Override
    public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
        ProjectBean projectBean=mProjectListAdapter.getItem(position);
        Intent intent=new Intent();
        intent.putExtra(Constants.FROM,mIsFromTeacher);

/*
        ActivityOptionsCompat optionsCompat =
        ActivityOptionsCompat.makeSceneTransitionAnimation(getActivity(), view.findViewById(R.id.img_thumb), "image");*/
        IntentInsHelper.forward(getActivity(),intent,projectBean);
    }



    @Override
    public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
            int viewId=view.getId();
            String uid=mProjectListAdapter.getData().get(position).getLecturerUid();
            if(viewId==R.id.tv_name||viewId==R.id.img_avator){

            }
    }
}
