package com.wanyue.main.view.proxy.login;

import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.bean.DataListner;
import com.wanyue.common.business.TimeModel;
import com.wanyue.common.proxy.RxViewProxy;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.server.observer.DefaultObserver;
import com.wanyue.common.utils.StringUtil;
import com.wanyue.common.utils.ToastUtil;
import com.wanyue.common.utils.ValidatePhoneUtil;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.main.R;
import com.wanyue.main.R2;
import com.wanyue.main.api.MainAPI;
import com.wanyue.main.bean.LoginCommitBean;

import butterknife.BindView;
import butterknife.OnClick;
import butterknife.OnTextChanged;
import io.reactivex.Observable;

/*验证码登陆*/
public class VerifiCodeLoginProxy extends BaseLoginProxy implements TimeModel.TimeListner {

    @BindView(R2.id.tv_phone)
    EditText mTvPhone;
    @BindView(R2.id.tv_code)
    EditText mTvCode;
    @BindView(R2.id.btn_get_code)
    TextView mBtnGetCode;

    private TimeModel mTimeModel;
    private LoginCommitBean mLoginCommitBean;

    @Override
    protected void initView(ViewGroup contentView) {
        super.initView(contentView);
        initCommitData();
    }

    @Override
    public Observable<Data<JSONObject>> createLoginRequest() {
        return MainAPI.loginByCode(mLoginCommitBean.getPhoneString(),mLoginCommitBean.getCheckString());
    }

    private void initCommitData() {
        mLoginCommitBean=new LoginCommitBean();
        mLoginCommitBean.setDataListner(new DataListner() {
            @Override
            public void compelete(boolean isCompelete) {
              mBtnLogin.setEnabled(isCompelete);
            }
        });
    }

    /*监听手机号输入框信息*/
    @OnTextChanged(value = R2.id.tv_phone, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchPhoneTextChange(CharSequence sequence, int start, int before, int count){
        String phoneString=sequence.toString();
        mLoginCommitBean.setPhoneString(phoneString);
        mBtnGetCode.setEnabled(ValidatePhoneUtil.validateMobileNumber(phoneString));
    }


    /*监听验证码号输入框信息*/
    @OnTextChanged(value = R2.id.tv_code, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchCodeTextChange(CharSequence sequence, int start, int before, int count){
        String codeString=sequence.toString();
        mLoginCommitBean.setCheckString(codeString);
    }

    @Override
    public int getLayoutId() {
        return R.layout.view_code_login;
    }

    /*获取验证码*/
    @OnClick(R2.id.btn_get_code)
    public void commit() {
        String phoneNum=mTvPhone.getText().toString();
        if(!ValidatePhoneUtil.validateMobileNumber(phoneNum)){
            mTvPhone.setError(WordUtil.getString(R.string.login_phone_error));
            mTvPhone.requestFocus();
            return;
        }

        MainAPI.getCode(phoneNum,0).compose(this.<Data<JSONObject>>bindUntilOnDestoryEvent()).subscribe(new DefaultObserver<Data<JSONObject>>() {
            @Override
            public void onNext(Data<JSONObject> jsonObjectData) {
                getLoginCodeSucc(jsonObjectData);
            }
        });
    }




    private void getLoginCodeSucc(Data<JSONObject> jsonObjectData) {
        String msg=jsonObjectData.getMsg();
        int code=jsonObjectData.getCode();
        if(code!=0&&code!=1002){
            ToastUtil.show(msg);
            return;
        }
        if(msg.contains("123456")){
            ToastUtil.show(msg);
        }
        initTimeModel();
        mTimeModel.start();
        mBtnGetCode.setEnabled(false);
    }

    private void initTimeModel() {
        if(mTimeModel==null){
            mTimeModel=new TimeModel()
                    .setTotalUseTime(60)
                    .setState(TimeModel.COUNT_DOWN)
                    .setAfterString("s");
            mTimeModel.addTimeListner(this);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(mTimeModel!=null){
           mTimeModel.clear();
        }
    }
    @Override
    public void time(String string) {
        mBtnGetCode.setText(string);
    }

    @Override
    public void remainTime(long time) {

    }

    @Override
    public void compelete() {
        mBtnGetCode.setEnabled(true);
        mBtnGetCode.setText(R.string.login_get_code);
    }


}
