package com.wanyue.main.view.proxy.login;

import android.app.Activity;
import android.content.Intent;
import androidx.annotation.Nullable;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.Constants;
import com.wanyue.common.bean.DataListner;
import com.wanyue.common.server.entity.Data;
import com.wanyue.main.R;
import com.wanyue.main.R2;
import com.wanyue.main.api.MainAPI;
import com.wanyue.main.bean.LoginCommitBean;
import com.wanyue.main.view.activity.ForgetPwdActivity;
import butterknife.BindView;
import butterknife.OnClick;
import butterknife.OnTextChanged;
import io.reactivex.Observable;

/*密码登陆*/
public class PasswordLoginProxy extends BaseLoginProxy {
    @BindView(R2.id.tv_phone)
    EditText mTvPhone;
    @BindView(R2.id.tv_pwd)
    EditText mTvPwd;

    @BindView(R2.id.btn_forget_pwd)
    TextView mBtnForgetPwd;
    private LoginCommitBean mLoginCommitBean;

    @Override
    public int getLayoutId() {
        return R.layout.view_login_proxy;
    }

    @Override
    protected void initView(ViewGroup contentView) {
        super.initView(contentView);
        initCommitData();
    }

    @Override
    public Observable<Data<JSONObject>> createLoginRequest() {
        return  MainAPI.loginByPassward(mLoginCommitBean.getPhoneString().toString(),mLoginCommitBean.getCheckString().toString());
    }


    /*监听手机号输入框信息*/
    @OnTextChanged(value = R2.id.tv_phone, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchPhoneTextChange(CharSequence sequence, int start, int before, int count){
        String phoneString=sequence.toString();
        mLoginCommitBean.setPhoneString(phoneString);
    }


    /*监听密码输入框信息*/
    @OnTextChanged(value = R2.id.tv_pwd, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchPwdTextChange(CharSequence sequence, int start, int before, int count){
        String codeString=sequence.toString();
        mLoginCommitBean.setCheckString(codeString);
    }

    private void initCommitData() {
        mLoginCommitBean=new LoginCommitBean();
        mLoginCommitBean.setDataListner(new DataListner() {
            @Override
            public void compelete(boolean isCompelete) {
                mBtnLogin.setEnabled(isCompelete);
            }
        });
    }

    @OnClick(R2.id.btn_forget_pwd)
    public void forgetPwd() {
        Intent intent=new Intent(getActivity(),ForgetPwdActivity.class);
        startActivityForResult(intent,ForgetPwdActivity.REQUEST_CODE_FIND);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if(requestCode==ForgetPwdActivity.REQUEST_CODE_FIND&&resultCode== Activity.RESULT_OK){
            String phone=data.getStringExtra(Constants.KEY_PHONE);
            String pwd=data.getStringExtra(Constants.KEY_PWD);
            mTvPhone.setText(phone);
            mTvPwd.setText(pwd);
        }
    }

}
