package com.wanyue.main.view.proxy.login;

import android.view.ViewGroup;
import android.widget.Button;

import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.proxy.RxViewProxy;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.server.observer.DefaultObserver;
import com.wanyue.common.server.observer.DialogObserver;
import com.wanyue.main.R2;
import com.wanyue.main.api.MainAPI;

import butterknife.BindView;
import butterknife.OnClick;
import io.reactivex.Observable;


public abstract class BaseLoginProxy  extends RxViewProxy {
    @BindView(R2.id.btn_login)
    public Button mBtnLogin;


    private DialogObserver<Data<JSONObject>> mDataDefaultObserver;

    @Override
    protected void initView(ViewGroup contentView) {
        super.initView(contentView);

    }

    public void setDataDefaultObserver(DialogObserver<Data<JSONObject>> dataDefaultObserver) {
        mDataDefaultObserver = dataDefaultObserver;
    }

    public abstract Observable<Data<JSONObject>> createLoginRequest();


    @OnClick(R2.id.btn_login)
    public void login() {
        Observable<Data<JSONObject>> observable=createLoginRequest();
        if(observable!=null&&mDataDefaultObserver!=null){
           mDataDefaultObserver.setContext(getActivity());
           createLoginRequest().compose(this.<Data<JSONObject>>bindUntilOnDestoryEvent()).subscribe(mDataDefaultObserver);
        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        mDataDefaultObserver=null;
    }
}
