package com.wanyue.main.view.proxy;

import android.content.Context;
import android.graphics.Outline;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.makeramen.roundedimageview.RoundedImageView;
import com.meetsl.scardview.SRoundRectDrawableWithShadow;
import com.wanyue.common.utils.DpUtil;
import com.youth.banner.Banner;
import com.youth.banner.BannerConfig;
import com.youth.banner.listener.OnBannerListener;
import com.youth.banner.loader.ImageLoaderInterface;
import com.wanyue.common.activity.WebViewActivity;
import com.wanyue.common.glide.ImgLoader;
import com.wanyue.common.proxy.RxViewProxy;
import com.wanyue.common.server.observer.DefaultObserver;
import com.wanyue.common.utils.L;
import com.wanyue.main.R;
import com.wanyue.main.R2;
import com.wanyue.main.bean.banner.HomBannerBean;
import com.wanyue.main.bean.banner.IBanner;

import java.util.List;
import butterknife.BindView;
import io.reactivex.Observable;

/*banner封装*/
public  class BannerViewProxy< T extends IBanner> extends RxViewProxy {
    @BindView(R2.id.banner)
    Banner mBanner;

    private List<T> mData;

    @Override
    protected void initView(ViewGroup contentView) {
        super.initView(contentView);
        initBanner();
        requestData();
    }

    public void requestData() {
        Observable<List<T>> observable=getRequest();
        if(observable==null){
            return;
        }
        observable.compose(this.<List<T>>bindUntilOnDestoryEvent()).subscribe(new DefaultObserver<List<T>>() {
            @Override
            public void onNext(List<T> list) {
                setData(list);

            }
        });
    }

    public void setData(List<T> list) {
        mData=list;
        mBanner.setImages(mData);
        mBanner.start();
    }


    private void initBanner() {
        //设置banner样式(显示圆形指示器)
        mBanner.setBannerStyle(BannerConfig.CIRCLE_INDICATOR);
        mBanner.setClipToOutline(true);
        mBanner.setClipToOutline(true);
        mBanner.setOutlineProvider(new ViewOutlineProvider() {
            @Override
            public void getOutline(View view, Outline outline) {
                int radius=DpUtil.dp2px(5);
                outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), radius);
            }
        });

        //设置指示器位置（指示器居右）
        mBanner.setIndicatorGravity(BannerConfig.CENTER);
        //设置图片加载器
        mBanner.setImageLoader(new ImageLoaderInterface<ImageView>() {
            @Override
            public void displayImage(Context context, Object path, ImageView imageView) {
                T liveBannerBean= (T) path;
                ImgLoader.display(context,liveBannerBean.getImageUrl(),imageView);
            }
            @Override
            public ImageView createImageView(Context context) {
               ImageView imageView=new ImageView(context);
                imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                return imageView;
            }
        });

        mBanner.setOnBannerListener(new OnBannerListener() {
            @Override
            public void OnBannerClick(int position) {
                if(mData!=null&&mData.size()>position){
                    T liveBannerBean= mData.get(position);
                    String url=liveBannerBean.getData();
                    if(!TextUtils.isEmpty(url)){
                        WebViewActivity.forward(getActivity(),liveBannerBean.getData(),false);
                    }
                }
            }
        });

        //设置banner动画效果
//        banner.setBannerAnimation(Transformer.DepthPage);
        //设置标题集合（当banner样式有显示title时）
//        banner.setBannerTitles(titles);
        //设置自动轮播，默认为true
//        banner.isAutoPlay(true);
        //设置轮播时间
        mBanner.isAutoPlay(true);
        mBanner.setDelayTime(5000);
        //banner设置方法全部调用完毕时最后调用
    }


    public  Observable<List<T>> getRequest(){
        return null;
    }


    @Override
    public void onPause() {
        super.onPause();
        L.e("onPause=a=");
    }

    @Override
    public void onResume() {
        super.onResume();
        L.e("onResume=b=");
    }

    @Override
    public int getLayoutId() {
        return R.layout.view_banner;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(mBanner!=null){
           mBanner.stopAutoPlay();
        }
    }
}
