package com.wanyue.main.view.activity;

import android.app.Activity;
import android.net.wifi.aware.WifiAwareSession;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.activity.BaseActivity;
import com.wanyue.common.bean.DataListner;
import com.wanyue.common.bean.UserBean;
import com.wanyue.common.business.TimeModel;
import com.wanyue.common.business.acmannger.ActivityMannger;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.server.observer.DefaultObserver;
import com.wanyue.common.server.observer.DialogObserver;
import com.wanyue.common.utils.StringUtil;
import com.wanyue.common.utils.ToastUtil;
import com.wanyue.common.utils.ValidatePhoneUtil;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.main.R;
import com.wanyue.main.R2;
import com.wanyue.main.api.MainAPI;
import com.wanyue.main.bean.RegisterCommitBean;
import butterknife.BindView;
import butterknife.OnClick;
import butterknife.OnTextChanged;
import io.reactivex.Observable;

public class RegisterActivity extends BaseActivity implements TimeModel.TimeListner {

    @BindView(R2.id.tv_phone)
    EditText mTvPhone;
    @BindView(R2.id.tv_code)
    EditText mTvCode;
    @BindView(R2.id.btn_get_code)
    TextView mBtnGetCode;
    @BindView(R2.id.tv_pwd)
    EditText mTvPwd;
    @BindView(R2.id.btn_commit)
    TextView mBtnCommit;
    @BindView(R2.id.tv_title)
    TextView mTvTitle;

    private TimeModel mTimeModel;
    RegisterCommitBean mRegisterCommitBean;


    @Override
    public void init() {
        mRegisterCommitBean=new RegisterCommitBean();
        mRegisterCommitBean.setDataListner(new DataListner() {
            @Override
            public void compelete(boolean isCompelete) {
               mBtnCommit.setEnabled(isCompelete);
            }
        });
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_register;
    }

    @OnClick(R2.id.btn_commit)
    public void commit (View view){
        if(mRegisterCommitBean==null){
            return;
        }
        commit();
    }

    protected void commit() {
        MainAPI.register(mRegisterCommitBean.getPhone(),mRegisterCommitBean.getCode(),mRegisterCommitBean.getPwd()).
                compose(this.<Data<JSONObject>>bindUntilOnDestoryEvent()) .
                subscribe(new DialogObserver<Data<JSONObject>>(this) {
                    @Override
                    public void onNextTo(Data<JSONObject> jsonObjectData) {
                        JSONObject jsonObject= jsonObjectData.getInfo_0();
                        ToastUtil.show(jsonObjectData.getMsg());
                        UserBean userBean= JSON.toJavaObject(jsonObject,UserBean.class);
                        String uid=userBean.getId();
                        String token=jsonObject.getString("token");
                        CommonAppConfig.setUserBean(userBean);
                        CommonAppConfig.setLoginInfo(uid,token,true);

                        String gradeId=jsonObject.getString("gradeid");
                        String gradeName=jsonObject.getString("gradename");
                        if(StringUtil.equals(gradeId,"0")){
                           /* startActivity(StudyStageActivity.class);
                            CommonAppConfig.setGradeId(gradeId,false);
                            CommonAppConfig.setGradeName(gradeName);*/
                        }else{
                            CommonAppConfig.setGradeId(gradeId);
                        }
                            CommonAppConfig.setGradeName(gradeName);
                        Activity loginActivity=ActivityMannger.getInstance().getFirstClassTypeActivieActivity(LoginActivity.class);
                        if(loginActivity!=null){
                           loginActivity.finish();
                        }

                        finish();
                    }
                });
    }

    @OnClick(R2.id.btn_get_code)
    public void getLoginCode() {
        String phoneNum=mTvPhone.getText().toString();
        if(!ValidatePhoneUtil.validateMobileNumber(phoneNum)){
            mTvPhone.setError(WordUtil.getString(R.string.login_phone_error));
            mTvPhone.requestFocus();
            return;
        }

        MainAPI.getCode(phoneNum,getCodeType()).subscribe(new DefaultObserver<Data<JSONObject>>() {
            @Override
            public void onNext(Data<JSONObject> jsonObjectData) {
                getRegisterCodeSucc(jsonObjectData);
            }
        });
    }

    protected int getCodeType() {
        return 1;
    }

    private void getRegisterCodeSucc(Data<JSONObject> jsonObjectData) {
        String msg=jsonObjectData.getMsg();
        int code=jsonObjectData.getCode();
        if(code!=0&&code!=1002){
            ToastUtil.show(msg);
            return;
        }
        if(code==1002){
           ToastUtil.show(msg);
           return;
        }
        initTimeModel();
        mTimeModel.start();
        mBtnGetCode.setEnabled(false);
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(mTimeModel!=null){
           mTimeModel.clear();
        }
    }

    /*监听手机号输入框信息*/
    @OnTextChanged(value = R2.id.tv_phone, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchPhoneTextChange(CharSequence sequence, int start, int before, int count){
        String phoneString=sequence.toString();
        mRegisterCommitBean.setPhone(phoneString);
        mBtnGetCode.setEnabled(ValidatePhoneUtil.validateMobileNumber(phoneString));
    }

    /*监听验证码号输入框信息*/
    @OnTextChanged(value = R2.id.tv_code, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchCodeTextChange(CharSequence sequence, int start, int before, int count){
        String codeString=sequence.toString();
        mRegisterCommitBean.setCode(codeString);
    }

    /*监听密码输入框信息*/
    @OnTextChanged(value = R2.id.tv_pwd, callback = OnTextChanged.Callback.TEXT_CHANGED)
    public void watchPwdTextChange(CharSequence sequence, int start, int before, int count){
        String pwdString=sequence.toString();
        mRegisterCommitBean.setPwd(pwdString);
    }

    private void initTimeModel() {
        if(mTimeModel==null){
            mTimeModel=new TimeModel()
                    .setTotalUseTime(60)
                    .setState(TimeModel.COUNT_DOWN)
                    .setAfterString("s");
            mTimeModel.addTimeListner(this);
        }
    }

    @Override
    public void time(String string) {
        mBtnGetCode.setText(string);
    }

    @Override
    public void remainTime(long time) {

    }

    @Override
    public void compelete() {
        mBtnGetCode.setEnabled(true);
        mBtnGetCode.setText(R.string.reg_get_code);
    }
}
