package com.wanyue.main.view.activity;


import android.Manifest;
import androidx.viewpager.widget.ViewPager;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.activity.BaseActivity;
import com.wanyue.common.bean.ConfigBean;
import com.wanyue.common.business.acmannger.ActivityMannger;
import com.wanyue.common.custom.TabButtonGroup;
import com.wanyue.common.interfaces.CommonCallback;
import com.wanyue.common.proxy.RxViewProxy;
import com.wanyue.common.proxy.ViewProxyPageAdapter;
import com.wanyue.common.utils.ProcessResultUtil;
import com.wanyue.common.utils.RouteUtil;
import com.wanyue.common.utils.ToastUtil;
import com.wanyue.common.utils.VersionUtil;
import com.wanyue.main.R;
import com.wanyue.main.R2;
import com.wanyue.main.view.proxy.home.HomePageViewProxy;
import com.wanyue.main.view.proxy.home.HomeViewProxy2;
import com.wanyue.main.view.proxy.home.HomeViewProxy3;
import com.wanyue.main.view.proxy.home.HomeViewProxy4;
import java.util.Arrays;
import java.util.List;
import butterknife.BindView;

@Route(path = RouteUtil.PATH_MAIN)
public class MainActivity extends BaseActivity {

    @BindView(R2.id.viewPager)
    ViewPager mViewPager;
    @BindView(R2.id.tab_group)
    TabButtonGroup mTabGroup;
    @BindView(R2.id.tv_red_point)
    TextView mTvRedPoint;

    private HomePageViewProxy mHomePageViewProxy;
    private HomeViewProxy2 mHomeProjectCenterViewProxy;
    private HomeViewProxy3 mHomeMessageViewProxy;
    private HomeViewProxy4 mHomeUserCenterViewProxy;

    private long mLastClickBackTime;
    private boolean mFirstResume=true;
    private ProcessResultUtil mProcessResultUtil;

    @Override
    public void init() {
        mTabGroup.setViewPager(mViewPager);
        mHomePageViewProxy = new HomePageViewProxy();
        mHomeProjectCenterViewProxy = new HomeViewProxy2();
        mHomeMessageViewProxy = new HomeViewProxy3();
        mHomeUserCenterViewProxy = new HomeViewProxy4();

        List<RxViewProxy> viewProxyList = Arrays.asList(
                mHomePageViewProxy,
                mHomeProjectCenterViewProxy,
                mHomeMessageViewProxy,
                mHomeUserCenterViewProxy);

        mViewPager.setOffscreenPageLimit(viewProxyList.size());
        ViewProxyPageAdapter mViewPagerAdapter = new ViewProxyPageAdapter(getViewProxyMannger(), viewProxyList);
        mViewPagerAdapter.isPrint=true;
        mViewPagerAdapter.attachViewPager(mViewPager);
        ActivityMannger.getInstance().setBaseActivity(this);
        mProcessResultUtil = new ProcessResultUtil(this);

    }

    @Override
    public void onBackPressed() {
        long curTime = System.currentTimeMillis();
        if (curTime - mLastClickBackTime > 2000) {
            mLastClickBackTime = curTime;
            ToastUtil.show(R.string.main_click_next_exit);
            return;
        }
       finish();
    }


    private void checkPermissions(CommonCallback<Boolean> commonCallback) {
        mProcessResultUtil.requestPermissions(new String[]{
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.CAMERA,
                Manifest.permission.RECORD_AUDIO,
                Manifest.permission.ACCESS_COARSE_LOCATION,
        }, commonCallback);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(!mFirstResume){
            return;
        }
        mFirstResume=false;
        askPermissions();
    }

    /**
     * 检查版本更新
     */

    private void checkVersion() {
        ConfigBean configBean=CommonAppConfig.getConfig();
        if(configBean!=null){
            if (!VersionUtil.isLatest(configBean.getVersion())) {
                VersionUtil.showDialog(mContext, configBean.getUpdateDes(), configBean.getDownloadApkUrl());
            }
        }
    }

    private void askPermissions() {
        if(mProcessResultUtil!=null){
            checkPermissions(new CommonCallback<Boolean>() {
                @Override
                public void callback(Boolean bean) {
                    if(bean){
                        checkVersion();
                    }
                }
            });
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ActivityMannger.getInstance().removeActivity(this);
        ActivityMannger.getInstance().releaseBaseActivity(this);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_main;
    }

}
