package com.wanyue.main.view.activity;

import android.content.Intent;

import com.wanyue.common.Constants;
import com.wanyue.common.server.observer.DialogObserver;
import com.wanyue.main.R;
import com.wanyue.main.api.MainAPI;

public class ForgetPwdActivity extends RegisterActivity {
    public static final int REQUEST_CODE_FIND=1;


    @Override
    public void init() {
        super.init();
        mTvPwd.setHint(R.string.login_input_pwd_3);
        mTvTitle.setText(R.string.find_pwd);
        mBtnCommit.setText(getString(R.string.login));
    }

    @Override
    protected void commit() {
     MainAPI.findPwd(mRegisterCommitBean.getPhone(),
             mRegisterCommitBean.getCode(),
             mRegisterCommitBean.getPwd()).
             compose(this.<Boolean>bindUntilOnDestoryEvent()).
             subscribe(new DialogObserver<Boolean>(this) {
                 @Override
                 public void onNextTo(Boolean aBoolean) {
                     if(aBoolean){
                        findPwdSucc();
                     }
                 }
             });
    }

    private void findPwdSucc() {
        Intent intent=new Intent();
        intent.putExtra(Constants.KEY_PHONE,mRegisterCommitBean.getPhone());
        intent.putExtra(Constants.KEY_PWD,mRegisterCommitBean.getPwd());
        setResult(RESULT_OK,intent);
        finish();
    }

    @Override
    protected int getCodeType() {
        return 2;
    }
}
