package com.wanyue.main.api.project;

import android.os.Parcel;
import android.os.Parcelable;
import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.main.R;
import com.wanyue.main.api.MainAPI;
import io.reactivex.Observable;

/*分类列表*/
public class SubjectProjectDataProvider extends ProjectDataProvider implements Parcelable {
    private String mClassId;

    public SubjectProjectDataProvider(){
        mEmptyHint= WordUtil.getString(R.string.no_about_course);
    }
    protected SubjectProjectDataProvider(Parcel in) {
        super(in);
        mClassId = in.readString();
    }
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest,flags);
        dest.writeString(mClassId);
    }
    @Override
    public int describeContents() {
        return 0;
    }
    public static final Creator<SubjectProjectDataProvider> CREATOR = new Creator<SubjectProjectDataProvider>() {
        @Override
        public SubjectProjectDataProvider createFromParcel(Parcel in) {
            return new SubjectProjectDataProvider(in);
        }
        @Override
        public SubjectProjectDataProvider[] newArray(int size) {
            return new SubjectProjectDataProvider[size];
        }
    };
    @Override
    public Observable<Data<JSONObject>> getData(int p) {
        return MainAPI.getClassCourse(mClassId,p);
    }
    public String getClassId() {
        return mClassId;
    }

    public void setClassId(String classId) {
        mClassId = classId;
    }
}
