package com.wanyue.main.api.project;

import android.os.Parcel;
import android.os.Parcelable;

import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.server.entity.Data;
import com.wanyue.inside.busniess.InsideConstants;
import com.wanyue.main.api.MainAPI;
import com.wanyue.main.bean.SectionProjectBean;

import io.reactivex.Observable;

/*首页更多跳转*/
public class HomeMoreProjectDataProvider  extends ProjectDataProvider implements Parcelable {
    private int type;
    public HomeMoreProjectDataProvider(){

    }

    @Override
    public Observable<Data<JSONObject>> getData(int p) {
        if(type== SectionProjectBean.HEAD_ID_PACKGE){
            return MainAPI.getPackgeList(p);
        }else{
          return MainAPI.getHomeMoreList(type,p);
        }

    }

    protected HomeMoreProjectDataProvider(Parcel in) {
        type = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(type);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static final Creator<HomeMoreProjectDataProvider> CREATOR = new Creator<HomeMoreProjectDataProvider>() {
        @Override
        public HomeMoreProjectDataProvider createFromParcel(Parcel in) {
            return new HomeMoreProjectDataProvider(in);
        }
        @Override
        public HomeMoreProjectDataProvider[] newArray(int size) {
            return new HomeMoreProjectDataProvider[size];
        }
    };
}
