package com.wanyue.main.api;

import android.text.TextUtils;

import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.bean.UserBean;
import com.wanyue.common.http.HttpCallback;
import com.wanyue.common.http.HttpClient;
import com.wanyue.common.mob.LoginData;
import com.wanyue.common.server.MapBuilder;
import com.wanyue.common.server.RequestFactory;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.utils.MD5Util;
import com.wanyue.common.utils.StringUtil;
import com.wanyue.common.utils.ToastUtil;
import com.wanyue.inside.bean.CourseBean;
import com.wanyue.inside.bean.LecturerBean;
import com.wanyue.inside.bean.ProjectBean;
import com.wanyue.inside.busniess.InsideConstants;
import com.wanyue.inside.busniess.data.ProjectDataHelper;
import com.wanyue.main.bean.NoticeBean;
import com.wanyue.main.bean.StudyStageBean;
import com.wanyue.main.bean.StudyStageSectionBean;
import com.wanyue.main.bean.SubjectBean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;

public class MainAPI {

    /*获取用户基本信息*/
    public static Observable<LecturerBean> getBaseInfo() {
        Map<String,Object>map= MapBuilder.factory().addBaseParm().build();
        return RequestFactory.getRequestManager().valueGet("User.getBaseInfo",map,LecturerBean.class,false).
                doOnNext(new Consumer<UserBean>() {  //doNext的意思是在接口回调的之前进行一些处理
                    @Override
                 public void accept(UserBean userBean) throws Exception {
                        CommonAppConfig.setUserBean(userBean);
                 }
            });
    }


    /*获取套餐列表*/
    public static  Observable<Data<JSONObject>>getPackgeList(int p){
        Map<String,Object> parm= MapBuilder.factory()
                .put("gradeid", CommonAppConfig.getGradeId())
                .put("p",p)
                .build();
        return RequestFactory.getRequestManager().originalRequest("Package.GetList",parm);
    }


    /*相关讲师*/
    public static Observable<List<UserBean>> getAboutLecture(String keyword,int p){
        Map<String,Object>parm= MapBuilder.factory()
                .put("p",p)
                .put("keyword",keyword)
                .build();
        return RequestFactory.getRequestManager().get("Teacher.Search",parm, UserBean.class,false);
    }


    /*关注讲师*/
    public static Observable<List<UserBean>> getFollowLecture(int p){
        Map<String,Object>parm= MapBuilder.factory()
                .put("p",p)
                .build();
        return RequestFactory.getRequestManager().get("User.GetFollow",parm, UserBean.class,false);
    }

    /*获取我的学员接口*/
    public static Observable<List<UserBean>> getStudentFans(String touid,int p){
        Map<String,Object>parm= MapBuilder.factory()
                .put("p",p)
                .put("touid",touid)
                .build();
        return RequestFactory.getRequestManager().get("User.GetFans",parm, UserBean.class,false);
    }

    /*更新用户信息*/
    public static Observable<Boolean> updateUserInfo(String field) {
        Map<String,Object>map= MapBuilder.factory().addBaseParm().build();
        map.put("fields",field);
        return RequestFactory.getRequestManager().commit("User.UpUserInfo",map,true);
    }

    /*意见反馈*/
    public static Observable<Boolean> feedBack(String thumb,String content) {
        Map<String,Object>map= MapBuilder.factory().addBaseParm().build();
        map.put("thumb",thumb);
        map.put("content",content);
        return RequestFactory.getRequestManager().commit("Feedback.Add",map,true);
    }



    /*密码登录*/
    public static Observable<Data<JSONObject>> loginByPassward(String phone,String pwd){
        Map<String,Object>parm= MapBuilder.factory().
                put("username",phone)
                .put("pass",pwd)
             //   .put("pushid", ImPushUtil.getInstance().getPushID())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Login.Login",parm);
    }


    /*三方登录*/
    public static Observable<Data<JSONObject>> loginByThird(String openid, String nicename, String avatar, int flag){
        String sign = MD5Util.getMD5(StringUtil.contact("openid=", openid, "&type=", String.valueOf(flag), "&", HttpClient.SALT));
        Map<String,Object>parm= MapBuilder.factory()
                .put("openid", openid)
                .put("nicename", nicename)
                .put("avatar", avatar)
                .put("type", flag)
                .put("sign", sign)
               // .put("pushid", ImPushUtil.getInstance().getPushID())
                .build();

        return RequestFactory.getRequestManager().originalRequest("Login.LoginByThird",parm);
    }

    /*用户注册*/
    public static Observable<Data<JSONObject>> register(String username, String code, String pass) {
        Map<String,Object>parm= MapBuilder.factory().
                put("username",username)
                .put("code",code)
                .put("pass",pass)
               // .put("pushid", ImPushUtil.getInstance().getPushID())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Login.Reg",parm);
    }

    /*用户注册*/
    public static Observable<Boolean> findPwd(String username, String code, String pass) {
        Map<String,Object>parm= MapBuilder.factory().
                put("username",username)
                .put("code",code)
                .put("pass",pass)
                .build();
        return RequestFactory.getRequestManager().commit("Login.Forget",parm,true);
    }

    /**
     * 验证码登录接口
     */

    public static Observable<Data<JSONObject>> loginByCode(String phoneNum,String code) {
        Map<String,Object>parm= MapBuilder.factory()
                .put("username", phoneNum)
                .put("code", code)
                //.put("pushid", ImPushUtil.getInstance().getPushID())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Login.LoginByCode",parm);
    }

    /**
     * 获取验证码 0登录1注册2忘记密码
     */


    public static Observable<Data<JSONObject>> getCode(String phoneNum,int type) {
        String sign = MD5Util.getMD5(StringUtil.contact("account=", phoneNum, "&", HttpClient.SALT));
        Map<String,Object>parm= MapBuilder.factory()
                .put("account", phoneNum)
                .put("type", type)
                .put("sign", sign)
                .build();
        return RequestFactory.getRequestManager().originalRequest("Login.getCode",parm);
    }

    /*获取教师的课程*/
    public static Observable<Data<JSONObject>> getTeacherProjectList(int p,String touid) {
        Map<String,Object>parm= MapBuilder.factory()
                .put("p",p)
                .put("touid",touid)
                .put("gradeid",CommonAppConfig.getGradeId())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Course.GetTeacherCourse",parm);
    }


    /*获取课程分类*/
    public static Observable<List<SubjectBean>> getSubject() {
        Map<String,Object>parm= MapBuilder.factory()
                .build();
        return RequestFactory.getRequestManager().get("Course.GetClass",parm, SubjectBean.class,false);
    }


    /*获取主页数据*/
    public static Observable<Data<JSONObject>> getIndex(){
        Map<String,Object>parm= MapBuilder.factory()
               .put("gradeid",CommonAppConfig.getGradeId()).
                build();
        return RequestFactory.getRequestManager().originalRequest("Home.GetIndex",parm);
    }

    /*名师名课列表*/
    public static Observable<List<LecturerBean>> getTeacherList(int p) {
        Map<String,Object>parm= MapBuilder.factory()
                .put("p",p)
                .build();
        return RequestFactory.getRequestManager().get("Teacher.GetTeachers",parm, LecturerBean.class,false);
    }

    /*获取教师主页*/
    public static Observable<LecturerBean> getTeacherHome(String id){
        Map<String,Object>parm= MapBuilder.factory()
                .put("touid",id)
                .build();
        return RequestFactory.getRequestManager().valueGet("Teacher.GetHome",parm, LecturerBean.class,false);
    }


    /*获取首页搜索结果*/
    public static Observable<Data<JSONObject>>getHomeSearch(String keyword){
        Map<String,Object>parm= MapBuilder.factory()
                .put("keyword",keyword)
                .put("gradeid",CommonAppConfig.getGradeId())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Home.Search",parm);
    }

    /*获取class分类下课程*/
    public static Observable<Data<JSONObject>>getClassCourse(String classid,int p){
        Map<String,Object>parm= MapBuilder.factory()
                .put("classid",classid)
                .put("p",p)
                .put("gradeid",CommonAppConfig.getGradeId())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Course.GetClassCourse",parm);
    }

    /*获取首页更多的课程*/
    public static Observable<Data<JSONObject>>getHomeMoreList(int type,int p){
        Map<String,Object>parm= MapBuilder.factory()
                .put("type",type)
                .put("p",p)
                .put("gradeid",CommonAppConfig.getGradeId())
                .build();
        return RequestFactory.getRequestManager().originalRequest("Course.GetList",parm);
    }



    /*获取自己购买的课程*/
    public static Observable<Data<JSONObject>>getMyBuyCourseList(int p){
        Map<String,Object>parm= MapBuilder.factory()
                .put("p",p)
                .build();
        return RequestFactory.getRequestManager().originalRequest("Course.GetMyBuy",parm);
    }





}
