package com.wanyue.main.adapter;

import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.adapter.base.BaseRecyclerAdapter;
import com.wanyue.common.bean.UserBean;
import com.wanyue.main.R;
import java.util.List;

public class SimpleUserAdapter extends BaseRecyclerAdapter<UserBean,BaseReclyViewHolder> {
    private boolean mNeedShowArrow;
    public SimpleUserAdapter(List<UserBean> data) {
        super(data);
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_recly_simple_user;
    }

    @Override
    protected void convert(BaseReclyViewHolder helper, UserBean item) {
        helper.setImageUrl(item.getAvatar(),R.id.img_avator);
        helper.setText(R.id.tv_name,item.getUserNiceName());
        helper.setVisible(R.id.img_arrow,mNeedShowArrow);
    }

    @Override
    public void setData(List<UserBean> data) {
        mNeedShowArrow=getOnItemClickListener()!=null;
        super.setData(data);
    }

    @Override
    public void appendData(List<UserBean> data) {
        mNeedShowArrow=getOnItemClickListener()!=null;
        super.appendData(data);
    }
}
