package com.wanyue.main.adapter;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.wanyue.common.adapter.base.BaseMutiRecyclerAdapter;
import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.utils.ResourceUtil;
import com.wanyue.detail.adapter.ProjectAdapterHelper;
import com.wanyue.inside.bean.ProjectBean;
import com.wanyue.inside.busniess.InsideConstants;
import com.wanyue.main.R;
import java.util.List;

public class ProjectListAdapter extends BaseMutiRecyclerAdapter<ProjectBean, BaseReclyViewHolder> {
    private ProjectAdapterHelper mProjectAdapterHelper;

    public ProjectListAdapter(List<ProjectBean> data) {
        super(data);
        addItemType(InsideConstants.TYPE_PROJECT_COURSE, R.layout.item_shader_relcy_project_course);
        addItemType(InsideConstants.TYPE_PROJECT_LIVE,R.layout.item_shader_relcy_project_live);
        addItemType(InsideConstants.TYPE_PROJECT_CAMERA,R.layout.item_shader_relcy_project_live);
        addItemType(InsideConstants.TYPE_PROJECT_CONTENT,R.layout.item_shader_recly_project_content);
        addItemType(InsideConstants.TYPE_PROJECT_PACKGE,R.layout.item_shader_relcy_project_packge);
    }


    @Override
    protected void convert(BaseReclyViewHolder helper, ProjectBean item) {
        View itemView=helper.getView(R.id.item);
        if(itemView!=null&&itemView.getBackground()==null){
           itemView.setBackground(ResourceUtil.getDrawable(R.drawable.press_raidius_5_color_white,false));
        }
        if(mProjectAdapterHelper==null){
           mProjectAdapterHelper=new ProjectAdapterHelper();
        }
        mProjectAdapterHelper.convert(helper,item);
    }

}
