package com.wanyue.main.adapter;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import android.view.View;

import com.wanyue.common.custom.BigPageTitleView;
import com.wanyue.main.R;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.CommonNavigatorAdapter;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerTitleView;

public class MainNavigatorAdapter extends CommonNavigatorAdapter {
    private String[]mTitle;
    private Context mContext;
    private ViewPager mViewPager;

    public MainNavigatorAdapter(@Nullable String[] title,Context context,ViewPager viewPager) {
        mTitle = title;
        mContext=context;
        mViewPager=viewPager;
    }

    @Override
    public int getCount() {
        return mTitle.length;
    }

    @Override
    public IPagerTitleView getTitleView(Context context,final int index) {
        BigPageTitleView simplePagerTitleView = new BigPageTitleView(context);
        simplePagerTitleView.setNormalColor(ContextCompat.getColor(mContext, R.color.textColor));
        simplePagerTitleView.setSelectedColor(ContextCompat.getColor(mContext, R.color.textColor));
        simplePagerTitleView.setText(mTitle[index]);

        simplePagerTitleView.setTextSizeDp(15);
        simplePagerTitleView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mViewPager != null) {
                    mViewPager.setCurrentItem(index,false);

                }
            }
        });
        return simplePagerTitleView;
    }

    @Override
    public IPagerIndicator getIndicator(Context context) {
      /*  LinePagerIndicator linePagerIndicator = new LinePagerIndicator(context);
        linePagerIndicator.setMode(LinePagerIndicator.MODE_EXACTLY);
        linePagerIndicator.setXOffset(DpUtil.dp2px(10));
        linePagerIndicator.setLineWidth(DpUtil.dp2px(15));
        linePagerIndicator.setRoundRadius(DpUtil.dp2px(2));
        linePagerIndicator.setColors(ContextCompat.getColor(mContext, R.color.global));*/
        return null;
    }
}
