package com.wanyue.main.adapter;

import android.view.View;
import android.view.ViewGroup;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.adapter.base.BaseRecyclerAdapter;
import com.wanyue.common.utils.DpUtil;
import com.wanyue.main.R;
import com.wanyue.main.bean.SubjectBean;
import java.util.List;


public class HomeSubjectAdapter extends BaseRecyclerAdapter<SubjectBean, BaseReclyViewHolder> {
    private int mItemSize;

    public HomeSubjectAdapter(List<SubjectBean> data) {
        super(data);
        mItemSize= CommonAppConfig.getWindowWidth()/5- DpUtil.dp2px(20);
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_main_home_subject;
    }

    @Override
    protected void convert(BaseReclyViewHolder helper, SubjectBean item) {
        View view=helper.getView(R.id.item);
        ViewGroup.LayoutParams params=view.getLayoutParams();
        params.width=mItemSize;
        helper.setText(R.id.name,item.getName());
        helper.setImageUrl(item.getThumb(),R.id.thumb);
    }

}
