package com.wanyue.main.adapter;

import android.view.View;
import com.wanyue.common.adapter.base.BaseMutiRecyclerAdapter;
import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.custom.DrawableTextView;
import com.wanyue.common.custom.ShadowContainer;
import com.wanyue.common.utils.ResourceUtil;
import com.wanyue.detail.adapter.ProjectAdapterHelper;
import com.wanyue.main.R;
import com.wanyue.main.bean.SectionProjectBean;
import java.util.List;

public class HomePageAdapter extends BaseMutiRecyclerAdapter<SectionProjectBean, BaseReclyViewHolder> {
    private ProjectAdapterHelper mProjectAdapterHelper;

    public HomePageAdapter(List<SectionProjectBean> data) {
        super(data);
        addItemType(SectionProjectBean.TYPE_HEAD, R.layout.item_recly_head_home_page);
        addItemType(SectionProjectBean.TYPE_PROJECT_COURSE,R.layout.item_shader_relcy_project_course);
        addItemType(SectionProjectBean.TYPE_PROJECT_LIVE,R.layout.item_shader_relcy_project_live);
        addItemType(SectionProjectBean.TYPE_PROJECT_CAMERA,R.layout.item_shader_relcy_project_live);
        addItemType(SectionProjectBean.TYPE_PROJECT_CONTENT,R.layout.item_shader_recly_project_content);
        addItemType(SectionProjectBean.TYPE_PROJECT_PACKGE,R.layout.item_shader_relcy_project_packge);
    }

    @Override
    protected void convert(BaseReclyViewHolder helper, SectionProjectBean item) {
            switch (item.getItemType()){
                case SectionProjectBean.TYPE_HEAD:
                    convertHead(helper,item);
                    break;
                default:
                    ShadowContainer container=helper.getView(R.id.container);
                    if(container!=null){
                        int drawId=item.backgroudDrawableId;
                        if(drawId==R.drawable.press_bg_top_border_press){
                           container.setHideBottom(true);
                           container.setHideTop(false);
                        } else if(drawId==R.drawable.press_bg_bottom_border_press){
                           container.setHideBottom(false);
                           container.setHideTop(true);
                        }else if(drawId==R.drawable.press_left_right_border_press){
                           container.setHideBottom(true);
                           container.setHideTop(true);
                        }else{
                           container.setHideBottom(false);
                           container.setHideTop(false);
                        }
                    }
                   View itemView=helper.getView(R.id.item);
                   int tag= getIntTag(itemView);
                    int id=item.backgroudDrawableId;
                   if(itemView!=null&&(tag!=id||itemView.getBackground()==null)){
                      itemView.setTag(id);
                      itemView.setBackground(ResourceUtil.getDrawable(id,false));
                   }
                    if(mProjectAdapterHelper==null){
                        mProjectAdapterHelper=new ProjectAdapterHelper();
                    }
                    mProjectAdapterHelper.convert(helper,item.t);
            }
    }

    private int getIntTag(View itemView) {
        Object tag=itemView.getTag();
        if(tag!=null&&tag instanceof Integer ){
            return (Integer) tag;
        }
        return 0;
    }

    private void convertHead(BaseReclyViewHolder helper, SectionProjectBean item) {
        helper.setText(R.id.tv_head_title,item.header);
        DrawableTextView drawableTextView=helper.getView(R.id.tv_more);
        if(drawableTextView!=null&&drawableTextView.getRightDrawable()==null){
           drawableTextView.setRightDrawable(ResourceUtil.getDrawable(R.mipmap.icon_arrow_right,true));
           drawableTextView.setObj(R.mipmap.icon_arrow_right);
        }
    }
}
