package com.wanyue.main.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.adapter.base.BaseRecyclerAdapter;
import com.wanyue.inside.busniess.ui.UIFactory;
import com.wanyue.main.R;
import com.wanyue.inside.bean.LecturerBean;

import java.util.List;

public class FamousTeacherSimpleAdapter extends BaseRecyclerAdapter<LecturerBean, BaseReclyViewHolder> {


    public FamousTeacherSimpleAdapter(List<LecturerBean> data) {
        super(data);
    }
    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        final  Context context=recyclerView.getContext();
        setOnItemClickListener(new OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                final LecturerBean lecturerBean=mData.get(position);
                //TeacherHomeActivity.forward(context,lecturerBean.getId());
            }
        });

    }

    @Override
    public int getLayoutId() {
        return R.layout.item_recly_simple_fateacher;
    }
    @Override
    protected void convert(BaseReclyViewHolder helper, LecturerBean item) {
        TextView tvTag=helper.getView(R.id.tv_tag);
        helper.setText(R.id.tv_name,item.getUserNiceName());
        helper.setImageUrl(item.getAvatar(),R.id.img_avator);
        UIFactory.setTeacherTag(tvTag,item.getIdentitys());

    }
}
