package com.wanyue.inside.widet.linear;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RadioGroup;

public class PoolRadioGroup extends RadioGroupEx implements IListView{
    private ViewGroupLayoutBaseAdapter adapter;
    private BindAdapterHelper mBindAdapterHelper;

    public PoolRadioGroup(Context context) {
        super(context);
    }
    public PoolRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAdapter(ViewGroupLayoutBaseAdapter adapter) {
        this.adapter = adapter;
        if(adapter!= null){
           adapter.attach(this);
        }
        getBindAdapterHelper().setAdapter(adapter );
        // setAdapter 时添加 view
        bindView();
    }

    @Override
    public ViewGroup getGroup() {
        return this;
    }

    @Override
    public ViewGroupLayoutBaseAdapter getAdapter() {
        return adapter;
    }

    @Override
    public void bindView() {
        if (adapter == null) {
            return;
        }
        mBindAdapterHelper.bind();
    }

    public void setItemPadding(int itemPadding) {
        getBindAdapterHelper().setItemPadding(itemPadding);
    }

    public void setListPool(ListPool listPool) {
        getBindAdapterHelper().setListPool(listPool);
    }

    public void setReclyed(boolean reclyed) {
        getBindAdapterHelper().setReclyed(reclyed);
    }


    public BindAdapterHelper getBindAdapterHelper() {
        if(mBindAdapterHelper==null){
           mBindAdapterHelper=new BindAdapterHelper(this);
        }
        return mBindAdapterHelper;
    }
}
