package com.wanyue.inside.widet.linear;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.utils.DebugUtil;

public class BindAdapterHelper {
    private ViewGroupLayoutBaseAdapter adapter;
    private ListPool mListPool;
    private ViewGroup mLayout;
    private int itemPadding;
    private boolean reclyed=true;

    public BindAdapterHelper(ViewGroup viewGroup) {
        mLayout = viewGroup;
    }


    public void bind() {
        if(mListPool==null){
            noPoolSet();
        }else{
            havePoolSet();
        }
    }

    private void havePoolSet() {
        int adapterCount=adapter.getCount();
        int viewChildCount=mLayout.getChildCount();
        int offectSize=adapterCount-viewChildCount;
        if(adapterCount==0&&viewChildCount==0){
            return;
        }
        if(viewChildCount>adapterCount){
            int absSize= Math.abs(offectSize);
            for(int index=0;index<absSize;index++){
                View view= mLayout.getChildAt(viewChildCount-(index+1));
                mListPool.removeToParent(view);
                BaseReclyViewHolder baseReclyViewHolder=adapter.getAndRemoveViewHolder(view);
                if(baseReclyViewHolder==null){
                    DebugUtil.sendException("BaseReclyViewHolder not Null");
                    mListPool.removeToParent(view);
                }else{
                    if(reclyed){
                       mListPool.put(view,baseReclyViewHolder);
                    }
                }
            }
        } else if(adapterCount>viewChildCount){
            for(int i=0;i<offectSize;i++){
                BaseReclyViewHolder baseReclyViewHolder=mListPool.getCacheHolder();
                if(baseReclyViewHolder==null||baseReclyViewHolder.convertView==null){
                    View v = adapter.getView(i);
                    mLayout.addView(v);
                }else{
                    View view=baseReclyViewHolder.convertView;
                    mLayout.addView(view);
                    adapter.putViewHolder(view,baseReclyViewHolder);
                }
            }
        }
        for(int i = 0; i < adapterCount; i++){
            View v = mLayout.getChildAt(i);
            adapter.bindView(v,i,adapter.getItem(i));
            setChildViewPadding(v);
        }
        adapter.convertCompelte();
    }

    private void setChildViewPadding(View v) {
        if(mLayout instanceof LinearLayout){
            LinearLayout.LayoutParams layoutParams= (LinearLayout.LayoutParams) v.getLayoutParams();
            LinearLayout linearLayout= (LinearLayout) mLayout;
            int orientation=linearLayout.getOrientation();
            if(orientation==LinearLayout.VERTICAL){
            }else if(orientation==LinearLayout.HORIZONTAL){
                layoutParams.rightMargin=itemPadding;
            }
        }


    }

    private void noPoolSet() {
        int adapterCount=adapter.getCount();
        mLayout.removeAllViews();
        for (int i = 0; i < adapterCount; i++) {
            final View v = adapter.getView(i);
            adapter.bindView(v,i,adapter.getItem(i));
            setChildViewPadding(v);
        }
        adapter.convertCompelte();
    }




    public void setReclyed(boolean reclyed) {
        this.reclyed = reclyed;
    }

    public void setItemPadding(int itemPadding) {
        this.itemPadding=itemPadding;
    }

    public void setAdapter(ViewGroupLayoutBaseAdapter adapter) {
        this.adapter=adapter;
    }

    public void setListPool(ListPool listPool) {
        mListPool=listPool;
    }
}
