package com.wanyue.inside.widet;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import android.text.style.ImageSpan;

public class CenteredImageSpan extends ImageSpan {


    /**
     * @param b
     * @deprecated Use  instead.
     */
    public CenteredImageSpan(@NonNull Bitmap b) {
        super(b);
    }

    /**
     * Constructs an {@link ImageSpan} from a drawable with the default
     * alignment .
     *
     * @param drawable drawable to be rendered
     */
    public CenteredImageSpan(@NonNull Drawable drawable) {
        super(drawable);
    }

    /**
     * Constructs an {@link ImageSpan} from a drawable and a vertical alignment.
     *
     * @param drawable          drawable to be rendered
     * @param verticalAlignment one of  or
     *
     */
    public CenteredImageSpan(@NonNull Drawable drawable, int verticalAlignment) {
        super(drawable, verticalAlignment);
    }

    @Override
    public void draw(@NonNull Canvas canvas, CharSequence text,
                     int start, int end, float x,
                     int top, int y, int bottom, @NonNull Paint paint) {
        // image to draw
        Drawable b = getDrawable();
        // font metrics of text to be replaced
        Paint.FontMetricsInt fm = paint.getFontMetricsInt();
        int transY = (y + fm.descent + y + fm.ascent) / 2
                - b.getBounds().bottom / 2;

        canvas.save();
        canvas.translate(x, transY);
        b.draw(canvas);
        canvas.restore();
    }
}