package com.wanyue.inside.busniess.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.CommonAppContext;
import com.wanyue.common.custom.NoScrollWebView;
import com.wanyue.common.utils.BitmapUtil;
import com.wanyue.common.utils.DpUtil;
import com.wanyue.common.utils.L;
import com.wanyue.common.utils.ResourceUtil;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.inside.R;
import com.wanyue.inside.bean.Identity;
import com.wanyue.inside.busniess.InsideConstants;
import java.text.DecimalFormat;


public class UIFactory {
    /*设置教师标签*/
    public static void setTeacherTag(TextView textView, Identity[] identitys,int index){
        if(textView==null){
            return;
        }
        if(identitys==null||identitys.length<=index){
            textView.setVisibility(View.INVISIBLE);
            return;
        }else{
            textView.setVisibility(View.VISIBLE);
        }
        Identity identity=identitys[0];
        String textColor=identity.getColor();
        if(!TextUtils.isEmpty(textColor)){
           int color= Color.parseColor(textColor);
           Drawable drawable=textView.getBackground();
           if(drawable!=null){
             drawable.setTint(color);
             textView.setBackground(drawable);
           }else{
             textView.setBackgroundColor(color);
           }
        }
        textView.setPadding(10,3,10,3);
        textView.setGravity(Gravity.CENTER);
        textView.setText(identity.getName());

    }
    public static void setTeacherTag(TextView textView, Identity[] identitys){
        setTeacherTag(textView,identitys,0);
    }


    private static int colorPwd=-1;
    private static int colorFree=-1;
    private static int colorCharge=-1;

    /*获取价格标签颜色*/
    public static int getPriceViewColor(int payType){
        switch (payType){
            case InsideConstants.TYPE_PAY_PWD:
                if(colorPwd==-1){
                   colorPwd= ResourceUtil.getColor(CommonAppContext.sInstance,R.color.blue2);
                }
                return colorPwd ;
            case InsideConstants.TYPE_PAY_FREE:
                if(colorFree==-1){
                   colorFree= ResourceUtil.getColor(CommonAppContext.sInstance,R.color.global);
                }
                return colorFree ;
        }
        if(colorCharge==-1){
           colorCharge= ResourceUtil.getColor(CommonAppContext.sInstance,R.color.red20);
        }
        return colorCharge ;
    }


    public static int getLessonTagName(int contenType){
        switch (contenType){
            case InsideConstants.LESSON_TYPE_COTENT_IMG_TEXT:
                return R.string.img_text ;
            case InsideConstants.LESSON_TYPE_COTENT_VIDEO:
                return R.string.video ;
            case InsideConstants.LESSON_TYPE_COTENT_AUDIO:
                return R.string.audio ;
            default:
                return R.string.live;
        }
    }
    public static String getLiveTypeName(int contenType){
        switch (contenType){
            case InsideConstants.LESSON_TYPE_LIVE_PPT:
                return WordUtil.getString(R.string.ppt);
            case InsideConstants.LESSON_TYPE_LIVE_AUDIO:
                return WordUtil.getString(R.string.audio);
            case InsideConstants.LESSON_TYPE_LIVE_VIDEO:
                return WordUtil.getString(R.string.video);
            case InsideConstants.LESSON_TYPE_LIVE_TEACHING:
                return WordUtil.getString(R.string.teaching);
            default:
                return null;
        }
    }

    /*获取内容类型*/
    public static int getContentName(int contenType){
        switch (contenType){
            case InsideConstants.CONTENT_IMAGE_TEXT:
                return R.string.img_text ;
            case InsideConstants.CONTENT_VIDEO:
                return R.string.video ;
            case InsideConstants.CONTENT_AUDIO:
                return R.string.audio ;
        }
        return R.string.empty_tag ;
    }

    private static String mAttentionedString;
    private static String mNoAttentionedString;
    private static int mAttentionedColor;
    private static int mNoAttentionedolor;

    /*设置关注label的样式*/
    public static void setFollowTextView(TextView textView,int isFollow){
        if(textView==null){
            return;
        }
        if(mAttentionedString==null){
           mAttentionedString= WordUtil.getString(R.string.following);
        }
        if(mNoAttentionedString==null){
           mNoAttentionedString= WordUtil.getString(R.string.follow_add);
        }
        if(mAttentionedColor==0){
            mAttentionedColor= ResourceUtil.getColor(CommonAppContext.sInstance,R.color.gray1);
        }
        if(mNoAttentionedolor==0){
            mNoAttentionedolor= ResourceUtil.getColor(CommonAppContext.sInstance,R.color.global);
        }
        if(isFollow==0){
            textView.setText(mNoAttentionedString);
            textView.setTextColor(mNoAttentionedolor);
        }else{
            textView.setText(mAttentionedString);
            textView.setTextColor(mAttentionedColor);
        }
    }

    /*生成webview*/
    public static WebView createWebView(Context context){
        NoScrollWebView webView=new NoScrollWebView(context);
        settingWebView(webView);
        return webView;
    }

    public static void settingWebView(final WebView webView) {
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);//设置能够解析Javascript
        webSettings.setDomStorageEnabled(true);//设置适应Html5的一些方法
        webView.setWebChromeClient(new WebChromeClient());
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setAppCacheEnabled(false);
        webSettings.setDatabaseEnabled(false);

        webView.setWebViewClient(new WebViewClient(){
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
//                return super.shouldOverrideUrlLoading(view, url);
                webView.loadUrl(url);
                return true;
            }
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    view.loadUrl(request.getUrl().toString());
                } else {
                    view.loadUrl(request.toString());
                }
                return true;
            }
            @Override
            public void onPageFinished(final WebView view, String url) {
                view.loadUrl("javascript:window.APP.resize(document.body.getBoundingClientRect().height)");
                final ViewGroup.LayoutParams  params =  webView.getLayoutParams();
                params.width= CommonAppConfig.getWindowWidth();
                int contentHeight=view.getContentHeight();
                if(contentHeight<100){
                   contentHeight= DpUtil.dp2px(230);
                }
                L.e("contentHeight=="+contentHeight);
                params.height= contentHeight;

                webView.setLayoutParams(params);
                if(view instanceof NoScrollWebView){
                   NoScrollWebView noScrollWebView= (NoScrollWebView) view;
                   noScrollWebView.setMaxHeight(contentHeight);
                }

            }
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
            }
        });
        webView.getSettings().setJavaScriptEnabled(true);
    }

    public static CharSequence getTypeSPanTag(CharSequence content,String tag,int textSize,int id){
        SpannableStringBuilder ssb = new SpannableStringBuilder(content+"\t");
        SpannableString spannableString=new SpannableString("\t \t \t");
        int dpSize= DpUtil.dp2px(textSize);
        Drawable drawable= BitmapUtil.zoomDrawable(CommonAppContext.sInstance.getResources(),id, dpSize);
        L.e("drawable width=="+drawable.getIntrinsicWidth());
        L.e("drawable height=="+drawable.getIntrinsicHeight());
        ImageSpan imageSpan = new ImageSpan(drawable,ImageSpan.ALIGN_BASELINE);
        spannableString.setSpan(imageSpan,1,spannableString.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        ssb.append(spannableString);
        return ssb;
    }


    public static String appendUnit(double price){
       return "¥"+price;
    }

    /*设置textview*/
    public static void setTextCount(TextView textView,int count){
        if(textView==null){
            return;
        }
        textView.setText(Integer.toString(count));
        if(count<=0){
           textView.setVisibility(View.INVISIBLE);
        }else{
           textView.setVisibility(View.VISIBLE);
        }
    }
    private static DecimalFormat df;

    public static String getFormatPrice(double price) {
        if(price==0){
            return "0";
        }

        if(df==null){
           df = new DecimalFormat("#0.00");
        }
        String formatPrice="¥"+df.format(price);
        return formatPrice;
    }
}
