package com.wanyue.inside.busniess.ui;

import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import java.util.ArrayList;
import java.util.List;

public  class RadioGroupHelper<T extends IChecker> {
    private List<RadioButton>mRadioButtonList;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private CompoundButton mCheckCompoundButton;
    private OnDataChangeListner mOnDataChangeListner;

    public RadioGroupHelper(){
        mChildOnCheckedChangeListener=new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                 if(isChecked&&(buttonView!=mCheckCompoundButton)){
                     if(mCheckCompoundButton!=null){
                        T data=getBundData(mCheckCompoundButton);
                        if(mOnDataChangeListner!=null){
                          mOnDataChangeListner.onUnCheckedData(data);
                          mCheckCompoundButton.setChecked(false);
                        }
                     }
                     mCheckCompoundButton=buttonView;
                     if(mOnDataChangeListner!=null){
                         T data=getBundData(mCheckCompoundButton);
                         if(!data.isChecked()){
                           mOnDataChangeListner.onCheckedData(data);
                         }

                     }
                 }
            }
        };
    }

    private T getBundData(CompoundButton checkCompoundButton) {
        if(checkCompoundButton==null){
            return null;
        }
        Object object=mCheckCompoundButton.getTag();
        if(object!=null){
            return (T) object;
        }
        return null;
    }

    private View.OnClickListener mOnClickListener;
    public void addRadioButton(RadioButton radioButton){
        if(mRadioButtonList==null){
           mRadioButtonList=new ArrayList<>();
        }
        if(mRadioButtonList==null||radioButton==null||mRadioButtonList.contains(radioButton)){
            return;
        }
        radioButton.setOnCheckedChangeListener(mChildOnCheckedChangeListener);

        if(mOnItemOnCLickListner!=null){
            if(mOnClickListener==null){
               mOnClickListener =new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                    if(mOnItemOnCLickListner!=null){
                       mOnItemOnCLickListner.onItemClick(v);
                    }
                }
              };
            }
            radioButton.setOnClickListener(mOnClickListener);
        }

        mRadioButtonList.add(radioButton);
    }

    private OnItemOnCLickListner mOnItemOnCLickListner;
    public void setOnItemOnCLickListner(OnItemOnCLickListner itemListner){
        mOnItemOnCLickListner=itemListner;
    }

    public void setOnDataChangeListner(OnDataChangeListner onDataChangeListner) {
        mOnDataChangeListner = onDataChangeListner;
    }

    public interface OnDataChangeListner<T>{
        public void onCheckedData(T t);
        public void onUnCheckedData(T t);
    }

    public static interface OnItemOnCLickListner{
        public void onItemClick(View view);
    }



}
