package com.wanyue.inside.busniess.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wanyue.inside.bean.ContentBean;
import com.wanyue.inside.bean.CourseBean;
import com.wanyue.inside.bean.LiveBean;
import com.wanyue.inside.bean.PackgeBean;
import com.wanyue.inside.bean.ProjectBean;
import com.wanyue.inside.busniess.InsideConstants;
import java.util.ArrayList;
import java.util.List;
import io.reactivex.Observable;

public class ProjectDataHelper {

  public static List<ProjectBean>formatProject(List<JSONObject> jsonObjectList){
      if(jsonObjectList==null){
          return new ArrayList<>(0);
      }
      int size=jsonObjectList.size();
      List<ProjectBean>list=new ArrayList<>(jsonObjectList.size());
      for(int i=0;i<size;i++){
         JSONObject jsonObject=  jsonObjectList.get(i);
         ProjectBean projectBean=valueProject(jsonObject);
         if(projectBean!=null){
            list.add(projectBean);
         }
      }
      return list;
  }

    public static List<ProjectBean>formatProject(JSONArray jsonArray){
        if(jsonArray==null){
            return new ArrayList<>(0);
        }
        int size=jsonArray.size();
        List<ProjectBean>list=new ArrayList<>(jsonArray.size());
        for(int i=0;i<size;i++){
            JSONObject jsonObject=  jsonArray.getJSONObject(i);
            ProjectBean projectBean=valueProject(jsonObject);
            if(projectBean!=null){
                list.add(projectBean);
            }
        }
        return list;
    }

    public static ProjectBean valueProject(JSONObject jsonObject) {
        Integer projectType=jsonObject.getInteger("sort");
        ProjectBean projectBean=null;

        if(projectType==null){
           projectType=InsideConstants.TYPE_PROJECT_PACKGE;
        }

        switch (projectType){
            case InsideConstants.TYPE_PROJECT_CONTENT:
                projectBean=jsonObject.toJavaObject(ContentBean.class);
                break;
            case InsideConstants.TYPE_PROJECT_COURSE:
                projectBean=jsonObject.toJavaObject(CourseBean.class);
                break;
            case InsideConstants.TYPE_PROJECT_CAMERA:
            case InsideConstants.TYPE_PROJECT_LIVE:
                projectBean=jsonObject.toJavaObject(LiveBean.class);
                break;
            case InsideConstants.TYPE_PROJECT_PACKGE:
                projectBean=jsonObject.toJavaObject(PackgeBean.class);
                projectBean.setProjectType(projectType);
                break;
            default:
                break;
        }
        return projectBean;
    }


}
