package com.wanyue.inside.bean;


import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.annotation.JSONField;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.google.gson.annotations.SerializedName;
import com.wanyue.common.utils.StringUtil;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.inside.R;
import com.wanyue.inside.busniess.InsideConstants;
import java.util.List;

/*
  @TODO 因为有多种类型的project(课程,直播,内容),避免相互之间的属性污染,进行了抽象
* @TODO 但是注意json序列化解析的时候,会统一处理成project所以一定要进行相关解析转型,
* @TODO com.wanyue.inside.busniess.data.ProjectDataHelper 在这个类里面进行了分类型解析,不可避免的牺牲一部分性能
* @TODO 但是结构上更加清晰,不会出现在内容里面会含有直播的相关字段,有利于拓展
 *
 */

public class ProjectBean implements MultiItemEntity, Parcelable {
    private String id;

    @SerializedName("sort")
    @JSONField(name="sort")
    private int projectType;

    @SerializedName("payval")
    @JSONField(name="payval")
    protected String price;

    @SerializedName("name")
    @JSONField(name="name")
    private String title;

    private String thumb;

    @SerializedName("views")
    @JSONField(name="views")
    private String studyCount;

    @SerializedName("des")
    @JSONField(name="des")
    private String introduce;


    @SerializedName("ifbuy")
    @JSONField(name="ifbuy")
    private int isBuy2;//这两个都是后台返回的，当其中一个返回当是1就好



    @SerializedName("isbuy")
    @JSONField(name="isbuy")
    private int isBuy;//这个是实际判断

    protected int paytype;

    @SerializedName("userinfo")
    @JSONField(name="userinfo")
    protected LecturerBean lecturerBean;

    @SerializedName("avatar")
    @JSONField(name="avatar")
    protected String lecturerAvatar;

    @SerializedName("uid")
    @JSONField(name="uid")
    protected String lecturerUid;

    @SerializedName("user_nickname")
    @JSONField(name="user_nickname")
    protected String lecturerNickName;

    private float star;

    @SerializedName("lessionid")
    @JSONField(name="lessionid")
    protected String lessionId;
    protected String handlePrice;

    @SerializedName("ismaterial")
    @JSONField(name="ismaterial")
    private int isMaterial; //是否有教材

    private int ispack;
    private int iscart;

    private List<LecturerBean> tutor;

    public ProjectBean(){

    }

    protected ProjectBean(Parcel in) {
        id = in.readString();
        projectType = in.readInt();
        price = in.readString();
        title = in.readString();
        thumb = in.readString();
        studyCount = in.readString();
        introduce = in.readString();
        isBuy = in.readInt();
        paytype = in.readInt();
        lecturerBean = in.readParcelable(LecturerBean.class.getClassLoader());
        lecturerAvatar = in.readString();
        lecturerUid = in.readString();
        lecturerNickName = in.readString();
        lessionId= in.readString();
        isMaterial=in.readInt();
        iscart=in.readInt();
        tutor = in.createTypedArrayList(LecturerBean.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(id);
        dest.writeInt(projectType);
        dest.writeString(price);
        dest.writeString(title);
        dest.writeString(thumb);
        dest.writeString(studyCount);
        dest.writeString(introduce);
        dest.writeInt(isBuy);
        dest.writeInt(paytype);
        dest.writeParcelable(lecturerBean, flags);
        dest.writeString(lecturerAvatar);
        dest.writeString(lecturerUid);
        dest.writeString(lecturerNickName);
        dest.writeString(lessionId);
        dest.writeInt(isMaterial);
        dest.writeInt(iscart);
        dest.writeTypedList(tutor);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ProjectBean> CREATOR = new Creator<ProjectBean>() {
        @Override
        public ProjectBean createFromParcel(Parcel in) {
            return new ProjectBean(in);
        }

        @Override
        public ProjectBean[] newArray(int size) {
            return new ProjectBean[size];
        }
    };

    public int getProjectType() {
        return projectType;
    }


    public void setProjectType(int projectType) {
        this.projectType = projectType;
    }

    public String getPrice() {
        return price;
    }


    public double getNumberPrice() {
        try {
            return Double.parseDouble(price);
        }catch (Exception e){
            e.printStackTrace();
        }
        return 0;
    }

    /*获取处理后的价格标签*/
    public String getHandlePrice(){
        if(!TextUtils.isEmpty(handlePrice)){
            return handlePrice;
        }
        if(paytype==InsideConstants.TYPE_PAY_CHARGE&&ifBuy()){
            handlePrice= WordUtil.getString(R.string.buyed);
        }else if(paytype==InsideConstants.TYPE_PAY_CHARGE&&!ifBuy()){
            handlePrice= "¥"+price;
        }else{
            handlePrice=price;
        }
        return handlePrice;
    }





    public void setPrice(String price) {
        this.price = price;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public String getThumb() {
        return thumb;
    }

    public void setThumb(String thumb) {
        this.thumb = thumb;
    }
    public LecturerBean getLecturerBean() {
        return lecturerBean;
    }
    public void setLecturerBean(LecturerBean lecturerBean) {
        this.lecturerBean = lecturerBean;
    }

    public String getStudyCount() {
        return studyCount;
    }

    public void setStudyCount(String studyCount) {
        this.studyCount = studyCount;
    }

    @Override
    public int getItemType() {
        return projectType;
    }


    public List<LecturerBean> getTutor() {
        return tutor;
    }

    public void setTutor(List<LecturerBean> tutor) {
        this.tutor = tutor;
    }


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public int getPaytype() {
        return paytype;
    }

    public void setPaytype(int paytype) {
        this.paytype = paytype;
    }

    public String getIntroduce() {
        return introduce;
    }

    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }


    public String getLecturerAvatar() {
        return lecturerAvatar;
    }

    public void setLecturerAvatar(String lecturerAvatar) {
        this.lecturerAvatar = lecturerAvatar;
    }

    public String getLecturerUid() {
        return lecturerUid;
    }

    public void setLecturerUid(String lecturerUid) {
        this.lecturerUid = lecturerUid;
    }

    public String getLecturerNickName() {
        return lecturerNickName;
    }

    public void setLecturerNickName(String lecturerNickName) {
        this.lecturerNickName = lecturerNickName;
    }

    public float getStar() {
        return star;
    }
    public void setStar(float star) {
        this.star = star;
    }

    public int getIsBuy() {
        return isBuy;
    }

    public void setIsBuy(int isBuy) {
        this.isBuy = isBuy;
    }

    public boolean ifBuy() {
        if(paytype== InsideConstants.TYPE_PAY_FREE){
           return true;
        }
       return isBuy==1||isBuy2==1;
    }





    public String getLessionId() {
        if(TextUtils.isEmpty(lessionId)){
            lessionId="0";
        }
        return lessionId;
    }

    public void setLessionId(String sessionId) {
        this.lessionId = sessionId;
    }


    public int getIsMaterial() {
        return isMaterial;
    }

    public void setIsMaterial(int isMaterial) {
        this.isMaterial = isMaterial;
    }


    public int getIscart() {
        return iscart;
    }

    public void setIscart(int iscart) {
        this.iscart = iscart;
    }

    public ProjectBean copyBaseInfo(ProjectBean projectBean){
        id=projectBean.id;
        thumb=projectBean.thumb;
        price=projectBean.price;
        title=projectBean.title;
        studyCount=projectBean.studyCount;
        projectType=projectBean.projectType;
        isBuy=projectBean.isBuy;
        lecturerAvatar=projectBean.lecturerAvatar;
        lecturerBean=projectBean.lecturerBean;
        star=projectBean.star;
        introduce=projectBean.introduce;
        return this;
    }

    public int getIsBuy2() {
        return isBuy2;
    }

    public void setIsBuy2(int isBuy2) {
        this.isBuy2 = isBuy2;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if(obj!=null && obj instanceof ProjectBean ){
            ProjectBean projectBean= (ProjectBean) obj;
            return StringUtil.equals(projectBean.id,id);
        }
        return super.equals(obj);
    }

    public int getIspack() {
        return ispack;
    }

    public void setIspack(int ispack) {
        this.ispack = ispack;
    }
}
