package com.wanyue.inside.bean;

import android.content.Intent;
import android.os.Parcel;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.gson.annotations.SerializedName;
import com.wanyue.common.bean.SimpleUserBean;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.inside.R;
import com.wanyue.inside.busniess.InsideConstants;
import com.wanyue.inside.busniess.data.ProjectDataHelper;
import java.util.List;

public class PackgeBean extends ProjectBean {
    @SerializedName("teacher")
    @JSONField(name="teacher")
    private List<SimpleUserBean>lectureList;

    private List<ProjectBean>mProjectBeanList;

    private JSONArray courses;

    private String nums;

    private String lesson;

    @SerializedName("price")
    @JSONField(name="price")
    private String packgePrice;

    public PackgeBean(){
        setProjectType(InsideConstants.TYPE_PROJECT_PACKGE);
        setPaytype(InsideConstants.TYPE_PAY_CHARGE);

    }


    protected PackgeBean(Parcel in) {
        super(in);

        lectureList = in.createTypedArrayList(SimpleUserBean.CREATOR);
        mProjectBeanList = in.createTypedArrayList(ProjectBean.CREATOR);
        nums = in.readString();
        lesson = in.readString();
        packgePrice = in.readString();

    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest,flags);
        dest.writeTypedList(lectureList);
        dest.writeTypedList(mProjectBeanList);
        dest.writeString(nums);
        dest.writeString(lesson);
        dest.writeString(packgePrice);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PackgeBean> CREATOR = new Creator<PackgeBean>() {
        @Override
        public PackgeBean createFromParcel(Parcel in) {
            return new PackgeBean(in);
        }

        @Override
        public PackgeBean[] newArray(int size) {
            return new PackgeBean[size];
        }
    };

    public String getPackgePrice() {
        return packgePrice;
    }

    public void setPackgePrice(String packgePrice) {
        this.packgePrice = packgePrice;
    }





    public String getNums() {
        return nums;
    }

    public void setNums(String nums) {
        this.nums = nums;
    }



    public List<SimpleUserBean> getLectureList() {
        return lectureList;
    }

    public void setLectureList(List<SimpleUserBean> lectureList) {
        this.lectureList = lectureList;
    }

    public String getLesson() {
        if(TextUtils.isEmpty(lesson)){
           lesson= WordUtil.getString(R.string.course_num,nums);
        }
        return lesson;
    }
    public void setLesson(String lesson) {
        this.lesson = lesson;
    }

    public List<ProjectBean> getProjectBeanList() {
        if(courses==null){
            return mProjectBeanList;
        }
        if(mProjectBeanList==null){
            mProjectBeanList= ProjectDataHelper.formatProject(courses);
        }
        return mProjectBeanList;
    }

    public void setProjectBeanList(List<ProjectBean> projectBeanList) {
        mProjectBeanList = projectBeanList;
    }

    public JSONArray getCourses() {
        return courses;
    }

    public void setCourses(JSONArray courses) {
        this.courses = courses;
    }


    @Override
    public String getPrice() {
        return packgePrice;
    }

    /*获取处理后的价格标签*/
    @Override
    public String getHandlePrice(){
        if(!TextUtils.isEmpty(handlePrice)){
            return handlePrice;
        }
        if(paytype==InsideConstants.TYPE_PAY_CHARGE&&ifBuy()){
            handlePrice= WordUtil.getString(R.string.buyed);
        }else if(paytype==InsideConstants.TYPE_PAY_CHARGE&&!ifBuy()){
            handlePrice= "¥"+packgePrice;
        }else{
            handlePrice=packgePrice;
        }
        return handlePrice;
    }


    @Override
    public double getNumberPrice() {
        try {
            return Double.parseDouble(packgePrice);
        }catch (Exception e){
            e.printStackTrace();
        }
        return 0;
    }

}
