package com.wanyue.inside.bean;

import android.os.Parcel;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.gson.annotations.SerializedName;
import com.wanyue.common.bean.LiveInfo;
import java.util.ArrayList;
import java.util.List;

public class LiveBean extends ProjectBean{
    @SerializedName("lesson")
    @JSONField(name = "lesson")
    private String beginTime;

    @SerializedName("islive")
    @JSONField(name = "islive")
    private int liveState;

    @SerializedName("livetype")
    @JSONField(name = "livetype")
    private int liveType;

    private String pull;
    private String liveUid;
    private String stream;
    private int nums;
    @SerializedName("intr")
    @JSONField(name = "intr")
    private String liveGuide;//直播指南
    private String chatserver;

    @SerializedName("ppts")
    @JSONField(name = "ppts")
    private List<GalleryBean>pptList;

    @SerializedName("livemode")
    @JSONField(name = "livemode")
    private int liveMode;
    /*拓展参数*/
    private String expandParm;


    @SerializedName("type")
    @JSONField(name = "type")
    private int tempType;
    public LiveBean(){

    }

    protected LiveBean(Parcel in) {
        super(in);
        beginTime = in.readString();
        liveState = in.readInt();
        liveType = in.readInt();
        pull = in.readString();
        stream = in.readString();
        nums = in.readInt();
        liveGuide = in.readString();
        chatserver = in.readString();
        liveUid= in.readString();
        pptList = in.createTypedArrayList(GalleryBean.CREATOR);
        this.expandParm=  in.readString();
        liveMode = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest,flags);
        dest.writeString(beginTime);
        dest.writeInt(liveState);
        dest.writeInt(liveType);
        dest.writeString(pull);
        dest.writeString(stream);
        dest.writeInt(nums);
        dest.writeString(liveGuide);
        dest.writeString(chatserver);
        dest.writeString(liveUid);
        dest.writeTypedList(pptList);
        dest.writeString(expandParm);
        dest.writeInt(liveMode);

    }

    public String getChatserver() {
        return chatserver;
    }

    public void setChatserver(String chatserver) {
        this.chatserver = chatserver;
    }

    public String getStream() {
        return stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public int getNums() {
        return nums;
    }

    public void setNums(int nums) {
        this.nums = nums;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<LiveBean> CREATOR = new Creator<LiveBean>() {
        @Override
        public LiveBean createFromParcel(Parcel in) {
            return new LiveBean(in);
        }

        @Override
        public LiveBean[] newArray(int size) {
            return new LiveBean[size];
        }
    };

    public String getBeginTime() {
        return beginTime;
    }
    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }
    public int getLiveState() {
        return liveState;
    }
    public void setLiveState(int liveState) {
        this.liveState = liveState;
    }

    public int getLiveType() {
        return liveType;
    }
    public void setLiveType(int liveType) {
        this.liveType = liveType;
    }

    public String getPull() {
        return pull;
    }

    public void setPull(String pull) {
        this.pull = pull;
    }


    public String getLiveUid() {
        if(liveUid==null&&lecturerBean!=null){
            liveUid=lecturerBean.getId();
        }
        return liveUid;
    }

    public void setLiveUid(String liveUid) {
        this.liveUid = liveUid;
    }

    public int getLiveMode() {
        return liveMode;
    }

    public void setLiveMode(int liveMode) {
        this.liveMode = liveMode;
    }

    public String getLiveGuide() {
        return liveGuide;
    }

    public void setLiveGuide(String liveGuide) {
        this.liveGuide = liveGuide;
    }

    public int getRoomId() {
        try {
            return Integer.parseInt(getLiveUid());
        }catch (Exception e){
            e.printStackTrace();
        }
        return -1;
    }

    public String getExpandParm() {
        return expandParm;
    }

    public void setExpandParm(String expandParm) {
        this.expandParm = expandParm;
    }

    public List<GalleryBean> getPptList() {
        if(pptList==null){
           pptList=new ArrayList<>();
        }
        return pptList;
    }

    public void setPptList(List<GalleryBean> pptList) {
        this.pptList = pptList;
    }

    public LiveInfo parseLiveInfo(){
        LiveInfo liveInfo=new LiveInfo();
        liveInfo.setSteam(stream);
        liveInfo.setRoomId(getRoomId());
        liveInfo.setLiveUid(getLiveUid());
        return liveInfo;
    }

    public int getTempType() {
        return tempType;
    }

    public void setTempType(int tempType) {
        this.tempType = tempType;
    }
}
