package com.wanyue.inside.bean;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;

import com.wanyue.common.utils.StringUtil;

public class GalleryBean implements Parcelable,IGallery {
    private String id;
    private String thumb;

    public GalleryBean(){

    }

    protected GalleryBean(Parcel in) {
        id = in.readString();
        thumb = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(id);
        dest.writeString(thumb);
    }


    @Override
    public boolean equals(@Nullable Object obj) {
        if(obj!=null&&obj instanceof GalleryBean){
            GalleryBean gl= (GalleryBean) obj;
            return StringUtil.equals(gl.id,id);
        }

        return super.equals(obj);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<GalleryBean> CREATOR = new Creator<GalleryBean>() {
        @Override
        public GalleryBean createFromParcel(Parcel in) {
            return new GalleryBean(in);
        }

        @Override
        public GalleryBean[] newArray(int size) {
            return new GalleryBean[size];
        }
    };

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getThumb() {
        return thumb;
    }

    public void setThumb(String thumb) {
        this.thumb = thumb;
    }
}
