package com.wanyue.inside.adapter;

import android.content.Context;
import android.graphics.Typeface;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;
import android.util.TypedValue;
import android.view.View;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.utils.DpUtil;
import com.wanyue.inside.R;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.CommonNavigatorAdapter;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.abs.IPagerTitleView;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.indicators.LinePagerIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.titles.SimplePagerTitleView;

public class GreenNavigatorAdapter extends CommonNavigatorAdapter {
    private String[] mTitle;
    private Context mContext;
    private ViewPager mViewPager;
    private int itemWidth;
    private boolean isNeedScreen;

    public GreenNavigatorAdapter(@Nullable String[] title, Context context, ViewPager viewPager) {
        mTitle = title;
        mContext = context;
        mViewPager = viewPager;
        itemWidth= CommonAppConfig.getWindowWidth()/title.length;
        isNeedScreen=true;
    }


    public GreenNavigatorAdapter(@Nullable String[] title, Context context, ViewPager viewPager,boolean isNeedScreen) {
        mTitle = title;
        mContext = context;
        mViewPager = viewPager;
        this.isNeedScreen=isNeedScreen;
        if(isNeedScreen){
           itemWidth= CommonAppConfig.getWindowWidth()/title.length;
        }
    }

    @Override
    public int getCount()  {
        return mTitle.length;
    }
    @Override
    public IPagerTitleView getTitleView(Context context, final int index) {
        BoldPagerTitleView simplePagerTitleView = new BoldPagerTitleView(context);
        if(isNeedScreen){
           simplePagerTitleView.setWidth(itemWidth);
        }

        simplePagerTitleView.setNormalColor(ContextCompat.getColor(mContext, R.color.gray1));
        simplePagerTitleView.setSelectedColor(ContextCompat.getColor(mContext, R.color.global));
        simplePagerTitleView.setText(mTitle[index]);
        simplePagerTitleView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        simplePagerTitleView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mViewPager != null) {
                    mViewPager.setCurrentItem(index, false);
                }
            }
        });
        return simplePagerTitleView;
    }

    @Override
    public IPagerIndicator getIndicator(Context context) {
        LinePagerIndicator linePagerIndicator = new LinePagerIndicator(context);
        linePagerIndicator.setMode(LinePagerIndicator.MODE_EXACTLY);
        linePagerIndicator.setXOffset(DpUtil.dp2px(10));
        linePagerIndicator.setLineWidth(DpUtil.dp2px(15));
        linePagerIndicator.setRoundRadius(DpUtil.dp2px(2));
        linePagerIndicator.setYOffset(15);
        linePagerIndicator.setColors(ContextCompat.getColor(mContext, R.color.global));
        return linePagerIndicator;
    }

    public static class BoldPagerTitleView extends SimplePagerTitleView{

        public BoldPagerTitleView(Context context) {
            super(context);
        }

        @Override
        public void onSelected(int index, int totalCount) {
           super.onSelected(index,totalCount);
            setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        }

        @Override
        public void onDeselected(int index, int totalCount) {
            super.onDeselected(index,totalCount);
            setTypeface(Typeface.defaultFromStyle(Typeface.NORMAL));
        }
    }
}