package com.wanyue.detail.widet;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;

public class RatingOnSelectBar extends FrameLayout {
    private List<ImageView> mImageViewList;
    private int mNum;
    private Bitmap mBitmap;
    private int mStarSize;

    public RatingOnSelectBar(@NonNull Context context) {
        super(context);
       init(context);
    }

    public RatingOnSelectBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public RatingOnSelectBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {

    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
    }


    public void setNum(int num){
        if (mImageViewList == null) {
            mImageViewList=new ArrayList<>();
        }
        int viewCount=getChildCount();
        if(viewCount<num){
            for(int i=viewCount;i<num;i++){
               addStar();
            }
        }

        for(int i=0;i<num;i++){
          View view=getChildAt(i);
          view.setVisibility(View.GONE);
        }


     }

    private void addStar() {
        ImageView imageView = new ImageView(getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(mStarSize, mStarSize);
        imageView.setLayoutParams(params);
        addView(imageView);
    }


}
