package com.wanyue.detail.widet;

import android.content.Context;
import androidx.appcompat.widget.AppCompatSeekBar;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SeekBar;

public class LockSeekBar extends AppCompatSeekBar {
    private double mLockScale;
    private boolean mIsLock;
    private OnLockSeekChangeListner mOnLockSeekChangeListner;


    public LockSeekBar(Context context) {
        super(context);
        init(context);
    }
    public LockSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }
    public LockSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);

    }

    private void init(Context context) {
        setBackground(null);
        setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if(mOnLockSeekChangeListner!=null){
                   mOnLockSeekChangeListner.onProgressChanged(seekBar,progress,fromUser);
                    float max=getMax();
                    if(max>0&&progress>=0){
                       float currentScale=progress/max;
                       if(mIsLock&&currentScale>=mLockScale){
                          mOnLockSeekChangeListner.needLock(true);
                       }else if(mIsLock&&currentScale<mLockScale){
                          mOnLockSeekChangeListner.needLock(false);
                       }
                    }
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                if(mOnLockSeekChangeListner!=null){
                   mOnLockSeekChangeListner.onStartTrackingTouch(seekBar);
                }
            }
            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                if(mOnLockSeekChangeListner!=null){
                    mOnLockSeekChangeListner.onStopTrackingTouch(seekBar);
                }
            }
        });
    }


    public void setOnLockSeekChangeListner(OnLockSeekChangeListner onLockSeekChangeListner) {
        mOnLockSeekChangeListner = onLockSeekChangeListner;
    }

    public void setLimitProgress(float limitProgress) {
        float max=getMax();
        if(max<=0){
            return;
        }
        mLockScale=limitProgress/max;
    }

    public void setLimitScale(double limitScale) {
        if(limitScale<=0){
            return;
        }
        mLockScale=limitScale;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if(mIsLock&&lockEvent(event)){
            return false;
        }
        return super.onTouchEvent(event);
    }

    public void setLock(boolean lock) {
        if(mIsLock!=lock){
           mIsLock = lock;
           return;
        }
    }

    /*锁定滑动事件*/
    private boolean lockEvent(MotionEvent event) {
        double width=getWidth();
        double x=event.getX();
        double currentScale=x/width;

        switch (event.getAction()){
            case MotionEvent.ACTION_DOWN:
            case MotionEvent.ACTION_MOVE:
            case MotionEvent.ACTION_UP:
            case MotionEvent.ACTION_CANCEL:
               if(mLockScale>0&&currentScale>=mLockScale){
                  return true;
               }
        }
        return false;
    }


    public interface OnLockSeekChangeListner extends OnSeekBarChangeListener{
        public void needLock(boolean isNeedLock);
    }
}
