package com.wanyue.detail.business;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import com.wanyue.common.Constants;

import com.wanyue.inside.bean.ContentBean;
import com.wanyue.inside.bean.CourseBean;
import com.wanyue.inside.bean.LiveBean;
import com.wanyue.inside.bean.PackgeBean;
import com.wanyue.inside.bean.ProjectBean;
import com.wanyue.inside.busniess.InsideConstants;

public class IntentInsHelper {

    public static <E extends ProjectBean> void forwardByClass(Context context, Intent intent, @Nullable E data,ActivityOptionsCompat compat) {
        if(context==null||data==null){
            return;
        }
        Class cs = ProjectBean.class;
        if (data instanceof CourseBean) {
        } else if (data instanceof LiveBean) {
        } else if (data instanceof ContentBean) {
        }
        else if (data instanceof PackgeBean) {
        }
        if(cs==null||cs==ProjectBean.class){
            return;
        }
        intent.setClass(context,cs);
        intent.putExtra(Constants.DATA, data);
        if(compat==null){
          context.startActivity(intent);
        }else{
          context.startActivity(intent,compat.toBundle());
        }
    }


    public static <E extends ProjectBean> void forward(Context context, Intent intent, E data, ActivityOptionsCompat compat) {
        if(context==null||data==null){
            return;
        }
        if(data.getClass()==ProjectBean.class){
            int projectType=data.getProjectType();
            ProjectBean projectBean=null;
            switch (projectType){
                case InsideConstants.TYPE_PROJECT_CONTENT:
                    projectBean=new ContentBean().copyBaseInfo(data);
                    break;
                case InsideConstants.TYPE_PROJECT_COURSE:
                    projectBean=new CourseBean().copyBaseInfo(data);
                    break;
                case InsideConstants.TYPE_PROJECT_LIVE:
                    projectBean=new LiveBean().copyBaseInfo(data);
                    break;
                case InsideConstants.TYPE_PROJECT_PACKGE:
                    projectBean=new PackgeBean().copyBaseInfo(data);
                    break;
                default:
                    break;
            }
            forwardByClass(context,intent,projectBean,compat);
        }
        forwardByClass(context,intent,data,compat);
    }

    public static <E extends ProjectBean> void forward(Context context, Intent intent, E data){
        forward(context,intent,data,null);
    }

}
