package com.wanyue.detail.api;

import com.alibaba.fastjson.JSONObject;
import com.wanyue.common.bean.CoinPayBean;
import com.wanyue.common.server.MapBuilder;
import com.wanyue.common.server.RequestFactory;
import com.wanyue.common.server.entity.Data;
import com.wanyue.inside.bean.PackgeBean;
import com.wanyue.inside.bean.ProjectBean;
import java.util.List;
import java.util.Map;
import io.reactivex.Observable;

public class DetailApi {


  /*获取项目详情*/
    public static <T extends ProjectBean> Observable<T>getProjectDetail(String projectId,Class<T>cs){
        Map<String,Object> parm= MapBuilder.factory()
                .put("courseid",projectId)
                .build();
        return RequestFactory.getRequestManager().valueGet("Course.GetDetail",parm, cs,false);
    }

    /*获取套餐详情*/
    public static  Observable<PackgeBean>getPackgeDeatail(String projectId){
        Map<String,Object> parm= MapBuilder.factory()
                .put("packageid",projectId)
                .build();
        return RequestFactory.getRequestManager().valueGet("Package.GetInfo",parm, PackgeBean.class,false);
    }


    /*提交评论*/
    public static Observable<Boolean>addComment(String courseid,float star,String content){
        Map<String,Object> parm= MapBuilder.factory()
                .put("courseid",courseid)
                .put("star",star)
                .put("content",content)
                .build();
        return RequestFactory.getRequestManager().commit("Comment.Add",parm,true);
    }

    /*评论列表*/
    public static Observable<Data<JSONObject>>getEvaluateList(String projectId,int p){
        Map<String,Object> parm= MapBuilder.factory()
                .put("courseid",projectId)
                .put("p",p)
                .build();
        return RequestFactory.getRequestManager().originalRequest("Comment.GetList",parm);
    }

    /*输入密码获得*/
    public static Observable<Boolean>checkPass(String courseid,String pass){
        Map<String,Object> parm= MapBuilder.factory()
                .put("courseid",courseid)
                .put("pass",pass)
                .build();
        return RequestFactory.getRequestManager().commit("Course.CheckPass",parm, true);
    }





    /*获取支付信息*/
    /*addrid	整型	可选			地址ID
    method	整型	可选			下单方式，0直接购买，1购物车
    goods	字符串	可选			商品信息 json串 格式：{"type":"类型，0课程1套餐","typeid":"课程/套餐ID"}*/
    public static Observable<Data<JSONObject>>getPayMessage(
                                                            String payid,
                                                            String addrid,
                                                            int method,
                                                            String goods
                                                            ){
        Map<String,Object> parm= MapBuilder.factory()
                .put("addrid",addrid)
                .put("payid",payid)
                .put("method",method)
                .put("goods",goods)
                .build();
        return RequestFactory.getRequestManager().originalRequest("Cart.Buy",parm);
    }



    /*获取支付方式列表*/
    public static Observable<List<CoinPayBean>>getPayList(){
        Map<String,Object> parm= MapBuilder.factory()
                .build();
        return RequestFactory.getRequestManager().get("Cart.GetPayList",parm,CoinPayBean.class,false);
    }


}
