package com.wanyue.detail.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.wanyue.common.CommonAppContext;
import com.wanyue.common.adapter.base.BaseReclyViewHolder;
import com.wanyue.common.custom.DrawableTextView;
import com.wanyue.common.custom.ItemDecoration;
import com.wanyue.common.utils.ResourceUtil;
import com.wanyue.common.utils.WordUtil;
import com.wanyue.detail.R;
import com.wanyue.inside.bean.ContentBean;
import com.wanyue.inside.bean.CourseBean;
import com.wanyue.inside.bean.LiveBean;
import com.wanyue.inside.bean.PackgeBean;
import com.wanyue.inside.bean.ProjectBean;
import com.wanyue.inside.busniess.InsideConstants;
import com.wanyue.inside.busniess.ui.UIFactory;

public class ProjectAdapterHelper {
    public  void convert(BaseReclyViewHolder helper, ProjectBean projectBean){
        if(projectBean==null){
            return;
         }
        switch (projectBean.getProjectType()){
            case InsideConstants.TYPE_PROJECT_CONTENT:
                convertContent(helper,projectBean);
                break;
            case InsideConstants.TYPE_PROJECT_CAMERA:
            case InsideConstants.TYPE_PROJECT_LIVE:
                convertLive(helper,projectBean);
                break;
            case InsideConstants.TYPE_PROJECT_COURSE:
                convertCourse(helper,projectBean);
                break;
            case InsideConstants.TYPE_PROJECT_PACKGE:
                convertPackge(helper,projectBean);
                break;
            default:
                break;
        }
    }

    private  void convertPackge(BaseReclyViewHolder helper, ProjectBean projectBean) {
        PackgeBean packgeBean= (PackgeBean) projectBean;
        helper.setText(R.id.tv_title,projectBean.getTitle());
        helper.setImageUrl(projectBean.getThumb(),R.id.img_thumb);

        TextView tvPrice=helper.getView(R.id.tv_price);
        int paytype=projectBean.getPaytype();
        tvPrice.setTextColor(UIFactory.getPriceViewColor(paytype));
        tvPrice.setText(projectBean.getHandlePrice());

        String  lesson=packgeBean.getLesson();
        helper.setText(R.id.tv_lesson,lesson);
        RecyclerView recyclerView=helper.getView(R.id.reclyView);
        initReclyView(recyclerView);

        AvatarAdapter avatarAdapter= (AvatarAdapter) recyclerView.getAdapter();
        avatarAdapter.setData(packgeBean.getLectureList());


        DrawableTextView drawableTextView=helper.getView(R.id.tv_teaching_material);
        if(drawableTextView==null){
            return;
        }
        int isMaterial=packgeBean.getIsMaterial();
        if(isMaterial==1){
            drawableTextView.setVisibility(View.VISIBLE);
            Drawable drawable= drawableTextView.getLeftDrawable();
            if(drawable==null){
                drawableTextView.setLeftDrawable(ResourceUtil.getDrawable(R.drawable.icon_teaching_material,true));
            }
        }else{
            drawableTextView.setVisibility(View.INVISIBLE);
        }
    }

    private  void initReclyView(RecyclerView recyclerView) {
        if(recyclerView.getAdapter()==null){
            AvatarAdapter avatarAdapter=new AvatarAdapter(null);
            recyclerView.setAdapter(avatarAdapter);
        }

        if(recyclerView.getLayoutManager()==null){
            Context context=recyclerView.getContext();
            LinearLayoutManager linearLayoutManager=new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false){
                @Override
                public boolean canScrollHorizontally() {
                    return false;
                }
            };
            ItemDecoration decoration = new ItemDecoration(context, 0xffdd00, 5, 5);
            recyclerView.setLayoutManager(linearLayoutManager);
            recyclerView.addItemDecoration(decoration);
        }

    }

    /*解析内容类型*/
    private  void convertContent(BaseReclyViewHolder helper, ProjectBean projectBean) {
        if(projectBean==null){
            return;
        }
        convertCommon(helper,projectBean);
        ContentBean contentBean= (ContentBean) projectBean;
        helper.setText(R.id.tv_content_type,contentBean.getLesson());
    }

    /*解析直播类型*/
    private  void convertLive(BaseReclyViewHolder helper, ProjectBean projectBean) {
        if(projectBean==null){
            return;
        }
        convertCommon(helper,projectBean);
        LiveBean liveBean= (LiveBean) projectBean;
        int liveState=liveBean.getLiveState();
        TextView tvTime=helper.getView(R.id.tv_live_time);
        if(liveState==1){
            tvTime.setText(R.string.live_ing_progress);
            tvTime.setTextColor(ResourceUtil.getColor(CommonAppContext.sInstance,R.color.global));
        }else{
            tvTime.setText(liveBean.getBeginTime());
            tvTime.setTextColor(ResourceUtil.getColor(CommonAppContext.sInstance,R.color.gray1));
        }
    }

    /*解析课程类型*/
    private  void convertCourse(BaseReclyViewHolder helper, ProjectBean projectBean) {
        if(projectBean==null){
            return;
        }
        CourseBean courseBean= (CourseBean) convertCommon(helper,projectBean);
        String  lesson=courseBean.getLesson();
        if(TextUtils.isEmpty(lesson)||lesson.equals("0课时")){
            helper.setText(R.id.tv_lesson, WordUtil.getString(R.string.no_add_content));
        }else{
            helper.setText(R.id.tv_lesson,lesson);
        }
        int isMaterial=courseBean.getIsMaterial();
        DrawableTextView drawableTextView=helper.getView(R.id.tv_teaching_material);
        if(drawableTextView==null){
            return;
        }
        if(isMaterial==1){
           drawableTextView.setVisibility(View.VISIBLE);
           Drawable drawable= drawableTextView.getLeftDrawable();
           if(drawable==null){
              drawableTextView.setLeftDrawable(ResourceUtil.getDrawable(R.drawable.icon_teaching_material,true));
           }
        }else{
            drawableTextView.setVisibility(View.INVISIBLE);
        }
    }

    /*通用的*/
    private  ProjectBean convertCommon(BaseReclyViewHolder helper, ProjectBean projectBean) {
        helper.setText(R.id.tv_title,projectBean.getTitle());
        helper.setImageUrl(projectBean.getThumb(),R.id.img_thumb);
        helper.setText(R.id.tv_name,projectBean.getLecturerNickName());
        helper.setImageUrl(projectBean.getLecturerAvatar(),R.id.img_avator);

        TextView tvPrice=helper.getView(R.id.tv_price);
        tvPrice.setText(projectBean.getHandlePrice());

        tvPrice.setTextColor(getPriceTextViewColor(projectBean));
        helper.addOnClickListener(R.id.img_avator);
        helper.addOnClickListener(R.id.tv_name);
        return projectBean;
    }

    public int getPriceTextViewColor(ProjectBean projectBean) {
       int paytype=projectBean.getPaytype();
       return UIFactory.getPriceViewColor(paytype);
    }
}
