package com.wanyue.common.utils;

import android.content.Intent;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.wanyue.common.fragment.ProcessFragment;
import com.wanyue.common.interfaces.ActivityResultCallback;
import com.wanyue.common.interfaces.CommonCallback;

/**
 * Created by cxf on 2018/9/29.
 */

public class ProcessResultUtil {

    protected ProcessFragment mFragment;
    public ProcessResultUtil(FragmentActivity activity) {
        mFragment = new ProcessFragment();
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        FragmentTransaction tx = fragmentManager.beginTransaction();
        tx.add(mFragment, "ProcessFragment").commit();
    }

    public void requestPermissions(String[] permissions, CommonCallback<Boolean> commonCallback) {
        mFragment.requestPermissions(permissions, commonCallback);
    }

    public void requestPermissions(CommonCallback<Boolean> commonCallback,String...permissions) {
        mFragment.requestPermissions(permissions, commonCallback);
    }

    public void startActivityForResult(Intent intent, ActivityResultCallback callback){
        mFragment.startActivityForResult(intent,callback);
    }

    public void startActivityForResult(Intent intent,int requestCode, ActivityResultCallback callback){
        mFragment.startActivityForResult(intent,requestCode,callback);
    }


    public void release(){
        if(mFragment!=null){
            mFragment.release();
        }
    }

}
