package com.wanyue.common.server;

import com.alibaba.fastjson.JSONObject;
import com.lzy.okgo.model.HttpParams;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.http.CommonHttpUtil;
import com.wanyue.common.http.HttpClient;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.utils.ListUtil;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;

public class OkGoRequestMannger implements IRequestManager {
    private static OkGoRequestMannger sOkGoRequestMannger;

    private OkGoRequestMannger() {
    }
    @Override
    public <T> Observable<List<T>> get(String url, Map<String, Object> map, Class<T> cs, boolean showMsg) {
        return CommonHttpUtil.get(url,parse(map),cs,showMsg);
    }
    @Override
    public <T> Observable<List<T>> post(String url, Map<String, Object> map, Class<T> cs, boolean showMsg) {
        return CommonHttpUtil.post(url,parse(map),cs,showMsg);
    }

    @Override
    public <T> Observable<T> valueGet(String url, Map<String, Object> map, Class<T> cs, boolean showMsg) {
        return get(url,map,cs,showMsg).map(new Function<List<T>, T>() {
            @Override
            public T apply(List<T> ts) throws Exception {
                if(ListUtil.haveData(ts)){
                   return ts.get(0);
                }else{
                    return null;
                }
            }
        });
    }

    @Override
    public <T> Observable<T> valuePost(String url, Map<String, Object> map, Class<T> cs, boolean showMsg) {
        return post(url,map,cs,showMsg).map(new Function<List<T>, T>() {
            @Override
            public T apply(List<T> ts) throws Exception {
                return ts.get(0);
            }
        });
    }

    @Override
    public Observable<Boolean> commit(String url, Map<String, Object> map, boolean showMsg) {
        return CommonHttpUtil.commit(url,parse(map),showMsg);
    }
    @Override
    public Observable<Data<JSONObject>> originalRequest(String url, Map<String, Object> map) {
        return CommonHttpUtil.originalRequest(url,parse(map));
    }

    @Override
    public void cancle(String tag) {
        String totalTag=HttpClient.getInstance().getBaseUrl()+tag;
        CommonHttpUtil.cancel(totalTag);
    }

    public static OkGoRequestMannger getInstance(){
        if(sOkGoRequestMannger==null){
            synchronized (OkGoRequestMannger.class){
                sOkGoRequestMannger=new OkGoRequestMannger();
            }
        }
        return sOkGoRequestMannger;
    }

    public static HttpParams parse(Map<String, Object> map){
        if(map==null){
            return null;
        }
        HttpParams httpParams=new HttpParams();
        Set<String> set= map.keySet();
       Iterator<String> iterator= set.iterator();
       while (iterator.hasNext()){
        String key=iterator.next();
        Object value=map.get(key);

        if(value==null){
            continue;
        }

        if(value instanceof Boolean){
            httpParams.put(key,(Boolean)value);
        }else if(value instanceof Integer){
            httpParams.put(key,(Integer)value);
        }else if(value instanceof String){
            httpParams.put(key,(String)value);
        }else if(value instanceof Double){
            httpParams.put(key,(Double)value);
        }else if(value instanceof Float){
            httpParams.put(key,(Float)value);
        }else  if(value instanceof File){
            httpParams.put(key,(File)value);
        }else if(value instanceof Long){
            httpParams.put(key,(Long)value);
        }
        else if(value instanceof Character){
            httpParams.put(key,(Character)value);
        }else{
            httpParams.put(key,value.toString());
        }
       }
        return httpParams;
    }

}
