package com.wanyue.common.http;

import com.alibaba.fastjson.JSONObject;
import com.lzy.okgo.model.HttpMethod;
import com.lzy.okgo.model.HttpParams;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.business.JumpInterceptor;
import com.wanyue.common.server.RxUtils;
import com.wanyue.common.server.SeverConfig;
import com.wanyue.common.server.entity.BaseResponse;
import com.wanyue.common.server.entity.Data;
import com.wanyue.common.server.generic.ParameterizedTypeImpl;
import com.wanyue.common.utils.RouteUtil;
import com.wanyue.common.utils.ToastUtil;
import java.lang.reflect.Type;
import java.util.List;
import io.reactivex.Observable;
import io.reactivex.functions.Function;

public class CommonHttpUtil {

    /**
     * 初始化
     */
    public static void init() {
        HttpClient.getInstance().init();
    }

    /**
     * 取消网络请求
     */
    public static void cancel(String tag) {
        HttpClient.getInstance().cancel(tag);
    }

    /*url 是默认的tag可以显式的取消*/
    public  static <T> io.reactivex.Observable<List<T>> request(HttpMethod httpMethod, String url, HttpParams params, final Class<T>cs,final boolean showMsg){
        url=appendUrl(url);

        Type type =null;
        if(SeverConfig.jsonType==SeverConfig.FAST_JSON){
            type= new com.alibaba.fastjson.util.ParameterizedTypeImpl(new Type[]{cs}, null, BaseResponse.class);
        }else{
            type= new ParameterizedTypeImpl(BaseResponse.class, new Class[]{cs});
        }
        Observable<BaseResponse<T>> observable= RxUtils.request(httpMethod, url, type,params);
        return observable.map(new Function<BaseResponse<T>, List<T>>() {
            @Override
            public List<T> apply(BaseResponse<T> response) throws Exception {
                Data<T> data=response.getData();
                int code=data.getCode();
                List<T>list=data.getInfo();
                if(showMsg){
                   ToastUtil.show(data.getMsg());
                }
                if(code==700){
                    if(CommonAppConfig.isLogin()){
                       ToastUtil.show(data.getMsg());
                    }
                   JumpInterceptor.interceptorAndFinshActivity();
                }else if(list.size()==0&&!showMsg){
                  ToastUtil.show(data.getMsg());
                }
                return list;
            }
        });
    }

    private static String appendUrl(String url) {
       return HttpClient.getInstance().getBaseUrl()+url;
    }

    public  static <T> io.reactivex.Observable<List<T>> get(String url, HttpParams params,Class<T>cs,boolean showMsg){
        return request(HttpMethod.GET,url,params,cs,showMsg);
    }

    public  static <T> io.reactivex.Observable<List<T>> post(String url, HttpParams params,Class<T>cs,boolean showMsg){
        return request(HttpMethod.POST,url,params,cs,showMsg);
    }

    public  static  io.reactivex.Observable<Boolean> commit(String url, HttpParams params,final boolean showMsg){
        url=appendUrl(url);
        Type type = new ParameterizedTypeImpl(BaseResponse.class, new Class[]{Void.class});
        Observable<BaseResponse> observable=RxUtils.request(HttpMethod.GET, url, type,params);
        return observable.map(new Function<BaseResponse, Boolean>() {
            @Override
            public Boolean apply(BaseResponse baseResponse) throws Exception {
                if(showMsg){
                  ToastUtil.show(baseResponse.getData().getMsg());
                }
                int code=baseResponse.getData().getCode();
                if(code==700){
                   JumpInterceptor.interceptorAndFinshActivity();
                }
                return code==0;
            }
        });
    }

    public  static  io.reactivex.Observable<Data<JSONObject>> originalRequest(String url, HttpParams params){
        url=appendUrl(url);
        Type  type= new ParameterizedTypeImpl(BaseResponse.class, new Class[]{JSONObject.class});
        Observable<BaseResponse<JSONObject>> observable=RxUtils.request(HttpMethod.GET, url, type,params);
        return observable.map(new Function<BaseResponse<JSONObject>, Data<JSONObject>>() {
            @Override
            public Data<JSONObject> apply(BaseResponse<JSONObject> response) throws Exception {
                int code=response.getData().getCode();
                if(code==700){
                    JumpInterceptor.interceptorAndFinshActivity();
                }
                return response.getData();
            }
        });
    }
}




