package com.wanyue.common.custom;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class TouchEventFrameLayout extends FrameLayout {
    private Activity mActivity;
    private boolean isEableShare;

    public TouchEventFrameLayout(@NonNull Context context) {
        super(context);
        init(context);
    }

    public TouchEventFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public TouchEventFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        if(context!=null &&context instanceof Activity){
            mActivity= (Activity) context;
        }
    }

    public void setEableShare(boolean eableShare) {
        isEableShare = eableShare;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if(mActivity!=null&&isEableShare){
            return mActivity.dispatchTouchEvent(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if(mActivity!=null&&isEableShare){
            return mActivity.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }
}
