package com.wanyue.common.business;

import android.app.Activity;
import android.content.Context;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.api.CommonAPI;
import com.wanyue.common.business.acmannger.ActivityMannger;
import com.wanyue.common.utils.RouteUtil;
import io.reactivex.Observable;
public class JumpInterceptor {
  public static Observable<Boolean> shouldInterceptor(Context context) {
      if (!CommonAppConfig.isLogin()){
           RouteUtil.forwardLogin();
           return Observable.just(false);
      }
      return CommonAPI.checkToken();
  }

    public static void interceptorAndFinshActivity(){
      Activity activity= ActivityMannger.getInstance().getMainStackTopActivity();
      boolean isBaseActivity=ActivityMannger.getInstance().isBaseActivity(activity);
      if(activity!=null&&!isBaseActivity&&!activity.isFinishing()){
         activity.finish();
      }
        RouteUtil.forwardLogin();
    }
}
