package com.wanyue.common.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.gson.annotations.SerializedName;
import com.wanyue.common.utils.StringUtil;

import java.util.List;

/**
 * Created by cxf on 2017/8/14.
 */

public class UserBean implements Parcelable {

    /*暂且先用gson完成自动解析框架,后期有时间更换,统一解析库,见谅了*/
    @SerializedName("id")
    protected String mId;

    @SerializedName("user_nickname")
    protected String mUserNiceName;

    @SerializedName("avatar")
    protected String mAvatar;

    @SerializedName("avatar_thumb")
    protected String mAvatarThumb;

    @SerializedName("sex")
    protected int mSex;

    @SerializedName("birthday")
    protected String mBirthday;

    @SerializedName("age")
    protected String mAge;

    @SerializedName("constellation")
    protected String mXingZuo;

    @SerializedName("signature")
    protected String mSignature;

    @SerializedName("addr")
    protected String mCity;

    @SerializedName("hobby")
    protected String mInteret;

    @SerializedName("school")
    protected String mSchool;

    @SerializedName("profession")
    protected String mProfession;

    @SerializedName("voice")
    protected String mVoice;

    @SerializedName("voice_l")
    protected int mVoiceDuration;

    @SerializedName("coin")
    protected String mCoin;

    @SerializedName("votes")
    protected String mVotes;

    @SerializedName("follows")
    protected long mFollowNum;

    @SerializedName("fans")
    protected long mFansNum;

    @SerializedName("star")
    protected String mStar;

    @SerializedName("auth_nums")
    protected int mAuthNum;


    @SerializedName("isattent")
    @JSONField(name = "isattent")
    private int isFollow;
    private int mVisitNums;
    private int mViewNums;
    private int mNewNums;

    private List<UserItemBean>list;
    private boolean isHide;


    public UserBean(){

    }

    protected UserBean(Parcel in) {
        mId = in.readString();
        mUserNiceName = in.readString();
        mAvatar = in.readString();
        mAvatarThumb = in.readString();
        mSex = in.readInt();
        mBirthday = in.readString();
        mAge = in.readString();
        mXingZuo = in.readString();
        mSignature = in.readString();
        mCity = in.readString();
        mInteret = in.readString();
        mSchool = in.readString();
        mProfession = in.readString();
        mVoice = in.readString();
        mVoiceDuration = in.readInt();
        mCoin = in.readString();
        mVotes = in.readString();
        mFollowNum = in.readLong();
        mFansNum = in.readLong();
        mStar = in.readString();
        mAuthNum = in.readInt();
        isFollow = in.readInt();
        mVisitNums = in.readInt();
        mViewNums = in.readInt();
        mNewNums = in.readInt();

    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mId);
        dest.writeString(mUserNiceName);
        dest.writeString(mAvatar);
        dest.writeString(mAvatarThumb);
        dest.writeInt(mSex);
        dest.writeString(mBirthday);
        dest.writeString(mAge);
        dest.writeString(mXingZuo);
        dest.writeString(mSignature);
        dest.writeString(mCity);
        dest.writeString(mInteret);
        dest.writeString(mSchool);
        dest.writeString(mProfession);
        dest.writeString(mVoice);
        dest.writeInt(mVoiceDuration);
        dest.writeString(mCoin);
        dest.writeString(mVotes);
        dest.writeLong(mFollowNum);
        dest.writeLong(mFansNum);
        dest.writeString(mStar);
        dest.writeInt(mAuthNum);
        dest.writeInt(isFollow);
        dest.writeInt(mVisitNums);
        dest.writeInt(mViewNums);
        dest.writeInt(mNewNums);

    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<UserBean> CREATOR = new Creator<UserBean>() {
        @Override
        public UserBean createFromParcel(Parcel in) {
            return new UserBean(in);
        }

        @Override
        public UserBean[] newArray(int size) {
            return new UserBean[size];
        }
    };

    public String getId() {
        if(mId==null){
           mId="";
        }
        return mId;
    }

    @JSONField(name = "id")
    public void setId(String id) {
        mId = id;
    }

    @JSONField(name = "user_nickname")
    public String getUserNiceName() {
        return mUserNiceName;
    }

    @JSONField(name = "user_nickname")
    public void setUserNiceName(String userNiceName) {
        mUserNiceName = userNiceName;
    }

    @JSONField(name = "avatar")
    public String getAvatar() {
        return mAvatar;
    }

    @JSONField(name = "avatar")
    public void setAvatar(String avatar) {
        mAvatar = avatar;
    }

    @JSONField(name = "avatar_thumb")
    public String getAvatarThumb() {
        return mAvatarThumb;
    }

    @JSONField(name = "avatar_thumb")
    public void setAvatarThumb(String avatarThumb) {
        mAvatarThumb = avatarThumb;
    }

    @JSONField(name = "sex")
    public int getSex() {
        return mSex;
    }

    @JSONField(name = "sex")
    public void setSex(int sex) {
        mSex = sex;
    }

    @JSONField(name = "birthday")
    public String getBirthday() {
        return mBirthday;
    }

    @JSONField(name = "birthday")
    public void setBirthday(String birthday) {
        mBirthday = birthday;
    }

    @JSONField(name = "age")
    public String getAge() {
        return mAge;
    }

    @JSONField(name = "age")
    public void setAge(String age) {
        mAge = age;
    }

    @JSONField(name = "constellation")
    public String getXingZuo() {
        return mXingZuo;
    }

    @JSONField(name = "constellation")
    public void setXingZuo(String xingZuo) {
        mXingZuo = xingZuo;
    }

    @JSONField(name = "signature")
    public String getSignature() {
        return mSignature;
    }

    @JSONField(name = "signature")
    public void setSignature(String signature) {
        mSignature = signature;
    }

    @JSONField(name = "addr")
    public String getCity() {
        return mCity;
    }

    @JSONField(name = "addr")
    public void setCity(String city) {
        mCity = city;
    }

    @JSONField(name = "hobby")
    public String getInteret() {
        return mInteret;
    }

    @JSONField(name = "hobby")
    public void setInteret(String interet) {
        mInteret = interet;
    }

    @JSONField(name = "school")
    public String getSchool() {
        return mSchool;
    }

    @JSONField(name = "school")
    public void setSchool(String school) {
        mSchool = school;
    }

    @JSONField(name = "profession")
    public String getProfession() {
        return mProfession;
    }

    @JSONField(name = "profession")
    public void setProfession(String profession) {
        mProfession = profession;
    }

    @JSONField(name = "voice")
    public String getVoice() {
        return mVoice;
    }

    @JSONField(name = "voice")
    public void setVoice(String voice) {
        mVoice = voice;
    }

    @JSONField(name = "voice_l")
    public int getVoiceDuration() {
        return mVoiceDuration;
    }

    @JSONField(name = "voice_l")
    public void setVoiceDuration(int voiceDuration) {
        mVoiceDuration = voiceDuration;
    }

    @JSONField(name = "coin")
    public String getCoin() {
        return mCoin;
    }

    @JSONField(name = "coin")
    public void setCoin(String coin) {
        mCoin = coin;
    }

    @JSONField(name = "votes")
    public String getVotes() {
        return mVotes;
    }

    @JSONField(name = "votes")
    public void setVotes(String votes) {
        mVotes = votes;
    }

    @JSONField(name = "follows")
    public long getFollowNum() {
        return mFollowNum;
    }

    @JSONField(name = "follows")
    public void setFollowNum(long followNum) {
        mFollowNum = followNum;
    }

    @JSONField(name = "fans")
    public long getFansNum() {
        return mFansNum;
    }

    @JSONField(name = "fans")
    public void setFansNum(long fansNum) {
        mFansNum = fansNum;
    }

    @JSONField(name = "star")
    public String getStar() {
        return mStar;
    }

    @JSONField(name = "star")
    public void setStar(String star) {
        mStar = star;
    }
    @JSONField(name = "auth_nums")
    public int getAuthNum() {
        return mAuthNum;
    }

    @JSONField(name = "auth_nums")
    public void setAuthNum(int authNum) {
        mAuthNum = authNum;
    }


    @JSONField(name = "visitnums")
    public int getVisitNums() {
        return mVisitNums;
    }
    @JSONField(name = "visitnums")
    public void setVisitNums(int mVisitNums) {
        this.mVisitNums = mVisitNums;
    }

    @JSONField(name = "viewnums")
    public int getViewNums() {
        return mViewNums;
    }

    @JSONField(name = "viewnums")
    public void setViewNums(int mViewNums) {
        this.mViewNums = mViewNums;
    }

    @JSONField(name = "newnums")
    public int getNewNums() {
        return mNewNums;
    }
    @JSONField(name = "newnums")
    public void setNewNums(int mNewNums) {
        this.mNewNums = mNewNums;
    }

    public int getIsFollow() {
        return isFollow;
    }

    public void setIsFollow(int isFollow) {
        this.isFollow = isFollow;
    }

    @Override
    public boolean equals( Object obj) {
        if(obj!=null &&obj instanceof UserBean){
            UserBean userBean= (UserBean) obj;
            return StringUtil.equals(userBean.getId(),mId);
        }else{
            return obj.equals(this);
        }
    }
    public static boolean isSameUser(UserBean userBean1,UserBean userBean2){
        if(userBean1==null||userBean2==null){
            return false;
        }
        return StringUtil.equals(userBean1.getId(),userBean2.getId());
    }

    private static UserBean compareUserBean;
    public static UserBean getCompareUserBean(String uid){
       if(compareUserBean==null){
          compareUserBean=new UserBean();
       }
        compareUserBean.setId(uid);
       return compareUserBean;
    }

    public boolean isHide() {
        return isHide;
    }

    public void setHide(boolean hide) {
        isHide = hide;
    }

    public List<UserItemBean> getList() {
        return list;
    }

    public void setList(List<UserItemBean> list) {
        this.list = list;
    }

}





