package com.wanyue.education;

import android.content.Intent;

import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.widget.ImageView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.activity.BaseActivity;
import com.wanyue.common.api.CommonAPI;
import com.wanyue.common.bean.ConfigBean;
import com.wanyue.common.custom.viewanimator.ViewAnimator;
import com.wanyue.common.glide.ImgLoader;
import com.wanyue.common.server.observer.DefaultObserver;
import com.wanyue.common.utils.RouteUtil;
import java.util.concurrent.TimeUnit;
import butterknife.BindView;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;

@Route(path = RouteUtil.PATH_LAUNCHER)
public class LaunchActivity extends BaseActivity {
    @BindView(R.id.img_cover)
    ImageView mImgCover;
    @Override
    public void init() {
        Intent intent = getIntent();
        if (!isTaskRoot()
                && intent != null
                && intent.hasCategory(Intent.CATEGORY_LAUNCHER)
                && intent.getAction() != null
                && intent.getAction().equals(Intent.ACTION_MAIN)) {
            finish();
            return;
        }
        ImgLoader.display(this,R.mipmap.screen,mImgCover);
        startLauncherAnim();
        startLauncher();
        //SystemUtil.setSystemUIVisible(this,false);
    }

    private  ViewAnimator mViewAnimator;
    private void startLauncherAnim() {
        mViewAnimator=ViewAnimator.animate(mImgCover).alpha(0,1).duration(500).start();
    }

    /*开始启动方法*/
    private void startLauncher() {
        /*倒计时开始*/
        Observable.timer(1, TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).flatMap(new Function<Long, ObservableSource<ConfigBean>>() {
            @Override
            public ObservableSource<ConfigBean> apply(Long aLong) throws Exception {
                return CommonAPI.getConfig();
            }
        }).compose(this.bindUntilOnDestoryEvent())
                .subscribe(new DefaultObserver<ConfigBean>() {
            @Override
            public void onNext(ConfigBean configBean) {
                RouteUtil.forwardMain(LaunchActivity.this);
                finish();
            }
        });
    }

    /*判断是否登录了*/
    private boolean checkLogined() {
        String uid= CommonAppConfig.getUid();
        String token=CommonAppConfig.getToken();
        return !TextUtils.isEmpty(uid)&&!TextUtils.isEmpty(token);
    }

    @Override
    public int getLayoutId() {
        return R.layout.activity_launch;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if(mViewAnimator!=null){
           mViewAnimator.cancel();
        }
    }
}
