package com.wanyue.education;

import android.app.Application;
import android.content.Context;
import com.alibaba.android.arouter.launcher.ARouter;
import com.github.moduth.blockcanary.BlockCanary;
import com.github.moduth.blockcanary.BlockCanaryContext;
import com.mob.MobSDK;
import com.squareup.leakcanary.LeakCanary;
import com.tencent.bugly.crashreport.CrashReport;
import com.wanyue.common.CommonAppConfig;
import com.wanyue.common.server.observer.DefaultObserver;
import com.wanyue.common.utils.DebugUtil;
import com.wanyue.common.utils.L;
import com.wanyue.common.utils.SystemUtil;
import java.util.concurrent.TimeUnit;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;

public class InitHelper {

    public void startInit(final Application context){
        Observable.timer(1, TimeUnit.SECONDS).
                observeOn(AndroidSchedulers.mainThread())
                .subscribe(new DefaultObserver<Long>() {
                    @Override
                    public void onNext(Long aLong) {
                        init(context);
                    }
                });
    }

    private  void init(Application context){
        boolean isDebug= SystemUtil.isApkInDebug(context);
        L.setDeBug(isDebug);
        DebugUtil.setDeBug(isDebug);
        //初始化腾讯bugly
        CrashReport.initCrashReport(context);
        CrashReport.setAppVersion(context, CommonAppConfig.getVersion());
        //初始化ShareSdk
        MobSDK.init(context);
        if (isDebug) {
            ARouter.openLog();
            ARouter.openDebug();
            LeakCanary.install(context);
            if (LeakCanary.isInAnalyzerProcess(context)) {
                return;
            }
        }
        ARouter.init(EducationApplication.sInstance);

    }
}
