package com.wanyue.education;

import com.bumptech.glide.Glide;
import com.wanyue.common.CommonAppContext;
import com.wanyue.common.utils.L;
import com.wanyue.common.utils.ResourceUtil;

public class EducationApplication extends CommonAppContext {
    @Override
    public void onCreate() {
        super.onCreate();
        InitHelper initHelper=new InitHelper();
        initHelper.startInit(this);
    }

    /*低内存的时候释放掉GLide的缓存*/
    @Override
    public void onLowMemory() {
        super.onLowMemory();
        Glide.get(getApplicationContext()).clearMemory();
        ResourceUtil.clearAllDrawable();
        L.e("onLowMemory==");
    }

    @Override
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        Glide.get(getApplicationContext()).trimMemory(level);
        L.e("onTrimMemory==");
    }
}
