/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.os.SystemClock;
import com.mob.tools.MobLog;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class FileLocker {
    private FileOutputStream fos;
    private FileLock lock;

    public synchronized void setLockFile(String path) {
        block4: {
            try {
                this.fos = new FileOutputStream(path);
            }
            catch (Throwable t) {
                if (this.fos == null) break block4;
                try {
                    this.fos.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.fos = null;
            }
        }
    }

    public synchronized boolean lock(boolean block) {
        return this.lock(block, block ? 1000L : 500L, 16L);
    }

    public synchronized boolean lock(boolean block, long timeout, long sleepInterval) {
        if (this.fos == null) {
            return false;
        }
        try {
            return this.getLock(block);
        }
        catch (Throwable t) {
            if (timeout > 0L && t instanceof OverlappingFileLockException) {
                long deadline = timeout + SystemClock.elapsedRealtime();
                boolean result = false;
                while (timeout > 0L) {
                    try {
                        try {
                            Thread.sleep(sleepInterval);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        timeout = deadline - SystemClock.elapsedRealtime();
                        result = this.getLock(block);
                        break;
                    }
                    catch (Throwable tr) {
                        if (tr instanceof OverlappingFileLockException) {
                            if (timeout > 0L) continue;
                            MobLog.getInstance().w("OverlappingFileLockException and timeout");
                            continue;
                        }
                        MobLog.getInstance().w(t);
                        timeout = -1L;
                    }
                }
                if (timeout > 0L) {
                    return result;
                }
            } else {
                MobLog.getInstance().w(t);
            }
            if (this.lock != null) {
                try {
                    this.lock.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.lock = null;
            }
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.fos = null;
            }
            return false;
        }
    }

    private boolean getLock(boolean block) throws Throwable {
        this.lock = block ? this.fos.getChannel().lock() : this.fos.getChannel().tryLock();
        return this.lock != null;
    }

    public synchronized void lock(Runnable onLock, boolean block) {
        if (this.lock(block) && onLock != null) {
            onLock.run();
        }
    }

    public synchronized void unlock() {
        if (this.lock == null) {
            return;
        }
        try {
            this.lock.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lock = null;
    }

    public synchronized void release() {
        if (this.fos == null) {
            return;
        }
        this.unlock();
        try {
            this.fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fos = null;
    }
}

