/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

import com.mob.tools.java8.Collect;
import com.mob.tools.java8.Each;
import com.mob.tools.java8.Filter;
import com.mob.tools.java8.Flow;
import com.mob.tools.java8.Inject;
import com.mob.tools.java8.Map;
import com.mob.tools.java8.Optional;
import com.mob.tools.java8.Peek;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class MapFlow<K, V> {
    Flow<MapItem<K, V>> flow;

    MapFlow(Flow<MapItem<K, V>> flow) {
        this.flow = flow;
    }

    public MapFlow<K, V> filter(final Filter.MapFilter<K, V> fun) {
        return new MapFlow<K, V>(this.flow.filter(new Filter<MapItem<K, V>>(){

            @Override
            public boolean filter(MapItem<K, V> it) {
                return fun.filter(it.key, it.value);
            }
        }));
    }

    public <R> MapFlow<K, R> map(final Map.MapMap<K, V, R> fun) {
        return new MapFlow<K, V>(this.flow.map(new Map<MapItem<K, V>, MapItem<K, R>>(){

            @Override
            public MapItem<K, R> map(MapItem<K, V> it) {
                MapItem tmp = it;
                tmp.value = fun.map(it.key, it.value);
                return tmp;
            }
        }));
    }

    public <U> MapFlow<U, V> mapKey(final Map.MapMap<K, V, U> fun) {
        return new MapFlow<K, V>(this.flow.map(new Map<MapItem<K, V>, MapItem<U, V>>(){

            @Override
            public MapItem<U, V> map(MapItem<K, V> it) {
                MapItem tmp = it;
                tmp.key = fun.map(it.key, it.value);
                return tmp;
            }
        }));
    }

    public <U, R> MapFlow<U, R> collect(final Collect.MapCollect<K, V, U, R> fun) {
        return new MapFlow<K, V>(this.flow.collect(new Collect<MapItem<K, V>, MapItem<U, R>>(){

            @Override
            public Flow<MapItem<U, R>> collect(MapItem<K, V> it) {
                return fun.collect(it.key, it.value).flow;
            }
        }));
    }

    public MapFlow<K, V> peek(final Peek.MapPeek<K, V> fun) {
        this.flow = this.flow.peek(new Peek<MapItem<K, V>>(){

            @Override
            public void peek(MapItem<K, V> it) {
                fun.peek(it.key, it.value);
            }
        });
        return this;
    }

    public MapFlow<K, V> limit(int limit) {
        this.flow = this.flow.limit(limit);
        return this;
    }

    public MapFlow<K, V> skip(int skip) {
        this.flow = this.flow.skip(skip);
        return this;
    }

    public MapFlow<K, V> distinct() {
        this.flow = this.flow.distinct();
        return this;
    }

    public MapFlow<K, V> sort(final Comparator<K> fun) {
        this.flow = this.flow.sort(new Comparator<MapItem<K, V>>(){

            @Override
            public int compare(MapItem<K, V> left, MapItem<K, V> right) {
                return fun.compare(left.key, right.key);
            }
        });
        return this;
    }

    public MapFlow<K, V> sort() {
        this.flow = this.flow.sort(new Comparator<MapItem<K, V>>(){

            @Override
            public int compare(MapItem<K, V> left, MapItem<K, V> right) {
                return left.compareTo(right);
            }
        });
        return this;
    }

    public void each(final Each.MapEach<K, V> fun) {
        this.flow.each(new Each<MapItem<K, V>>(){

            @Override
            public void each(MapItem<K, V> it) {
                fun.each(it.key, it.value);
            }
        });
    }

    public Optional<V> first() {
        MapItem e = this.flow.first().orElse(null);
        return new Optional<Object>((e == null ? null : (Object)e.value));
    }

    public Optional<V> last() {
        MapItem e = this.flow.last().orElse(null);
        return new Optional<Object>((e == null ? null : (Object)e.value));
    }

    public boolean any() {
        return this.flow.any();
    }

    public java.util.Map<K, V> toMap() {
        final HashMap map = new HashMap();
        this.each(new Each.MapEach<K, V>(){

            @Override
            public void each(K key, V value) {
                map.put(key, value);
            }
        });
        return map;
    }

    public int count() {
        return this.flow.count();
    }

    public <R> R inject(R identity, final Inject.MapInject<K, V, R> fun) {
        return this.flow.inject(identity, new Inject<MapItem<K, V>, R>(){

            @Override
            public R inject(MapItem<K, V> it, R previous) {
                return fun.inject(it.key, it.value, previous);
            }
        });
    }

    public <R> R inject(Inject.MapInject<K, V, R> fun) {
        return this.inject(null, fun);
    }

    static class MapItem<K, V>
    implements Comparable<MapItem<K, V>> {
        public K key;
        public V value;

        MapItem() {
        }

        public static <K, V> MapItem<K, V> of(K key, V value) {
            MapItem<K, V> item = new MapItem<K, V>();
            item.key = key;
            item.value = value;
            return item;
        }

        @Override
        public int compareTo(MapItem<K, V> mi) {
            if (this.key == null) {
                if (mi == null) {
                    return 0;
                }
                if (mi.key == null) {
                    return 0;
                }
                return -1;
            }
            if (mi == null) {
                return 1;
            }
            if (mi.key == null) {
                return 1;
            }
            Object[] oa = new Object[]{this.key, mi.key};
            Arrays.sort(oa);
            if (this.key.equals(oa[0])) {
                oa = new Object[]{mi.key, this.key};
                Arrays.sort(oa);
                if (this.key.equals(oa[0])) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
    }
}

