/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

public class Closure {
    public static <R> Result<R> call(IClosure<R> c) {
        Result result = new Result();
        try {
            result.res = c.call();
        }
        catch (Throwable t) {
            result.t = t;
        }
        return result;
    }

    public static Result<Void> call(IClosureV c) {
        Result<Void> result = new Result<Void>();
        try {
            c.call();
        }
        catch (Throwable t) {
            ((Result)result).t = t;
        }
        return result;
    }

    public static <R> R uncheck(IClosure<R> c) {
        try {
            return c.call();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void uncheck(IClosureV c) {
        try {
            c.call();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void asyncCall(final IClosureV c) {
        new Thread(){

            @Override
            public void run() {
                Closure.uncheck(c);
            }
        }.start();
    }

    public static interface IClosure1V<R> {
        public void call(R var1) throws Throwable;
    }

    public static interface IClosureV {
        public void call() throws Throwable;
    }

    public static interface IClosure<R> {
        public R call() throws Throwable;
    }

    public static class Result<R> {
        private R res;
        private Throwable t;

        public R result() {
            return this.res;
        }

        public Throwable error() {
            return this.t;
        }

        public void throwError() {
            if (this.t != null) {
                throw new RuntimeException(this.t);
            }
        }
    }
}

