/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.java8;

import com.mob.tools.java8.Function;
import java.util.LinkedList;

class Batch<R>
implements Function {
    private int limit;
    protected LinkedList<R> output;

    public Batch(int limit) {
        this.limit = limit;
        this.output = new LinkedList();
    }

    public int test(R item) {
        this.output.add(item);
        if (this.limit == -1) {
            return 0;
        }
        if (this.output.size() == this.limit) {
            return 1;
        }
        if (this.output.size() > this.limit) {
            this.output.removeLast();
            return 2;
        }
        return 0;
    }

    public LinkedList<R> output() {
        return this.output;
    }

    static class Chunk<R>
    extends Batch<R> {
        public Chunk(int chunk) {
            super(chunk);
        }

        public void reset() {
            this.output = new LinkedList();
        }
    }

    static class Skip<R>
    extends Batch<R> {
        public Skip(int skip) {
            super(skip);
        }
    }

    static class Limit<R>
    extends Batch<R> {
        public Limit() {
            super(-1);
        }

        public Limit(int limit) {
            super(limit);
        }
    }
}

